"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
import PyQt5.sip
from PyQt5 import QtCore
from PyQt5.QtSerialPort import *
from PyQt5 import sip


class QSerialPort(QtCore.QIODevice):
    """
    https://doc.qt.io/qt-5/qserialport.html

    **Detailed Description**

    You can get information about the available serial ports using the
    **QSerialPortInfo**  helper class, which allows an enumeration of all the
    serial ports in the system. This is useful to obtain the correct name of the
    serial port you want to use. You can pass an object of the helper class as
    an argument to the **setPort** () or **setPortName** () methods to assign
    the desired serial device.

    After setting the port, you can open it in read-only (r/o), write-only
    (w/o), or read-write (r/w) mode using the **open** () method.

    **Note:** The serial port is always opened with exclusive access (that is,
    no other process or thread can access an already opened serial port).

    Use the **close** () method to close the port and cancel the I/O operations.

    Having successfully opened, QSerialPort tries to determine the current
    configuration of the port and initializes itself. You can reconfigure the
    port to the desired setting using the **setBaudRate** (), **setDataBits**
    (), **setParity** (), **setStopBits** (), and **setFlowControl** () methods.

    There are a couple of properties to work with the pinout signals namely:
    **QSerialPort::dataTerminalReady** , **QSerialPort::requestToSend** . It is
    also possible to use the **pinoutSignals** () method to query the current
    pinout signals set.

    Once you know that the ports are ready to read or write, you can use the
    **read** () or **write** () methods. Alternatively the **readLine** () and
    **readAll** () convenience methods can also be invoked. If not all the data
    is read at once, the remaining data will be available for later as new
    incoming data is appended to the QSerialPort's internal read buffer. You can
    limit the size of the read buffer using **setReadBufferSize** ().

    QSerialPort provides a set of functions that suspend the calling thread
    until certain signals are emitted. These functions can be used to implement
    blocking serial ports:

    * **waitForReadyRead** () blocks calls until new data is available for
    reading.
      * **waitForBytesWritten** () blocks calls until one payload of
    data has been written to the serial port.

    See the following example:

    int numRead = 0, numReadTotal = 0;
        char buffer[50];

        for (;;) {
    numRead  = serial.read(buffer, 50);

            // Do whatever with the
    array

            numReadTotal += numRead;
            if (numRead == 0 &&
    !serial.waitForReadyRead())
                break;
        }

    If **waitForReadyRead()**  returns `false`, the connection has been closed
    or an error has occurred.

    If an error occurs at any point in time, QSerialPort will emit the
    **errorOccurred** () signal. You can also call **error** () to find the type
    of error that occurred last.

    **Note:** Not all error conditions are handled in a platform independent way
    in QSerialport, as for example the Framing, Parity, and Break condition
    errors. These kind of errors need to be handled by the application code,
    probably using OS system specific ioctls on the device descriptor and/or
    parsing the stream's byte-stuffing.

    Programming with a blocking serial port is radically different from
    programming with a non-blocking serial port. A blocking serial port does not
    require an event loop and typically leads to simpler code. However, in a GUI
    application, blocking serial port should only be used in non-GUI threads, to
    avoid freezing the user interface.

    For more details about these approaches, refer to the **example**
    applications.

    The QSerialPort class can also be used with **QTextStream**  and
    **QDataStream** 's stream operators (operator<<() and operator>>()). There
    is one issue to be aware of, though: make sure that enough data is available
    before attempting to read by using the operator>>() overloaded operator.

    **See also** **QSerialPortInfo** .
    """

    class SerialPortError(int):
        NoError: QSerialPort = ...
        DeviceNotFoundError: QSerialPort = ...
        PermissionError: QSerialPort = ...
        OpenError: QSerialPort = ...
        ParityError: QSerialPort = ...
        FramingError: QSerialPort = ...
        BreakConditionError: QSerialPort = ...
        WriteError: QSerialPort = ...
        ReadError: QSerialPort = ...
        ResourceError: QSerialPort = ...
        UnsupportedOperationError: QSerialPort = ...
        TimeoutError: QSerialPort = ...
        NotOpenError: QSerialPort = ...
        UnknownError: QSerialPort = ...

    class DataErrorPolicy(int):
        SkipPolicy: QSerialPort = ...
        PassZeroPolicy: QSerialPort = ...
        IgnorePolicy: QSerialPort = ...
        StopReceivingPolicy: QSerialPort = ...
        UnknownPolicy: QSerialPort = ...

    class PinoutSignal(int):
        NoSignal: QSerialPort = ...
        TransmittedDataSignal: QSerialPort = ...
        ReceivedDataSignal: QSerialPort = ...
        DataTerminalReadySignal: QSerialPort = ...
        DataCarrierDetectSignal: QSerialPort = ...
        DataSetReadySignal: QSerialPort = ...
        RingIndicatorSignal: QSerialPort = ...
        RequestToSendSignal: QSerialPort = ...
        ClearToSendSignal: QSerialPort = ...
        SecondaryTransmittedDataSignal: QSerialPort = ...
        SecondaryReceivedDataSignal: QSerialPort = ...

    class FlowControl(int):
        NoFlowControl: QSerialPort = ...
        HardwareControl: QSerialPort = ...
        SoftwareControl: QSerialPort = ...
        UnknownFlowControl: QSerialPort = ...

    class StopBits(int):
        OneStop: QSerialPort = ...
        OneAndHalfStop: QSerialPort = ...
        TwoStop: QSerialPort = ...
        UnknownStopBits: QSerialPort = ...

    class Parity(int):
        NoParity: QSerialPort = ...
        EvenParity: QSerialPort = ...
        OddParity: QSerialPort = ...
        SpaceParity: QSerialPort = ...
        MarkParity: QSerialPort = ...
        UnknownParity: QSerialPort = ...

    class DataBits(int):
        Data5: QSerialPort = ...
        Data6: QSerialPort = ...
        Data7: QSerialPort = ...
        Data8: QSerialPort = ...
        UnknownDataBits: QSerialPort = ...

    class BaudRate(int):
        Baud1200: QSerialPort = ...
        Baud2400: QSerialPort = ...
        Baud4800: QSerialPort = ...
        Baud9600: QSerialPort = ...
        Baud19200: QSerialPort = ...
        Baud38400: QSerialPort = ...
        Baud57600: QSerialPort = ...
        Baud115200: QSerialPort = ...
        UnknownBaud: QSerialPort = ...

    class Direction(int):
        Input: QSerialPort = ...
        Output: QSerialPort = ...
        AllDirections: QSerialPort = ...

    class Directions(sip.simplewrapper):
        @typing.overload
        def __init__(self) -> None:
            ...

        @typing.overload
        def __init__(
            self, f: typing.Union["QSerialPort.Directions", "QSerialPort.Direction"]
        ) -> None:
            ...

        @typing.overload
        def __init__(self, a0: "QSerialPort.Directions") -> None:
            ...

        def __hash__(self) -> int:
            ...

        def __bool__(self) -> int:
            ...

        def __invert__(self) -> "QSerialPort.Directions":
            ...

        def __index__(self) -> int:
            ...

        def __int__(self) -> int:
            ...

    class PinoutSignals(sip.simplewrapper):
        @typing.overload
        def __init__(self) -> None:
            ...

        @typing.overload
        def __init__(
            self,
            f: typing.Union["QSerialPort.PinoutSignals", "QSerialPort.PinoutSignal"],
        ) -> None:
            ...

        @typing.overload
        def __init__(self, a0: "QSerialPort.PinoutSignals") -> None:
            ...

        def __hash__(self) -> int:
            ...

        def __bool__(self) -> int:
            ...

        def __invert__(self) -> "QSerialPort.PinoutSignals":
            ...

        def __index__(self) -> int:
            ...

        def __int__(self) -> int:
            ...

    @typing.overload
    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qserialport.html#QSerialPort

        **QSerialPort::QSerialPort(QObject * parent = nullptr)**

        Constructs a new serial port object with the given **parent**.
        """
        ...

    @typing.overload
    def __init__(
        self, name: str, parent: typing.Optional[QtCore.QObject] = ...
    ) -> None:
        """
        https://doc.qt.io/qt-5/qserialport.html#QSerialPort-1

        **QSerialPort::QSerialPort(const QString & name , QObject * parent =
        nullptr)**

        Constructs a new serial port object with the given **parent** to
        represent the serial port with the specified **name**.

        The name should have a specific format; see the **setPort** () method.
        """
        ...

    @typing.overload
    def __init__(
        self, info: "QSerialPortInfo", parent: typing.Optional[QtCore.QObject] = ...
    ) -> None:
        """
        https://doc.qt.io/qt-5/qserialport.html#QSerialPort-2

        **QSerialPort::QSerialPort(const QSerialPortInfo & serialPortInfo ,
        QObject * parent = nullptr)**

        Constructs a new serial port object with the given **parent** to
        represent the serial port with the specified helper class
        **serialPortInfo**.
        """
        ...

    def isBreakEnabled(self) -> bool:
        ...

    def handle(self) -> PyQt5.sip.voidptr:
        """
        https://doc.qt.io/qt-5/qserialport.html#handle

        **QSerialPort::Handle QSerialPort::handle() const**

        If the platform is supported and the serial port is open, returns the
        native serial port handle; otherwise returns `-1`.

        **Warning:** This function is for expert use only; use it at your own
        risk. Furthermore, this function carries no compatibility promise
        between minor Qt releases.

        This function was introduced in Qt 5.2.
        """
        ...

    def writeData(self, data: bytes) -> int:
        """
        https://doc.qt.io/qt-5/qserialport.html#writeData

        **[override virtual protected] qint64 QSerialPort::writeData(const char
        * data , qint64 maxSize )**

        Reimplements: **QIODevice::writeData** (const char *data, qint64
        maxSize).
        """
        ...

    def readLineData(self, maxlen: int) -> bytes:
        """
        https://doc.qt.io/qt-5/qserialport.html#readLineData

        **[override virtual protected] qint64 QSerialPort::readLineData(char *
        data , qint64 maxSize )**

        Reimplements: **QIODevice::readLineData** (char *data, qint64 maxSize).
        """
        ...

    def readData(self, maxlen: int) -> bytes:
        """
        https://doc.qt.io/qt-5/qserialport.html#readData

        **[override virtual protected] qint64 QSerialPort::readData(char * data
        , qint64 maxSize )**

        Reimplements: **QIODevice::readData** (char *data, qint64 maxSize).
        """
        ...

    def settingsRestoredOnCloseChanged(self, restore: bool) -> None:
        ...

    def dataErrorPolicyChanged(self, policy: "QSerialPort.DataErrorPolicy") -> None:
        ...

    def setBreakEnabled(self, enabled: bool = ...) -> bool:
        """
        https://doc.qt.io/qt-5/qserialport.html#breakEnabled-prop

        **breakEnabled : bool**

        This property holds the state of the transmission line in break

        Returns `true` on success, `false` otherwise. If the flag is `true` then
        the transmission line is in break state; otherwise is in non-break
        state.

        **Note:** The serial port has to be open before trying to set or get
        this property; otherwise returns `false` and sets the **NotOpenError**
        error code. This is a bit unusual as opposed to the regular Qt property
        settings of a class. However, this is a special use case since the
        property is set through the interaction with the kernel and hardware.
        Hence, the two scenarios cannot be completely compared to each other.

        This property was introduced in Qt 5.5.

        **Access functions:**

        bool **isBreakEnabled** () const
        bool **setBreakEnabled** (bool
        **set** = true)

        **Notifier signal:**

        void **breakEnabledChanged** (bool **set** )
        """
        ...

    def sendBreak(self, duration: int = ...) -> bool:
        """
        https://doc.qt.io/qt-5/qserialport.html#sendBreak

        **bool QSerialPort::sendBreak(int duration = 0)**

        Sends a continuous stream of zero bits during a specified period of time
        **duration** in msec if the terminal is using asynchronous serial data.
        If successful, returns `true`; otherwise returns `false`.

        If the duration is zero then zero bits are transmitted by at least
        `0.25` seconds, but no more than `0.5` seconds.

        If the duration is non zero then zero bits are transmitted within a
        certain period of time depending on the implementation.

        **Note:** The serial port has to be open before trying to send a break
        duration; otherwise returns `false` and sets the **NotOpenError**  error
        code.

        **See also** **setBreakEnabled** ().
        """
        ...

    def waitForBytesWritten(self, msecs: int = ...) -> bool:
        """
        https://doc.qt.io/qt-5/qserialport.html#waitForBytesWritten

        **[override virtual] bool QSerialPort::waitForBytesWritten(int msecs =
        30000)**

        Reimplements: **QIODevice::waitForBytesWritten** (int msecs).

        This function blocks until at least one byte has been written to the
        serial port and the **bytesWritten()**  signal has been emitted. The
        function will timeout after **msecs** milliseconds; the default timeout
        is 30000 milliseconds. If **msecs** is -1, this function will not time
        out.

        The function returns `true` if the **bytesWritten** () signal is
        emitted; otherwise it returns `false` (if an error occurred or the
        operation timed out).
        """
        ...

    def waitForReadyRead(self, msecs: int = ...) -> bool:
        """
        https://doc.qt.io/qt-5/qserialport.html#waitForReadyRead

        **[override virtual] bool QSerialPort::waitForReadyRead(int msecs =
        30000)**

        Reimplements: **QIODevice::waitForReadyRead** (int msecs).

        This function blocks until new data is available for reading and the
        **readyRead()**  signal has been emitted. The function will timeout
        after **msecs** milliseconds; the default timeout is 30000 milliseconds.
        If **msecs** is -1, this function will not time out.

        The function returns `true` if the **readyRead** () signal is emitted
        and there is new data available for reading; otherwise it returns
        `false` (if an error occurred or the operation timed out).

        **See also** **waitForBytesWritten** ().
        """
        ...

    def canReadLine(self) -> bool:
        """
        https://doc.qt.io/qt-5/qserialport.html#canReadLine

        **[override virtual] bool QSerialPort::canReadLine() const**

        Reimplements: **QIODevice::canReadLine** () const.

        Returns `true` if a line of data can be read from the serial port;
        otherwise returns `false`.

        **See also** **readLine** ().
        """
        ...

    def bytesToWrite(self) -> int:
        """
        https://doc.qt.io/qt-5/qserialport.html#bytesToWrite

        **[override virtual] qint64 QSerialPort::bytesToWrite() const**

        Reimplements: **QIODevice::bytesToWrite** () const.

        Returns the number of bytes that are waiting to be written. The bytes
        are written when control goes back to the event loop or when **flush**
        () is called.

        **See also** **bytesAvailable** () and **flush** ().
        """
        ...

    def bytesAvailable(self) -> int:
        """
        https://doc.qt.io/qt-5/qserialport.html#bytesAvailable

        **[override virtual] qint64 QSerialPort::bytesAvailable() const**

        Reimplements: **QIODevice::bytesAvailable** () const.

        Returns the number of incoming bytes that are waiting to be read.

        **See also** **bytesToWrite** () and **read** ().
        """
        ...

    def isSequential(self) -> bool:
        """
        https://doc.qt.io/qt-5/qserialport.html#isSequential

        **[override virtual] bool QSerialPort::isSequential() const**

        Reimplements: **QIODevice::isSequential** () const.

        Always returns `true`. The serial port is a sequential device.
        """
        ...

    def setReadBufferSize(self, size: int) -> None:
        """
        https://doc.qt.io/qt-5/qserialport.html#setReadBufferSize

        **void QSerialPort::setReadBufferSize(qint64 size )**

        Sets the size of **QSerialPort** 's internal read buffer to be **size**
        bytes.

        If the buffer size is limited to a certain size, **QSerialPort**  will
        not buffer more than this size of data. The special case of a buffer
        size of `0` means that the read buffer is unlimited and all incoming
        data is buffered. This is the default.

        This option is useful if the data is only read at certain points in time
        (for instance in a real-time streaming application) or if the serial
        port should be protected against receiving too much data, which may
        eventually cause the application to run out of memory.

        **See also** **readBufferSize** () and **read** ().
        """
        ...

    def readBufferSize(self) -> int:
        """
        https://doc.qt.io/qt-5/qserialport.html#readBufferSize

        **qint64 QSerialPort::readBufferSize() const**

        Returns the size of the internal read buffer. This limits the amount of
        data that the client can receive before calling the **read** () or
        **readAll** () methods.

        A read buffer size of `0` (the default) means that the buffer has no
        size limit, ensuring that no data is lost.

        **See also** **setReadBufferSize** () and **read** ().
        """
        ...

    def clearError(self) -> None:
        ...

    @typing.overload
    def error(self) -> "QSerialPort.SerialPortError":
        """
        https://doc.qt.io/qt-5/qserialport.html#error-prop

        **error : SerialPortError**

        This property holds the error status of the serial port

        The I/O device status returns an error code. For example, if **open** ()
        returns `false`, or a read/write operation returns `-1`, this property
        can be used to figure out the reason why the operation failed.

        The error code is set to the default **QSerialPort::NoError**  after a
        call to clearError()

        **Access functions:**

        QSerialPort::SerialPortError **error** () const
        void **clearError** ()
        """
        ...

    @typing.overload
    def error(self, serialPortError: "QSerialPort.SerialPortError") -> None:
        """
        https://doc.qt.io/qt-5/qserialport.html#error-prop

        **error : SerialPortError**

        This property holds the error status of the serial port

        The I/O device status returns an error code. For example, if **open** ()
        returns `false`, or a read/write operation returns `-1`, this property
        can be used to figure out the reason why the operation failed.

        The error code is set to the default **QSerialPort::NoError**  after a
        call to clearError()

        **Access functions:**

        QSerialPort::SerialPortError **error** () const
        void **clearError** ()
        """
        ...

    def dataErrorPolicy(self) -> "QSerialPort.DataErrorPolicy":
        ...

    def setDataErrorPolicy(self, policy: "QSerialPort.DataErrorPolicy" = ...) -> bool:
        ...

    def atEnd(self) -> bool:
        """
        https://doc.qt.io/qt-5/qserialport.html#atEnd

        **[override virtual] bool QSerialPort::atEnd() const**

        Reimplements: **QIODevice::atEnd** () const.

        Returns `true` if no more data is currently available for reading;
        otherwise returns `false`.

        This function is most commonly used when reading data from the serial
        port in a loop. For example:

        // This slot is connected to QSerialPort::readyRead()
            void
        QSerialPortClass::readyReadSlot()
            {
                while (!port.atEnd()) {
        **QByteArray**  data = port.read(100);
                    ....
                }
            }

        **See also** **bytesAvailable** () and **readyRead** ().
        """
        ...

    def clear(
        self, dir: typing.Union["QSerialPort.Directions", "QSerialPort.Direction"] = ...
    ) -> bool:
        """
        https://doc.qt.io/qt-5/qserialport.html#clear

        **bool QSerialPort::clear(QSerialPort::Directions directions =
        AllDirections)**

        Discards all characters from the output or input buffer, depending on
        given directions **directions**. This includes clearing the internal
        class buffers and the UART (driver) buffers. Also terminate pending read
        or write operations. If successful, returns `true`; otherwise returns
        `false`.

        **Note:** The serial port has to be open before trying to clear any
        buffered data; otherwise returns `false` and sets the **NotOpenError**
        error code.
        """
        ...

    def flush(self) -> bool:
        """
        https://doc.qt.io/qt-5/qserialport.html#flush

        **bool QSerialPort::flush()**

        This function writes as much as possible from the internal write buffer
        to the underlying serial port without blocking. If any data was written,
        this function returns `true`; otherwise returns `false`.

        Call this function for sending the buffered data immediately to the
        serial port. The number of bytes successfully written depends on the
        operating system. In most cases, this function does not need to be
        called, because the **QSerialPort**  class will start sending data
        automatically once control is returned to the event loop. In the absence
        of an event loop, call **waitForBytesWritten** () instead.

        **Note:** The serial port has to be open before trying to flush any
        buffered data; otherwise returns `false` and sets the **NotOpenError**
        error code.

        **See also** **write** () and **waitForBytesWritten** ().
        """
        ...

    def pinoutSignals(self) -> "QSerialPort.PinoutSignals":
        """
        https://doc.qt.io/qt-5/qserialport.html#pinoutSignals

        **QSerialPort::PinoutSignals QSerialPort::pinoutSignals()**

        Returns the state of the line signals in a bitmap format.

        From this result, it is possible to allocate the state of the desired
        signal by applying a mask "AND", where the mask is the desired
        enumeration value from **QSerialPort::PinoutSignals** .

        **Note:** This method performs a system call, thus ensuring that the
        line signal states are returned properly. This is necessary when the
        underlying operating systems cannot provide proper notifications about
        the changes.

        **Note:** The serial port has to be open before trying to get the pinout
        signals; otherwise returns **NoSignal**  and sets the **NotOpenError**
        error code.

        **See also** **QSerialPort::dataTerminalReady**  and
        **QSerialPort::requestToSend** .
        """
        ...

    def isRequestToSend(self) -> bool:
        ...

    def setRequestToSend(self, set: bool) -> bool:
        """
        https://doc.qt.io/qt-5/qserialport.html#requestToSend-prop

        **requestToSend : bool**

        This property holds the state (high or low) of the line signal RTS

        Returns `true` on success, `false` otherwise. If the flag is `true` then
        the RTS signal is set to high; otherwise low.

        **Note:** The serial port has to be open before trying to set or get
        this property; otherwise `false` is returned and the error code is set
        to **NotOpenError** .

        **Note:** An attempt to control the RTS signal in the
        **HardwareControl**  mode will fail with error code set to
        **UnsupportedOperationError** , because the signal is automatically
        controlled by the driver.

        **Access functions:**

        bool **isRequestToSend** ()
        bool **setRequestToSend** (bool **set** )

        **Notifier signal:**

        void ****requestToSendChanged** ** (bool **set** )

        **See also** **pinoutSignals** ().
        """
        ...

    def isDataTerminalReady(self) -> bool:
        ...

    def setDataTerminalReady(self, set: bool) -> bool:
        """
        https://doc.qt.io/qt-5/qserialport.html#dataTerminalReady-prop

        **dataTerminalReady : bool**

        This property holds the state (high or low) of the line signal DTR

        Returns `true` on success, `false` otherwise. If the flag is `true` then
        the DTR signal is set to high; otherwise low.

        **Note:** The serial port has to be open before trying to set or get
        this property; otherwise `false` is returned and the error code is set
        to **NotOpenError** .

        **Access functions:**

        bool **isDataTerminalReady** ()
        bool **setDataTerminalReady** (bool
        **set** )

        **Notifier signal:**

        void ****dataTerminalReadyChanged** ** (bool **set** )

        **See also** **pinoutSignals** ().
        """
        ...

    def flowControl(self) -> "QSerialPort.FlowControl":
        """
        https://doc.qt.io/qt-5/qserialport.html#flowControl-prop

        **flowControl : FlowControl**

        This property holds the desired flow control mode

        If the setting is successful or set before opening the port, returns
        `true`; otherwise returns `false` and sets an error code which can be
        obtained by accessing the value of the **QSerialPort::error**  property.

        **Note:** If the setting is set before opening the port, the actual
        serial port setting is done automatically in the **QSerialPort::open**
        () method right after that the opening of the port succeeds.

        The default value is **NoFlowControl** , i.e. no flow control.

        **Access functions:**

        QSerialPort::FlowControl **flowControl** () const
        bool
        **setFlowControl** (QSerialPort::FlowControl **flowControl** )

        **Notifier signal:**

        void ****flowControlChanged** ** (QSerialPort::FlowControl **flow** )
        """
        ...

    def setFlowControl(self, flow: "QSerialPort.FlowControl") -> bool:
        """
        https://doc.qt.io/qt-5/qserialport.html#flowControl-prop

        **flowControl : FlowControl**

        This property holds the desired flow control mode

        If the setting is successful or set before opening the port, returns
        `true`; otherwise returns `false` and sets an error code which can be
        obtained by accessing the value of the **QSerialPort::error**  property.

        **Note:** If the setting is set before opening the port, the actual
        serial port setting is done automatically in the **QSerialPort::open**
        () method right after that the opening of the port succeeds.

        The default value is **NoFlowControl** , i.e. no flow control.

        **Access functions:**

        QSerialPort::FlowControl **flowControl** () const
        bool
        **setFlowControl** (QSerialPort::FlowControl **flowControl** )

        **Notifier signal:**

        void ****flowControlChanged** ** (QSerialPort::FlowControl **flow** )
        """
        ...

    def stopBits(self) -> "QSerialPort.StopBits":
        """
        https://doc.qt.io/qt-5/qserialport.html#stopBits-prop

        **stopBits : StopBits**

        This property holds the number of stop bits in a frame

        If the setting is successful or set before opening the port, returns
        `true`; otherwise returns `false` and sets an error code which can be
        obtained by accessing the value of the **QSerialPort::error**  property.

        **Note:** If the setting is set before opening the port, the actual
        serial port setting is done automatically in the **QSerialPort::open**
        () method right after that the opening of the port succeeds.

        The default value is **OneStop** , i.e. 1 stop bit.

        **Access functions:**

        QSerialPort::StopBits **stopBits** () const
        bool **setStopBits**
        (QSerialPort::StopBits **stopBits** )

        **Notifier signal:**

        void ****stopBitsChanged** ** (QSerialPort::StopBits **stopBits** )

        **Member Function Documentation**
        """
        ...

    def setStopBits(self, stopBits: "QSerialPort.StopBits") -> bool:
        """
        https://doc.qt.io/qt-5/qserialport.html#stopBits-prop

        **stopBits : StopBits**

        This property holds the number of stop bits in a frame

        If the setting is successful or set before opening the port, returns
        `true`; otherwise returns `false` and sets an error code which can be
        obtained by accessing the value of the **QSerialPort::error**  property.

        **Note:** If the setting is set before opening the port, the actual
        serial port setting is done automatically in the **QSerialPort::open**
        () method right after that the opening of the port succeeds.

        The default value is **OneStop** , i.e. 1 stop bit.

        **Access functions:**

        QSerialPort::StopBits **stopBits** () const
        bool **setStopBits**
        (QSerialPort::StopBits **stopBits** )

        **Notifier signal:**

        void ****stopBitsChanged** ** (QSerialPort::StopBits **stopBits** )

        **Member Function Documentation**
        """
        ...

    def parity(self) -> "QSerialPort.Parity":
        """
        https://doc.qt.io/qt-5/qserialport.html#parity-prop

        **parity : Parity**

        This property holds the parity checking mode

        If the setting is successful or set before opening the port, returns
        `true`; otherwise returns `false` and sets an error code which can be
        obtained by accessing the value of the **QSerialPort::error**  property.

        **Note:** If the setting is set before opening the port, the actual
        serial port setting is done automatically in the **QSerialPort::open**
        () method right after that the opening of the port succeeds.

        The default value is **NoParity** , i.e. no parity.

        **Access functions:**

        QSerialPort::Parity **parity** () const
        bool **setParity**
        (QSerialPort::Parity **parity** )

        **Notifier signal:**

        void ****parityChanged** ** (QSerialPort::Parity **parity** )
        """
        ...

    def setParity(self, parity: "QSerialPort.Parity") -> bool:
        """
        https://doc.qt.io/qt-5/qserialport.html#parity-prop

        **parity : Parity**

        This property holds the parity checking mode

        If the setting is successful or set before opening the port, returns
        `true`; otherwise returns `false` and sets an error code which can be
        obtained by accessing the value of the **QSerialPort::error**  property.

        **Note:** If the setting is set before opening the port, the actual
        serial port setting is done automatically in the **QSerialPort::open**
        () method right after that the opening of the port succeeds.

        The default value is **NoParity** , i.e. no parity.

        **Access functions:**

        QSerialPort::Parity **parity** () const
        bool **setParity**
        (QSerialPort::Parity **parity** )

        **Notifier signal:**

        void ****parityChanged** ** (QSerialPort::Parity **parity** )
        """
        ...

    def dataBits(self) -> "QSerialPort.DataBits":
        """
        https://doc.qt.io/qt-5/qserialport.html#dataBits-prop

        **dataBits : DataBits**

        This property holds the data bits in a frame

        If the setting is successful or set before opening the port, returns
        `true`; otherwise returns `false` and sets an error code which can be
        obtained by accessing the value of the **QSerialPort::error**  property.

        **Note:** If the setting is set before opening the port, the actual
        serial port setting is done automatically in the **QSerialPort::open**
        () method right after that the opening of the port succeeds.

        The default value is Data8, i.e. 8 data bits.

        **Access functions:**

        QSerialPort::DataBits **dataBits** () const
        bool **setDataBits**
        (QSerialPort::DataBits **dataBits** )

        **Notifier signal:**

        void ****dataBitsChanged** ** (QSerialPort::DataBits **dataBits** )
        """
        ...

    def setDataBits(self, dataBits: "QSerialPort.DataBits") -> bool:
        """
        https://doc.qt.io/qt-5/qserialport.html#dataBits-prop

        **dataBits : DataBits**

        This property holds the data bits in a frame

        If the setting is successful or set before opening the port, returns
        `true`; otherwise returns `false` and sets an error code which can be
        obtained by accessing the value of the **QSerialPort::error**  property.

        **Note:** If the setting is set before opening the port, the actual
        serial port setting is done automatically in the **QSerialPort::open**
        () method right after that the opening of the port succeeds.

        The default value is Data8, i.e. 8 data bits.

        **Access functions:**

        QSerialPort::DataBits **dataBits** () const
        bool **setDataBits**
        (QSerialPort::DataBits **dataBits** )

        **Notifier signal:**

        void ****dataBitsChanged** ** (QSerialPort::DataBits **dataBits** )
        """
        ...

    def baudRate(
        self, dir: typing.Union["QSerialPort.Directions", "QSerialPort.Direction"] = ...
    ) -> int:
        """
        https://doc.qt.io/qt-5/qserialport.html#baudRate-prop

        **baudRate : qint32**

        This property holds the data baud rate for the desired direction

        If the setting is successful or set before opening the port, returns
        `true`; otherwise returns `false` and sets an error code which can be
        obtained by accessing the value of the **QSerialPort::error**  property.
        To set the baud rate, use the enumeration **QSerialPort::BaudRate**  or
        any positive qint32 value.

        **Note:** If the setting is set before opening the port, the actual
        serial port setting is done automatically in the **QSerialPort::open**
        () method right after that the opening of the port succeeds.

        **Warning:** Setting the **AllDirections**  flag is supported on all
        platforms. Windows supports only this mode.

        **Warning:** Returns equal baud rate in any direction on Windows.

        The default value is Baud9600, i.e. 9600 bits per second.

        **Access functions:**

        qint32 **baudRate** (QSerialPort::Directions **directions** =
        AllDirections) const
        bool **setBaudRate** (qint32 **baudRate** ,
        QSerialPort::Directions **directions** = AllDirections)

        **Notifier signal:**

        void ****baudRateChanged** ** (qint32 **baudRate** ,
        QSerialPort::Directions **directions** )
        """
        ...

    def setBaudRate(
        self,
        baudRate: int,
        dir: typing.Union["QSerialPort.Directions", "QSerialPort.Direction"] = ...,
    ) -> bool:
        """
        https://doc.qt.io/qt-5/qserialport.html#baudRate-prop

        **baudRate : qint32**

        This property holds the data baud rate for the desired direction

        If the setting is successful or set before opening the port, returns
        `true`; otherwise returns `false` and sets an error code which can be
        obtained by accessing the value of the **QSerialPort::error**  property.
        To set the baud rate, use the enumeration **QSerialPort::BaudRate**  or
        any positive qint32 value.

        **Note:** If the setting is set before opening the port, the actual
        serial port setting is done automatically in the **QSerialPort::open**
        () method right after that the opening of the port succeeds.

        **Warning:** Setting the **AllDirections**  flag is supported on all
        platforms. Windows supports only this mode.

        **Warning:** Returns equal baud rate in any direction on Windows.

        The default value is Baud9600, i.e. 9600 bits per second.

        **Access functions:**

        qint32 **baudRate** (QSerialPort::Directions **directions** =
        AllDirections) const
        bool **setBaudRate** (qint32 **baudRate** ,
        QSerialPort::Directions **directions** = AllDirections)

        **Notifier signal:**

        void ****baudRateChanged** ** (qint32 **baudRate** ,
        QSerialPort::Directions **directions** )
        """
        ...

    def settingsRestoredOnClose(self) -> bool:
        ...

    def setSettingsRestoredOnClose(self, restore: bool) -> None:
        ...

    def close(self) -> None:
        """
        https://doc.qt.io/qt-5/qserialport.html#close

        **[override virtual] void QSerialPort::close()**

        Reimplements: **QIODevice::close** ().

        **Note:** The serial port has to be open before trying to close it;
        otherwise sets the **NotOpenError**  error code.

        **See also** **QIODevice::close** ().
        """
        ...

    def open(
        self,
        mode: typing.Union[QtCore.QIODevice.OpenMode, QtCore.QIODevice.OpenModeFlag],
    ) -> bool:
        """
        https://doc.qt.io/qt-5/qserialport.html#open

        **[override virtual] bool QSerialPort::open(QIODevice::OpenMode mode )**

        Reimplements: **QIODevice::open** (QIODevice::OpenMode mode).

        Opens the serial port using **OpenMode**  **mode** , and then returns
        `true` if successful; otherwise returns `false` and sets an error code
        which can be obtained by calling the **error** () method.

        **Note:** The method returns `false` if opening the port is successful,
        but could not set any of the port settings successfully. In that case,
        the port is closed automatically not to leave the port around with
        incorrect settings.

        **Warning:** The **mode** has to be **QIODevice::ReadOnly** ,
        **QIODevice::WriteOnly** , or **QIODevice::ReadWrite** . Other modes are
        unsupported.

        **See also** **QIODevice::OpenMode**  and **setPort** ().
        """
        ...

    def setPort(self, info: "QSerialPortInfo") -> None:
        """
        https://doc.qt.io/qt-5/qserialport.html#setPort

        **void QSerialPort::setPort(const QSerialPortInfo & serialPortInfo )**

        Sets the port stored in the serial port info instance
        **serialPortInfo**.

        **See also** **portName** () and **QSerialPortInfo** .
        """
        ...

    def portName(self) -> str:
        """
        https://doc.qt.io/qt-5/qserialport.html#portName

        **QString QSerialPort::portName() const**

        Returns the name set by **setPort** () or passed to the **QSerialPort**
        constructor. This name is short, i.e. it is extracted and converted from
        the internal variable system location of the device. The conversion
        algorithm is platform specific:

        PlatformBrief Description
        WindowsRemoves the prefix "\\\\\\\\.\\" or "//./"
        from the system location and returns the remainder of the string.
        Unix, BSDRemoves the prefix "/dev/" from the system location and returns
        the remainder of the string.

        **See also** **setPortName** (), **setPort** (), and
        **QSerialPortInfo::portName** ().
        """
        ...

    def setPortName(self, name: str) -> None:
        """
        https://doc.qt.io/qt-5/qserialport.html#setPortName

        **void QSerialPort::setPortName(const QString & name )**

        Sets the **name** of the serial port.

        The name of the serial port can be passed as either a short name or the
        long system location if necessary.

        **See also** **portName** () and **QSerialPortInfo** .
        """
        ...

    @property
    def baudRateChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qserialport.html#baudRateChanged

        **[signal] void QSerialPort::baudRateChanged(qint32 baudRate ,
        QSerialPort::Directions directions )**

        This signal is emitted after the baud rate has been changed. The new
        baud rate is passed as **baudRate** and directions as **directions**.

        **Note:** Notifier signal for property **baudRate** .

        **See also** **QSerialPort::baudRate** .
        """
        ...

    @property
    def breakEnabledChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        ...

    @property
    def dataBitsChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qserialport.html#dataBitsChanged

        **[signal] void QSerialPort::dataBitsChanged(QSerialPort::DataBits
        dataBits )**

        This signal is emitted after the data bits in a frame has been changed.
        The new data bits in a frame is passed as **dataBits**.

        **Note:** Notifier signal for property **dataBits** .

        **See also** **QSerialPort::dataBits** .
        """
        ...

    @property
    def dataTerminalReadyChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qserialport.html#dataTerminalReadyChanged

        **[signal] void QSerialPort::dataTerminalReadyChanged(bool set )**

        This signal is emitted after the state (high or low) of the line signal
        DTR has been changed. The new the state (high or low) of the line signal
        DTR is passed as **set**.

        **Note:** Notifier signal for property **dataTerminalReady** .

        **See also** **QSerialPort::dataTerminalReady** .
        """
        ...

    @property
    def errorOccurred(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qserialport.html#errorOccurred

        **[signal] void QSerialPort::errorOccurred(QSerialPort::SerialPortError
        error )**

        This signal is emitted when an error occurs in the serial port. The
        specified **error** describes the type of error that occurred.

        This function was introduced in Qt 5.8.

        **See also** **QSerialPort::error** .
        """
        ...

    @property
    def flowControlChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qserialport.html#flowControlChanged

        **[signal] void QSerialPort::flowControlChanged(QSerialPort::FlowControl
        flow )**

        This signal is emitted after the flow control mode has been changed. The
        new flow control mode is passed as **flow**.

        **Note:** Notifier signal for property **flowControl** .

        **See also** **QSerialPort::flowControl** .
        """
        ...

    @property
    def parityChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qserialport.html#parityChanged

        **[signal] void QSerialPort::parityChanged(QSerialPort::Parity parity
        )**

        This signal is emitted after the parity checking mode has been changed.
        The new parity checking mode is passed as **parity**.

        **Note:** Notifier signal for property **parity** .

        **See also** **QSerialPort::parity** .
        """
        ...

    @property
    def requestToSendChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qserialport.html#requestToSendChanged

        **[signal] void QSerialPort::requestToSendChanged(bool set )**

        This signal is emitted after the state (high or low) of the line signal
        RTS has been changed. The new the state (high or low) of the line signal
        RTS is passed as **set**.

        **Note:** Notifier signal for property **requestToSend** .

        **See also** **QSerialPort::requestToSend** .
        """
        ...

    @property
    def stopBitsChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qserialport.html#stopBitsChanged

        **[signal] void QSerialPort::stopBitsChanged(QSerialPort::StopBits
        stopBits )**

        This signal is emitted after the number of stop bits in a frame has been
        changed. The new number of stop bits in a frame is passed as
        **stopBits**.

        **Note:** Notifier signal for property **stopBits** .

        **See also** **QSerialPort::stopBits** .
        """
        ...
