"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
import PyQt5.sip
from PyQt5 import QtCore
from PyQt5.QtSensors import *


class QLightSensor(QSensor):
    """
    https://doc.qt.io/qt-5/qlightsensor.html

    **Detailed Description**

    The only behavioural difference is that this class sets the type properly.

    This class also features a **reading** () function that returns a
    **QLightReading**  instead of a **QSensorReading** .

    For details about how the sensor works, see **QLightReading** .

    **See also** **QLightReading** .
    """

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qlightsensor.html#QLightSensor

        **QLightSensor::QLightSensor(QObject * parent = Q_NULLPTR)**

        Construct the sensor as a child of **parent**.
        """
        ...

    def setFieldOfView(self, fieldOfView: float) -> None:
        """
        https://doc.qt.io/qt-5/qlightsensor.html#setFieldOfView

        **void QLightSensor::setFieldOfView(qreal fieldOfView )**

        Sets the field of view to **fieldOfView**. This is to be called from the
        backend.

        This function was introduced in Qt 5.1.

        **See also** **fieldOfView** ().
        """
        ...

    def fieldOfView(self) -> float:
        """
        https://doc.qt.io/qt-5/qlightsensor.html#fieldOfView-prop

        **fieldOfView : const qreal**

        This property holds a value indicating the field of view.

        This is an angle that represents the field of view of the sensor.

        Not all light sensor support retrieving their field of view. For sensors
        that don't support this property, the value will be 0. Whether the field
        of view is supported can be checked with **QSensor::isFeatureSupported**
        () and the **QSensor::FieldOfView**  flag.

        **Access functions:**

        qreal **fieldOfView** () const

        **Notifier signal:**

        void **fieldOfViewChanged** (qreal **fieldOfView** )

        **Member Function Documentation**
        """
        ...

    def reading(self) -> QLightReading:
        """
        https://doc.qt.io/qt-5/qlightsensor.html#reading

        **QLightReading *QLightSensor::reading() const**

        Returns the reading class for this sensor.

        **See also** **QSensor::reading** ().
        """
        ...

    @property
    def fieldOfViewChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        ...
