"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
from PyQt5.QtSensors import *


class QLidReading(QSensorReading):
    """
    https://doc.qt.io/qt-5/qlidreading.html

    **Detailed Description**

    A normal laptop has what we call a front lid.

    If the laptop can be converted to a tablet by rotating or closing the lid
    where the display is out, this is known as a back lid.

    **QLidReading Units**

    The Lid sensor can detect if a device's lid is closed or not. A lid can be a
    laptop, a laptop that converts to a tablet, or even a cover for a tablet or
    phone.
    """

    def frontLidChanged(self, closed: bool) -> None:
        ...

    def backLidChanged(self, closed: bool) -> None:
        ...

    def setFrontLidClosed(self, closed: bool) -> None:
        """
        https://doc.qt.io/qt-5/qlidreading.html#setFrontLidClosed

        **void QLidReading::setFrontLidClosed(bool closed )**

        Sets the **frontLidClosed**  value to **closed**.

        **See also** **frontLidClosed** ().
        """
        ...

    def frontLidClosed(self) -> bool:
        """
        https://doc.qt.io/qt-5/qlidreading.html#frontLidClosed-prop

        **frontLidClosed : const bool**

        This property holds a value indicating whether the front lid is closed.
        A front lid would be a normal laptop lid.

        **Access functions:**

        bool **frontLidClosed** () const

        **See also** **QLidReading Units** .

        **Member Function Documentation**
        """
        ...

    def setBackLidClosed(self, closed: bool) -> None:
        """
        https://doc.qt.io/qt-5/qlidreading.html#setBackLidClosed

        **void QLidReading::setBackLidClosed(bool closed )**

        Sets the **backLidClosed**  value to **closed**.

        **See also** **backLidClosed** ().
        """
        ...

    def backLidClosed(self) -> bool:
        """
        https://doc.qt.io/qt-5/qlidreading.html#backLidClosed-prop

        **backLidClosed : const bool**

        This property holds a value indicating whether the back lid is closed. A
        back lid can be when a convertable laptop is closed into to tablet mode
        without keyboard.

        **Access functions:**

        bool **backLidClosed** () const

        **See also** **QLidReading Units** .
        """
        ...
