"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
from PyQt5.QtSensors import *


class QIRProximityReading(QSensorReading):
    """
    https://doc.qt.io/qt-5/qirproximityreading.html

    **Detailed Description**

    The IR (infra-red) proximity sensor detects proximity by beaming out infra-
    red light and detecting how much of the light returns.

    The biggest limitation of this technology is that there is no reliable way
    to turn the reflectance values into distances unless both the item being
    detected and the ambient conditions are known.

    **QIRProximityReading Units**

    The sensor reports reflectance as a decimal fraction in the range of 0 - 1.
    That is, 0 indicates nothing was detected within the range of the sensor and
    1 indicates the infra-red signal returned at the full power level that it
    was sent at.

    With some IR sensors, it is quite uncommon to reach the top and the bottom
    of the value range, and some parts of the range ends might not be obtainable
    at all. This is due to the behavior of the sensor hardware. With these
    sensors, the absolute value of reflectance should never be used directly.
    Instead, applications should react to the relative change of the reading
    values. Use **QProximitySensor**  if it is only necessary to check if
    something is close to the device or not.
    """

    def setReflectance(self, reflectance: float) -> None:
        """
        https://doc.qt.io/qt-5/qirproximityreading.html#setReflectance

        **void QIRProximityReading::setReflectance(qreal reflectance )**

        Sets the reflectance value to **reflectance**.

        **See also** **reflectance** ().
        """
        ...

    def reflectance(self) -> float:
        """
        https://doc.qt.io/qt-5/qirproximityreading.html#reflectance-prop

        **reflectance : const qreal**

        Holds the reflectance value.

        The reflectance is a decimal fraction (from 0 to 1) indicating how much
        of the transmitted infra-red light was returned.

        **Access functions:**

        qreal **reflectance** () const

        **See also** **QIRProximityReading Units** .

        **Member Function Documentation**
        """
        ...
