"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
from PyQt5.QtSensors import *


class QDistanceReading(QSensorReading):
    """
    https://doc.qt.io/qt-5/qdistancereading.html

    **Detailed Description**

    The QDistanceReading class holds distance reading in cm from the proximity
    sensor. Note: Some proximity sensor only support two values for distance, a
    near and far value. In this case, the sensor should report its maximum range
    value to represent the far state, and a lesser value to represent the near
    state.

    **QDistanceReading Units**

    The distance is measured in cm

    The distance sensor is typically located in the front face of a device, and
    thus will measure the distance of an object from the device's front face.
    """

    def setDistance(self, distance: float) -> None:
        """
        https://doc.qt.io/qt-5/qdistancereading.html#setDistance

        **void QDistanceReading::setDistance(qreal distance )**

        Sets distance to **distance**.

        **See also** **distance** ().
        """
        ...

    def distance(self) -> float:
        """
        https://doc.qt.io/qt-5/qdistancereading.html#distance-prop

        **distance : const qreal**

        distance of object from front face of device

        **Access functions:**

        qreal **distance** () const

        **See also** **QDistanceReading Units** .

        **Member Function Documentation**
        """
        ...
