"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
from PyQt5.QtSensors import *


class QAmbientLightReading(QSensorReading):
    """
    https://doc.qt.io/qt-5/qambientlightreading.html

    **Detailed Description**

    **QAmbientLightReading Units**

    The ambient light sensor returns the intensity of the ambient light using
    the pre-defined values found in the **QAmbientLightReading::LightLevel**
    enum.
    """

    class LightLevel(int):
        Undefined: QAmbientLightReading = ...
        Dark: QAmbientLightReading = ...
        Twilight: QAmbientLightReading = ...
        Light: QAmbientLightReading = ...
        Bright: QAmbientLightReading = ...
        Sunny: QAmbientLightReading = ...

    def setLightLevel(self, lightLevel: "QAmbientLightReading.LightLevel") -> None:
        """
        https://doc.qt.io/qt-5/qambientlightreading.html#setLightLevel

        **void
        QAmbientLightReading::setLightLevel(QAmbientLightReading::LightLevel
        lightLevel )**

        Sets the ambient light level to **lightLevel**.

        **See also** **lightLevel** ().
        """
        ...

    def lightLevel(self) -> "QAmbientLightReading.LightLevel":
        """
        https://doc.qt.io/qt-5/qambientlightreading.html#lightLevel-prop

        **lightLevel : const LightLevel**

        This property holds the ambient light level.

        The value represents the ambient light and comes from
        **QAmbientLightReading::LightLevel** .

        **Access functions:**

        QAmbientLightReading::LightLevel **lightLevel** () const

        **See also** **QAmbientLightReading Units** .

        **Member Function Documentation**
        """
        ...
