"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
from PyQt5.QtSensors import *


class QAccelerometerReading(QSensorReading):
    """
    https://doc.qt.io/qt-5/qaccelerometerreading.html

    **Detailed Description**

    **QAccelerometerReading Units**

    The scale of the values is meters per second squared. The axes are arranged
    as follows.

    ![](images/sensors-coordinates2.jpg)

    A monoblock device sitting at rest, face up on a desk will experience a
    force of approximately 9.8 on the Z axis (ie. towards the roof). This is the
    proper acceleration the device experiences relative to freefall.
    """

    def setZ(self, z: float) -> None:
        """
        https://doc.qt.io/qt-5/qaccelerometerreading.html#setZ

        **void QAccelerometerReading::setZ(qreal z )**

        Sets the acceleration on the Z axis to **z**.

        **See also** **z** ().
        """
        ...

    def z(self) -> float:
        """
        https://doc.qt.io/qt-5/qaccelerometerreading.html#z-prop

        **z : const qreal**

        This property holds the acceleration on the Z axis.

        The scale of the values is meters per second squared.

        **Access functions:**

        qreal **z** () const

        **See also** **QAccelerometerReading Units** .

        **Member Function Documentation**
        """
        ...

    def setY(self, y: float) -> None:
        """
        https://doc.qt.io/qt-5/qaccelerometerreading.html#setY

        **void QAccelerometerReading::setY(qreal y )**

        Sets the acceleration on the Y axis to **y**.

        **See also** **y** ().
        """
        ...

    def y(self) -> float:
        """
        https://doc.qt.io/qt-5/qaccelerometerreading.html#y-prop

        **y : const qreal**

        This property holds the acceleration on the Y axis.

        The scale of the values is meters per second squared.

        **Access functions:**

        qreal **y** () const

        **See also** **QAccelerometerReading Units** .
        """
        ...

    def setX(self, x: float) -> None:
        """
        https://doc.qt.io/qt-5/qaccelerometerreading.html#setX

        **void QAccelerometerReading::setX(qreal x )**

        Sets the acceleration on the X axis to **x**.

        **See also** **x** ().
        """
        ...

    def x(self) -> float:
        """
        https://doc.qt.io/qt-5/qaccelerometerreading.html#x-prop

        **x : const qreal**

        This property holds the acceleration on the X axis.

        The scale of the values is meters per second squared.

        **Access functions:**

        qreal **x** () const

        **See also** **QAccelerometerReading Units** .
        """
        ...
