"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
import PyQt5.sip
from PyQt5 import QtWidgets
from PyQt5 import QtQuick
from PyQt5 import QtQml
from PyQt5 import QtGui
from PyQt5 import QtCore
from PyQt5.QtQuickWidgets import *


class QQuickWidget(QtWidgets.QWidget):
    """
    https://doc.qt.io/qt-5/qquickwidget.html

    **Detailed Description**

    This is a convenience wrapper for **QQuickWindow**  which will automatically
    load and display a QML scene when given the URL of the main source file.
    Alternatively, you can instantiate your own objects using **QQmlComponent**
    and place them in a manually set up QQuickWidget.

    Typical usage:

    **QQuickWidget**  *view = new **QQuickWidget** ;
    view->setSource(**QUrl** ::fromLocalFile("myqmlfile.qml"));
    view->show();

    To receive errors related to loading and executing QML with QQuickWidget,
    you can connect to the **statusChanged** () signal and monitor for
    **QQuickWidget::Error** . The errors are available via
    **QQuickWidget::errors** ().

    QQuickWidget also manages sizing of the view and root object. By default,
    the **resizeMode**  is **SizeViewToRootObject** , which will load the
    component and resize it to the size of the view. Alternatively the
    **resizeMode**  may be set to **SizeRootObjectToView**  which will resize
    the view to the size of the root object.

    **Note:** QQuickWidget is an alternative to using **QQuickView**  and
    **QWidget::createWindowContainer** (). The restrictions on stacking order do
    not apply, making QQuickWidget the more flexible alternative, behaving more
    like an ordinary widget. This comes at the expense of performance. Unlike
    **QQuickWindow**  and **QQuickView** , QQuickWidget involves rendering into
    OpenGL framebuffer objects. This will naturally carry a minor performance
    hit.

    **Note:** Using QQuickWidget disables the threaded render loop on all
    platforms. This means that some of the benefits of threaded rendering, for
    example **Animator**  classes and vsync driven animations, will not be
    available.

    **Note:** Avoid calling **winId** () on a QQuickWidget. This function
    triggers the creation of a native window, resulting in reduced performance
    and possibly rendering glitches. The entire purpose of QQuickWidget is to
    render Quick scenes without a separate native window, hence making it a
    native widget should always be avoided.

    **Scene Graph and Context Persistency**

    QQuickWidget honors **QQuickWindow::isPersistentSceneGraph** (), meaning
    that applications can decide - by calling
    **QQuickWindow::setPersistentSceneGraph** () on the window returned from the
    **quickWindow** () function - to let scenegraph nodes and other Qt Quick
    scene related resources be released whenever the widget becomes hidden. By
    default persistency is enabled, just like with **QQuickWindow** .

    When running with the OpenGL backend of the scene graph, **QQuickWindow**
    offers the possibility to disable persistent OpenGL contexts as well. This
    setting is currently ignored by QQuickWidget and the context is always
    persistent. The OpenGL context is thus not destroyed when hiding the widget.
    The context is destroyed only when the widget is destroyed or when the
    widget gets reparented into another top-level widget's child hierarchy.
    However, some applications, in particular those that have their own graphics
    resources due to performing custom OpenGL rendering in the Qt Quick scene,
    may wish to disable the latter since they may not be prepared to handle the
    loss of the context when moving a QQuickWidget into another window. Such
    applications can set the QCoreApplication::AA_ShareOpenGLContexts attribute.
    For a discussion on the details of resource initialization and cleanup,
    refer to the **QOpenGLWidget**  documentation.

    **Note:** QQuickWidget offers less fine-grained control over its internal
    OpenGL context than **QOpenGLWidget** , and there are subtle differences,
    most notably that disabling the persistent scene graph will lead to
    destroying the context on a window change regardless of the presence of
    QCoreApplication::AA_ShareOpenGLContexts.

    **Limitations**

    Putting other widgets underneath and making the QQuickWidget transparent
    will not lead to the expected results: the widgets underneath will not be
    visible. This is because in practice the QQuickWidget is drawn before all
    other regular, non-OpenGL widgets, and so see-through types of solutions are
    not feasible. Other type of layouts, like having widgets on top of the
    QQuickWidget, will function as expected.

    When absolutely necessary, this limitation can be overcome by setting the
    **Qt::WA_AlwaysStackOnTop**  attribute on the QQuickWidget. Be aware,
    however that this breaks stacking order. For example it will not be possible
    to have other widgets on top of the QQuickWidget, so it should only be used
    in situations where a semi-transparent QQuickWidget with other widgets
    visible underneath is required.

    This limitation only applies when there are other widgets underneath the
    QQuickWidget inside the same window. Making the window semi-transparent,
    with other applications and the desktop visible in the background, is done
    in the traditional way: Set **Qt::WA_TranslucentBackground**  on the top-
    level window, request an alpha channel, and change the Qt Quick Scenegraph's
    clear color to **Qt::transparent**  via **setClearColor** ().

    **Support when not using OpenGL**

    In addition to OpenGL, the `software` backend of Qt Quick also supports
    QQuickWidget. Other backends, for example the Direct 3D 12 one, are not
    compatible however and attempting to construct a QQuickWidget will lead to
    problems.

    **Tab Key Handling**

    On press of the `[TAB]` key, the item inside the QQuickWidget gets focus. If
    this item can handle `[TAB]` key press, focus will change accordingly within
    the item, otherwise the next widget in the focus chain gets focus.

    **See also** **Exposing Attributes of C++ Types to QML** , **Qt Quick
    Widgets Example** , and **QQuickView** .
    """

    class Status(int):
        Null: QQuickWidget = ...
        Ready: QQuickWidget = ...
        Loading: QQuickWidget = ...
        Error: QQuickWidget = ...

    class ResizeMode(int):
        SizeViewToRootObject: QQuickWidget = ...
        SizeRootObjectToView: QQuickWidget = ...

    @typing.overload
    def __init__(self, parent: typing.Optional[QtWidgets.QWidget] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qquickwidget.html#QQuickWidget

        **QQuickWidget::QQuickWidget(QWidget * parent = nullptr)**

        Constructs a QQuickWidget with the given **parent**. The default value
        of **parent** is 0.
        """
        ...

    @typing.overload
    def __init__(self, engine: QtQml.QQmlEngine, parent: QtWidgets.QWidget) -> None:
        """
        https://doc.qt.io/qt-5/qquickwidget.html#QQuickWidget-1

        **QQuickWidget::QQuickWidget(QQmlEngine * engine , QWidget * parent )**

        Constructs a QQuickWidget with the given QML **engine** and **parent**.

        Note: In this case, the QQuickWidget does not own the given **engine**
        object; it is the caller's responsibility to destroy the engine. If the
        **engine** is deleted before the view, **status** () will return
        **QQuickWidget::Error** .

        **See also** **Status** , **status** (), and **errors** ().
        """
        ...

    @typing.overload
    def __init__(
        self, source: QtCore.QUrl, parent: typing.Optional[QtWidgets.QWidget] = ...
    ) -> None:
        """
        https://doc.qt.io/qt-5/qquickwidget.html#QQuickWidget-2

        **QQuickWidget::QQuickWidget(const QUrl & source , QWidget * parent =
        nullptr)**

        Constructs a QQuickWidget with the given QML **source** and **parent**.
        The default value of **parent** is 0.
        """
        ...

    def focusNextPrevChild(self, next: bool) -> bool:
        """
        https://doc.qt.io/qt-5/qquickwidget.html#focusNextPrevChild

        **[override virtual protected] bool
        QQuickWidget::focusNextPrevChild(bool next )**

        Reimplements: **QWidget::focusNextPrevChild** (bool next).
        """
        ...

    def quickWindow(self) -> QtQuick.QQuickWindow:
        """
        https://doc.qt.io/qt-5/qquickwidget.html#quickWindow

        **QQuickWindow *QQuickWidget::quickWindow() const**

        Returns the offscreen **QQuickWindow**  which is used by this widget to
        drive the Qt Quick rendering. This is useful if you want to use
        **QQuickWindow**  APIs that are not currently exposed by
        **QQuickWidget** , for instance connecting to the
        **QQuickWindow::beforeRendering** () signal in order to draw native
        OpenGL content below Qt Quick's own rendering.

        **Warning:** Use the return value of this function with caution. In
        particular, do not ever attempt to show the **QQuickWindow** , and be
        very careful when using other **QWindow** -only APIs.

        This function was introduced in Qt 5.5.
        """
        ...

    def setClearColor(
        self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor]
    ) -> None:
        """
        https://doc.qt.io/qt-5/qquickwidget.html#setClearColor

        **void QQuickWidget::setClearColor(const QColor & color )**

        Sets the clear **color**. By default this is an opaque color.

        To get a semi-transparent **QQuickWidget** , call this function with
        **color** set to **Qt::transparent** , set the
        **Qt::WA_TranslucentBackground**  widget attribute on the top-level
        window, and request an alpha channel via **setFormat** ().

        **See also** **QQuickWindow::setColor** ().
        """
        ...

    def grabFramebuffer(self) -> QtGui.QImage:
        """
        https://doc.qt.io/qt-5/qquickwidget.html#grabFramebuffer

        **QImage QQuickWidget::grabFramebuffer() const**

        Renders a frame and reads it back into an image.

        **Note:** This is a potentially expensive operation.
        """
        ...

    def paintEvent(self, event: QtGui.QPaintEvent) -> None:
        """
        https://doc.qt.io/qt-5/qquickwidget.html#paintEvent

        **[override virtual protected] void QQuickWidget::paintEvent(QPaintEvent
        * event )**

        Reimplements: **QWidget::paintEvent** (QPaintEvent *event).
        """
        ...

    def dropEvent(self, a0: QtGui.QDropEvent) -> None:
        """
        https://doc.qt.io/qt-5/qquickwidget.html#dropEvent

        **[override virtual protected] void QQuickWidget::dropEvent(QDropEvent *
        e )**

        Reimplements: **QWidget::dropEvent** (QDropEvent *event).
        """
        ...

    def dragLeaveEvent(self, a0: QtGui.QDragLeaveEvent) -> None:
        """
        https://doc.qt.io/qt-5/qquickwidget.html#dragLeaveEvent

        **[override virtual protected] void
        QQuickWidget::dragLeaveEvent(QDragLeaveEvent * e )**

        Reimplements: **QWidget::dragLeaveEvent** (QDragLeaveEvent *event).
        """
        ...

    def dragMoveEvent(self, a0: QtGui.QDragMoveEvent) -> None:
        """
        https://doc.qt.io/qt-5/qquickwidget.html#dragMoveEvent

        **[override virtual protected] void
        QQuickWidget::dragMoveEvent(QDragMoveEvent * e )**

        Reimplements: **QWidget::dragMoveEvent** (QDragMoveEvent *event).
        """
        ...

    def dragEnterEvent(self, a0: QtGui.QDragEnterEvent) -> None:
        """
        https://doc.qt.io/qt-5/qquickwidget.html#dragEnterEvent

        **[override virtual protected] void
        QQuickWidget::dragEnterEvent(QDragEnterEvent * e )**

        Reimplements: **QWidget::dragEnterEvent** (QDragEnterEvent *event).
        """
        ...

    def focusOutEvent(self, event: QtGui.QFocusEvent) -> None:
        """
        https://doc.qt.io/qt-5/qquickwidget.html#focusOutEvent

        **[override virtual protected] void
        QQuickWidget::focusOutEvent(QFocusEvent * event )**

        Reimplements: **QWidget::focusOutEvent** (QFocusEvent *event).
        """
        ...

    def focusInEvent(self, event: QtGui.QFocusEvent) -> None:
        """
        https://doc.qt.io/qt-5/qquickwidget.html#focusInEvent

        **[override virtual protected] void
        QQuickWidget::focusInEvent(QFocusEvent * event )**

        Reimplements: **QWidget::focusInEvent** (QFocusEvent *event).
        """
        ...

    def event(self, a0: QtCore.QEvent) -> bool:
        """
        https://doc.qt.io/qt-5/qquickwidget.html#event

        **[override virtual protected] bool QQuickWidget::event(QEvent * e )**

        Reimplements: **QWidget::event** (QEvent *event).
        """
        ...

    def wheelEvent(self, a0: QtGui.QWheelEvent) -> None:
        """
        https://doc.qt.io/qt-5/qquickwidget.html#wheelEvent

        **[override virtual protected] void QQuickWidget::wheelEvent(QWheelEvent
        * e )**

        Reimplements: **QWidget::wheelEvent** (QWheelEvent *event).
        """
        ...

    def hideEvent(self, a0: QtGui.QHideEvent) -> None:
        """
        https://doc.qt.io/qt-5/qquickwidget.html#hideEvent

        **[override virtual protected] void QQuickWidget::hideEvent( QHideEvent
        * )**

        Reimplements: **QWidget::hideEvent** (QHideEvent *event).
        """
        ...

    def showEvent(self, a0: QtGui.QShowEvent) -> None:
        """
        https://doc.qt.io/qt-5/qquickwidget.html#showEvent

        **[override virtual protected] void QQuickWidget::showEvent( QShowEvent
        * )**

        Reimplements: **QWidget::showEvent** (QShowEvent *event).
        """
        ...

    def mouseDoubleClickEvent(self, a0: QtGui.QMouseEvent) -> None:
        """
        https://doc.qt.io/qt-5/qquickwidget.html#mouseDoubleClickEvent

        **[override virtual protected] void
        QQuickWidget::mouseDoubleClickEvent(QMouseEvent * e )**

        Reimplements: **QWidget::mouseDoubleClickEvent** (QMouseEvent *event).
        """
        ...

    def mouseMoveEvent(self, a0: QtGui.QMouseEvent) -> None:
        """
        https://doc.qt.io/qt-5/qquickwidget.html#mouseMoveEvent

        **[override virtual protected] void
        QQuickWidget::mouseMoveEvent(QMouseEvent * e )**

        Reimplements: **QWidget::mouseMoveEvent** (QMouseEvent *event).
        """
        ...

    def mouseReleaseEvent(self, a0: QtGui.QMouseEvent) -> None:
        """
        https://doc.qt.io/qt-5/qquickwidget.html#mouseReleaseEvent

        **[override virtual protected] void
        QQuickWidget::mouseReleaseEvent(QMouseEvent * e )**

        Reimplements: **QWidget::mouseReleaseEvent** (QMouseEvent *event).
        """
        ...

    def mousePressEvent(self, a0: QtGui.QMouseEvent) -> None:
        """
        https://doc.qt.io/qt-5/qquickwidget.html#mousePressEvent

        **[override virtual protected] void
        QQuickWidget::mousePressEvent(QMouseEvent * e )**

        Reimplements: **QWidget::mousePressEvent** (QMouseEvent *event).
        """
        ...

    def keyReleaseEvent(self, a0: QtGui.QKeyEvent) -> None:
        """
        https://doc.qt.io/qt-5/qquickwidget.html#keyReleaseEvent

        **[override virtual protected] void
        QQuickWidget::keyReleaseEvent(QKeyEvent * e )**

        Reimplements: **QWidget::keyReleaseEvent** (QKeyEvent *event).
        """
        ...

    def keyPressEvent(self, a0: QtGui.QKeyEvent) -> None:
        """
        https://doc.qt.io/qt-5/qquickwidget.html#keyPressEvent

        **[override virtual protected] void
        QQuickWidget::keyPressEvent(QKeyEvent * e )**

        Reimplements: **QWidget::keyPressEvent** (QKeyEvent *event).
        """
        ...

    def timerEvent(self, a0: QtCore.QTimerEvent) -> None:
        ...

    def resizeEvent(self, a0: QtGui.QResizeEvent) -> None:
        ...

    def setSource(self, a0: QtCore.QUrl) -> None:
        """
        https://doc.qt.io/qt-5/qquickwidget.html#setSource

        **[slot] void QQuickWidget::setSource(const QUrl & url )**

        Sets the source to the **url** , loads the QML component and
        instantiates it.

        Ensure that the URL provided is full and correct, in particular, use
        **QUrl::fromLocalFile** () when loading a file from the local
        filesystem.

        Calling this method multiple times with the same URL will result in the
        QML component being reinstantiated.

        **Note:** Setter function for property **source** .

        **See also** **source** ().
        """
        ...

    def format(self) -> QtGui.QSurfaceFormat:
        """
        https://doc.qt.io/qt-5/qquickwidget.html#format

        **QSurfaceFormat QQuickWidget::format() const**

        Returns the actual surface format.

        If the widget has not yet been shown, the requested format is returned.

        **See also** **setFormat** ().
        """
        ...

    def setFormat(self, format: QtGui.QSurfaceFormat) -> None:
        """
        https://doc.qt.io/qt-5/qquickwidget.html#setFormat

        **void QQuickWidget::setFormat(const QSurfaceFormat & format )**

        Sets the surface **format** for the context and offscreen surface used
        by this widget.

        Call this function when there is a need to request a context for a given
        OpenGL version or profile. The sizes for depth, stencil and alpha
        buffers are taken care of automatically and there is no need to request
        those explicitly.

        **See also** **QWindow::setFormat** (), **QWindow::format** (), and
        **format** ().
        """
        ...

    def initialSize(self) -> QtCore.QSize:
        """
        https://doc.qt.io/qt-5/qquickwidget.html#initialSize

        **QSize QQuickWidget::initialSize() const**

        Returns the initial size of the root object.

        If **resizeMode**  is **SizeRootObjectToView** , the root object will be
        resized to the size of the view. This function returns the size of the
        root object before it was resized.
        """
        ...

    def sizeHint(self) -> QtCore.QSize:
        ...

    def errors(self) -> typing.List[QtQml.QQmlError]:
        """
        https://doc.qt.io/qt-5/qquickwidget.html#errors

        **QList<QQmlError> QQuickWidget::errors() const**

        Return the list of errors that occurred during the last compile or
        create operation. When the status is not **Error** , an empty list is
        returned.

        **See also** **status** .
        """
        ...

    def status(self) -> "QQuickWidget.Status":
        """
        https://doc.qt.io/qt-5/qquickwidget.html#status-prop

        **status : const Status**

        The component's current **status** .

        **Access functions:**

        QQuickWidget::Status **status** () const

        **Notifier signal:**

        void ****statusChanged** ** (QQuickWidget::Status **status** )

        **Member Function Documentation**
        """
        ...

    def setResizeMode(self, a0: "QQuickWidget.ResizeMode") -> None:
        """
        https://doc.qt.io/qt-5/qquickwidget.html#resizeMode-prop

        **resizeMode : ResizeMode**

        Determines whether the view should resize the window contents.

        If this property is set to **SizeViewToRootObject**  (the default), the
        view resizes to the size of the root item in the QML.

        If this property is set to **SizeRootObjectToView** , the view will
        automatically resize the root item to the size of the view.

        Regardless of this property, the **sizeHint**  of the view is the
        initial size of the root item. Note though that since QML may load
        dynamically, that size may change.

        **Access functions:**

        QQuickWidget::ResizeMode **resizeMode** () const
        void
        **setResizeMode** ( **QQuickWidget::ResizeMode** )

        **See also** **initialSize** ().
        """
        ...

    def resizeMode(self) -> "QQuickWidget.ResizeMode":
        """
        https://doc.qt.io/qt-5/qquickwidget.html#resizeMode-prop

        **resizeMode : ResizeMode**

        Determines whether the view should resize the window contents.

        If this property is set to **SizeViewToRootObject**  (the default), the
        view resizes to the size of the root item in the QML.

        If this property is set to **SizeRootObjectToView** , the view will
        automatically resize the root item to the size of the view.

        Regardless of this property, the **sizeHint**  of the view is the
        initial size of the root item. Note though that since QML may load
        dynamically, that size may change.

        **Access functions:**

        QQuickWidget::ResizeMode **resizeMode** () const
        void
        **setResizeMode** ( **QQuickWidget::ResizeMode** )

        **See also** **initialSize** ().
        """
        ...

    def rootObject(self) -> QtQuick.QQuickItem:
        """
        https://doc.qt.io/qt-5/qquickwidget.html#rootObject

        **QQuickItem *QQuickWidget::rootObject() const**

        Returns the view's root **item** . Can be null when **setSource** () has
        not been called, if it was called with broken **QtQuick**  code or while
        the **QtQuick**  contents are being created.
        """
        ...

    def rootContext(self) -> QtQml.QQmlContext:
        """
        https://doc.qt.io/qt-5/qquickwidget.html#rootContext

        **QQmlContext *QQuickWidget::rootContext() const**

        This function returns the root of the context hierarchy. Each QML
        component is instantiated in a **QQmlContext** . **QQmlContext** 's are
        essential for passing data to QML components. In QML, contexts are
        arranged hierarchically and this hierarchy is managed by the
        **QQmlEngine** .
        """
        ...

    def engine(self) -> QtQml.QQmlEngine:
        """
        https://doc.qt.io/qt-5/qquickwidget.html#engine

        **QQmlEngine *QQuickWidget::engine() const**

        Returns a pointer to the **QQmlEngine**  used for instantiating QML
        Components.
        """
        ...

    def source(self) -> QtCore.QUrl:
        """
        https://doc.qt.io/qt-5/qquickwidget.html#source

        **QUrl QQuickWidget::source() const**

        Returns the source URL, if set.

        **Note:** Getter function for property source.

        **See also** **setSource** ().
        """
        ...

    @property
    def sceneGraphError(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qquickwidget.html#sceneGraphError

        **[signal] void
        QQuickWidget::sceneGraphError(QQuickWindow::SceneGraphError error ,
        const QString & message )**

        This signal is emitted when an **error** occurred during scene graph
        initialization.

        Applications should connect to this signal if they wish to handle
        errors, like OpenGL context creation failures, in a custom way. When no
        slot is connected to the signal, the behavior will be different: Quick
        will print the **message** , or show a message box, and terminate the
        application.

        This signal will be emitted from the GUI thread.

        **See also** **QQuickWindow::sceneGraphError** ().
        """
        ...

    @property
    def statusChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qquickwidget.html#statusChanged

        **[signal] void QQuickWidget::statusChanged(QQuickWidget::Status status
        )**

        This signal is emitted when the component's current **status** changes.

        **Note:** Notifier signal for property **status** .
        """
        ...
