"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
import PyQt5.sip
from PyQt5 import QtGui
from PyQt5 import QtCore
from PyQt5.QtQuick3D import *
from PyQt5 import sip


class QQuick3DGeometry(QQuick3DObject):
    """
    https://doc.qt.io/qt-5/qquick3dgeometry.html

    **Detailed Description**

    The QQuick3DGeometry can be used to specify custom geometry used with Qt
    Quick 3D.

    The user should inherit this class and specify it's own properties, which
    can then be used from QML code. The user then should use these properties to
    construct the geometry and set it for the QQuick3DGeometry, which then
    uploads it to the Qt Quick3D engine.

    Example implementation:

    class CustomGeometry : public QQuick3DGeometry
        {
            Q_OBJECT
    ... properties ...

        public:
            CustomGeometry();
    void setProperty(...)
            {
                ...
    rebuildGeometry();
            }

        private:
            void
    rebuildGeometry()
            {
                **QByteArray**  vertices;
    **QByteArray**  indices;
                fillGeometry(vertices, indices);
    setPrimitiveType(Lines);
                setVertexBuffer(vertices);
    setIndexBuffer(indices);
                setStride(sizeof(QVector3D));
    setBounds(...);
                addAttrubute(PositionSemantic, 0, F32Type);
    }
        };

    This class can then be registered as a QML type and used with **Model** .

    qmlRegisterType<CustomGeometry>("Example", 1, 0, "CustomGeometry");

    import Example 1.0

        Model {
            id: customModel
    geometry: CustomGeometry {
            }
        }
    """

    class PrimitiveType(int):
        Unknown: QQuick3DGeometry = ...
        Points: QQuick3DGeometry = ...
        LineStrip: QQuick3DGeometry = ...
        Lines: QQuick3DGeometry = ...
        TriangleStrip: QQuick3DGeometry = ...
        TriangleFan: QQuick3DGeometry = ...
        Triangles: QQuick3DGeometry = ...

    class Attribute(sip.simplewrapper):
        class ComponentType(int):
            DefaultType: QQuick3DGeometry = ...
            U16Type: QQuick3DGeometry = ...
            U32Type: QQuick3DGeometry = ...
            F32Type: QQuick3DGeometry = ...

        class Semantic(int):
            UnknownSemantic: QQuick3DGeometry = ...
            IndexSemantic: QQuick3DGeometry = ...
            PositionSemantic: QQuick3DGeometry = ...
            NormalSemantic: QQuick3DGeometry = ...
            TexCoordSemantic: QQuick3DGeometry = ...
            TangentSemantic: QQuick3DGeometry = ...
            BinormalSemantic: QQuick3DGeometry = ...

        componentType = ...
        offset: int = ...
        semantic = ...

        @typing.overload
        def __init__(self) -> None:
            ...

        @typing.overload
        def __init__(self, a0: "QQuick3DGeometry.Attribute") -> None:
            ...

    def __init__(self, parent: typing.Optional[QQuick3DObject] = ...) -> None:
        ...

    def setName(self, name: str) -> None:
        """
        https://doc.qt.io/qt-5/qquick3dgeometry.html#name-prop

        **name : QString**

        Unique name identifying the geometry. This becomes the source path for
        the geometry. If multiple instances from the same geometry class are
        used, each of them must have their own unique name. Otherwise, geometry
        with same name will override the others. Geometry can be shared either
        by setting the geometry parameter for a model or using the name of the
        geometry as source parameter for the model.

        **Access functions:**

        QString **name** () const
        void **setName** (const QString & **name** )

        **Notifier signal:**

        void **nameChanged** ()

        **Member Function Documentation**
        """
        ...

    def clear(self) -> None:
        """
        https://doc.qt.io/qt-5/qquick3dgeometry.html#clear

        **void QQuick3DGeometry::clear()**

        Clears previously set vertex- and index data as well as attributes.
        """
        ...

    @typing.overload
    def addAttribute(
        self,
        semantic: "QQuick3DGeometry.Attribute.Semantic",
        offset: int,
        componentType: "QQuick3DGeometry.Attribute.ComponentType",
    ) -> None:
        """
        https://doc.qt.io/qt-5/qquick3dgeometry.html#addAttribute

        **void QQuick3DGeometry::addAttribute(Attribute::Semantic semantic , int
        offset , Attribute::ComponentType componentType )**

        Adds vertex attribute description. Each attribute has a **semantic** ,
        which specifies the usage of the attribute and the number of components
        it has, an **offset** from the beginning to the vertex to the attribute
        location inside a vertex and a **componentType** specifying the datatype
        and size of the attribute.

        The semantic can be one of the following:

        ConstantDescription
        `UnknownSemantic`The semantic is not set.
        `IndexSemantic`The attribute is an index.
        `PositionSemantic`The
        attribute is a position.
        `NormalSemantic`The attribute is a normal
        vector.
        `TexCoordSemantic`The attribute is a texture coordinate.
        `TangentSemantic`The attribute is a tangent vector.
        `BinormalSemantic`The attribute is a binormal vector.

        The component type can be one of the following:

        ConstantDescription
        `DefaultType`The attribute uses default type
        depending on the semantic.
        `U16Type`The attribute is an unsigned
        16-bit integer.
        `U32Type`The attribute is an unsigned 32-bit integer.
        This is the default for IndexSemantic.
        `F32Type`The attribute is a
        single-precision float. This is the default for most semantics.
        """
        ...

    @typing.overload
    def addAttribute(self, att: "QQuick3DGeometry.Attribute") -> None:
        """
        https://doc.qt.io/qt-5/qquick3dgeometry.html#addAttribute-1

        **void QQuick3DGeometry::addAttribute(const QQuick3DGeometry::Attribute
        & attribute )**

        Adds vertex attribute description. Each attribute has a semantic, which
        specifies the usage of the attribute and the number of components it
        has, an offset from the beginning to the vertex to the attribute
        location inside a vertex and a componentType specifying the datatype and
        size of the attribute.
        """
        ...

    def setPrimitiveType(self, type: "QQuick3DGeometry.PrimitiveType") -> None:
        """
        https://doc.qt.io/qt-5/qquick3dgeometry.html#setPrimitiveType

        **void
        QQuick3DGeometry::setPrimitiveType(QQuick3DGeometry::PrimitiveType type
        )**

        Sets the primitive **type**.

        ConstantDescription
        `UnknownType`The primitive type is not set.
        `Points`The primitives are points.
        `LineStrip`The primitives are lines
        in a strip.
        `Lines`The primitives are lines in a list.
        `TriangleStrip`The primitives are triangles in a strip.
        `TriangleFan`The primitives are triangles in a fan.
        `Triangles`The
        primitives are triangles in a list.

        **See also** **primitiveType** ().
        """
        ...

    def setBounds(self, min: QtGui.QVector3D, max: QtGui.QVector3D) -> None:
        """
        https://doc.qt.io/qt-5/qquick3dgeometry.html#setBounds

        **void QQuick3DGeometry::setBounds(const QVector3D & min , const
        QVector3D & max )**

        Sets the bounds of the geometry with **min** and **max** point.
        """
        ...

    def setStride(self, stride: int) -> None:
        """
        https://doc.qt.io/qt-5/qquick3dgeometry.html#setStride

        **void QQuick3DGeometry::setStride(int stride )**

        Sets the byte **stride** of the vertex.

        **See also** **stride** ().
        """
        ...

    def setIndexData(
        self, data: typing.Union[QtCore.QByteArray, bytes, bytearray]
    ) -> None:
        """
        https://doc.qt.io/qt-5/qquick3dgeometry.html#setIndexData

        **void QQuick3DGeometry::setIndexData(const QByteArray & data )**

        Sets the index buffer **data**. If the index buffer is not set, the
        vertex buffer is used as is for the vertices.
        """
        ...

    def setVertexData(
        self, data: typing.Union[QtCore.QByteArray, bytes, bytearray]
    ) -> None:
        """
        https://doc.qt.io/qt-5/qquick3dgeometry.html#setVertexData

        **void QQuick3DGeometry::setVertexData(const QByteArray & data )**

        Sets the vertex buffer **data**. The buffer should hold all the vertex
        data packed in the array described by the attributes.
        """
        ...

    def stride(self) -> int:
        """
        https://doc.qt.io/qt-5/qquick3dgeometry.html#stride

        **int QQuick3DGeometry::stride() const**

        Returns the byte stride of the vertex buffer.

        **See also** **setStride** ().
        """
        ...

    def boundsMax(self) -> QtGui.QVector3D:
        """
        https://doc.qt.io/qt-5/qquick3dgeometry.html#boundsMax

        **QVector3D QQuick3DGeometry::boundsMax() const**

        Returns the maximum bound coordinate.
        """
        ...

    def boundsMin(self) -> QtGui.QVector3D:
        """
        https://doc.qt.io/qt-5/qquick3dgeometry.html#boundsMin

        **QVector3D QQuick3DGeometry::boundsMin() const**

        Returns the minimum bound coordinate.
        """
        ...

    def primitiveType(self) -> "QQuick3DGeometry.PrimitiveType":
        """
        https://doc.qt.io/qt-5/qquick3dgeometry.html#primitiveType

        **QQuick3DGeometry::PrimitiveType QQuick3DGeometry::primitiveType()
        const**

        Returns the primitive type. The default is `Triangles`.

        ConstantDescription
        `Unknown`The primitive type is not set.
        `Points`The primitives are points.
        `LineStrip`The primitives are lines
        in a strip.
        `Lines`The primitives are lines in a list.
        `TriangleStrip`The primitives are triangles in a strip.
        `TriangleFan`The primitives are triangles in a fan.
        `Triangles`The
        primitives are triangles in a list.

        **See also** **setPrimitiveType** ().
        """
        ...

    def attribute(self, index: int) -> "QQuick3DGeometry.Attribute":
        """
        https://doc.qt.io/qt-5/qquick3dgeometry.html#attribute

        **QQuick3DGeometry::Attribute QQuick3DGeometry::attribute(int index )
        const**

        Returns an attribute at **index**
        """
        ...

    def attributeCount(self) -> int:
        """
        https://doc.qt.io/qt-5/qquick3dgeometry.html#attributeCount

        **int QQuick3DGeometry::attributeCount() const**

        Returns the attribute count.
        """
        ...

    def indexBuffer(self) -> QtCore.QByteArray:
        """
        https://doc.qt.io/qt-5/qquick3dgeometry.html#indexBuffer

        **QByteArray QQuick3DGeometry::indexBuffer() const**

        Returns the index buffer data.
        """
        ...

    def vertexBuffer(self) -> QtCore.QByteArray:
        """
        https://doc.qt.io/qt-5/qquick3dgeometry.html#vertexBuffer

        **QByteArray QQuick3DGeometry::vertexBuffer() const**

        Returns the vertex buffer data.
        """
        ...

    def name(self) -> str:
        """
        https://doc.qt.io/qt-5/qquick3dgeometry.html#name-prop

        **name : QString**

        Unique name identifying the geometry. This becomes the source path for
        the geometry. If multiple instances from the same geometry class are
        used, each of them must have their own unique name. Otherwise, geometry
        with same name will override the others. Geometry can be shared either
        by setting the geometry parameter for a model or using the name of the
        geometry as source parameter for the model.

        **Access functions:**

        QString **name** () const
        void **setName** (const QString & **name** )

        **Notifier signal:**

        void **nameChanged** ()

        **Member Function Documentation**
        """
        ...

    @property
    def nameChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        ...
