"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
import PyQt5.sip
from PyQt5 import QtCore
from PyQt5.QtQuick import *
from PyQt5 import sip


class QSGTexture(QtCore.QObject):
    """
    https://doc.qt.io/qt-5/qsgtexture.html

    **Detailed Description**

    Users can freely implement their own texture classes to support arbitrary
    input textures, such as YUV video frames or 8 bit alpha masks. The scene
    graph backend provides a default implementation of normal color textures. As
    the implementation of these may be hardware specific, they are constructed
    via the factory function **QQuickWindow::createTextureFromImage** ().

    The texture is a wrapper around an OpenGL texture, which texture id is given
    by **textureId** () and which size in pixels is given by **textureSize** ().
    **hasAlphaChannel** () reports if the texture contains opacity values and
    **hasMipmaps** () reports if the texture contains mipmap levels.

    To use a texture, call the **bind** () function. The texture parameters
    specifying how the texture is bound, can be specified with
    **setMipmapFiltering** (), **setFiltering** (), **setHorizontalWrapMode** ()
    and **setVerticalWrapMode** (). The texture will internally try to store
    these values to minimize the OpenGL state changes when the texture is bound.

    **Texture Atlasses**

    Some scene graph backends use texture atlasses, grouping multiple small
    textures into one large texture. If this is the case, the function
    **isAtlasTexture** () will return true. Atlasses are used to aid the
    rendering algorithm to do better sorting which increases performance. The
    location of the texture inside the atlas is given with the
    **normalizedTextureSubRect** () function.

    If the texture is used in such a way that atlas is not preferable, the
    function **removedFromAtlas** () can be used to extract a non-atlassed copy.

    **Note:** All classes with QSG prefix should be used solely on the scene
    graph's rendering thread. See **Scene Graph and Rendering**  for more
    information.

    **See also** **Scene Graph - Rendering FBOs**  and **Scene Graph - Rendering
    FBOs in a thread** .
    """

    class AnisotropyLevel(int):
        AnisotropyNone: QSGTexture = ...
        Anisotropy2x: QSGTexture = ...
        Anisotropy4x: QSGTexture = ...
        Anisotropy8x: QSGTexture = ...
        Anisotropy16x: QSGTexture = ...

    class Filtering(int):
        None_: QSGTexture = ...
        Nearest: QSGTexture = ...
        Linear: QSGTexture = ...

    class WrapMode(int):
        Repeat: QSGTexture = ...
        ClampToEdge: QSGTexture = ...
        MirroredRepeat: QSGTexture = ...

    class NativeTexture(sip.simplewrapper):
        layout: int = ...
        object: PyQt5 = ...

        @typing.overload
        def __init__(self) -> None:
            ...

        @typing.overload
        def __init__(self, a0: "QSGTexture.NativeTexture") -> None:
            ...

    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qsgtexture.html#QSGTexture

        **QSGTexture::QSGTexture()**

        Constructs the QSGTexture base class.
        """
        ...

    def nativeTexture(self) -> "QSGTexture.NativeTexture":
        """
        https://doc.qt.io/qt-5/qsgtexture.html#nativeTexture

        **QSGTexture::NativeTexture QSGTexture::nativeTexture() const**

        Returns the platform-specific texture data for this texture.

        **Note:** This is only available when running the graphics API
        independent rendering path of the scene graph. Use **textureId** ()
        otherwise.

        Returns an empty result (`object` is null) if there is no available
        underlying native texture.

        This function was introduced in Qt 5.15.

        **See also** **QQuickWindow::createTextureFromNativeObject** ().
        """
        ...

    def comparisonKey(self) -> int:
        """
        https://doc.qt.io/qt-5/qsgtexture.html#comparisonKey

        **int QSGTexture::comparisonKey() const**

        Returns a key suitable for comparing textures. Typically used in
        **QSGMaterial::compare** () implementations.

        Just comparing **QSGTexture**  pointers is not always sufficient because
        two **QSGTexture**  instances that refer to the same native texture
        object underneath should also be considered equal. Hence this function.

        **Note:** Unlike **textureId** (), implementations of this function are
        not expected to and should not create any graphics resources (so texture
        objects) in case there is none yet.

        A **QSGTexture**  that does not have a native texture object underneath
        is typically not equal to any other **QSGTexture** . There are
        exceptions to this, in particular when atlasing is used (where multiple
        textures share the same atlas texture under the hood), that is then up
        to the subclass implementations to deal with as appropriate.

        **Warning:** This function can only be called from the rendering thread.

        This function was introduced in Qt 5.14.
        """
        ...

    def anisotropyLevel(self) -> "QSGTexture.AnisotropyLevel":
        """
        https://doc.qt.io/qt-5/qsgtexture.html#anisotropyLevel

        **QSGTexture::AnisotropyLevel QSGTexture::anisotropyLevel() const**

        Returns the anisotropy level in use for filtering this texture.

        This function was introduced in Qt 5.9.

        **See also** **setAnisotropyLevel** ().
        """
        ...

    def setAnisotropyLevel(self, level: "QSGTexture.AnisotropyLevel") -> None:
        """
        https://doc.qt.io/qt-5/qsgtexture.html#setAnisotropyLevel

        **void QSGTexture::setAnisotropyLevel(QSGTexture::AnisotropyLevel level
        )**

        Sets the level of anisotropic filtering to be used for the upcoming
        **bind** () call to **level**. The default value is
        **QSGTexture::AnisotropyNone** , which means no anisotropic filtering is
        enabled.

        This function was introduced in Qt 5.9.

        **See also** **anisotropyLevel** ().
        """
        ...

    def convertToNormalizedSourceRect(self, rect: QtCore.QRectF) -> QtCore.QRectF:
        """
        https://doc.qt.io/qt-5/qsgtexture.html#convertToNormalizedSourceRect

        **QRectF QSGTexture::convertToNormalizedSourceRect(const QRectF & rect )
        const**

        Returns **rect** converted to normalized coordinates.

        **See also** **normalizedTextureSubRect** ().
        """
        ...

    def verticalWrapMode(self) -> "QSGTexture.WrapMode":
        """
        https://doc.qt.io/qt-5/qsgtexture.html#verticalWrapMode

        **QSGTexture::WrapMode QSGTexture::verticalWrapMode() const**

        Returns the vertical wrap mode to be used for this texture.

        **See also** **setVerticalWrapMode** ().
        """
        ...

    def setVerticalWrapMode(self, vwrap: "QSGTexture.WrapMode") -> None:
        """
        https://doc.qt.io/qt-5/qsgtexture.html#setVerticalWrapMode

        **void QSGTexture::setVerticalWrapMode(QSGTexture::WrapMode vwrap )**

        Sets the vertical wrap mode to be used for the upcoming **bind** () call
        to **vwrap**

        **See also** **verticalWrapMode** ().
        """
        ...

    def horizontalWrapMode(self) -> "QSGTexture.WrapMode":
        """
        https://doc.qt.io/qt-5/qsgtexture.html#horizontalWrapMode

        **QSGTexture::WrapMode QSGTexture::horizontalWrapMode() const**

        Returns the horizontal wrap mode to be used for this texture.

        **See also** **setHorizontalWrapMode** ().
        """
        ...

    def setHorizontalWrapMode(self, hwrap: "QSGTexture.WrapMode") -> None:
        """
        https://doc.qt.io/qt-5/qsgtexture.html#setHorizontalWrapMode

        **void QSGTexture::setHorizontalWrapMode(QSGTexture::WrapMode hwrap )**

        Sets the horizontal wrap mode to be used for the upcoming **bind** ()
        call to **hwrap**

        **See also** **horizontalWrapMode** ().
        """
        ...

    def filtering(self) -> "QSGTexture.Filtering":
        """
        https://doc.qt.io/qt-5/qsgtexture.html#filtering

        **QSGTexture::Filtering QSGTexture::filtering() const**

        Returns the sampling mode to be used for this texture.

        **See also** **setFiltering** ().
        """
        ...

    def setFiltering(self, filter: "QSGTexture.Filtering") -> None:
        """
        https://doc.qt.io/qt-5/qsgtexture.html#setFiltering

        **void QSGTexture::setFiltering(QSGTexture::Filtering filter )**

        Sets the sampling mode to be used for the upcoming **bind** () call to
        **filter**.

        **See also** **filtering** ().
        """
        ...

    def mipmapFiltering(self) -> "QSGTexture.Filtering":
        """
        https://doc.qt.io/qt-5/qsgtexture.html#mipmapFiltering

        **QSGTexture::Filtering QSGTexture::mipmapFiltering() const**

        Returns whether mipmapping should be used when sampling from this
        texture.

        **See also** **setMipmapFiltering** ().
        """
        ...

    def setMipmapFiltering(self, filter: "QSGTexture.Filtering") -> None:
        """
        https://doc.qt.io/qt-5/qsgtexture.html#setMipmapFiltering

        **void QSGTexture::setMipmapFiltering(QSGTexture::Filtering filter )**

        Sets the mipmap sampling mode to be used for the upcoming **bind** ()
        call to **filter**.

        Setting the mipmap filtering has no effect it the texture does not have
        mipmaps.

        **See also** **mipmapFiltering** () and **hasMipmaps** ().
        """
        ...

    def updateBindOptions(self, force: bool = ...) -> None:
        """
        https://doc.qt.io/qt-5/qsgtexture.html#updateBindOptions

        **void QSGTexture::updateBindOptions(bool force = false)**

        Update the texture state to match the filtering, mipmap and wrap options
        currently set.

        If **force** is true, all properties will be updated regardless of
        weither they have changed or not.
        """
        ...

    def bind(self) -> None:
        """
        https://doc.qt.io/qt-5/qsgtexture.html#bind

        **[pure virtual] void QSGTexture::bind()**

        Call this function to bind this texture to the current texture target.

        Binding a texture may also include uploading the texture data from a
        previously set **QImage** .

        **Warning:** This function should only be called when running with the
        direct OpenGL rendering path.

        **Warning:** This function can only be called from the rendering thread.
        """
        ...

    def removedFromAtlas(self) -> "QSGTexture":
        """
        https://doc.qt.io/qt-5/qsgtexture.html#removedFromAtlas

        **[virtual] QSGTexture *QSGTexture::removedFromAtlas() const**

        This function returns a copy of the current texture which is removed
        from its atlas.

        The current texture remains unchanged, so texture coordinates do not
        need to be updated.

        Removing a texture from an atlas is primarily useful when passing it to
        a shader that operates on the texture coordinates 0-1 instead of the
        texture subrect inside the atlas.

        If the texture is not part of a texture atlas, this function returns 0.

        Implementations of this function are recommended to return the same
        instance for multiple calls to limit memory usage.

        **Warning:** This function can only be called from the rendering thread.
        """
        ...

    def isAtlasTexture(self) -> bool:
        """
        https://doc.qt.io/qt-5/qsgtexture.html#isAtlasTexture

        **[virtual] bool QSGTexture::isAtlasTexture() const**

        Returns weither this texture is part of an atlas or not.

        The default implementation returns false.
        """
        ...

    def normalizedTextureSubRect(self) -> QtCore.QRectF:
        """
        https://doc.qt.io/qt-5/qsgtexture.html#normalizedTextureSubRect

        **[virtual] QRectF QSGTexture::normalizedTextureSubRect() const**

        Returns the rectangle inside **textureSize** () that this texture
        represents in normalized coordinates.

        The default implementation returns a rect at position (0, 0) with width
        and height of 1.
        """
        ...

    def hasMipmaps(self) -> bool:
        """
        https://doc.qt.io/qt-5/qsgtexture.html#hasMipmaps

        **[pure virtual] bool QSGTexture::hasMipmaps() const**

        Returns true if the texture data contains mipmap levels.
        """
        ...

    def hasAlphaChannel(self) -> bool:
        """
        https://doc.qt.io/qt-5/qsgtexture.html#hasAlphaChannel

        **[pure virtual] bool QSGTexture::hasAlphaChannel() const**

        Returns true if the texture data contains an alpha channel.
        """
        ...

    def textureSize(self) -> QtCore.QSize:
        """
        https://doc.qt.io/qt-5/qsgtexture.html#textureSize

        **[pure virtual] QSize QSGTexture::textureSize() const**

        Returns the size of the texture.
        """
        ...

    def textureId(self) -> int:
        """
        https://doc.qt.io/qt-5/qsgtexture.html#textureId

        **[pure virtual] int QSGTexture::textureId() const**

        Returns the OpenGL texture id for this texture.

        The default value is 0, indicating that it is an invalid texture id.

        The function should at all times return the correct texture id.

        **Warning:** This function can only be called from the rendering thread.
        """
        ...
