"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
from PyQt5 import QtGui
from PyQt5 import QtCore
from PyQt5.QtQuick import *


class QSGSimpleRectNode(QSGGeometryNode):
    """
    https://doc.qt.io/qt-5/qsgsimplerectnode.html

    **Detailed Description**

    **Warning:** This utility class is only functional when running with the
    default or software backends of the Qt Quick scenegraph. As an alternative,
    prefer using **QSGRectangleNode**  via **QQuickWindow::createRectangleNode**
    () or **QSGEngine::createRectangleNode** ().
    """

    @typing.overload
    def __init__(
        self,
        rect: QtCore.QRectF,
        color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor],
    ) -> None:
        """
        https://doc.qt.io/qt-5/qsgsimplerectnode.html#QSGSimpleRectNode

        **QSGSimpleRectNode::QSGSimpleRectNode(const QRectF & rect , const
        QColor & color )**

        Constructs a QSGSimpleRectNode instance which is spanning **rect** with
        the color **color**.
        """
        ...

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qsgsimplerectnode.html#QSGSimpleRectNode-1

        **QSGSimpleRectNode::QSGSimpleRectNode()**

        Constructs a QSGSimpleRectNode instance with an empty rectangle and
        white color.
        """
        ...

    def color(self) -> QtGui.QColor:
        """
        https://doc.qt.io/qt-5/qsgsimplerectnode.html#color

        **QColor QSGSimpleRectNode::color() const**

        Returns the color of this rectangle.

        **See also** **setColor** ().
        """
        ...

    def setColor(
        self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor]
    ) -> None:
        """
        https://doc.qt.io/qt-5/qsgsimplerectnode.html#setColor

        **void QSGSimpleRectNode::setColor(const QColor & color )**

        Sets the color of this rectangle to **color**. The default color will be
        white.

        **See also** **color** ().
        """
        ...

    def rect(self) -> QtCore.QRectF:
        """
        https://doc.qt.io/qt-5/qsgsimplerectnode.html#rect

        **QRectF QSGSimpleRectNode::rect() const**

        Returns the rectangle that this rect node covers.

        **See also** **setRect** ().
        """
        ...

    @typing.overload
    def setRect(self, rect: QtCore.QRectF) -> None:
        """
        https://doc.qt.io/qt-5/qsgsimplerectnode.html#setRect

        **void QSGSimpleRectNode::setRect(const QRectF & rect )**

        Sets the rectangle of this rect node to **rect**.

        **See also** **rect** ().
        """
        ...

    @typing.overload
    def setRect(self, x: float, y: float, w: float, h: float) -> None:
        """
        https://doc.qt.io/qt-5/qsgsimplerectnode.html#setRect-1

        **void QSGSimpleRectNode::setRect(qreal x , qreal y , qreal w , qreal h
        )**

        This is an overloaded function.

        Sets the rectangle of this rect node to begin at ( **x** , **y** ) and
        have width **w** and height **h**.
        """
        ...
