"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
import PyQt5.sip
from PyQt5.QtQuick import *
from PyQt5 import sip


class QSGNode(PyQt5.sip.wrapper):
    """
    https://doc.qt.io/qt-5/qsgnode.html

    **Detailed Description**

    The QSGNode class can be used as a child container. Children are added with
    the **appendChildNode** (), **prependChildNode** (),
    **insertChildNodeBefore** () and **insertChildNodeAfter** (). The order of
    nodes is important as geometry nodes are rendered according to their
    ordering in the scene graph.

    The scene graph nodes contains a mechanism to describe which parts of the
    scene has changed. This includes the combined matrices, accumulated opacity,
    changes to the node hierarchy, and so on. This information can be used for
    optimizations inside the scene graph renderer. For the renderer to properly
    render the nodes, it is important that users call **QSGNode::markDirty** ()
    with the correct flags when nodes are changed. Most of the functions on the
    node classes will implicitly call **markDirty** (). For example,
    **QSGNode::appendChildNode** () will call **markDirty** () passing in
    **QSGNode::DirtyNodeAdded** .

    If nodes change every frame, the **preprocess** () function can be used to
    apply changes to a node for every frame it is rendered. The use of
    **preprocess** () must be explicitly enabled by setting the
    **QSGNode::UsePreprocess**  flag on the node.

    The virtual **isSubtreeBlocked** () function can be used to disable a
    subtree all together. Nodes in a blocked subtree will not be preprocessed()
    and not rendered.

    **Note:** All classes with QSG prefix should be used solely on the scene
    graph's rendering thread. See **Scene Graph and Rendering**  for more
    information.
    """

    class DirtyStateBit(int):
        DirtyMatrix: QSGNode = ...
        DirtyNodeAdded: QSGNode = ...
        DirtyNodeRemoved: QSGNode = ...
        DirtyGeometry: QSGNode = ...
        DirtyMaterial: QSGNode = ...
        DirtyOpacity: QSGNode = ...

    class Flag(int):
        OwnedByParent: QSGNode = ...
        UsePreprocess: QSGNode = ...
        OwnsGeometry: QSGNode = ...
        OwnsMaterial: QSGNode = ...
        OwnsOpaqueMaterial: QSGNode = ...

    class NodeType(int):
        BasicNodeType: QSGNode = ...
        GeometryNodeType: QSGNode = ...
        TransformNodeType: QSGNode = ...
        ClipNodeType: QSGNode = ...
        OpacityNodeType: QSGNode = ...

    class Flags(sip.simplewrapper):
        @typing.overload
        def __init__(self) -> None:
            ...

        @typing.overload
        def __init__(self, f: typing.Union["QSGNode.Flags", "QSGNode.Flag"]) -> None:
            ...

        @typing.overload
        def __init__(self, a0: "QSGNode.Flags") -> None:
            ...

        def __hash__(self) -> int:
            ...

        def __bool__(self) -> int:
            ...

        def __invert__(self) -> "QSGNode.Flags":
            ...

        def __index__(self) -> int:
            ...

        def __int__(self) -> int:
            ...

    class DirtyState(sip.simplewrapper):
        @typing.overload
        def __init__(self) -> None:
            ...

        @typing.overload
        def __init__(
            self, f: typing.Union["QSGNode.DirtyState", "QSGNode.DirtyStateBit"]
        ) -> None:
            ...

        @typing.overload
        def __init__(self, a0: "QSGNode.DirtyState") -> None:
            ...

        def __hash__(self) -> int:
            ...

        def __bool__(self) -> int:
            ...

        def __invert__(self) -> "QSGNode.DirtyState":
            ...

        def __index__(self) -> int:
            ...

        def __int__(self) -> int:
            ...

    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qsgnode.html#QSGNode

        **QSGNode::QSGNode()**

        Constructs a new node
        """
        ...

    def preprocess(self) -> None:
        """
        https://doc.qt.io/qt-5/qsgnode.html#preprocess

        **[virtual] void QSGNode::preprocess()**

        Override this function to do processing on the node before it is
        rendered.

        Preprocessing needs to be explicitly enabled by setting the flag
        **QSGNode::UsePreprocess** . The flag needs to be set before the node is
        added to the scene graph and will cause the preprocess() function to be
        called for every frame the node is rendered.

        **Warning:** Beware of deleting nodes while they are being preprocessed.
        It is possible, with a small performance hit, to delete a single node
        during its own preprocess call. Deleting a subtree which has nodes that
        also use preprocessing may result in a segmentation fault. This is done
        for performance reasons.
        """
        ...

    def setFlags(
        self, a0: typing.Union["QSGNode.Flags", "QSGNode.Flag"], enabled: bool = ...
    ) -> None:
        """
        https://doc.qt.io/qt-5/qsgnode.html#setFlags

        **void QSGNode::setFlags(QSGNode::Flags f , bool enabled = true)**

        Sets the flags **f** on this node if **enabled** is true; otherwise
        clears the flags.

        **See also** **flags** ().
        """
        ...

    def setFlag(self, a0: "QSGNode.Flag", enabled: bool = ...) -> None:
        """
        https://doc.qt.io/qt-5/qsgnode.html#setFlag

        **void QSGNode::setFlag(QSGNode::Flag f , bool enabled = true)**

        Sets the flag **f** on this node if **enabled** is true; otherwise
        clears the flag.

        **See also** **flags** ().
        """
        ...

    def flags(self) -> "QSGNode.Flags":
        """
        https://doc.qt.io/qt-5/qsgnode.html#flags

        **QSGNode::Flags QSGNode::flags() const**

        Returns the set of flags for this node.

        **See also** **setFlags** ().
        """
        ...

    def isSubtreeBlocked(self) -> bool:
        """
        https://doc.qt.io/qt-5/qsgnode.html#isSubtreeBlocked

        **[virtual] bool QSGNode::isSubtreeBlocked() const**

        Returns whether this node and its subtree is available for use.

        Blocked subtrees will not get their dirty states updated and they will
        not be rendered.

        The **QSGOpacityNode**  will return a blocked subtree when accumulated
        opacity is 0, for instance.
        """
        ...

    def markDirty(
        self, bits: typing.Union["QSGNode.DirtyState", "QSGNode.DirtyStateBit"]
    ) -> None:
        """
        https://doc.qt.io/qt-5/qsgnode.html#markDirty

        **void QSGNode::markDirty(QSGNode::DirtyState bits )**

        Notifies all connected renderers that the node has dirty **bits**.
        """
        ...

    def type(self) -> "QSGNode.NodeType":
        """
        https://doc.qt.io/qt-5/qsgnode.html#type

        **QSGNode::NodeType QSGNode::type() const**

        Returns the type of this node. The node type must be one of the
        predefined types defined in **QSGNode::NodeType**  and can safely be
        used to cast to the corresponding class.
        """
        ...

    def previousSibling(self) -> "QSGNode":
        """
        https://doc.qt.io/qt-5/qsgnode.html#previousSibling

        **QSGNode *QSGNode::previousSibling() const**

        Returns the node before this in the parent's list of children.

        The children are stored as a linked list.
        """
        ...

    def nextSibling(self) -> "QSGNode":
        """
        https://doc.qt.io/qt-5/qsgnode.html#nextSibling

        **QSGNode *QSGNode::nextSibling() const**

        Returns the node after this in the parent's list of children.

        The children are stored as a linked list.
        """
        ...

    def lastChild(self) -> "QSGNode":
        """
        https://doc.qt.io/qt-5/qsgnode.html#lastChild

        **QSGNode *QSGNode::lastChild() const**

        Returns the last child of this node.

        The children are stored as a linked list.
        """
        ...

    def firstChild(self) -> "QSGNode":
        """
        https://doc.qt.io/qt-5/qsgnode.html#firstChild

        **QSGNode *QSGNode::firstChild() const**

        Returns the first child of this node.

        The children are stored in a linked list.
        """
        ...

    def childAtIndex(self, i: int) -> "QSGNode":
        """
        https://doc.qt.io/qt-5/qsgnode.html#childAtIndex

        **QSGNode *QSGNode::childAtIndex(int i ) const**

        Returns the child at index **i**.

        Children are stored internally as a linked list, so iterating over the
        children via the index is suboptimal.
        """
        ...

    def __len__(self) -> int:
        ...

    def childCount(self) -> int:
        """
        https://doc.qt.io/qt-5/qsgnode.html#childCount

        **int QSGNode::childCount() const**

        Returns the number of child nodes.
        """
        ...

    def insertChildNodeAfter(self, node: "QSGNode", after: "QSGNode") -> None:
        """
        https://doc.qt.io/qt-5/qsgnode.html#insertChildNodeAfter

        **void QSGNode::insertChildNodeAfter(QSGNode * node , QSGNode * after
        )**

        Inserts **node** to this node's list of children after the node
        specified with **after**.

        Ordering of nodes is important as geometry nodes will be rendered in the
        order they are added to the scene graph.
        """
        ...

    def insertChildNodeBefore(self, node: "QSGNode", before: "QSGNode") -> None:
        """
        https://doc.qt.io/qt-5/qsgnode.html#insertChildNodeBefore

        **void QSGNode::insertChildNodeBefore(QSGNode * node , QSGNode * before
        )**

        Inserts **node** to this node's list of children before the node
        specified with **before**.

        Ordering of nodes is important as geometry nodes will be rendered in the
        order they are added to the scene graph.
        """
        ...

    def appendChildNode(self, node: "QSGNode") -> None:
        """
        https://doc.qt.io/qt-5/qsgnode.html#appendChildNode

        **void QSGNode::appendChildNode(QSGNode * node )**

        Appends **node** to this node's list of children.

        Ordering of nodes is important as geometry nodes will be rendered in the
        order they are added to the scene graph.
        """
        ...

    def prependChildNode(self, node: "QSGNode") -> None:
        """
        https://doc.qt.io/qt-5/qsgnode.html#prependChildNode

        **void QSGNode::prependChildNode(QSGNode * node )**

        Prepends **node** to this node's the list of children.

        Ordering of nodes is important as geometry nodes will be rendered in the
        order they are added to the scene graph.
        """
        ...

    def removeAllChildNodes(self) -> None:
        """
        https://doc.qt.io/qt-5/qsgnode.html#removeAllChildNodes

        **void QSGNode::removeAllChildNodes()**

        Removes all child nodes from this node's list of children.
        """
        ...

    def removeChildNode(self, node: "QSGNode") -> None:
        """
        https://doc.qt.io/qt-5/qsgnode.html#removeChildNode

        **void QSGNode::removeChildNode(QSGNode * node )**

        Removes **node** from this node's list of children.
        """
        ...

    def parent(self) -> "QSGNode":
        """
        https://doc.qt.io/qt-5/qsgnode.html#parent

        **QSGNode *QSGNode::parent() const**

        Returns the parent node of this node.
        """
        ...
