"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
from PyQt5 import QtGui
from PyQt5 import QtCore
from PyQt5.QtQuick import *
from PyQt5 import sip


class QSGEngine(QtCore.QObject):
    """
    https://doc.qt.io/qt-5/qsgengine.html

    **Detailed Description**

    A QSGEngine can be used to render a tree of **QSGNode**  directly on a
    **QWindow**  or **QOpenGLFramebufferObject**  without any integration with
    QML, **QQuickWindow**  or **QQuickItem**  and the convenience that they
    provide.

    This means that you must handle event propagation, animation timing, and
    node lifetime yourself.

    **Note:** This class is for very low level access to an independent scene
    graph. Most of the time you will instead want to subclass **QQuickItem**
    and insert your **QSGNode**  in a normal **QtQuick**  scene by overriding
    **QQuickItem::updatePaintNode** ().

    **Warning:** This class is only suitable when working directly with OpenGL.
    It is not compatible with the **RHI-based rendering path** .

    **See also** **QSGAbstractRenderer** .
    """

    class CreateTextureOption(int):
        TextureHasAlphaChannel: QSGEngine = ...
        TextureOwnsGLTexture: QSGEngine = ...
        TextureCanUseAtlas: QSGEngine = ...
        TextureIsOpaque: QSGEngine = ...

    class CreateTextureOptions(sip.simplewrapper):
        @typing.overload
        def __init__(self) -> None:
            ...

        @typing.overload
        def __init__(
            self,
            f: typing.Union[
                "QSGEngine.CreateTextureOptions", "QSGEngine.CreateTextureOption"
            ],
        ) -> None:
            ...

        @typing.overload
        def __init__(self, a0: "QSGEngine.CreateTextureOptions") -> None:
            ...

        def __hash__(self) -> int:
            ...

        def __bool__(self) -> int:
            ...

        def __invert__(self) -> "QSGEngine.CreateTextureOptions":
            ...

        def __index__(self) -> int:
            ...

        def __int__(self) -> int:
            ...

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qsgengine.html#QSGEngine

        **QSGEngine::QSGEngine(QObject * parent = nullptr)**

        Constructs a new QSGEngine with its **parent**
        """
        ...

    def createImageNode(self) -> "QSGImageNode":
        """
        https://doc.qt.io/qt-5/qsgengine.html#createImageNode

        **QSGImageNode *QSGEngine::createImageNode() const**

        Creates a simple image node. When the scenegraph is not initialized, the
        return value is null.

        This is cross-backend alternative to constructing a QSGSimpleTextureNode
        directly.

        This function was introduced in Qt 5.8.

        **See also** **QSGImageNode** .
        """
        ...

    def createRectangleNode(self) -> "QSGRectangleNode":
        """
        https://doc.qt.io/qt-5/qsgengine.html#createRectangleNode

        **QSGRectangleNode *QSGEngine::createRectangleNode() const**

        Creates a simple rectangle node. When the scenegraph is not initialized,
        the return value is null.

        This is cross-backend alternative to constructing a QSGSimpleRectNode
        directly.

        This function was introduced in Qt 5.8.

        **See also** **QSGRectangleNode** .
        """
        ...

    def rendererInterface(self) -> "QSGRendererInterface":
        """
        https://doc.qt.io/qt-5/qsgengine.html#rendererInterface

        **QSGRendererInterface *QSGEngine::rendererInterface() const**

        Returns the current renderer interface if there is one. Otherwise null
        is returned.

        This function was introduced in Qt 5.8.

        **See also** **QSGRenderNode**  and **QSGRendererInterface** .
        """
        ...

    def createTextureFromId(
        self,
        id: int,
        size: QtCore.QSize,
        options: typing.Union[
            "QSGEngine.CreateTextureOptions", "QSGEngine.CreateTextureOption"
        ] = ...,
    ) -> "QSGTexture":
        """
        https://doc.qt.io/qt-5/qsgengine.html#createTextureFromId

        **QSGTexture *QSGEngine::createTextureFromId(uint id , const QSize &
        size , QSGEngine::CreateTextureOptions options = CreateTextureOption())
        const**

        Creates a texture object that wraps the GL texture **id** uploaded with
        **size**

        Valid **options** are **TextureHasAlphaChannel**  and
        **TextureOwnsGLTexture**

        The caller takes ownership of the texture object and the texture should
        only be used with this engine.

        **See also** **createTextureFromImage** (),
        **QSGSimpleTextureNode::setOwnsTexture** (), and
        **QQuickWindow::createTextureFromId** ().
        """
        ...

    def createTextureFromImage(
        self,
        image: QtGui.QImage,
        options: typing.Union[
            "QSGEngine.CreateTextureOptions", "QSGEngine.CreateTextureOption"
        ] = ...,
    ) -> "QSGTexture":
        """
        https://doc.qt.io/qt-5/qsgengine.html#createTextureFromImage

        **QSGTexture *QSGEngine::createTextureFromImage(const QImage & image ,
        QSGEngine::CreateTextureOptions options = CreateTextureOption()) const**

        Creates a texture using the data of **image**

        Valid **options** are **TextureCanUseAtlas**  and **TextureIsOpaque** .

        The caller takes ownership of the texture and the texture should only be
        used with this engine.

        **See also** **createTextureFromId** (),
        **QSGSimpleTextureNode::setOwnsTexture** (), and
        **QQuickWindow::createTextureFromImage** ().
        """
        ...

    def createRenderer(self) -> QSGAbstractRenderer:
        """
        https://doc.qt.io/qt-5/qsgengine.html#createRenderer

        **QSGAbstractRenderer *QSGEngine::createRenderer() const**

        Returns a renderer that can be used to render a **QSGNode**  tree

        You call **initialize** () first with the **QOpenGLContext**  that you
        want to use with this renderer. This will return a null renderer
        otherwise.
        """
        ...

    def invalidate(self) -> None:
        """
        https://doc.qt.io/qt-5/qsgengine.html#invalidate

        **void QSGEngine::invalidate()**

        Invalidate the engine releasing its resources

        You will have to call **initialize** () and **createRenderer** () if you
        want to use it again.
        """
        ...

    def initialize(self, context: QtGui.QOpenGLContext) -> None:
        """
        https://doc.qt.io/qt-5/qsgengine.html#initialize

        **void QSGEngine::initialize(QOpenGLContext * context )**

        Initialize the engine with **context**.

        **Warning:** You have to make sure that you call
        **QOpenGLContext::makeCurrent** () on **context** before calling this.
        """
        ...
