"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
import PyQt5.sip
from PyQt5 import QtQml
from PyQt5 import QtGui
from PyQt5 import QtCore
from PyQt5.QtQuick import *
from PyQt5 import sip


class QQuickWindow(QtGui.QWindow):
    """
    https://doc.qt.io/qt-5/qquickwindow.html

    **Detailed Description**

    QQuickWindow provides the graphical scene management needed to interact with
    and display a scene of QQuickItems.

    A QQuickWindow always has a single invisible root item. To add items to this
    window, reparent the items to the root item or to an existing item in the
    scene.

    For easily displaying a scene from a QML file, see **QQuickView** .

    **Rendering**

    QQuickWindow uses a scene graph to represent what needs to be rendered. This
    scene graph is disconnected from the QML scene and potentially lives in
    another thread, depending on the platform implementation. Since the
    rendering scene graph lives independently from the QML scene, it can also be
    completely released without affecting the state of the QML scene.

    The **sceneGraphInitialized** () signal is emitted on the rendering thread
    before the QML scene is rendered to the screen for the first time. If the
    rendering scene graph has been released, the signal will be emitted again
    before the next frame is rendered.

    **Integration with OpenGL**

    When using the default OpenGL adaptation, it is possible to integrate OpenGL
    calls directly into the QQuickWindow using the same OpenGL context as the Qt
    Quick Scene Graph. This is done by connecting to the
    **QQuickWindow::beforeRendering** () or **QQuickWindow::afterRendering** ()
    signal.

    **Note:** When using **QQuickWindow::beforeRendering** (), make sure to
    disable clearing before rendering with
    **QQuickWindow::setClearBeforeRendering** ().

    **Exposure and Visibility**

    When a QQuickWindow instance is deliberately hidden with **hide** () or
    **setVisible** (false), it will stop rendering and its scene graph and
    graphics context might be released. The **sceneGraphInvalidated** () signal
    will be emitted when this happens.

    **Warning:** It is crucial that graphics operations and interaction with the
    scene graph happens exclusively on the rendering thread, primarily during
    the updatePaintNode() phase.

    **Warning:** As signals related to rendering might be emitted from the
    rendering thread, connections should be made using **Qt::DirectConnection**
    .

    **Resource Management**

    QML will try to cache images and scene graph nodes to improve performance,
    but in some low-memory scenarios it might be required to aggressively
    release these resources. The **releaseResources** () can be used to force
    the clean up of certain resources. Calling **releaseResources** () may
    result in the entire scene graph and in the case of the OpenGL adaptation
    the associated context will be deleted. The **sceneGraphInvalidated** ()
    signal will be emitted when this happens.

    **Note:** All classes with QSG prefix should be used solely on the scene
    graph's rendering thread. See **Scene Graph and Rendering**  for more
    information.

    **Context and Surface Formats**

    While it is possible to specify a **QSurfaceFormat**  for every QQuickWindow
    by calling the member function **setFormat** (), windows may also be created
    from QML by using the Window and **ApplicationWindow**  elements. In this
    case there is no C++ code involved in the creation of the window instance,
    yet applications may still wish to set certain surface format values, for
    example to request a given OpenGL version or profile. Such applications can
    call the static function **QSurfaceFormat::setDefaultFormat** () at startup.
    The specified format will be used for all Quick windows created afterwards.

    **See also** **Scene Graph - OpenGL Under QML** .
    """

    class NativeObjectType(int):
        NativeObjectTexture: QQuickWindow = ...

    class TextRenderType(int):
        QtTextRendering: QQuickWindow = ...
        NativeTextRendering: QQuickWindow = ...

    class RenderStage(int):
        BeforeSynchronizingStage: QQuickWindow = ...
        AfterSynchronizingStage: QQuickWindow = ...
        BeforeRenderingStage: QQuickWindow = ...
        AfterRenderingStage: QQuickWindow = ...
        AfterSwapStage: QQuickWindow = ...
        NoStage: QQuickWindow = ...

    class SceneGraphError(int):
        ContextNotAvailable: QQuickWindow = ...

    class CreateTextureOption(int):
        TextureHasAlphaChannel: QQuickWindow = ...
        TextureHasMipmaps: QQuickWindow = ...
        TextureOwnsGLTexture: QQuickWindow = ...
        TextureCanUseAtlas: QQuickWindow = ...
        TextureIsOpaque: QQuickWindow = ...

    class CreateTextureOptions(sip.simplewrapper):
        @typing.overload
        def __init__(self) -> None:
            ...

        @typing.overload
        def __init__(
            self,
            f: typing.Union[
                "QQuickWindow.CreateTextureOptions", "QQuickWindow.CreateTextureOption"
            ],
        ) -> None:
            ...

        @typing.overload
        def __init__(self, a0: "QQuickWindow.CreateTextureOptions") -> None:
            ...

        def __hash__(self) -> int:
            ...

        def __bool__(self) -> int:
            ...

        def __invert__(self) -> "QQuickWindow.CreateTextureOptions":
            ...

        def __index__(self) -> int:
            ...

        def __int__(self) -> int:
            ...

    def __init__(self, parent: typing.Optional[QtGui.QWindow] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qquickwindow.html#QQuickWindow

        **QQuickWindow::QQuickWindow(QWindow * parent = nullptr)**

        Constructs a window for displaying a QML scene with parent window
        **parent**.
        """
        ...

    def endExternalCommands(self) -> None:
        """
        https://doc.qt.io/qt-5/qquickwindow.html#endExternalCommands

        **void QQuickWindow::endExternalCommands()**

        When mixing raw graphics (OpenGL, Vulkan, Metal, etc.) commands with
        scene graph rendering, it is necessary to call this function after
        recording commands to the command buffer used by the scene graph to
        render its main render pass. This is to avoid clobbering state.

        In practice this function is often called from a slot connected to the
        **beforeRenderPassRecording** () or **afterRenderPassRecording** ()
        signals.

        The function does not need to be called when recording commands to the
        application's own command buffer (such as, a VkCommandBuffer or
        MTLCommandBuffer + MTLRenderCommandEncoder created and managed by the
        application, not retrieved from the scene graph). With graphics APIs
        where no native command buffer concept is exposed (OpenGL, Direct 3D
        11), **beginExternalCommands** () and endExternalCommands() together
        provide a replacement for **resetOpenGLState** ().

        Calling this function and **beginExternalCommands** () is not necessary
        within the **render()**  implementation of a **QSGRenderNode**  because
        the scene graph performs the necessary steps implicitly for render
        nodes.

        **Note:** This function has no effect when the scene graph is using
        OpenGL directly and the RHI graphics abstraction layer is not in use.
        Refer to **resetOpenGLState** () in that case.

        This function was introduced in Qt 5.14.

        **See also** **beginExternalCommands** ().
        """
        ...

    def beginExternalCommands(self) -> None:
        """
        https://doc.qt.io/qt-5/qquickwindow.html#beginExternalCommands

        **void QQuickWindow::beginExternalCommands()**

        When mixing raw graphics (OpenGL, Vulkan, Metal, etc.) commands with
        scene graph rendering, it is necessary to call this function before
        recording commands to the command buffer used by the scene graph to
        render its main render pass. This is to avoid clobbering state.

        In practice this function is often called from a slot connected to the
        **beforeRenderPassRecording** () or **afterRenderPassRecording** ()
        signals.

        The function does not need to be called when recording commands to the
        application's own command buffer (such as, a VkCommandBuffer or
        MTLCommandBuffer + MTLRenderCommandEncoder created and managed by the
        application, not retrieved from the scene graph). With graphics APIs
        where no native command buffer concept is exposed (OpenGL, Direct 3D
        11), beginExternalCommands() and **endExternalCommands** () together
        provide a replacement for **resetOpenGLState** ().

        Calling this function and **endExternalCommands** () is not necessary
        within the **render()**  implementation of a **QSGRenderNode**  because
        the scene graph performs the necessary steps implicitly for render
        nodes.

        Native graphics objects (such as, graphics device, command buffer or
        encoder) are accessible via **QSGRendererInterface::getResource** ().

        **Warning:** Watch out for the fact that
        **QSGRendererInterface::CommandListResource**  may return a different
        object between beginExternalCommands() - **endExternalCommands** ().
        This can happen when the underlying implementation provides a dedicated
        secondary command buffer for recording external graphics commands within
        a render pass. Therefore, always query CommandListResource after calling
        this function. Do not attempt to reuse an object from an earlier query.

        **Note:** This function has no effect when the scene graph is using
        OpenGL directly and the RHI graphics abstraction layer is not in use.
        Refer to **resetOpenGLState** () in that case.

        **Note:** When the scenegraph is using the RHI graphics abstraction
        layer with the OpenGL backend underneath, pay attention to the fact that
        the OpenGL state in the context can have arbitrary settings, and this
        function does not perform any resetting of the state back to defaults.
        Call **resetOpenGLState** () if that is seen necessary.

        This function was introduced in Qt 5.14.

        **See also** **endExternalCommands** () and **resetOpenGLState** ().
        """
        ...

    @staticmethod
    def setTextRenderType(renderType: "QQuickWindow.TextRenderType") -> None:
        """
        https://doc.qt.io/qt-5/qquickwindow.html#setTextRenderType

        **[static] void
        QQuickWindow::setTextRenderType(QQuickWindow::TextRenderType renderType
        )**

        Sets the default render type of text-like elements in Qt Quick to
        **renderType**.

        **Note:** setting the render type will only affect elements created
        afterwards; the render type of existing elements will not be modified.

        This function was introduced in Qt 5.10.

        **See also** **textRenderType** ().
        """
        ...

    @staticmethod
    def textRenderType() -> "QQuickWindow.TextRenderType":
        """
        https://doc.qt.io/qt-5/qquickwindow.html#textRenderType

        **[static] QQuickWindow::TextRenderType QQuickWindow::textRenderType()**

        Returns the render type of text-like elements in Qt Quick. The default
        is **QQuickWindow::QtTextRendering** .

        This function was introduced in Qt 5.10.

        **See also** **setTextRenderType** ().
        """
        ...

    @staticmethod
    def sceneGraphBackend() -> str:
        """
        https://doc.qt.io/qt-5/qquickwindow.html#sceneGraphBackend

        **[static] QString QQuickWindow::sceneGraphBackend()**

        Returns the requested Qt Quick scenegraph backend.

        **Note:** The return value of this function may still be outdated by
        subsequent calls to **setSceneGraphBackend** () until the first
        **QQuickWindow**  in the application has been constructed.

        This function was introduced in Qt 5.9.

        **See also** **setSceneGraphBackend** ().
        """
        ...

    def createImageNode(self) -> "QSGImageNode":
        """
        https://doc.qt.io/qt-5/qquickwindow.html#createImageNode

        **QSGImageNode *QQuickWindow::createImageNode() const**

        Creates a simple image node. When the scenegraph is not initialized, the
        return value is null.

        This is cross-backend alternative to constructing a QSGSimpleTextureNode
        directly.

        This function was introduced in Qt 5.8.

        **See also** **QSGImageNode** .
        """
        ...

    def createRectangleNode(self) -> "QSGRectangleNode":
        """
        https://doc.qt.io/qt-5/qquickwindow.html#createRectangleNode

        **QSGRectangleNode *QQuickWindow::createRectangleNode() const**

        Creates a simple rectangle node. When the scenegraph is not initialized,
        the return value is null.

        This is cross-backend alternative to constructing a QSGSimpleRectNode
        directly.

        This function was introduced in Qt 5.8.

        **See also** **QSGRectangleNode** .
        """
        ...

    @typing.overload
    @staticmethod
    def setSceneGraphBackend(api: "QSGRendererInterface.GraphicsApi") -> None:
        """
        https://doc.qt.io/qt-5/qquickwindow.html#setSceneGraphBackend

        **[static] void
        QQuickWindow::setSceneGraphBackend(QSGRendererInterface::GraphicsApi api
        )**

        Requests a Qt Quick scenegraph backend for the specified graphics
        **api**. Backends can either be built-in or be installed in form of
        dynamically loaded plugins.

        **Note:** The call to the function must happen before constructing the
        first **QQuickWindow**  in the application. It cannot be changed
        afterwards.

        If the selected backend is invalid or an error occurs, the default
        backend (OpenGL or software, depending on the Qt configuration) is used.

        This function was introduced in Qt 5.8.

        **See also** **sceneGraphBackend** ().
        """
        ...

    @typing.overload
    @staticmethod
    def setSceneGraphBackend(backend: str) -> None:
        """
        https://doc.qt.io/qt-5/qquickwindow.html#setSceneGraphBackend-1

        **[static] void QQuickWindow::setSceneGraphBackend(const QString &
        backend )**

        Requests the specified Qt Quick scenegraph **backend**. Backends can
        either be built-in or be installed in form of dynamically loaded
        plugins.

        This is an overloaded function.

        **Note:** The call to the function must happen before constructing the
        first **QQuickWindow**  in the application. It cannot be changed
        afterwards.

        If **backend** is invalid or an error occurs, the default backend
        (OpenGL or software, depending on the Qt configuration) is used.

        **Note:** Calling this function is equivalent to setting the
        `QT_QUICK_BACKEND` or `QMLSCENE_DEVICE` environment variables. However,
        this API is safer to use in applications that spawn other processes as
        there is no need to worry about environment inheritance.

        This function was introduced in Qt 5.8.
        """
        ...

    def rendererInterface(self) -> "QSGRendererInterface":
        """
        https://doc.qt.io/qt-5/qquickwindow.html#rendererInterface

        **QSGRendererInterface *QQuickWindow::rendererInterface() const**

        Returns the current renderer interface. The value is always valid and is
        never null.

        **Note:** This function can be called at any time after constructing the
        **QQuickWindow** , even while **isSceneGraphInitialized** () is still
        false. However, some renderer interface functions, in particular
        **QSGRendererInterface::getResource** () will not be functional until
        the scenegraph is up and running. Backend queries, like
        **QSGRendererInterface::graphicsApi** () or
        **QSGRendererInterface::shaderType** (), will always be functional on
        the other hand.

        **Note:** The ownership of the returned pointer stays with Qt. The
        returned instance may or may not be shared between different
        **QQuickWindow**  instances, depending on the scenegraph backend in use.
        Therefore applications are expected to query the interface object for
        each **QQuickWindow**  instead of reusing the already queried pointer.

        This function was introduced in Qt 5.8.

        **See also** **QSGRenderNode**  and **QSGRendererInterface** .
        """
        ...

    def isSceneGraphInitialized(self) -> bool:
        """
        https://doc.qt.io/qt-5/qquickwindow.html#isSceneGraphInitialized

        **bool QQuickWindow::isSceneGraphInitialized() const**

        Returns true if the scene graph has been initialized; otherwise returns
        false.
        """
        ...

    def effectiveDevicePixelRatio(self) -> float:
        """
        https://doc.qt.io/qt-5/qquickwindow.html#effectiveDevicePixelRatio

        **qreal QQuickWindow::effectiveDevicePixelRatio() const**

        Returns the device pixel ratio for this window.

        This is different from **QWindow::devicePixelRatio** () in that it
        supports redirected rendering via **QQuickRenderControl** . When using a
        **QQuickRenderControl** , the **QQuickWindow**  is often not created,
        meaning it is never shown and there is no underlying native window
        created in the windowing system. As a result, querying properties like
        the device pixel ratio cannot give correct results. Use this function
        instead.

        **See also** **QWindow::devicePixelRatio** ().
        """
        ...

    def scheduleRenderJob(
        self, job: QtCore.QRunnable, schedule: "QQuickWindow.RenderStage"
    ) -> None:
        """
        https://doc.qt.io/qt-5/qquickwindow.html#scheduleRenderJob

        **void QQuickWindow::scheduleRenderJob(QRunnable * job ,
        QQuickWindow::RenderStage stage )**

        Schedules **job** to run when the rendering of this window reaches the
        given **stage**.

        This is a convenience to the equivalent signals in **QQuickWindow**  for
        "one shot" tasks.

        The window takes ownership over **job** and will delete it when the job
        is completed.

        If rendering is shut down before **job** has a chance to run, the job
        will be run and then deleted as part of the scene graph cleanup. If the
        window is never shown and no rendering happens before the
        **QQuickWindow**  is destroyed, all pending jobs will be destroyed
        without their run() method being called.

        If the rendering is happening on a different thread, then the job will
        happen on the rendering thread.

        If **stage** is **NoStage** , **job** will be run at the earliest
        opportunity whenever the render thread is not busy rendering a frame. If
        there is no OpenGL context available or the window is not exposed at the
        time the job is either posted or handled, it is deleted without
        executing the run() method. If a non-threaded renderer is in use, the
        run() method of the job is executed synchronously. The OpenGL context is
        changed to the renderer context before executing a **NoStage**  job.

        **Note:** This function does not trigger rendering; the jobs targeting
        any other stage than **NoStage**  will be stored run until rendering is
        triggered elsewhere. To force the job to run earlier, call
        **QQuickWindow::update** ();

        This function was introduced in Qt 5.4.

        **See also** **beforeRendering** (), **afterRendering** (),
        **beforeSynchronizing** (), **afterSynchronizing** (), **frameSwapped**
        (), and **sceneGraphInvalidated** ().
        """
        ...

    def resetOpenGLState(self) -> None:
        """
        https://doc.qt.io/qt-5/qquickwindow.html#resetOpenGLState

        **void QQuickWindow::resetOpenGLState()**

        Call this function to reset the OpenGL context its default state.

        The scene graph uses the OpenGL context and will both rely on and
        clobber its state. When mixing raw OpenGL commands with scene graph
        rendering, this function provides a convenient way of resetting the
        OpenGL context state back to its default values.

        This function does not touch state in the fixed-function pipeline.

        This function does not clear the color, depth and stencil buffers. Use
        **QQuickWindow::setClearBeforeRendering**  to control clearing of the
        color buffer. The depth and stencil buffer might be clobbered by the
        scene graph renderer. Clear these manually on demand.

        **Note:** This function only has an effect when using the default OpenGL
        scene graph adaptation.

        **Note:** This function will only reset the OpenGL context in relation
        to what has been changed internally as part of the OpenGL scene graph.
        It does not reset anything that has been changed externally such as
        direct OpenGL calls done inside the application code if those same calls
        are not used internally.

        **Note:** This function has no effect when running on the RHI graphics
        abstraction and the underlying RHI backend is not OpenGL.

        This function was introduced in Qt 5.2.

        **See also** **QQuickWindow::beforeRendering** (),
        **beginExternalCommands** (), and **endExternalCommands** ().
        """
        ...

    @staticmethod
    def setDefaultAlphaBuffer(useAlpha: bool) -> None:
        """
        https://doc.qt.io/qt-5/qquickwindow.html#setDefaultAlphaBuffer

        **[static] void QQuickWindow::setDefaultAlphaBuffer(bool useAlpha )**

        **useAlpha** specifies whether to use alpha transparency on newly
        created windows.

        In any application which expects to create translucent windows, it's
        necessary to set this to true before creating the first **QQuickWindow**
        . The default value is false.

        This function was introduced in Qt 5.1.

        **See also** **hasDefaultAlphaBuffer** ().
        """
        ...

    @staticmethod
    def hasDefaultAlphaBuffer() -> bool:
        """
        https://doc.qt.io/qt-5/qquickwindow.html#hasDefaultAlphaBuffer

        **[static] bool QQuickWindow::hasDefaultAlphaBuffer()**

        Returns whether to use alpha transparency on newly created windows.

        This function was introduced in Qt 5.1.

        **See also** **setDefaultAlphaBuffer** ().
        """
        ...

    def tabletEvent(self, a0: QtGui.QTabletEvent) -> None:
        """
        https://doc.qt.io/qt-5/qquickwindow.html#tabletEvent

        **[override virtual protected] void
        QQuickWindow::tabletEvent(QTabletEvent * event )**

        Reimplements: **QWindow::tabletEvent** (QTabletEvent *ev).
        """
        ...

    def wheelEvent(self, a0: QtGui.QWheelEvent) -> None:
        """
        https://doc.qt.io/qt-5/qquickwindow.html#wheelEvent

        **[override virtual protected] void QQuickWindow::wheelEvent(QWheelEvent
        * event )**

        Reimplements: **QWindow::wheelEvent** (QWheelEvent *ev).
        """
        ...

    def mouseMoveEvent(self, a0: QtGui.QMouseEvent) -> None:
        """
        https://doc.qt.io/qt-5/qquickwindow.html#mouseMoveEvent

        **[override virtual protected] void
        QQuickWindow::mouseMoveEvent(QMouseEvent * event )**

        Reimplements: **QWindow::mouseMoveEvent** (QMouseEvent *ev).
        """
        ...

    def mouseDoubleClickEvent(self, a0: QtGui.QMouseEvent) -> None:
        """
        https://doc.qt.io/qt-5/qquickwindow.html#mouseDoubleClickEvent

        **[override virtual protected] void
        QQuickWindow::mouseDoubleClickEvent(QMouseEvent * event )**

        Reimplements: **QWindow::mouseDoubleClickEvent** (QMouseEvent *ev).
        """
        ...

    def mouseReleaseEvent(self, a0: QtGui.QMouseEvent) -> None:
        """
        https://doc.qt.io/qt-5/qquickwindow.html#mouseReleaseEvent

        **[override virtual protected] void
        QQuickWindow::mouseReleaseEvent(QMouseEvent * event )**

        Reimplements: **QWindow::mouseReleaseEvent** (QMouseEvent *ev).
        """
        ...

    def mousePressEvent(self, a0: QtGui.QMouseEvent) -> None:
        """
        https://doc.qt.io/qt-5/qquickwindow.html#mousePressEvent

        **[override virtual protected] void
        QQuickWindow::mousePressEvent(QMouseEvent * event )**

        Reimplements: **QWindow::mousePressEvent** (QMouseEvent *ev).
        """
        ...

    def keyReleaseEvent(self, a0: QtGui.QKeyEvent) -> None:
        """
        https://doc.qt.io/qt-5/qquickwindow.html#keyReleaseEvent

        **[override virtual protected] void
        QQuickWindow::keyReleaseEvent(QKeyEvent * e )**

        Reimplements: **QWindow::keyReleaseEvent** (QKeyEvent *ev).
        """
        ...

    def keyPressEvent(self, a0: QtGui.QKeyEvent) -> None:
        """
        https://doc.qt.io/qt-5/qquickwindow.html#keyPressEvent

        **[override virtual protected] void
        QQuickWindow::keyPressEvent(QKeyEvent * e )**

        Reimplements: **QWindow::keyPressEvent** (QKeyEvent *ev).
        """
        ...

    def event(self, a0: QtCore.QEvent) -> bool:
        """
        https://doc.qt.io/qt-5/qquickwindow.html#event

        **[override virtual protected] bool QQuickWindow::event(QEvent * e )**

        Reimplements: **QWindow::event** (QEvent *ev).
        """
        ...

    def focusOutEvent(self, a0: QtGui.QFocusEvent) -> None:
        """
        https://doc.qt.io/qt-5/qquickwindow.html#focusOutEvent

        **[override virtual protected] void
        QQuickWindow::focusOutEvent(QFocusEvent * ev )**

        Reimplements: **QWindow::focusOutEvent** (QFocusEvent *ev).
        """
        ...

    def focusInEvent(self, a0: QtGui.QFocusEvent) -> None:
        """
        https://doc.qt.io/qt-5/qquickwindow.html#focusInEvent

        **[override virtual protected] void
        QQuickWindow::focusInEvent(QFocusEvent * ev )**

        Reimplements: **QWindow::focusInEvent** (QFocusEvent *ev).
        """
        ...

    def hideEvent(self, a0: QtGui.QHideEvent) -> None:
        """
        https://doc.qt.io/qt-5/qquickwindow.html#hideEvent

        **[override virtual protected] void QQuickWindow::hideEvent( QHideEvent
        * )**

        Reimplements: **QWindow::hideEvent** (QHideEvent *ev).
        """
        ...

    def showEvent(self, a0: QtGui.QShowEvent) -> None:
        """
        https://doc.qt.io/qt-5/qquickwindow.html#showEvent

        **[override virtual protected] void QQuickWindow::showEvent( QShowEvent
        * )**

        Reimplements: **QWindow::showEvent** (QShowEvent *ev).
        """
        ...

    def resizeEvent(self, a0: QtGui.QResizeEvent) -> None:
        """
        https://doc.qt.io/qt-5/qquickwindow.html#resizeEvent

        **[override virtual protected] void
        QQuickWindow::resizeEvent(QResizeEvent * ev )**

        Reimplements: **QWindow::resizeEvent** (QResizeEvent *ev).
        """
        ...

    def exposeEvent(self, a0: QtGui.QExposeEvent) -> None:
        """
        https://doc.qt.io/qt-5/qquickwindow.html#exposeEvent

        **[override virtual protected] void QQuickWindow::exposeEvent(
        QExposeEvent * )**

        Reimplements: **QWindow::exposeEvent** (QExposeEvent *ev).
        """
        ...

    def releaseResources(self) -> None:
        """
        https://doc.qt.io/qt-5/qquickwindow.html#releaseResources

        **[slot] void QQuickWindow::releaseResources()**

        This function tries to release redundant resources currently held by the
        QML scene.

        Calling this function might result in the scene graph and the OpenGL
        context used for rendering being released to release graphics memory. If
        this happens, the **sceneGraphInvalidated** () signal will be called,
        allowing users to clean up their own graphics resources. The
        **setPersistentOpenGLContext** () and **setPersistentSceneGraph** ()
        functions can be used to prevent this from happening, if handling the
        cleanup is not feasible in the application, at the cost of higher memory
        usage.

        **See also** **sceneGraphInvalidated** (),
        **setPersistentOpenGLContext** (), and **setPersistentSceneGraph** ().
        """
        ...

    def update(self) -> None:
        """
        https://doc.qt.io/qt-5/qquickwindow.html#update

        **[slot] void QQuickWindow::update()**

        Schedules the window to render another frame.

        Calling QQuickWindow::update() differs from **QQuickItem::update** () in
        that it always triggers a repaint, regardless of changes in the
        underlying scene graph or not.
        """
        ...

    def openglContext(self) -> QtGui.QOpenGLContext:
        """
        https://doc.qt.io/qt-5/qquickwindow.html#openglContext

        **QOpenGLContext *QQuickWindow::openglContext() const**

        Returns the OpenGL context used for rendering.

        **Note:** If the scene graph is not ready, or the scene graph is not
        using OpenGL (or RHI over OpenGL), this function will return null.

        **See also** **sceneGraphInitialized** () and **sceneGraphInvalidated**
        ().
        """
        ...

    def isPersistentSceneGraph(self) -> bool:
        """
        https://doc.qt.io/qt-5/qquickwindow.html#isPersistentSceneGraph

        **bool QQuickWindow::isPersistentSceneGraph() const**

        Returns whether the scene graph nodes and resources can be released
        during the lifetime of this **QQuickWindow** .

        **Note:** This is a hint. When and how this happens is implementation
        specific.
        """
        ...

    def setPersistentSceneGraph(self, persistent: bool) -> None:
        """
        https://doc.qt.io/qt-5/qquickwindow.html#setPersistentSceneGraph

        **void QQuickWindow::setPersistentSceneGraph(bool persistent )**

        Sets whether the scene graph nodes and resources are **persistent**.
        Persistent means the nodes and resources cannot be released. The default
        value is `true`.

        The scene graph nodes and resources can be released to free up graphics
        resources when the window is obscured, hidden or not rendering. When
        this happens is implementation specific.

        The **QQuickWindow::sceneGraphInvalidated** () signal is emitted when
        cleanup occurs. The **QQuickWindow::sceneGraphInitialized** () signal is
        emitted when a new scene graph is recreated for this window. Make a
        **Qt::DirectConnection**  to these signals to be notified.

        The scene graph nodes and resources are still released when the last
        **QQuickWindow**  is deleted.

        **See also** **isPersistentSceneGraph** (),
        **setPersistentOpenGLContext** (), **sceneGraphInvalidated** (), and
        **sceneGraphInitialized** ().
        """
        ...

    def isPersistentOpenGLContext(self) -> bool:
        """
        https://doc.qt.io/qt-5/qquickwindow.html#isPersistentOpenGLContext

        **bool QQuickWindow::isPersistentOpenGLContext() const**

        Returns whether the OpenGL context can be released during the lifetime
        of the **QQuickWindow** .

        **Note:** This is a hint. When and how this happens is implementation
        specific. It also only has an effect when using the default OpenGL scene
        graph adaptation
        """
        ...

    def setPersistentOpenGLContext(self, persistent: bool) -> None:
        """
        https://doc.qt.io/qt-5/qquickwindow.html#setPersistentOpenGLContext

        **void QQuickWindow::setPersistentOpenGLContext(bool persistent )**

        Sets whether the OpenGL context should be preserved, and cannot be
        released until the last window is deleted, to **persistent**. The
        default value is true.

        The OpenGL context can be released to free up graphics resources when
        the window is obscured, hidden or not rendering. When this happens is
        implementation specific.

        The **QOpenGLContext::aboutToBeDestroyed** () signal is emitted from the
        **QQuickWindow::openglContext** () when the OpenGL context is about to
        be released. The **QQuickWindow::sceneGraphInitialized** () signal is
        emitted when a new OpenGL context is created for this window. Make a
        **Qt::DirectConnection**  to these signals to be notified.

        The OpenGL context is still released when the last **QQuickWindow**  is
        deleted.

        **Note:** This only has an effect when using the default OpenGL scene
        graph adaptation.

        **See also** **isPersistentOpenGLContext** (),
        **setPersistentSceneGraph** (), **QOpenGLContext::aboutToBeDestroyed**
        (), and **sceneGraphInitialized** ().
        """
        ...

    def color(self) -> QtGui.QColor:
        """
        https://doc.qt.io/qt-5/qquickwindow.html#color-prop

        **color : QColor**

        This property holds the color used to clear the OpenGL context.

        Setting the clear color has no effect when clearing is disabled. By
        default, the clear color is white.

        **Access functions:**

        QColor **color** () const
        void **setColor** (const QColor & **color**
        )

        **Notifier signal:**

        void **colorChanged** ( **const QColor &**)

        **See also** **setClearBeforeRendering** () and
        **setDefaultAlphaBuffer** ().
        """
        ...

    def setColor(
        self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor]
    ) -> None:
        """
        https://doc.qt.io/qt-5/qquickwindow.html#color-prop

        **color : QColor**

        This property holds the color used to clear the OpenGL context.

        Setting the clear color has no effect when clearing is disabled. By
        default, the clear color is white.

        **Access functions:**

        QColor **color** () const
        void **setColor** (const QColor & **color**
        )

        **Notifier signal:**

        void **colorChanged** ( **const QColor &**)

        **See also** **setClearBeforeRendering** () and
        **setDefaultAlphaBuffer** ().
        """
        ...

    def clearBeforeRendering(self) -> bool:
        """
        https://doc.qt.io/qt-5/qquickwindow.html#clearBeforeRendering

        **bool QQuickWindow::clearBeforeRendering() const**

        Returns whether clearing of the color buffer is done before rendering or
        not.

        **See also** **setClearBeforeRendering** ().
        """
        ...

    def setClearBeforeRendering(self, enabled: bool) -> None:
        """
        https://doc.qt.io/qt-5/qquickwindow.html#setClearBeforeRendering

        **void QQuickWindow::setClearBeforeRendering(bool enabled )**

        Sets whether the scene graph rendering of QML should clear the color
        buffer before it starts rendering to **enabled**.

        By disabling clearing of the color buffer, it is possible to render
        OpengGL content under the scene graph.

        The color buffer is cleared by default.

        **Warning:** This flag is ignored completely when running with the RHI
        graphics abstraction instead of using OpenGL directly. As explicit clear
        commands simply do not exist in some modern APIs, the scene graph cannot
        offer this flexibility anymore. The images associated with a render
        target will always get cleared when a render pass starts. As a solution,
        an alternative to disabling scene graph issued clears is provided in
        form of the **beforeRenderPassRecording** () signal.

        **See also** **clearBeforeRendering** (), **beforeRendering** (), and
        **beforeRenderPassRecording** ().
        """
        ...

    def createTextureFromNativeObject(
        self,
        type: "QQuickWindow.NativeObjectType",
        nativeObjectPtr: PyQt5.sip.voidptr,
        nativeLayout: int,
        size: QtCore.QSize,
        options: typing.Union[
            "QQuickWindow.CreateTextureOptions", "QQuickWindow.CreateTextureOption"
        ] = ...,
    ) -> "QSGTexture":
        """
        https://doc.qt.io/qt-5/qquickwindow.html#createTextureFromNativeObject

        **QSGTexture *QQuickWindow::createTextureFromNativeObject(QQuickWindow::
        NativeObjectType type , const void * nativeObjectPtr , int nativeLayout
        , const QSize & size , QQuickWindow::CreateTextureOptions options =
        CreateTextureOption()) const**

        Creates a new **QSGTexture**  object from an existing native object.

        The native object is wrapped, but not owned, by the resulting
        **QSGTexture** . The caller of the function is responsible for deleting
        the returned **QSGTexture** , but that will not destroy the underlying
        native object.

        **type** specifies the type of the object. In practice the type is
        **NativeObjectTexture** , indicating that the native object is a texture
        or image of the underlying graphics API. Other types may be introduced
        in the future.

        This function is currently suitable for 2D RGBA textures only.

        Unlike createTextureFromId(), this function supports both direct OpenGL
        usage and the RHI abstracted rendering path.

        **Warning:** This function will return null if the scenegraph has not
        yet been initialized.

        Use **options** to customize the texture attributes. Only the
        **TextureHasAlphaChannel**  and **TextureHasMipmaps**  are taken into
        account here.

        **Warning:** Unlike createTextureFromId(), this function never takes
        ownership of the native object, and the **TextureOwnsGLTexture**  flag
        is ignored.

        **size** specifies the size in pixels.

        **nativeObjectPtr** is a pointer to the native object handle. With
        OpenGL, the native handle is a GLuint value, so **nativeObjectPtr** is
        then a pointer to a GLuint. With Vulkan, the native handle is a VkImage,
        so **nativeObjectPtr** is a pointer to a VkImage. With Direct3D 11 and
        Metal **nativeObjectPtr** is a pointer to a ID3D11Texture2D or
        MTLTexture pointer.

        **Note:** Pay attention to the fact that **nativeObjectPtr** is always a
        pointer to the native texture handle type, even if the native type
        itself is a pointer.

        **nativeLayout** is only used for APIs like Vulkan. When applicable, it
        must specify the current image layout, such as, a VkImageLayout value.

        This function was introduced in Qt 5.14.

        **See also** **sceneGraphInitialized** (), **QSGTexture** , and
        **QSGTexture::nativeTexture** ().
        """
        ...

    def createTextureFromId(
        self,
        id: int,
        size: QtCore.QSize,
        options: typing.Union[
            "QQuickWindow.CreateTextureOptions", "QQuickWindow.CreateTextureOption"
        ] = ...,
    ) -> "QSGTexture":
        ...

    @typing.overload
    def createTextureFromImage(self, image: QtGui.QImage) -> "QSGTexture":
        """
        https://doc.qt.io/qt-5/qquickwindow.html#createTextureFromImage

        **QSGTexture *QQuickWindow::createTextureFromImage(const QImage & image
        , QQuickWindow::CreateTextureOptions options ) const**

        Creates a new **QSGTexture**  from the supplied **image**. If the image
        has an alpha channel, the corresponding texture will have an alpha
        channel.

        The caller of the function is responsible for deleting the returned
        texture. For example whe using the OpenGL adaptation the actual OpenGL
        texture will be deleted when the texture object is deleted.

        When **options** contains **TextureCanUseAtlas** , the engine may put
        the image into a texture atlas. Textures in an atlas need to rely on
        **QSGTexture::normalizedTextureSubRect** () for their geometry and will
        not support **QSGTexture::Repeat** . Other values from
        **CreateTextureOption**  are ignored.

        When **options** contains **TextureIsOpaque** , the engine will create
        an RGB texture which returns false for **QSGTexture::hasAlphaChannel**
        (). Opaque textures will in most cases be faster to render. When this
        flag is not set, the texture will have an alpha channel based on the
        image's format.

        When **options** contains **TextureHasMipmaps** , the engine will create
        a texture which can use mipmap filtering. Mipmapped textures can not be
        in an atlas.

        When using the OpenGL adaptation, the returned texture will be using
        `GL_TEXTURE_2D` as texture target and `GL_RGBA` as internal format.
        Reimplement **QSGTexture**  to create textures with different
        parameters.

        **Warning:** This function will return 0 if the scene graph has not yet
        been initialized.

        **Warning:** The returned texture is not memory managed by the scene
        graph and must be explicitly deleted by the caller on the rendering
        thread. This is achieved by deleting the texture from a **QSGNode**
        destructor or by using **deleteLater** () in the case where the texture
        already has affinity to the rendering thread.

        This function can be called from any thread.

        **See also** **sceneGraphInitialized** () and **QSGTexture** .
        """
        ...

    @typing.overload
    def createTextureFromImage(
        self,
        image: QtGui.QImage,
        options: typing.Union[
            "QQuickWindow.CreateTextureOptions", "QQuickWindow.CreateTextureOption"
        ],
    ) -> "QSGTexture":
        """
        https://doc.qt.io/qt-5/qquickwindow.html#createTextureFromImage-1

        **QSGTexture *QQuickWindow::createTextureFromImage(const QImage & image
        ) const**

        This is an overloaded function.
        """
        ...

    def incubationController(self) -> QtQml.QQmlIncubationController:
        """
        https://doc.qt.io/qt-5/qquickwindow.html#incubationController

        **QQmlIncubationController *QQuickWindow::incubationController() const**

        Returns an incubation controller that splices incubation between frames
        for this window. **QQuickView**  automatically installs this controller
        for you, otherwise you will need to install it yourself using
        **QQmlEngine::setIncubationController** ().

        The controller is owned by the window and will be destroyed when the
        window is deleted.
        """
        ...

    def renderTargetSize(self) -> QtCore.QSize:
        """
        https://doc.qt.io/qt-5/qquickwindow.html#renderTargetSize

        **QSize QQuickWindow::renderTargetSize() const**

        Returns the size of the currently set render target; otherwise returns
        an empty size.
        """
        ...

    def renderTargetId(self) -> int:
        """
        https://doc.qt.io/qt-5/qquickwindow.html#renderTargetId

        **uint QQuickWindow::renderTargetId() const**

        Returns the FBO id of the render target when set; otherwise returns 0.
        """
        ...

    def renderTarget(self) -> QtGui.QOpenGLFramebufferObject:
        """
        https://doc.qt.io/qt-5/qquickwindow.html#renderTarget

        **QOpenGLFramebufferObject *QQuickWindow::renderTarget() const**

        Returns the render target for this window.

        The default is to render to the surface of the window, in which case the
        render target is 0.

        **Note:** This function will return nullptr when not using the OpenGL
        scene graph adaptation.

        **Note:** This function has no effect and returns nullptr when running
        on the RHI graphics abstraction.

        **See also** **setRenderTarget** ().
        """
        ...

    @typing.overload
    def setRenderTarget(self, fbo: QtGui.QOpenGLFramebufferObject) -> None:
        """
        https://doc.qt.io/qt-5/qquickwindow.html#setRenderTarget

        **void QQuickWindow::setRenderTarget(QOpenGLFramebufferObject * fbo )**

        Sets the render target for this window to be **fbo**.

        The specified fbo must be created in the context of the window or one
        that shares with it.

        **Note:** This function only has an effect when using the default OpenGL
        scene graph adaptation.

        **Note:** This function has no effect when running on the RHI graphics
        abstraction.

        **Warning:** This function can only be called from the thread doing the
        rendering.

        **See also** **renderTarget** ().
        """
        ...

    @typing.overload
    def setRenderTarget(self, fboId: int, size: QtCore.QSize) -> None:
        """
        https://doc.qt.io/qt-5/qquickwindow.html#setRenderTarget-1

        **void QQuickWindow::setRenderTarget(uint fboId , const QSize & size )**

        This is an overloaded function.

        Sets the render target for this window to be an FBO with **fboId** and
        **size**.

        The specified FBO must be created in the context of the window or one
        that shares with it.

        **Note:** **fboId** can also be set to 0. In this case rendering will
        target the default framebuffer of whichever surface is current when the
        scenegraph renders. **size** must still be valid, specifying the
        dimensions of the surface.

        **Note:** This function only has an effect when using the default OpenGL
        scene graph adaptation.

        **Warning:** This function can only be called from the thread doing the
        rendering.
        """
        ...

    def grabWindow(self) -> QtGui.QImage:
        """
        https://doc.qt.io/qt-5/qquickwindow.html#grabWindow

        **QImage QQuickWindow::grabWindow()**

        Grabs the contents of the window and returns it as an image.

        It is possible to call the grabWindow() function when the window is not
        visible. This requires that the window is **created**  and has a valid
        size and that no other **QQuickWindow**  instances are rendering in the
        same process.

        **Warning:** Calling this function will cause performance problems.

        **Warning:** This function can only be called from the GUI thread.
        """
        ...

    def sendEvent(self, a0: QQuickItem, a1: QtCore.QEvent) -> bool:
        ...

    def mouseGrabberItem(self) -> QQuickItem:
        """
        https://doc.qt.io/qt-5/qquickwindow.html#mouseGrabberItem

        **QQuickItem *QQuickWindow::mouseGrabberItem() const**

        Returns the item which currently has the mouse grab.
        """
        ...

    def focusObject(self) -> QtCore.QObject:
        ...

    def activeFocusItem(self) -> QQuickItem:
        """
        https://doc.qt.io/qt-5/qquickwindow.html#activeFocusItem-prop

        **activeFocusItem : QQuickItem* const**

        This property holds the item which currently has active focus or `null`
        if there is no item with active focus.

        **Access functions:**

        QQuickItem * **activeFocusItem** () const

        **Notifier signal:**

        void **activeFocusItemChanged** ()
        """
        ...

    def contentItem(self) -> QQuickItem:
        """
        https://doc.qt.io/qt-5/qquickwindow.html#contentItem-prop

        **contentItem : QQuickItem* const**

        This property holds the invisible root item of the scene.

        A **QQuickWindow**  always has a single invisible root item containing
        all of its content. To add items to this window, reparent the items to
        the contentItem or to an existing item in the scene.

        **Access functions:**

        QQuickItem * **contentItem** () const

        **Member Function Documentation**
        """
        ...

    @property
    def activeFocusItemChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        ...

    @property
    def afterAnimating(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qquickwindow.html#afterAnimating

        **[signal] void QQuickWindow::afterAnimating()**

        This signal is emitted on the GUI thread before requesting the render
        thread to perform the synchronization of the scene graph.

        Unlike the other similar signals, this one is emitted on the GUI thread
        instead of the render thread. It can be used to synchronize external
        animation systems with the QML content. At the same time this means that
        this signal is not suitable for triggering graphics operations.

        This function was introduced in Qt 5.3.
        """
        ...

    @property
    def afterRenderPassRecording(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qquickwindow.html#afterRenderPassRecording

        **[signal] void QQuickWindow::afterRenderPassRecording()**

        This signal is emitted after the scenegraph has recorded the commands
        for its main render pass, but the pass is not yet finalized on the
        command buffer.

        This signal is applicable when using the RHI graphics abstraction with
        the scenegraph. It is emitted earlier than **afterRendering** () and it
        guarantees that not just the frame, but also the recording of the
        scenegraph's main render pass is still active. This allows inserting
        commands without having to generate an entire, separate render pass
        (which would typically clear the attached images). The native graphics
        objects can be queried via **QSGRendererInterface** .

        When not running with the RHI (and using OpenGL directly), the signal is
        emitted after the renderer has finished its rendering, but before
        **afterRendering** (). This makes it possible to create applications
        that function identically both with and without the RHI.

        **Note:** Resource updates (uploads, copies) typically cannot be
        enqueued from within a render pass. Therefore, more complex user
        rendering will need to connect to both **beforeRendering** () and this
        signal.

        **Warning:** This signal is emitted from the scene graph rendering
        thread. If your slot function needs to finish before execution
        continues, you must make sure that the connection is direct (see
        **Qt::ConnectionType** ).

        This function was introduced in Qt 5.14.
        """
        ...

    @property
    def afterRendering(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qquickwindow.html#afterRendering

        **[signal] void QQuickWindow::afterRendering()**

        This signal is emitted after the scene has completed rendering, before
        swapbuffers is called.

        This signal can be used to paint using raw OpenGL on top of QML content,
        or to do screen scraping of the current frame buffer.

        The OpenGL context used for rendering the scene graph will be bound at
        this point.

        When using the RHI, the signal is emitted after scene graph has added
        its commands to the command buffer, which is not yet submitted to the
        graphics queue. If desired, the slot function connected to this signal
        can query native resources, like the command buffer, before via
        **QSGRendererInterface** . Note however that the render pass (or passes)
        are already recorded at this point and it is not possible to add more
        commands within the scenegraph's pass. Instead, use
        **afterRenderPassRecording** () for that. This signal has therefore
        limited use and is rarely needed in an RHI-based setup. Rather, it is
        the combination of **beforeRendering** () +
        **beforeRenderPassRecording** () or **beforeRendering** () +
        **afterRenderPassRecording** () that is typically used to achieve under-
        or overlaying of the custom rendering.

        **Warning:** This signal is emitted from the scene graph rendering
        thread. If your slot function needs to finish before execution
        continues, you must make sure that the connection is direct (see
        **Qt::ConnectionType** ).

        **Warning:** Make very sure that a signal handler for afterRendering()
        leaves the OpenGL context in the same state as it was when the signal
        handler was entered. Failing to do so can result in the scene not
        rendering properly.

        **See also** **resetOpenGLState** ().
        """
        ...

    @property
    def afterSynchronizing(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qquickwindow.html#afterSynchronizing

        **[signal] void QQuickWindow::afterSynchronizing()**

        This signal is emitted after the scene graph is synchronized with the
        QML state.

        This signal can be used to do preparation required after calls to
        **QQuickItem::updatePaintNode** (), while the GUI thread is still
        locked.

        The graphics context used for rendering the scene graph will be bound at
        this point.

        **Warning:** This signal is emitted from the scene graph rendering
        thread. If your slot function needs to finish before execution
        continues, you must make sure that the connection is direct (see
        **Qt::ConnectionType** ).

        **Warning:** When using the OpenGL adaptation, make sure that a signal
        handler for afterSynchronizing leaves the OpenGL context in the same
        state as it was when the signal handler was entered. Failing to do so
        can result in the scene not rendering properly.

        This function was introduced in Qt 5.3.

        **See also** **resetOpenGLState** ().
        """
        ...

    @property
    def beforeRenderPassRecording(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qquickwindow.html#beforeRenderPassRecording

        **[signal] void QQuickWindow::beforeRenderPassRecording()**

        This signal is emitted before the scenegraph starts recording commands
        for the main render pass. (Layers have their own passes and are fully
        recorded by the time this signal is emitted.) The render pass is already
        active on the command buffer when the signal is emitted.

        This signal is applicable when using the RHI graphics abstraction with
        the scenegraph. It is emitted later than **beforeRendering** () and it
        guarantees that not just the frame, but also the recording of the
        scenegraph's main render pass is active. This allows inserting commands
        without having to generate an entire, separate render pass (which would
        typically clear the attached images). The native graphics objects can be
        queried via **QSGRendererInterface** .

        When not running with the RHI (and using OpenGL directly), the signal is
        emitted after the renderer has cleared the render target. This makes it
        possible to create applications that function identically both with and
        without the RHI.

        **Note:** Resource updates (uploads, copies) typically cannot be
        enqueued from within a render pass. Therefore, more complex user
        rendering will need to connect to both **beforeRendering** () and this
        signal.

        **Warning:** This signal is emitted from the scene graph rendering
        thread. If your slot function needs to finish before execution
        continues, you must make sure that the connection is direct (see
        **Qt::ConnectionType** ).

        This function was introduced in Qt 5.14.
        """
        ...

    @property
    def beforeRendering(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qquickwindow.html#beforeRendering

        **[signal] void QQuickWindow::beforeRendering()**

        This signal is emitted before the scene starts rendering.

        Combined with the modes for clearing the background, this option can be
        used to paint using raw OpenGL under QML content.

        The OpenGL context used for rendering the scene graph will be bound at
        this point.

        When using the RHI, the signal is emitted after the preparations for the
        frame have been done, meaning there is a command buffer in recording
        mode, where applicable. If desired, the slot function connected to this
        signal can query native resources like the command before via
        **QSGRendererInterface** . Note however that the recording of the main
        render pass is not yet started at this point and it is not possible to
        add commands within that pass. Starting a pass means clearing the color,
        depth, and stencil buffers so it is not possible to achieve an underlay
        type of rendering by just connecting to this signal. Rather, connect to
        **beforeRenderPassRecording** (). However, connecting to this signal is
        still important if the recording of copy type of commands is desired
        since those cannot be enqueued within a render pass.

        **Warning:** This signal is emitted from the scene graph rendering
        thread. If your slot function needs to finish before execution
        continues, you must make sure that the connection is direct (see
        **Qt::ConnectionType** ).

        **Warning:** Make very sure that a signal handler for beforeRendering
        leaves the OpenGL context in the same state as it was when the signal
        handler was entered. Failing to do so can result in the scene not
        rendering properly.

        **See also** **resetOpenGLState** ().
        """
        ...

    @property
    def beforeSynchronizing(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qquickwindow.html#beforeSynchronizing

        **[signal] void QQuickWindow::beforeSynchronizing()**

        This signal is emitted before the scene graph is synchronized with the
        QML state.

        This signal can be used to do any preparation required before calls to
        **QQuickItem::updatePaintNode** ().

        The OpenGL context used for rendering the scene graph will be bound at
        this point.

        **Warning:** This signal is emitted from the scene graph rendering
        thread. If your slot function needs to finish before execution
        continues, you must make sure that the connection is direct (see
        **Qt::ConnectionType** ).

        **Warning:** Make very sure that a signal handler for
        beforeSynchronizing leaves the GL context in the same state as it was
        when the signal handler was entered. Failing to do so can result in the
        scene not rendering properly.

        **See also** **resetOpenGLState** ().
        """
        ...

    @property
    def closing(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qquickwindow.html#closing

        **[signal] void QQuickWindow::closing(QQuickCloseEvent * close )**

        This signal is emitted when the window receives the event **close** from
        the windowing system.

        On macOs, Qt will create a menu item `Quit` if there is no menu item
        whose text is "quit" or "exit". This menu item calls the
        `QCoreApplication::quit` signal, not the `QQuickWindow::closing()`
        signal.

        This function was introduced in Qt 5.1.

        **See also** **QMenuBar as a Global Menu Bar** .
        """
        ...

    @property
    def colorChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        ...

    @property
    def frameSwapped(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qquickwindow.html#frameSwapped

        **[signal] void QQuickWindow::frameSwapped()**

        This signal is emitted when a frame has been queued for presenting. With
        vertical synchronization enabled the signal is emitted at most once per
        vsync interval in a continuously animating scene.

        This signal will be emitted from the scene graph rendering thread.
        """
        ...

    @property
    def openglContextCreated(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qquickwindow.html#openglContextCreated

        **[signal] void QQuickWindow::openglContextCreated(QOpenGLContext *
        context )**

        This signal is emitted on the GUI thread when the OpenGL **context** for
        this window is created, before it is made current.

        Some implementations will share the same OpenGL context between multiple
        **QQuickWindow**  instances. The openglContextCreated() signal will in
        this case only be emitted for the first window, when the OpenGL context
        is actually created.

        **QQuickWindow::openglContext** () will still return 0 for this window
        until after the **QQuickWindow::sceneGraphInitialized** () has been
        emitted.

        **Note:** This signal will only be emmited when using the default OpenGL
        scene graph adaptation.

        This function was introduced in Qt 5.3.
        """
        ...

    @property
    def sceneGraphAboutToStop(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qquickwindow.html#sceneGraphAboutToStop

        **[signal] void QQuickWindow::sceneGraphAboutToStop()**

        This signal is emitted on the render thread when the scene graph is
        about to stop rendering. This happens usually because the window has
        been hidden.

        Applications may use this signal to release resources, but should be
        prepared to reinstantiated them again fast. The scene graph and the
        graphics context are not released at this time.

        **Warning:** This signal is emitted from the scene graph rendering
        thread. If your slot function needs to finish before execution
        continues, you must make sure that the connection is direct (see
        **Qt::ConnectionType** ).

        **Warning:** Make very sure that a signal handler for
        sceneGraphAboutToStop() leaves the graphics context in the same state as
        it was when the signal handler was entered. Failing to do so can result
        in the scene not rendering properly.

        This function was introduced in Qt 5.3.

        **See also** **sceneGraphInvalidated** () and **resetOpenGLState** ().
        """
        ...

    @property
    def sceneGraphError(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qquickwindow.html#sceneGraphError

        **[signal] void
        QQuickWindow::sceneGraphError(QQuickWindow::SceneGraphError error ,
        const QString & message )**

        This signal is emitted when an **error** occurred during scene graph
        initialization.

        Applications should connect to this signal if they wish to handle
        errors, like graphics context creation failures, in a custom way. When
        no slot is connected to the signal, the behavior will be different:
        Quick will print the **message** , or show a message box, and terminate
        the application.

        This signal will be emitted from the GUI thread.

        This function was introduced in Qt 5.3.
        """
        ...

    @property
    def sceneGraphInitialized(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qquickwindow.html#sceneGraphInitialized

        **[signal] void QQuickWindow::sceneGraphInitialized()**

        This signal is emitted when the scene graph has been initialized.

        This signal will be emitted from the scene graph rendering thread.
        """
        ...

    @property
    def sceneGraphInvalidated(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qquickwindow.html#sceneGraphInvalidated

        **[signal] void QQuickWindow::sceneGraphInvalidated()**

        This signal is emitted when the scene graph has been invalidated.

        This signal implies that the graphics rendering context used has been
        invalidated and all user resources tied to that context should be
        released.

        In the case of the default OpenGL adaptation the context of this window
        will be bound when this function is called. The only exception is if the
        native OpenGL has been destroyed outside Qt's control, for instance
        through EGL_CONTEXT_LOST.

        This signal will be emitted from the scene graph rendering thread.
        """
        ...
