"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
import PyQt5.sip
from PyQt5 import QtGui
from PyQt5 import QtCore
from PyQt5.QtQuick import *


class QQuickRenderControl(QtCore.QObject):
    """
    https://doc.qt.io/qt-5/qquickrendercontrol.html

    **Detailed Description**

    **QQuickWindow**  and **QQuickView**  and their associated internal render
    loops render the Qt Quick scene onto a native window. In some cases, for
    example when integrating with 3rd party OpenGL renderers, it might be
    beneficial to get the scene into a texture that can then be used in
    arbitrary ways by the external rendering engine. QQuickRenderControl makes
    this possible in a hardware accelerated manner, unlike the performance-wise
    limited alternative of using **QQuickWindow::grabWindow** ()

    When using a QQuickRenderControl, the **QQuickWindow**  does not have to be
    shown or even created at all. This means there will not be an underlying
    native window for it. Instead, the **QQuickWindow**  instance is associated
    with the render control, using the overload of the **QQuickWindow**
    constructor, and an OpenGL framebuffer object by calling
    **QQuickWindow::setRenderTarget** ().

    Management of the context and framebuffer object is up to the application.
    The context that will be used by Qt Quick must be created before calling
    **initialize** (). The creation of the framebuffer object can be deferred,
    see below. Qt 5.4 introduces the ability for **QOpenGLContext**  to adopt
    existing native contexts. Together with QQuickRenderControl this makes it
    possible to create a **QOpenGLContext**  that shares with an external
    rendering engine's existing context. This new **QOpenGLContext**  can then
    be used to render the Qt Quick scene into a texture that is accessible by
    the other engine's context too.

    Loading and instantiation of the QML components happen by using a
    **QQmlEngine** . Once the root object is created, it will need to be
    parented to the **QQuickWindow** 's contentItem().

    Applications will usually have to connect to 4 important signals:

    * **QQuickWindow::sceneGraphInitialized** () Emitted at some point after
    calling **QQuickRenderControl::initialize** (). Upon this signal, the
    application is expected to create its framebuffer object and associate it
    with the **QQuickWindow** .
      * **QQuickWindow::sceneGraphInvalidated** ()
    When the scenegraph resources are released, the framebuffer object can be
    destroyed too.
      * **QQuickRenderControl::renderRequested** () Indicates
    that the scene has to be rendered by calling **render** (). After making the
    context current, applications are expected to call **render** ().
      *
    **QQuickRenderControl::sceneChanged** () Indicates that the scene has
    changed meaning that, before rendering, polishing and synchronizing is also
    necessary.

    To send events, for example mouse or keyboard events, to the scene, use
    **QCoreApplication::sendEvent** () with the **QQuickWindow**  instance as
    the receiver.

    **Note:** In general QQuickRenderControl is supported in combination with
    all Qt Quick backends. However, some functionality, in particular **grab**
    (), may not be available in all cases.
    """

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qquickrendercontrol.html#QQuickRenderControl

        **QQuickRenderControl::QQuickRenderControl(QObject * parent = nullptr)**

        Constructs a QQuickRenderControl object, with parent object **parent**.
        """
        ...

    def prepareThread(self, targetThread: QtCore.QThread) -> None:
        """
        https://doc.qt.io/qt-5/qquickrendercontrol.html#prepareThread

        **void QQuickRenderControl::prepareThread(QThread * targetThread )**

        Prepares rendering the Qt Quick scene outside the GUI thread.

        **targetThread** specifies the thread on which synchronization and
        rendering will happen. There is no need to call this function in a
        single threaded scenario.
        """
        ...

    def renderWindow(self, offset: QtCore.QPoint) -> QtGui.QWindow:
        """
        https://doc.qt.io/qt-5/qquickrendercontrol.html#renderWindow

        **[virtual] QWindow *QQuickRenderControl::renderWindow(QPoint * offset
        )**

        Reimplemented in subclasses to return the real window this render
        control is rendering into.

        If **offset** in non-null, it is set to the offset of the control inside
        the window.

        **Note:** While not mandatory, reimplementing this function becomes
        essential for supporting multiple screens with different device pixel
        ratios and properly positioning popup windows opened from QML. Therefore
        providing it in subclasses is highly recommended.
        """
        ...

    @staticmethod
    def renderWindowFor(
        win: "QQuickWindow", offset: typing.Optional[QtCore.QPoint] = ...
    ) -> QtGui.QWindow:
        """
        https://doc.qt.io/qt-5/qquickrendercontrol.html#renderWindowFor

        **[static] QWindow *QQuickRenderControl::renderWindowFor(QQuickWindow *
        win , QPoint * offset = nullptr)**

        Returns the real window that **win** is being rendered to, if any.

        If **offset** in non-null, it is set to the offset of the rendering
        inside its window.
        """
        ...

    def grab(self) -> QtGui.QImage:
        """
        https://doc.qt.io/qt-5/qquickrendercontrol.html#grab

        **QImage QQuickRenderControl::grab()**

        Grabs the contents of the scene and returns it as an image.

        **Note:** Requires the context to be current.
        """
        ...

    def sync(self) -> bool:
        """
        https://doc.qt.io/qt-5/qquickrendercontrol.html#sync

        **bool QQuickRenderControl::sync()**

        This function is used to synchronize the QML scene with the rendering
        scene graph.

        If a dedicated render thread is used, the GUI thread should be blocked
        for the duration of this call.

        Returns **true** if the synchronization changed the scene graph.
        """
        ...

    def render(self) -> None:
        """
        https://doc.qt.io/qt-5/qquickrendercontrol.html#render

        **void QQuickRenderControl::render()**

        Renders the scenegraph using the current context.
        """
        ...

    def polishItems(self) -> None:
        """
        https://doc.qt.io/qt-5/qquickrendercontrol.html#polishItems

        **void QQuickRenderControl::polishItems()**

        This function should be called as late as possible before **sync** ().
        In a threaded scenario, rendering can happen in parallel with this
        function.
        """
        ...

    def invalidate(self) -> None:
        """
        https://doc.qt.io/qt-5/qquickrendercontrol.html#invalidate

        **void QQuickRenderControl::invalidate()**

        Stop rendering and release resources. Requires a current context.

        This is the equivalent of the cleanup operations that happen with a real
        **QQuickWindow**  when the window becomes hidden.

        This function is called from the destructor. Therefore there will
        typically be no need to call it directly. Pay attention however to the
        fact that this requires the context, that was passed to **initialize**
        (), to be the current one at the time of destroying the
        **QQuickRenderControl**  instance.

        Once invalidate() has been called, it is possible to reuse the
        **QQuickRenderControl**  instance by calling **initialize** () again.

        **Note:** This function does not take
        QQuickWindow::persistentSceneGraph() or
        QQuickWindow::persistentOpenGLContext() into account. This means that
        context-specific resources are always released.
        """
        ...

    def initialize(self, gl: QtGui.QOpenGLContext) -> None:
        """
        https://doc.qt.io/qt-5/qquickrendercontrol.html#initialize

        **void QQuickRenderControl::initialize(QOpenGLContext * gl )**

        Initializes the scene graph resources. The context **gl** has to be the
        current OpenGL context or null if it is not relevant because a Qt Quick
        backend other than OpenGL is in use.

        **Note:** Qt Quick does not take ownership of the context. It is up to
        the application to destroy it after a call to **invalidate** () or after
        the **QQuickRenderControl**  instance is destroyed.
        """
        ...

    @property
    def renderRequested(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qquickrendercontrol.html#renderRequested

        **[signal] void QQuickRenderControl::renderRequested()**

        This signal is emitted when the scene graph needs to be rendered. It is
        not necessary to call **sync** ().

        **Note:** Avoid triggering rendering directly when this signal is
        emitted. Instead, prefer deferring it by using a timer for example. This
        will lead to better performance.
        """
        ...

    @property
    def sceneChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qquickrendercontrol.html#sceneChanged

        **[signal] void QQuickRenderControl::sceneChanged()**

        This signal is emitted when the scene graph is updated, meaning that
        **polishItems** () and **sync** () needs to be called. If **sync** ()
        returns true, then **render** () needs to be called.

        **Note:** Avoid triggering polishing, synchronization and rendering
        directly when this signal is emitted. Instead, prefer deferring it by
        using a timer for example. This will lead to better performance.
        """
        ...
