"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
from PyQt5 import QtCore
from PyQt5.QtQml import *


class QQmlEngineExtensionPlugin(QtCore.QObject):
    """
    https://doc.qt.io/qt-5/qqmlengineextensionplugin.html

    **Detailed Description**

    **QQmlEngineExtensionPlugin**  is a plugin interface that makes it possible
    to create QML extensions that can be loaded dynamically into QML
    applications. These extensions allow custom QML types to be made available
    to the QML engine.

    To write a QML extension plugin:

    1. Subclass **QQmlEngineExtensionPlugin**  and use the **Q_PLUGIN_METADATA**
    () macro to register the plugin with the Qt meta object system.
      2. Use the
    **QML_ELEMENT**  and **QML_NAMED_ELEMENT** () macros to declare QML types.
    3. Write a project file for the plugin. Add:
        * `CONFIG += qmltypes` to
    instruct the build system to generate QML types.
        * `QML_IMPORT_NAME =
    <my.import.name>` to specify the import name.
        *
    `QML_IMPORT_MAJOR_VERSION = <version>` to specify the import major version.
    4. Create a **qmldir file**  to describe the plugin

    QML extension plugins are for either application-specific or library-like
    plugins. Library plugins should limit themselves to registering types, as
    any manipulation of the engine's root context may cause conflicts or other
    issues in the library user's code.

    The linker might erroneously remove the generated type registration function
    as an optimization. You can prevent that by declaring a synthetic volatile
    pointer to the function somewhere in your code. If your module is called
    "my.module", you would add the forward declaration in global scope:

    void qml_register_types_my_module();
        \\code

        Then add the
    following snippet of code in the implementation of any function
        that's
    part of the same binary as the registration:

        \\code
        volatile
    auto registration = &qml_register_types_my_module;
    Q_UNUSED(registration);
        \\code

        \\section1 TimeExample QML
    extension plugin

        Suppose there is a new \\c TimeModel C++ class that
    should be made available
        as a new QML type. It provides the current time
    through \\c hour and \\c minute
        properties. It declares a QML type called
    \\c Time via \\l QML_NAMED_ELEMENT().

        \\snippet
    qmlextensionplugins/timemodel.h 0
        \\dots

        To make this type
    available, we create a plugin class named \\c QExampleQmlPlugin
        which is
    a subclass of \\l QQmlEngineExtensionPlugin. It uses the
    Q_PLUGIN_METADATA() macro in the class definition to register the plugin
    with the
        Qt meta object system using a unique identifier for the plugin.
    \\snippet qmlextensionplugins/plugin.cpp plugin

        \\section1 Project
    settings for the plugin

        Additionally, the project file (\\c .pro)
    defines the project as a plugin library,
        specifies it should be built
    into the \\c imports/TimeExample directory, and registers
        the plugin
    target name and various other details:

        \\code
        TEMPLATE = lib
    CONFIG += qt plugin qmltypes
        QT += qml

        QML_IMPORT_NAME =
    TimeExample
        QML_IMPORT_MAJOR_VERSION = 1

        DESTDIR =
    imports/$$QML_IMPORT_NAME
        TARGET  = qmlqtimeexampleplugin
    SOURCES += qexampleqmlplugin.cpp

    This registers the `TimeModel` class with the import `TimeExample 1.0`, as a
    QML type called `Time`. The **Defining QML Types from C++**  article has
    more information about registering C++ types for usage in QML.

    **Plugin definition in the qmldir**

    Finally, a **qmldir file**  is required in the `imports/TimeExample`
    directory to describe the plugin and the types that it exports. The plugin
    includes a `Clock.qml` file along with the `qmlqtimeexampleplugin` that is
    built by the project (as shown above in the `.pro` file) so both of these
    need to be specified in the `qmldir` file:

    module TimeExample
        Clock 1.0 Clock.qml
        plugin qmlqtimeexampleplugin

    To make things easier for this example, the TimeExample source directory is
    in `imports/TimeExample`, and we build **in-source** . However, the
    structure of the source directory is not so important, as the `qmldir` file
    can specify paths to installed QML files.

    What is important is the name of the directory that the qmldir is installed
    into. When the user imports our module, the QML engine uses the **module
    identifier**  (`TimeExample`) to find the plugin, and so the directory in
    which it is installed must match the module identifier.

    Once the project is built and installed, the new `Time` component is
    accessible by any QML component that imports the `TimeExample` module

    import TimeExample 1.0 // import types from the plugin

        Clock { //
    this class is defined in QML (imports/TimeExample/Clock.qml)
    Time { // this class is defined in C++ (plugin.cpp)
                id: time
    }

            hours: time.hour
            minutes: time.minute

        }

    The full source code is available in the **plugins example** .

    The **Writing QML Extensions with C++**  tutorial also contains a chapter on
    creating QML plugins.

    **See also** **QQmlEngine::importPlugin** () and **How to Create Qt
    Plugins** .
    """

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qqmlengineextensionplugin.html#QQmlEngineExtensio
        nPlugin-2

        **QQmlEngineExtensionPlugin::QQmlEngineExtensionPlugin(QObject * parent
        = nullptr)**

        Constructs a QML extension plugin with the given **parent**.

        Note that this constructor is invoked automatically by the
        **Q_PLUGIN_METADATA** () macro, so there is no need for calling it
        explicitly.
        """
        ...

    def initializeEngine(self, engine: QQmlEngine, uri: str) -> None:
        """
        https://doc.qt.io/qt-5/qqmlengineextensionplugin.html#initializeEngine

        **[override virtual] void
        QQmlEngineExtensionPlugin::initializeEngine(QQmlEngine * engine , const
        char * uri )**

        Initializes the extension from the **uri** using the **engine**. Here an
        application plugin might, for example, expose some data or objects to
        QML, as context properties on the engine's root context.
        """
        ...
