"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
from PyQt5 import QtGui
from PyQt5 import QtCore
from PyQt5.QtPrintSupport import *
from PyQt5 import sip


class QPrinterInfo(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qprinterinfo.html

    **Detailed Description**

    Use the static functions to generate a list of QPrinterInfo objects. Each
    QPrinterInfo object in the list represents a single printer and can be
    queried for name, supported paper sizes, and whether or not it is the
    default printer.
    """

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qprinterinfo.html#QPrinterInfo

        **QPrinterInfo::QPrinterInfo()**

        Constructs an empty QPrinterInfo object.

        **See also** **isNull** ().
        """
        ...

    @typing.overload
    def __init__(self, src: "QPrinterInfo") -> None:
        """
        https://doc.qt.io/qt-5/qprinterinfo.html#QPrinterInfo-1

        **QPrinterInfo::QPrinterInfo(const QPrinterInfo & other )**

        Constructs a copy of **other**.
        """
        ...

    @typing.overload
    def __init__(self, printer: QPrinter) -> None:
        """
        https://doc.qt.io/qt-5/qprinterinfo.html#QPrinterInfo-2

        **QPrinterInfo::QPrinterInfo(const QPrinter & printer )**

        Constructs a QPrinterInfo object from **printer**.
        """
        ...

    def supportedColorModes(self) -> typing.List[QPrinter.ColorMode]:
        """
        https://doc.qt.io/qt-5/qprinterinfo.html#supportedColorModes

        **QList<QPrinter::ColorMode> QPrinterInfo::supportedColorModes() const**

        Returns the supported color modes of this printer.

        This function was introduced in Qt 5.13.
        """
        ...

    def defaultColorMode(self) -> QPrinter.ColorMode:
        """
        https://doc.qt.io/qt-5/qprinterinfo.html#defaultColorMode

        **QPrinter::ColorMode QPrinterInfo::defaultColorMode() const**

        Returns the default color mode of this printer.

        This function was introduced in Qt 5.13.
        """
        ...

    def supportedDuplexModes(self) -> typing.List[QPrinter.DuplexMode]:
        """
        https://doc.qt.io/qt-5/qprinterinfo.html#supportedDuplexModes

        **QList<QPrinter::DuplexMode> QPrinterInfo::supportedDuplexModes()
        const**

        Returns a list of duplex modes supported by this printer.

        This function was introduced in Qt 5.4.
        """
        ...

    def defaultDuplexMode(self) -> QPrinter.DuplexMode:
        """
        https://doc.qt.io/qt-5/qprinterinfo.html#defaultDuplexMode

        **QPrinter::DuplexMode QPrinterInfo::defaultDuplexMode() const**

        Returns the default duplex mode of this printer.

        This function was introduced in Qt 5.4.
        """
        ...

    @staticmethod
    def defaultPrinterName() -> str:
        """
        https://doc.qt.io/qt-5/qprinterinfo.html#defaultPrinterName

        **[static] QString QPrinterInfo::defaultPrinterName()**

        Returns the current default printer name.

        This function was introduced in Qt 5.3.
        """
        ...

    @staticmethod
    def availablePrinterNames() -> typing.List[str]:
        """
        https://doc.qt.io/qt-5/qprinterinfo.html#availablePrinterNames

        **[static] QStringList QPrinterInfo::availablePrinterNames()**

        Returns a list of all the available Printer Names on this system.

        It is recommended to use this instead of **availablePrinters** () as it
        will be faster on most systems.

        Note that the list may become outdated if changes are made on the local
        system or remote print server. Only instantiate required
        **QPrinterInfo**  instances when needed, and always check for validity
        before calling.

        This function was introduced in Qt 5.3.
        """
        ...

    def supportedResolutions(self) -> typing.List[int]:
        """
        https://doc.qt.io/qt-5/qprinterinfo.html#supportedResolutions

        **QList<int> QPrinterInfo::supportedResolutions() const**

        Returns a list of resolutions supported by this printer.

        This function was introduced in Qt 5.3.
        """
        ...

    def maximumPhysicalPageSize(self) -> QtGui.QPageSize:
        """
        https://doc.qt.io/qt-5/qprinterinfo.html#maximumPhysicalPageSize

        **QPageSize QPrinterInfo::maximumPhysicalPageSize() const**

        Returns the maximum physical page size supported by this printer.

        This function was introduced in Qt 5.3.

        **See also** **minimumPhysicalPageSize** ().
        """
        ...

    def minimumPhysicalPageSize(self) -> QtGui.QPageSize:
        """
        https://doc.qt.io/qt-5/qprinterinfo.html#minimumPhysicalPageSize

        **QPageSize QPrinterInfo::minimumPhysicalPageSize() const**

        Returns the minimum physical page size supported by this printer.

        This function was introduced in Qt 5.3.

        **See also** **maximumPhysicalPageSize** ().
        """
        ...

    def supportsCustomPageSizes(self) -> bool:
        """
        https://doc.qt.io/qt-5/qprinterinfo.html#supportsCustomPageSizes

        **bool QPrinterInfo::supportsCustomPageSizes() const**

        Returns whether this printer supports custom page sizes.

        This function was introduced in Qt 5.3.
        """
        ...

    def defaultPageSize(self) -> QtGui.QPageSize:
        """
        https://doc.qt.io/qt-5/qprinterinfo.html#defaultPageSize

        **QPageSize QPrinterInfo::defaultPageSize() const**

        Returns the current default Page Size for this printer.

        This function was introduced in Qt 5.3.
        """
        ...

    def supportedPageSizes(self) -> typing.List[QtGui.QPageSize]:
        """
        https://doc.qt.io/qt-5/qprinterinfo.html#supportedPageSizes

        **QList<QPageSize> QPrinterInfo::supportedPageSizes() const**

        Returns a list of Page Sizes supported by this printer.

        This function was introduced in Qt 5.3.
        """
        ...

    def state(self) -> QPrinter.PrinterState:
        """
        https://doc.qt.io/qt-5/qprinterinfo.html#state

        **QPrinter::PrinterState QPrinterInfo::state() const**

        Returns the current state of this printer.

        This state may not always be accurate, depending on the platform,
        printer driver, or printer itself.

        This function was introduced in Qt 5.3.
        """
        ...

    def isRemote(self) -> bool:
        """
        https://doc.qt.io/qt-5/qprinterinfo.html#isRemote

        **bool QPrinterInfo::isRemote() const**

        Returns whether this printer is a remote network printer.

        This function was introduced in Qt 5.3.
        """
        ...

    @staticmethod
    def printerInfo(printerName: str) -> "QPrinterInfo":
        """
        https://doc.qt.io/qt-5/qprinterinfo.html#printerInfo

        **[static] QPrinterInfo QPrinterInfo::printerInfo(const QString &
        printerName )**

        Returns the printer **printerName**.

        The return value should be checked using **isNull** () before being
        used, in case the named printer does not exist.

        This function was introduced in Qt 5.0.

        **See also** **isNull** ().
        """
        ...

    def makeAndModel(self) -> str:
        """
        https://doc.qt.io/qt-5/qprinterinfo.html#makeAndModel

        **QString QPrinterInfo::makeAndModel() const**

        Returns the human-readable make and model of the printer.

        This function was introduced in Qt 5.0.
        """
        ...

    def location(self) -> str:
        """
        https://doc.qt.io/qt-5/qprinterinfo.html#location

        **QString QPrinterInfo::location() const**

        Returns the human-readable location of the printer.

        This function was introduced in Qt 5.0.
        """
        ...

    def description(self) -> str:
        """
        https://doc.qt.io/qt-5/qprinterinfo.html#description

        **QString QPrinterInfo::description() const**

        Returns the human-readable description of the printer.

        This function was introduced in Qt 5.0.

        **See also** **QPrinterInfo::printerName** ().
        """
        ...

    @staticmethod
    def defaultPrinter() -> "QPrinterInfo":
        """
        https://doc.qt.io/qt-5/qprinterinfo.html#defaultPrinter

        **[static] QPrinterInfo QPrinterInfo::defaultPrinter()**

        Returns the default printer on the system.

        The return value should be checked using **isNull** () before being
        used, in case there is no default printer.

        On some systems it is possible for there to be available printers but
        none of them set to be the default printer.

        **See also** **isNull** (), **isDefault** (), and **availablePrinters**
        ().
        """
        ...

    @staticmethod
    def availablePrinters() -> typing.List["QPrinterInfo"]:
        """
        https://doc.qt.io/qt-5/qprinterinfo.html#availablePrinters

        **[static] QList<QPrinterInfo> QPrinterInfo::availablePrinters()**

        Returns a list of **QPrinterInfo**  objects for all the available
        printers on this system.

        It is NOT recommended to use this as creating each printer instance may
        take a long time, especially if there are remote networked printers, and
        retained instances may become outdated if changes are made on the local
        system or remote print server. Use **availablePrinterNames** () instead
        and only instantiate printer instances as you need them.
        """
        ...

    def supportedSizesWithNames(self) -> typing.List[typing.Tuple[str, QtCore.QSizeF]]:
        ...

    def supportedPaperSizes(self) -> typing.List[QtGui.QPagedPaintDevice.PageSize]:
        ...

    def isDefault(self) -> bool:
        """
        https://doc.qt.io/qt-5/qprinterinfo.html#isDefault

        **bool QPrinterInfo::isDefault() const**

        Returns whether this printer is currently the default printer.
        """
        ...

    def isNull(self) -> bool:
        """
        https://doc.qt.io/qt-5/qprinterinfo.html#isNull

        **bool QPrinterInfo::isNull() const**

        Returns whether this **QPrinterInfo**  object holds a printer
        definition.

        An empty **QPrinterInfo**  object could result for example from calling
        **defaultPrinter** () when there are no printers on the system.
        """
        ...

    def printerName(self) -> str:
        """
        https://doc.qt.io/qt-5/qprinterinfo.html#printerName

        **QString QPrinterInfo::printerName() const**

        Returns the name of the printer.

        This is a unique id to identify the printer and may not be human-
        readable.

        **See also** **QPrinterInfo::description** () and
        **QPrinter::setPrinterName** ().
        """
        ...
