"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
from PyQt5.QtPositioning import *


class QGeoRectangle(QGeoShape):
    """
    https://doc.qt.io/qt-5/qgeorectangle.html

    **Detailed Description**

    The rectangle is defined in terms of a **QGeoCoordinate**  which specifies
    the top left coordinate of the rectangle and a **QGeoCoordinate**  which
    specifies the bottom right coordinate of the rectangle.

    A geo rectangle is considered invalid if the top left or bottom right
    coordinates are invalid or if the top left coordinate is south of the bottom
    right coordinate.

    Geo rectangles can never cross the poles.

    Several methods behave as though the geo rectangle is defined in terms of a
    center coordinate, the width of the geo rectangle in degrees and the height
    of the geo rectangle in degrees.

    If the height or center of a geo rectangle is adjusted such that it would
    cross one of the poles the height is modified such that the geo rectangle
    touches but does not cross the pole and that the center coordinate is still
    in the center of the geo rectangle.

    This class is a **Q_GADGET**  since Qt 5.5. It can be **directly used from
    C++ and QML** .
    """

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qgeorectangle.html#QGeoRectangle

        **QGeoRectangle::QGeoRectangle()**

        Constructs a new, invalid geo rectangle.
        """
        ...

    @typing.overload
    def __init__(
        self, center: QGeoCoordinate, degreesWidth: float, degreesHeight: float
    ) -> None:
        """
        https://doc.qt.io/qt-5/qgeorectangle.html#QGeoRectangle-1

        **QGeoRectangle::QGeoRectangle(const QGeoCoordinate & center , double
        degreesWidth , double degreesHeight )**

        Constructs a new geo rectangle centered at **center** with a width in
        degrees of **degreesWidth** and a height in degrees of
        **degreesHeight**.

        If **degreesHeight** would take the geo rectangle beyond one of the
        poles, the height of the geo rectangle will be truncated such that the
        geo rectangle only extends up to the pole. The center of the geo
        rectangle will be unchanged, and the height will be adjusted such that
        the center point is at the center of the truncated geo rectangle.
        """
        ...

    @typing.overload
    def __init__(self, topLeft: QGeoCoordinate, bottomRight: QGeoCoordinate) -> None:
        """
        https://doc.qt.io/qt-5/qgeorectangle.html#QGeoRectangle-2

        **QGeoRectangle::QGeoRectangle(const QGeoCoordinate & topLeft , const
        QGeoCoordinate & bottomRight )**

        Constructs a new geo rectangle with a top left coordinate **topLeft**
        and a bottom right coordinate **bottomRight**.
        """
        ...

    @typing.overload
    def __init__(self, coordinates: typing.Iterable[QGeoCoordinate]) -> None:
        """
        https://doc.qt.io/qt-5/qgeorectangle.html#QGeoRectangle-3

        **QGeoRectangle::QGeoRectangle(const QList<QGeoCoordinate> & coordinates
        )**

        Constructs a new geo rectangle, of minimum size, containing all of the
        **coordinates**.
        """
        ...

    @typing.overload
    def __init__(self, other: "QGeoRectangle") -> None:
        """
        https://doc.qt.io/qt-5/qgeorectangle.html#QGeoRectangle-4

        **QGeoRectangle::QGeoRectangle(const QGeoRectangle & other )**

        Constructs a geo rectangle from the contents of **other**.
        """
        ...

    @typing.overload
    def __init__(self, other: QGeoShape) -> None:
        """
        https://doc.qt.io/qt-5/qgeorectangle.html#QGeoRectangle-5

        **QGeoRectangle::QGeoRectangle(const QGeoShape & other )**

        Constructs a geo rectangle from the contents of **other**.
        """
        ...

    def extendRectangle(self, coordinate: QGeoCoordinate) -> None:
        """
        https://doc.qt.io/qt-5/qgeorectangle.html#extendRectangle

        **void QGeoRectangle::extendRectangle(const QGeoCoordinate & coordinate
        )**

        Extends the geo rectangle to also cover the coordinate **coordinate**

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .

        This function was introduced in Qt 5.9.
        """
        ...

    def toString(self) -> str:
        """
        https://doc.qt.io/qt-5/qgeorectangle.html#toString

        **QString QGeoRectangle::toString() const**

        Returns the geo rectangle properties as a string.

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .

        This function was introduced in Qt 5.5.
        """
        ...

    def united(self, rectangle: "QGeoRectangle") -> "QGeoRectangle":
        """
        https://doc.qt.io/qt-5/qgeorectangle.html#united

        **QGeoRectangle QGeoRectangle::united(const QGeoRectangle & rectangle )
        const**

        Returns the smallest geo rectangle which contains both this geo
        rectangle and **rectangle**.

        If the centers of the two geo rectangles are separated by exactly 180.0
        degrees then the width is set to 360.0 degrees with the leftmost
        longitude set to -180.0 degrees and the rightmost longitude set to 180.0
        degrees. This is done to ensure that the result is independent of the
        order of the operands.

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .
        """
        ...

    def translated(
        self, degreesLatitude: float, degreesLongitude: float
    ) -> "QGeoRectangle":
        """
        https://doc.qt.io/qt-5/qgeorectangle.html#translated

        **QGeoRectangle QGeoRectangle::translated(double degreesLatitude ,
        double degreesLongitude ) const**

        Returns a copy of this geo rectangle translated by **degreesLatitude**
        northwards and **degreesLongitude** eastwards.

        Negative values of **degreesLatitude** and **degreesLongitude**
        correspond to southward and westward translation respectively.

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .

        **See also** **translate** ().
        """
        ...

    def translate(self, degreesLatitude: float, degreesLongitude: float) -> None:
        """
        https://doc.qt.io/qt-5/qgeorectangle.html#translate

        **void QGeoRectangle::translate(double degreesLatitude , double
        degreesLongitude )**

        Translates this geo rectangle by **degreesLatitude** northwards and
        **degreesLongitude** eastwards.

        Negative values of **degreesLatitude** and **degreesLongitude**
        correspond to southward and westward translation respectively.

        If the translation would have caused the geo rectangle to cross a pole
        the geo rectangle will be translated until the top or bottom edge of the
        geo rectangle touches the pole but not further.

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .
        """
        ...

    def intersects(self, rectangle: "QGeoRectangle") -> bool:
        """
        https://doc.qt.io/qt-5/qgeorectangle.html#intersects

        **bool QGeoRectangle::intersects(const QGeoRectangle & rectangle )
        const**

        Returns whether the geo rectangle **rectangle** intersects this geo
        rectangle.

        If the top or bottom edges of both geo rectangles are at one of the
        poles the geo rectangles are considered to be intersecting, since the
        longitude is irrelevant when the edges are at the pole.

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .
        """
        ...

    def contains(self, rectangle: "QGeoRectangle") -> bool:
        """
        https://doc.qt.io/qt-5/qgeorectangle.html#contains

        **bool QGeoRectangle::contains(const QGeoRectangle & rectangle ) const**

        Returns whether the geo rectangle **rectangle** is contained within this
        geo rectangle.
        """
        ...

    def height(self) -> float:
        """
        https://doc.qt.io/qt-5/qgeorectangle.html#height

        **double QGeoRectangle::height() const**

        Returns the height of this geo rectangle in degrees.

        The return value is undefined if this geo rectangle is invalid.

        **Note:** Getter function for property **height** .

        **See also** **setHeight** ().
        """
        ...

    def setHeight(self, degreesHeight: float) -> None:
        """
        https://doc.qt.io/qt-5/qgeorectangle.html#setHeight

        **void QGeoRectangle::setHeight(double degreesHeight )**

        Sets the height of this geo rectangle in degrees to **degreesHeight**.

        **Note:** Setter function for property **height** .

        **See also** **height** ().
        """
        ...

    def width(self) -> float:
        """
        https://doc.qt.io/qt-5/qgeorectangle.html#width

        **double QGeoRectangle::width() const**

        Returns the width of this geo rectangle in degrees.

        The return value is undefined if this geo rectangle is invalid.

        **Note:** Getter function for property **width** .

        **See also** **setWidth** ().
        """
        ...

    def setWidth(self, degreesWidth: float) -> None:
        """
        https://doc.qt.io/qt-5/qgeorectangle.html#setWidth

        **void QGeoRectangle::setWidth(double degreesWidth )**

        Sets the width of this geo rectangle in degrees to **degreesWidth**.

        **Note:** Setter function for property **width** .

        **See also** **width** ().
        """
        ...

    def center(self) -> QGeoCoordinate:
        """
        https://doc.qt.io/qt-5/qgeorectangle.html#center

        **QGeoCoordinate QGeoRectangle::center() const**

        Returns the center of this geo rectangle. Equivalent to
        **QGeoShape::center** ().

        **Note:** Getter function for property **center** .

        **See also** **setCenter** ().
        """
        ...

    def setCenter(self, center: QGeoCoordinate) -> None:
        """
        https://doc.qt.io/qt-5/qgeorectangle.html#setCenter

        **void QGeoRectangle::setCenter(const QGeoCoordinate & center )**

        Sets the center of this geo rectangle to **center**.

        If this causes the geo rectangle to cross on of the poles the height of
        the geo rectangle will be truncated such that the geo rectangle only
        extends up to the pole. The center of the geo rectangle will be
        unchanged, and the height will be adjusted such that the center point is
        at the center of the truncated geo rectangle.

        **Note:** Setter function for property **center** .

        **See also** **center** ().
        """
        ...

    def bottomRight(self) -> QGeoCoordinate:
        """
        https://doc.qt.io/qt-5/qgeorectangle.html#bottomRight

        **QGeoCoordinate QGeoRectangle::bottomRight() const**

        Returns the bottom right coordinate of this geo rectangle.

        **Note:** Getter function for property **bottomRight** .

        **See also** **setBottomRight** ().
        """
        ...

    def setBottomRight(self, bottomRight: QGeoCoordinate) -> None:
        """
        https://doc.qt.io/qt-5/qgeorectangle.html#setBottomRight

        **void QGeoRectangle::setBottomRight(const QGeoCoordinate & bottomRight
        )**

        Sets the bottom right coordinate of this geo rectangle to
        **bottomRight**.

        **Note:** Setter function for property **bottomRight** .

        **See also** **bottomRight** ().
        """
        ...

    def bottomLeft(self) -> QGeoCoordinate:
        """
        https://doc.qt.io/qt-5/qgeorectangle.html#bottomLeft

        **QGeoCoordinate QGeoRectangle::bottomLeft() const**

        Returns the bottom left coordinate of this geo rectangle.

        **Note:** Getter function for property **bottomLeft** .

        **See also** **setBottomLeft** ().
        """
        ...

    def setBottomLeft(self, bottomLeft: QGeoCoordinate) -> None:
        """
        https://doc.qt.io/qt-5/qgeorectangle.html#setBottomLeft

        **void QGeoRectangle::setBottomLeft(const QGeoCoordinate & bottomLeft
        )**

        Sets the bottom left coordinate of this geo rectangle to **bottomLeft**.

        **Note:** Setter function for property **bottomLeft** .

        **See also** **bottomLeft** ().
        """
        ...

    def topRight(self) -> QGeoCoordinate:
        """
        https://doc.qt.io/qt-5/qgeorectangle.html#topRight

        **QGeoCoordinate QGeoRectangle::topRight() const**

        Returns the top right coordinate of this geo rectangle.

        **Note:** Getter function for property **topRight** .

        **See also** **setTopRight** ().
        """
        ...

    def setTopRight(self, topRight: QGeoCoordinate) -> None:
        """
        https://doc.qt.io/qt-5/qgeorectangle.html#setTopRight

        **void QGeoRectangle::setTopRight(const QGeoCoordinate & topRight )**

        Sets the top right coordinate of this geo rectangle to **topRight**.

        **Note:** Setter function for property **topRight** .

        **See also** **topRight** ().
        """
        ...

    def topLeft(self) -> QGeoCoordinate:
        """
        https://doc.qt.io/qt-5/qgeorectangle.html#topLeft

        **QGeoCoordinate QGeoRectangle::topLeft() const**

        Returns the top left coordinate of this geo rectangle.

        **Note:** Getter function for property **topLeft** .

        **See also** **setTopLeft** ().
        """
        ...

    def setTopLeft(self, topLeft: QGeoCoordinate) -> None:
        """
        https://doc.qt.io/qt-5/qgeorectangle.html#setTopLeft

        **void QGeoRectangle::setTopLeft(const QGeoCoordinate & topLeft )**

        Sets the top left coordinate of this geo rectangle to **topLeft**.

        **Note:** Setter function for property **topLeft** .

        **See also** **topLeft** ().
        """
        ...
