"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
import PyQt5.sip


class QGeoAddress(PyQt5.sip.wrapper):
    """
    https://doc.qt.io/qt-5/qgeoaddress.html

    **Detailed Description**

    The address' attributes are normalized to US feature names and can be mapped
    to the local feature levels (for example State matches "Bundesland" in
    Germany).

    The address contains a **text** () for displaying purposes and additional
    properties to access the components of an address:

    * **QGeoAddress::country** ()
      * **QGeoAddress::countryCode** ()
      *
    **QGeoAddress::state** ()
      * **QGeoAddress::city** ()
      *
    **QGeoAddress::district** ()
      * **QGeoAddress::street** ()
      *
    **QGeoAddress::postalCode** ()
    """

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qgeoaddress.html#QGeoAddress

        **QGeoAddress::QGeoAddress()**

        Default constructor.
        """
        ...

    @typing.overload
    def __init__(self, other: "QGeoAddress") -> None:
        """
        https://doc.qt.io/qt-5/qgeoaddress.html#QGeoAddress-1

        **QGeoAddress::QGeoAddress(const QGeoAddress & other )**

        Constructs a copy of **other**.
        """
        ...

    def isTextGenerated(self) -> bool:
        """
        https://doc.qt.io/qt-5/qgeoaddress.html#isTextGenerated

        **bool QGeoAddress::isTextGenerated() const**

        Returns true if **QGeoAddress::text** () is automatically generated from
        address elements, otherwise returns false if **text** () has been
        explicitly assigned.

        **See also** **text** () and **setText** ().
        """
        ...

    def clear(self) -> None:
        """
        https://doc.qt.io/qt-5/qgeoaddress.html#clear

        **void QGeoAddress::clear()**

        Clears all of the address' data fields.
        """
        ...

    def isEmpty(self) -> bool:
        """
        https://doc.qt.io/qt-5/qgeoaddress.html#isEmpty

        **bool QGeoAddress::isEmpty() const**

        Returns whether this address is empty. An address is considered empty if
        **all** of its fields are empty.
        """
        ...

    def setStreet(self, street: str) -> None:
        """
        https://doc.qt.io/qt-5/qgeoaddress.html#setStreet

        **void QGeoAddress::setStreet(const QString & street )**

        Sets the street-level component of the address to **street**.

        This typically includes a street number and street name but may also
        contain things like a unit number, a building name, or anything else
        that might be used to distinguish one address from another.

        **See also** **street** ().
        """
        ...

    def street(self) -> str:
        """
        https://doc.qt.io/qt-5/qgeoaddress.html#street

        **QString QGeoAddress::street() const**

        Returns the street-level component of the address.

        This typically includes a street number and street name but may also
        contain things like a unit number, a building name, or anything else
        that might be used to distinguish one address from another.

        **See also** **setStreet** ().
        """
        ...

    def setPostalCode(self, postalCode: str) -> None:
        """
        https://doc.qt.io/qt-5/qgeoaddress.html#setPostalCode

        **void QGeoAddress::setPostalCode(const QString & postalCode )**

        Sets the **postalCode**.

        **See also** **postalCode** ().
        """
        ...

    def postalCode(self) -> str:
        """
        https://doc.qt.io/qt-5/qgeoaddress.html#postalCode

        **QString QGeoAddress::postalCode() const**

        Returns the postal code.

        **See also** **setPostalCode** ().
        """
        ...

    def setDistrict(self, district: str) -> None:
        """
        https://doc.qt.io/qt-5/qgeoaddress.html#setDistrict

        **void QGeoAddress::setDistrict(const QString & district )**

        Sets the **district**.

        **See also** **district** ().
        """
        ...

    def district(self) -> str:
        """
        https://doc.qt.io/qt-5/qgeoaddress.html#district

        **QString QGeoAddress::district() const**

        Returns the district. The district is considered the subdivison below
        city.

        **See also** **setDistrict** ().
        """
        ...

    def setCity(self, city: str) -> None:
        """
        https://doc.qt.io/qt-5/qgeoaddress.html#setCity

        **void QGeoAddress::setCity(const QString & city )**

        Sets the **city**.

        **See also** **city** ().
        """
        ...

    def city(self) -> str:
        """
        https://doc.qt.io/qt-5/qgeoaddress.html#city

        **QString QGeoAddress::city() const**

        Returns the city.

        **See also** **setCity** ().
        """
        ...

    def setCounty(self, county: str) -> None:
        """
        https://doc.qt.io/qt-5/qgeoaddress.html#setCounty

        **void QGeoAddress::setCounty(const QString & county )**

        Sets the **county**.

        **See also** **county** ().
        """
        ...

    def county(self) -> str:
        """
        https://doc.qt.io/qt-5/qgeoaddress.html#county

        **QString QGeoAddress::county() const**

        Returns the county. The county is considered the second subdivision
        below country.

        **See also** **setCounty** ().
        """
        ...

    def setState(self, state: str) -> None:
        """
        https://doc.qt.io/qt-5/qgeoaddress.html#setState

        **void QGeoAddress::setState(const QString & state )**

        Sets the **state**.

        **See also** **state** ().
        """
        ...

    def state(self) -> str:
        """
        https://doc.qt.io/qt-5/qgeoaddress.html#state

        **QString QGeoAddress::state() const**

        Returns the state. The state is considered the first subdivision below
        country.

        **See also** **setState** ().
        """
        ...

    def setCountryCode(self, countryCode: str) -> None:
        """
        https://doc.qt.io/qt-5/qgeoaddress.html#setCountryCode

        **void QGeoAddress::setCountryCode(const QString & countryCode )**

        Sets the **countryCode** according to ISO 3166-1 alpha-3

        **See also** **countryCode** ().
        """
        ...

    def countryCode(self) -> str:
        """
        https://doc.qt.io/qt-5/qgeoaddress.html#countryCode

        **QString QGeoAddress::countryCode() const**

        Returns the country code according to ISO 3166-1 alpha-3

        **See also** **setCountryCode** ().
        """
        ...

    def setCountry(self, country: str) -> None:
        """
        https://doc.qt.io/qt-5/qgeoaddress.html#setCountry

        **void QGeoAddress::setCountry(const QString & country )**

        Sets the **country** name.

        **See also** **country** ().
        """
        ...

    def country(self) -> str:
        """
        https://doc.qt.io/qt-5/qgeoaddress.html#country

        **QString QGeoAddress::country() const**

        Returns the country name.

        **See also** **setCountry** ().
        """
        ...

    def setText(self, text: str) -> None:
        """
        https://doc.qt.io/qt-5/qgeoaddress.html#setText

        **void QGeoAddress::setText(const QString & text )**

        If **text** is not empty, explicitly assigns **text** as the string to
        be returned by **text** (). **isTextGenerated** () will return false.

        If **text** is empty, indicates that **text** () should be automatically
        generated from the address elements. **isTextGenerated** () will return
        true.

        **See also** **text** ().
        """
        ...

    def text(self) -> str:
        """
        https://doc.qt.io/qt-5/qgeoaddress.html#text

        **QString QGeoAddress::text() const**

        Returns the address as a single formatted string. It is the recommended
        string to use to display the address to the user. It typically takes the
        format of an address as found on an envelope, but this is not always
        necessarily the case.

        The address text is either automatically generated or explicitly
        assigned. This can be determined by checking **isTextGenerated** .

        If an empty string is provided to **setText** (), then
        **isTextGenerated** () will be set to true and text() will return a
        string which is locally formatted according to **countryCode** () and
        based on the elements of the address such as street, city and so on.
        Because the text string is generated from the address elements, a
        sequence of calls such as text(), **setStreet** (), text() may return
        different strings for each invocation of text().

        If a non-empty string is provided to **setText** (), then
        **isTextGenerated** () will be set to false and text() will always
        return the explicitly assigned string. Calls to modify other elements
        such as **setStreet** (), **setCity** () and so on will not affect the
        resultant string from text().

        **See also** **setText** ().
        """
        ...
