"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
from PyQt5.QtOpenGL import *
from PyQt5 import sip


class QGLFormat(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qglformat.html

    **Detailed Description**

    A display format has several characteristics:

    * **Double or single buffering.**
      * **Depth buffer.**
      * **RGBA or
    color index mode.**
      * **Alpha channel.**
      * **Accumulation buffer.**
    * **Stencil buffer.**
      * **Stereo buffers.**
      * **Direct rendering.**
    * **Presence of an overlay.**
      * **Plane of an overlay.**
      *
    **Multisample buffers.**

    You can also specify preferred bit depths for the color buffer, depth
    buffer, alpha buffer, accumulation buffer and the stencil buffer with the
    functions: **setRedBufferSize** (), **setGreenBufferSize** (),
    **setBlueBufferSize** (), **setDepthBufferSize** (), **setAlphaBufferSize**
    (), **setAccumBufferSize** () and **setStencilBufferSize** ().

    Note that even if you specify that you prefer a 32 bit depth buffer (e.g.
    with **setDepthBufferSize** (32)), the format that is chosen may not have a
    32 bit depth buffer, even if there is a format available with a 32 bit depth
    buffer. The main reason for this is how the system dependant picking
    algorithms work on the different platforms, and some format options may have
    higher precedence than others.

    You create and tell a QGLFormat object what rendering options you want from
    an OpenGL rendering context.

    OpenGL drivers or accelerated hardware may or may not support advanced
    features such as alpha channel or stereographic viewing. If you request some
    features that the driver/hardware does not provide when you create a
    **QGLWidget** , you will get a rendering context with the nearest subset of
    features.

    There are different ways to define the display characteristics of a
    rendering context. One is to create a QGLFormat and make it the default for
    the entire application:

    **QGLFormat**  fmt;
        fmt.setAlpha(true);
        fmt.setStereo(true);
    **QGLFormat** ::setDefaultFormat(fmt);

    Or you can specify the desired format when creating an object of your
    **QGLWidget**  subclass:

    **QGLFormat**  fmt;
        fmt.setDoubleBuffer(false);                 //
    single buffer
        fmt.setDirectRendering(false);              // software
    rendering
        MyGLWidget* myWidget = new MyGLWidget(fmt, ...);

    After the widget has been created, you can find out which of the requested
    features the system was able to provide:

    **QGLFormat**  fmt;
        fmt.setOverlay(true);
        fmt.setStereo(true);
    MyGLWidget* myWidget = new MyGLWidget(fmt, ...);
        if
    (!myWidget->format().stereo()) {
            // ok, goggles off
            if
    (!myWidget->format().hasOverlay()) {
                **qFatal** ("Cool hardware
    required");
            }
        }

    OpenGL is a trademark of Silicon Graphics, Inc. in the United States and
    other countries.

    **See also** **QGLContext**  and **QGLWidget** .
    """

    class OpenGLContextProfile(int):
        NoProfile: QGLFormat = ...
        CoreProfile: QGLFormat = ...
        CompatibilityProfile: QGLFormat = ...

    class OpenGLVersionFlag(int):
        OpenGL_Version_None: QGLFormat = ...
        OpenGL_Version_1_1: QGLFormat = ...
        OpenGL_Version_1_2: QGLFormat = ...
        OpenGL_Version_1_3: QGLFormat = ...
        OpenGL_Version_1_4: QGLFormat = ...
        OpenGL_Version_1_5: QGLFormat = ...
        OpenGL_Version_2_0: QGLFormat = ...
        OpenGL_Version_2_1: QGLFormat = ...
        OpenGL_Version_3_0: QGLFormat = ...
        OpenGL_Version_3_1: QGLFormat = ...
        OpenGL_Version_3_2: QGLFormat = ...
        OpenGL_Version_3_3: QGLFormat = ...
        OpenGL_Version_4_0: QGLFormat = ...
        OpenGL_Version_4_1: QGLFormat = ...
        OpenGL_Version_4_2: QGLFormat = ...
        OpenGL_Version_4_3: QGLFormat = ...
        OpenGL_ES_Common_Version_1_0: QGLFormat = ...
        OpenGL_ES_CommonLite_Version_1_0: QGLFormat = ...
        OpenGL_ES_Common_Version_1_1: QGLFormat = ...
        OpenGL_ES_CommonLite_Version_1_1: QGLFormat = ...
        OpenGL_ES_Version_2_0: QGLFormat = ...

    class OpenGLVersionFlags(sip.simplewrapper):
        @typing.overload
        def __init__(self) -> None:
            ...

        @typing.overload
        def __init__(
            self,
            f: typing.Union[
                "QGLFormat.OpenGLVersionFlags", "QGLFormat.OpenGLVersionFlag"
            ],
        ) -> None:
            ...

        @typing.overload
        def __init__(self, a0: "QGLFormat.OpenGLVersionFlags") -> None:
            ...

        def __hash__(self) -> int:
            ...

        def __bool__(self) -> int:
            ...

        def __invert__(self) -> "QGLFormat.OpenGLVersionFlags":
            ...

        def __index__(self) -> int:
            ...

        def __int__(self) -> int:
            ...

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qglformat.html#QGLFormat

        **QGLFormat::QGLFormat()**

        Constructs a QGLFormat object with the following default settings:

        * **Double buffer:**  Enabled.
          * **Depth buffer:**  Enabled.
          *
        **RGBA:**  Enabled (i.e., color index disabled).
          * **Alpha channel:**
        Disabled.
          * **Accumulator buffer:**  Disabled.
          * **Stencil buffer:**
        Enabled.
          * **Stereo:**  Disabled.
          * **Direct rendering:**  Enabled.
        * **Overlay:**  Disabled.
          * **Plane:**  0 (i.e., normal plane).
          *
        **Multisample buffers:**  Disabled.
        """
        ...

    @typing.overload
    def __init__(
        self,
        options: typing.Union[QGL.FormatOptions, QGL.FormatOption],
        plane: int = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qglformat.html#QGLFormat-1

        **QGLFormat::QGLFormat(QGL::FormatOptions options , int plane = 0)**

        Creates a QGLFormat object that is a copy of the current
        **defaultFormat** ().

        If **options** is not 0, the default format is modified by the specified
        format options. The **options** parameter should be
        **QGL::FormatOption**  values OR'ed together.

        This constructor makes it easy to specify a certain desired format in
        classes derived from QGLWidget, for example:

        // The rendering in MyGLWidget depends on using
            // stencil buffer
        and alpha channel
            MyGLWidget::MyGLWidget(**QWidget** * parent)
        : **QGLWidget** (**QGLFormat** (QGL::StencilBuffer | QGL::AlphaChannel),
        parent)
            {
                if (!format().stencil())
                    **qWarning**
        ("Could not get stencil buffer; results will be suboptimal");
                if
        (!format().alpha())
                    **qWarning** ("Could not get alpha
        channel; results will be suboptimal");
                ...
            }

        Note that there are **QGL::FormatOption**  values to turn format
        settings both on and off, e.g. **QGL::DepthBuffer**  and
        **QGL::NoDepthBuffer** , **QGL::DirectRendering**  and
        **QGL::IndirectRendering** , etc.

        The **plane** parameter defaults to 0 and is the plane which this format
        should be associated with. Not all OpenGL implementations supports
        overlay/underlay rendering planes.

        **See also** **defaultFormat** (), **setOption** (), and **setPlane**
        ().
        """
        ...

    @typing.overload
    def __init__(self, other: "QGLFormat") -> None:
        """
        https://doc.qt.io/qt-5/qglformat.html#QGLFormat-2

        **QGLFormat::QGLFormat(const QGLFormat & other )**

        Constructs a copy of **other**.
        """
        ...

    def profile(self) -> "QGLFormat.OpenGLContextProfile":
        """
        https://doc.qt.io/qt-5/qglformat.html#profile

        **QGLFormat::OpenGLContextProfile QGLFormat::profile() const**

        Returns the OpenGL context profile.

        This function was introduced in Qt 4.7.

        **See also** **setProfile** ().
        """
        ...

    def setProfile(self, profile: "QGLFormat.OpenGLContextProfile") -> None:
        """
        https://doc.qt.io/qt-5/qglformat.html#setProfile

        **void QGLFormat::setProfile(QGLFormat::OpenGLContextProfile profile )**

        Set the OpenGL context profile to **profile**. The **profile** is
        ignored if the requested OpenGL version is less than 3.2.

        This function was introduced in Qt 4.7.

        **See also** **profile** ().
        """
        ...

    def minorVersion(self) -> int:
        """
        https://doc.qt.io/qt-5/qglformat.html#minorVersion

        **int QGLFormat::minorVersion() const**

        Returns the OpenGL minor version.

        This function was introduced in Qt 4.7.

        **See also** **setVersion** () and **majorVersion** ().
        """
        ...

    def majorVersion(self) -> int:
        """
        https://doc.qt.io/qt-5/qglformat.html#majorVersion

        **int QGLFormat::majorVersion() const**

        Returns the OpenGL major version.

        This function was introduced in Qt 4.7.

        **See also** **setVersion** () and **minorVersion** ().
        """
        ...

    def setVersion(self, major: int, minor: int) -> None:
        """
        https://doc.qt.io/qt-5/qglformat.html#setVersion

        **void QGLFormat::setVersion(int major , int minor )**

        Set the OpenGL version to the **major** and **minor** numbers. If a
        context compatible with the requested OpenGL version cannot be created,
        a context compatible with version 1.x is created instead.

        This function was introduced in Qt 4.7.

        **See also** **majorVersion** () and **minorVersion** ().
        """
        ...

    @staticmethod
    def openGLVersionFlags() -> "QGLFormat.OpenGLVersionFlags":
        """
        https://doc.qt.io/qt-5/qglformat.html#openGLVersionFlags

        **[static] QGLFormat::OpenGLVersionFlags
        QGLFormat::openGLVersionFlags()**

        Identifies, at runtime, which OpenGL versions that are supported by the
        current platform.

        Note that if OpenGL version 1.5 is supported, its predecessors (i.e.,
        version 1.4 and lower) are also supported. To identify the support of a
        particular feature, like multi texturing, test for the version in which
        the feature was first introduced (i.e., version 1.3 in the case of multi
        texturing) to adapt to the largest possible group of runtime platforms.

        This function needs a valid current OpenGL context to work; otherwise it
        will return **OpenGL_Version_None** .

        This function was introduced in Qt 4.2.

        **See also** **hasOpenGL** () and **hasOpenGLOverlays** ().
        """
        ...

    def swapInterval(self) -> int:
        """
        https://doc.qt.io/qt-5/qglformat.html#swapInterval

        **int QGLFormat::swapInterval() const**

        Returns the currently set swap interval. -1 is returned if setting the
        swap interval isn't supported in the system GL implementation.

        This function was introduced in Qt 4.2.

        **See also** **setSwapInterval** ().
        """
        ...

    def setSwapInterval(self, interval: int) -> None:
        """
        https://doc.qt.io/qt-5/qglformat.html#setSwapInterval

        **void QGLFormat::setSwapInterval(int interval )**

        Set the preferred swap interval. This can be used to sync the GL drawing
        into a system window to the vertical refresh of the screen. Setting an
        **interval** value of 0 will turn the vertical refresh syncing off, any
        value higher than 0 will turn the vertical syncing on.

        Under Windows and under X11, where the `WGL_EXT_swap_control` and
        `GLX_SGI_video_sync` extensions are used, the **interval** parameter can
        be used to set the minimum number of video frames that are displayed
        before a buffer swap will occur. In effect, setting the **interval** to
        10, means there will be 10 vertical retraces between every buffer swap.

        Under Windows the `WGL_EXT_swap_control` extension has to be present,
        and under X11 the `GLX_SGI_video_sync` extension has to be present.

        This function was introduced in Qt 4.2.

        **See also** **swapInterval** ().
        """
        ...

    def blueBufferSize(self) -> int:
        """
        https://doc.qt.io/qt-5/qglformat.html#blueBufferSize

        **int QGLFormat::blueBufferSize() const**

        Returns the blue buffer size.

        This function was introduced in Qt 4.2.

        **See also** **setBlueBufferSize** ().
        """
        ...

    def setBlueBufferSize(self, size: int) -> None:
        """
        https://doc.qt.io/qt-5/qglformat.html#setBlueBufferSize

        **void QGLFormat::setBlueBufferSize(int size )**

        Set the preferred blue buffer size to **size**.

        This function was introduced in Qt 4.2.

        **See also** **blueBufferSize** (), **setRedBufferSize** (),
        **setGreenBufferSize** (), and **setAlphaBufferSize** ().
        """
        ...

    def greenBufferSize(self) -> int:
        """
        https://doc.qt.io/qt-5/qglformat.html#greenBufferSize

        **int QGLFormat::greenBufferSize() const**

        Returns the green buffer size.

        This function was introduced in Qt 4.2.

        **See also** **setGreenBufferSize** ().
        """
        ...

    def setGreenBufferSize(self, size: int) -> None:
        """
        https://doc.qt.io/qt-5/qglformat.html#setGreenBufferSize

        **void QGLFormat::setGreenBufferSize(int size )**

        Set the preferred green buffer size to **size**.

        This function was introduced in Qt 4.2.

        **See also** **greenBufferSize** (), **setRedBufferSize** (),
        **setBlueBufferSize** (), and **setAlphaBufferSize** ().
        """
        ...

    def redBufferSize(self) -> int:
        """
        https://doc.qt.io/qt-5/qglformat.html#redBufferSize

        **int QGLFormat::redBufferSize() const**

        Returns the red buffer size.

        This function was introduced in Qt 4.2.

        **See also** **setRedBufferSize** ().
        """
        ...

    def setRedBufferSize(self, size: int) -> None:
        """
        https://doc.qt.io/qt-5/qglformat.html#setRedBufferSize

        **void QGLFormat::setRedBufferSize(int size )**

        Set the preferred red buffer size to **size**.

        This function was introduced in Qt 4.2.

        **See also** **redBufferSize** (), **setGreenBufferSize** (),
        **setBlueBufferSize** (), and **setAlphaBufferSize** ().
        """
        ...

    def sampleBuffers(self) -> bool:
        """
        https://doc.qt.io/qt-5/qglformat.html#sampleBuffers

        **bool QGLFormat::sampleBuffers() const**

        Returns `true` if multisample buffer support is enabled; otherwise
        returns `false`.

        The multisample buffer is disabled by default.

        **See also** **setSampleBuffers** ().
        """
        ...

    def hasOverlay(self) -> bool:
        """
        https://doc.qt.io/qt-5/qglformat.html#hasOverlay

        **bool QGLFormat::hasOverlay() const**

        Returns `true` if overlay plane is enabled; otherwise returns `false`.

        Overlay is disabled by default.

        **See also** **setOverlay** ().
        """
        ...

    def directRendering(self) -> bool:
        """
        https://doc.qt.io/qt-5/qglformat.html#directRendering

        **bool QGLFormat::directRendering() const**

        Returns `true` if direct rendering is enabled; otherwise returns false.

        Direct rendering is enabled by default.

        **See also** **setDirectRendering** ().
        """
        ...

    def stereo(self) -> bool:
        """
        https://doc.qt.io/qt-5/qglformat.html#stereo

        **bool QGLFormat::stereo() const**

        Returns `true` if stereo buffering is enabled; otherwise returns false.
        Stereo buffering is disabled by default.

        **See also** **setStereo** ().
        """
        ...

    def stencil(self) -> bool:
        """
        https://doc.qt.io/qt-5/qglformat.html#stencil

        **bool QGLFormat::stencil() const**

        Returns `true` if the stencil buffer is enabled; otherwise returns
        false. The stencil buffer is enabled by default.

        **See also** **setStencil** () and **setStencilBufferSize** ().
        """
        ...

    def accum(self) -> bool:
        """
        https://doc.qt.io/qt-5/qglformat.html#accum

        **bool QGLFormat::accum() const**

        Returns `true` if the accumulation buffer is enabled; otherwise returns
        `false`. The accumulation buffer is disabled by default.

        **See also** **setAccum** () and **setAccumBufferSize** ().
        """
        ...

    def alpha(self) -> bool:
        """
        https://doc.qt.io/qt-5/qglformat.html#alpha

        **bool QGLFormat::alpha() const**

        Returns `true` if the alpha buffer in the framebuffer is enabled;
        otherwise returns `false`. The alpha buffer is disabled by default.

        **See also** **setAlpha** () and **setAlphaBufferSize** ().
        """
        ...

    def rgba(self) -> bool:
        """
        https://doc.qt.io/qt-5/qglformat.html#rgba

        **bool QGLFormat::rgba() const**

        Returns `true` if RGBA color mode is set. Returns `false` if color index
        mode is set. The default color mode is RGBA.

        **See also** **setRgba** ().
        """
        ...

    def depth(self) -> bool:
        """
        https://doc.qt.io/qt-5/qglformat.html#depth

        **bool QGLFormat::depth() const**

        Returns `true` if the depth buffer is enabled; otherwise returns false.
        The depth buffer is enabled by default.

        **See also** **setDepth** () and **setDepthBufferSize** ().
        """
        ...

    def doubleBuffer(self) -> bool:
        """
        https://doc.qt.io/qt-5/qglformat.html#doubleBuffer

        **bool QGLFormat::doubleBuffer() const**

        Returns `true` if double buffering is enabled; otherwise returns false.
        Double buffering is enabled by default.

        **See also** **setDoubleBuffer** ().
        """
        ...

    @staticmethod
    def hasOpenGLOverlays() -> bool:
        """
        https://doc.qt.io/qt-5/qglformat.html#hasOpenGLOverlays

        **[static] bool QGLFormat::hasOpenGLOverlays()**

        Returns `true` if the window system supports OpenGL overlays; otherwise
        returns `false`.

        **Warning:** This function must not be called until the **QApplication**
        object has been created.
        """
        ...

    @staticmethod
    def hasOpenGL() -> bool:
        """
        https://doc.qt.io/qt-5/qglformat.html#hasOpenGL

        **[static] bool QGLFormat::hasOpenGL()**

        Returns `true` if the window system has any OpenGL support; otherwise
        returns `false`.

        **Warning:** This function must not be called until the **QApplication**
        object has been created.
        """
        ...

    @staticmethod
    def setDefaultOverlayFormat(f: "QGLFormat") -> None:
        """
        https://doc.qt.io/qt-5/qglformat.html#setDefaultOverlayFormat

        **[static] void QGLFormat::setDefaultOverlayFormat(const QGLFormat & f
        )**

        Sets a new default **QGLFormat**  for overlay contexts to **f**. This
        format is used whenever a QGLWidget is created with a format that
        **hasOverlay** () enabled.

        For example, to get a double buffered overlay context (if available),
        use code like this:

        **QGLFormat**  f = **QGLFormat** ::defaultOverlayFormat();
        f.setDoubleBuffer(true);
            **QGLFormat** ::setDefaultOverlayFormat(f);

        As usual, you can find out after widget creation whether the underlying
        OpenGL system was able to provide the requested specification:

        // ...continued from above
            MyGLWidget* myWidget = new
        MyGLWidget(**QGLFormat** (QGL::HasOverlay), ...);
            if
        (myWidget->format().hasOverlay()) {
                // Yes, we got an overlay,
        let's check _its_ format:
                **QGLContext** * olContext =
        myWidget->overlayContext();
                if
        (olContext->format().doubleBuffer())
                    ; // yes, we got a
        double buffered overlay
                else
                    ; // no, only single
        buffered overlays are available
            }

        **See also** **defaultOverlayFormat** ().
        """
        ...

    @staticmethod
    def defaultOverlayFormat() -> "QGLFormat":
        """
        https://doc.qt.io/qt-5/qglformat.html#defaultOverlayFormat

        **[static] QGLFormat QGLFormat::defaultOverlayFormat()**

        Returns the default **QGLFormat**  for overlay contexts.

        The default overlay format is:

        * **Double buffer:**  Disabled.
          * **Depth buffer:**  Disabled.
          *
        **RGBA:**  Disabled (i.e., color index enabled).
          * **Alpha channel:**
        Disabled.
          * **Accumulator buffer:**  Disabled.
          * **Stencil buffer:**
        Disabled.
          * **Stereo:**  Disabled.
          * **Direct rendering:**  Enabled.
        * **Overlay:**  Disabled.
          * **Multisample buffers:**  Disabled.
          *
        **Plane:**  1 (i.e., first overlay plane).

        **See also** **setDefaultOverlayFormat** () and **setDefaultFormat** ().
        """
        ...

    @staticmethod
    def setDefaultFormat(f: "QGLFormat") -> None:
        """
        https://doc.qt.io/qt-5/qglformat.html#setDefaultFormat

        **[static] void QGLFormat::setDefaultFormat(const QGLFormat & f )**

        Sets a new default **QGLFormat**  for the application to **f**. For
        example, to set single buffering as the default instead of double
        buffering, your main() might contain code like this:

        **QApplication**  a(argc, argv);
            **QGLFormat**  f;
        f.setDoubleBuffer(false);
            **QGLFormat** ::setDefaultFormat(f);

        **See also** **defaultFormat** ().
        """
        ...

    @staticmethod
    def defaultFormat() -> "QGLFormat":
        """
        https://doc.qt.io/qt-5/qglformat.html#defaultFormat

        **[static] QGLFormat QGLFormat::defaultFormat()**

        Returns the default **QGLFormat**  for the application. All QGLWidget
        objects that are created use this format unless another format is
        specified, e.g. when they are constructed.

        If no special default format has been set using **setDefaultFormat** (),
        the default format is the same as that created with **QGLFormat** ().

        **See also** **setDefaultFormat** ().
        """
        ...

    def testOption(
        self, opt: typing.Union[QGL.FormatOptions, QGL.FormatOption]
    ) -> bool:
        """
        https://doc.qt.io/qt-5/qglformat.html#testOption

        **bool QGLFormat::testOption(QGL::FormatOptions opt ) const**

        Returns `true` if format option **opt** is set; otherwise returns
        `false`.

        **See also** **setOption** ().
        """
        ...

    def setOption(self, opt: typing.Union[QGL.FormatOptions, QGL.FormatOption]) -> None:
        """
        https://doc.qt.io/qt-5/qglformat.html#setOption

        **void QGLFormat::setOption(QGL::FormatOptions opt )**

        Sets the format option to **opt**.

        **See also** **testOption** ().
        """
        ...

    def setPlane(self, plane: int) -> None:
        """
        https://doc.qt.io/qt-5/qglformat.html#setPlane

        **void QGLFormat::setPlane(int plane )**

        Sets the requested plane to **plane**. 0 is the normal plane, 1 is the
        first overlay plane, 2 is the second overlay plane, etc.; -1, -2, etc.
        are underlay planes.

        Note that in contrast to other format specifications, the plane
        specifications will be matched exactly. This means that if you specify a
        plane that the underlying OpenGL system cannot provide, an **invalid**
        QGLWidget will be created.

        **See also** **plane** ().
        """
        ...

    def plane(self) -> int:
        """
        https://doc.qt.io/qt-5/qglformat.html#plane

        **int QGLFormat::plane() const**

        Returns the plane of this format. The default for normal formats is 0,
        which means the normal plane. The default for overlay formats is 1,
        which is the first overlay plane.

        **See also** **setPlane** () and **defaultOverlayFormat** ().
        """
        ...

    def setOverlay(self, enable: bool) -> None:
        """
        https://doc.qt.io/qt-5/qglformat.html#setOverlay

        **void QGLFormat::setOverlay(bool enable )**

        If **enable** is true enables an overlay plane; otherwise disables the
        overlay plane.

        Enabling the overlay plane will cause QGLWidget to create an additional
        context in an overlay plane. See the QGLWidget documentation for further
        information.

        **See also** **hasOverlay** ().
        """
        ...

    def setDirectRendering(self, enable: bool) -> None:
        """
        https://doc.qt.io/qt-5/qglformat.html#setDirectRendering

        **void QGLFormat::setDirectRendering(bool enable )**

        If **enable** is true enables direct rendering; otherwise disables
        direct rendering.

        Direct rendering is enabled by default.

        Enabling this option will make OpenGL bypass the underlying window
        system and render directly from hardware to the screen, if this is
        supported by the system.

        **See also** **directRendering** ().
        """
        ...

    def setStereo(self, enable: bool) -> None:
        """
        https://doc.qt.io/qt-5/qglformat.html#setStereo

        **void QGLFormat::setStereo(bool enable )**

        If **enable** is true enables stereo buffering; otherwise disables
        stereo buffering.

        Stereo buffering is disabled by default.

        Stereo buffering provides extra color buffers to generate left-eye and
        right-eye images.

        **See also** **stereo** ().
        """
        ...

    def setStencil(self, enable: bool) -> None:
        """
        https://doc.qt.io/qt-5/qglformat.html#setStencil

        **void QGLFormat::setStencil(bool enable )**

        If **enable** is true enables the stencil buffer; otherwise disables the
        stencil buffer.

        The stencil buffer is enabled by default.

        The stencil buffer masks certain parts of the drawing area so that
        masked parts are not drawn on.

        **See also** **stencil** () and **setStencilBufferSize** ().
        """
        ...

    def setAccum(self, enable: bool) -> None:
        """
        https://doc.qt.io/qt-5/qglformat.html#setAccum

        **void QGLFormat::setAccum(bool enable )**

        If **enable** is true enables the accumulation buffer; otherwise
        disables the accumulation buffer.

        The accumulation buffer is disabled by default.

        The accumulation buffer is used to create blur effects and multiple
        exposures.

        **See also** **accum** () and **setAccumBufferSize** ().
        """
        ...

    def setAlpha(self, enable: bool) -> None:
        """
        https://doc.qt.io/qt-5/qglformat.html#setAlpha

        **void QGLFormat::setAlpha(bool enable )**

        If **enable** is true enables the alpha buffer; otherwise disables the
        alpha buffer.

        The alpha buffer is disabled by default.

        The alpha buffer is typically used for implementing transparency or
        translucency. The A in RGBA specifies the transparency of a pixel.

        **See also** **alpha** () and **setAlphaBufferSize** ().
        """
        ...

    def setRgba(self, enable: bool) -> None:
        """
        https://doc.qt.io/qt-5/qglformat.html#setRgba

        **void QGLFormat::setRgba(bool enable )**

        If **enable** is true sets RGBA mode. If **enable** is false sets color
        index mode.

        The default color mode is RGBA.

        RGBA is the preferred mode for most OpenGL applications. In RGBA color
        mode you specify colors as red + green + blue + alpha quadruplets.

        In color index mode you specify an index into a color lookup table.

        **See also** **rgba** ().
        """
        ...

    def setDepth(self, enable: bool) -> None:
        """
        https://doc.qt.io/qt-5/qglformat.html#setDepth

        **void QGLFormat::setDepth(bool enable )**

        If **enable** is true enables the depth buffer; otherwise disables the
        depth buffer.

        The depth buffer is enabled by default.

        The purpose of a depth buffer (or Z-buffering) is to remove hidden
        surfaces. Pixels are assigned Z values based on the distance to the
        viewer. A pixel with a high Z value is closer to the viewer than a pixel
        with a low Z value. This information is used to decide whether to draw a
        pixel or not.

        **See also** **depth** () and **setDepthBufferSize** ().
        """
        ...

    def setDoubleBuffer(self, enable: bool) -> None:
        """
        https://doc.qt.io/qt-5/qglformat.html#setDoubleBuffer

        **void QGLFormat::setDoubleBuffer(bool enable )**

        If **enable** is true sets double buffering; otherwise sets single
        buffering.

        Double buffering is enabled by default.

        Double buffering is a technique where graphics are rendered on an off-
        screen buffer and not directly to the screen. When the drawing has been
        completed, the program calls a swapBuffers() function to exchange the
        screen contents with the buffer. The result is flicker-free drawing and
        often better performance.

        Note that single buffered contexts are currently not supported with EGL.

        **See also** **doubleBuffer** (), **QGLContext::swapBuffers** (), and
        **QGLWidget::swapBuffers** ().
        """
        ...

    def samples(self) -> int:
        """
        https://doc.qt.io/qt-5/qglformat.html#samples

        **int QGLFormat::samples() const**

        Returns the number of samples per pixel when multisampling is enabled.
        By default, the highest number of samples that is available is used.

        **See also** **setSampleBuffers** (), **sampleBuffers** (), and
        **setSamples** ().
        """
        ...

    def setSamples(self, numSamples: int) -> None:
        """
        https://doc.qt.io/qt-5/qglformat.html#setSamples

        **void QGLFormat::setSamples(int numSamples )**

        Set the preferred number of samples per pixel when multisampling is
        enabled to **numSamples**. By default, the highest number of samples
        available is used.

        **See also** **setSampleBuffers** (), **sampleBuffers** (), and
        **samples** ().
        """
        ...

    def setSampleBuffers(self, enable: bool) -> None:
        """
        https://doc.qt.io/qt-5/qglformat.html#setSampleBuffers

        **void QGLFormat::setSampleBuffers(bool enable )**

        If **enable** is true, a GL context with multisample buffer support is
        picked; otherwise ignored.

        **See also** **sampleBuffers** (), **setSamples** (), and **samples**
        ().
        """
        ...

    def stencilBufferSize(self) -> int:
        """
        https://doc.qt.io/qt-5/qglformat.html#stencilBufferSize

        **int QGLFormat::stencilBufferSize() const**

        Returns the stencil buffer size.

        **See also** **stencil** (), **setStencil** (), and
        **setStencilBufferSize** ().
        """
        ...

    def setStencilBufferSize(self, size: int) -> None:
        """
        https://doc.qt.io/qt-5/qglformat.html#setStencilBufferSize

        **void QGLFormat::setStencilBufferSize(int size )**

        Set the preferred stencil buffer size to **size**.

        **See also** **stencilBufferSize** (), **setStencil** (), and
        **stencil** ().
        """
        ...

    def alphaBufferSize(self) -> int:
        """
        https://doc.qt.io/qt-5/qglformat.html#alphaBufferSize

        **int QGLFormat::alphaBufferSize() const**

        Returns the alpha buffer size.

        **See also** **alpha** (), **setAlpha** (), and **setAlphaBufferSize**
        ().
        """
        ...

    def setAlphaBufferSize(self, size: int) -> None:
        """
        https://doc.qt.io/qt-5/qglformat.html#setAlphaBufferSize

        **void QGLFormat::setAlphaBufferSize(int size )**

        Set the preferred alpha buffer size to **size**. This function
        implicitly enables the alpha channel.

        **See also** **setRedBufferSize** (), **setGreenBufferSize** (), and
        **alphaBufferSize** ().
        """
        ...

    def accumBufferSize(self) -> int:
        """
        https://doc.qt.io/qt-5/qglformat.html#accumBufferSize

        **int QGLFormat::accumBufferSize() const**

        Returns the accumulation buffer size.

        **See also** **setAccumBufferSize** (), **accum** (), and **setAccum**
        ().
        """
        ...

    def setAccumBufferSize(self, size: int) -> None:
        """
        https://doc.qt.io/qt-5/qglformat.html#setAccumBufferSize

        **void QGLFormat::setAccumBufferSize(int size )**

        Set the preferred accumulation buffer size, where **size** is the bit
        depth for each RGBA component.

        **See also** **accum** (), **setAccum** (), and **accumBufferSize** ().
        """
        ...

    def depthBufferSize(self) -> int:
        """
        https://doc.qt.io/qt-5/qglformat.html#depthBufferSize

        **int QGLFormat::depthBufferSize() const**

        Returns the depth buffer size.

        **See also** **depth** (), **setDepth** (), and **setDepthBufferSize**
        ().
        """
        ...

    def setDepthBufferSize(self, size: int) -> None:
        """
        https://doc.qt.io/qt-5/qglformat.html#setDepthBufferSize

        **void QGLFormat::setDepthBufferSize(int size )**

        Set the minimum depth buffer size to **size**.

        **See also** **depthBufferSize** (), **setDepth** (), and **depth** ().
        """
        ...
