"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
import PyQt5.sip
from PyQt5 import QtGui
from PyQt5 import QtCore
from PyQt5.QtOpenGL import *
from PyQt5 import sip


class QGLContext(PyQt5.sip.wrapper):
    """
    https://doc.qt.io/qt-5/qglcontext.html

    **Detailed Description**

    An OpenGL rendering context is a complete set of OpenGL state variables. The
    rendering context's **format**  is set in the constructor, but it can also
    be set later with **setFormat** (). The format options that are actually set
    are returned by **format** (); the options you asked for are returned by
    **requestedFormat** (). Note that after a QGLContext object has been
    constructed, the actual OpenGL context must be created by explicitly calling
    the **create** () function. The **makeCurrent** () function makes this
    context the current rendering context. You can make **no** context current
    using **doneCurrent** (). The **reset** () function will reset the context
    and make it invalid.

    You can examine properties of the context with, e.g. **isValid** (),
    **isSharing** (), **initialized** (), **windowCreated** () and
    **overlayTransparentColor** ().

    If you're using double buffering you can swap the screen contents with the
    off-screen buffer using **swapBuffers** ().

    Please note that QGLContext is not thread safe.
    """

    class BindOption(int):
        NoBindOption: QGLContext = ...
        InvertedYBindOption: QGLContext = ...
        MipmapBindOption: QGLContext = ...
        PremultipliedAlphaBindOption: QGLContext = ...
        LinearFilteringBindOption: QGLContext = ...
        DefaultBindOption: QGLContext = ...

    class BindOptions(sip.simplewrapper):
        @typing.overload
        def __init__(self) -> None:
            ...

        @typing.overload
        def __init__(
            self, f: typing.Union["QGLContext.BindOptions", "QGLContext.BindOption"]
        ) -> None:
            ...

        @typing.overload
        def __init__(self, a0: "QGLContext.BindOptions") -> None:
            ...

        def __hash__(self) -> int:
            ...

        def __bool__(self) -> int:
            ...

        def __invert__(self) -> "QGLContext.BindOptions":
            ...

        def __index__(self) -> int:
            ...

        def __int__(self) -> int:
            ...

    def __init__(self, format: QGLFormat) -> None:
        """
        https://doc.qt.io/qt-5/qglcontext.html#QGLContext-1

        **QGLContext::QGLContext(const QGLFormat & format )**

        Constructs an OpenGL context with the given **format** which specifies
        several display options for the context.

        If the underlying OpenGL/Window system cannot satisfy all the features
        requested in **format** , the nearest subset of features will be used.
        After creation, the **format** () method will return the actual format
        obtained.

        Note that after a QGLContext object has been constructed, **create** ()
        must be called explicitly to create the actual OpenGL context. The
        context will be **invalid**  if it was not possible to obtain a GL
        context at all.

        **See also** **format** () and **isValid** ().
        """
        ...

    def moveToThread(self, thread: QtCore.QThread) -> None:
        """
        https://doc.qt.io/qt-5/qglcontext.html#moveToThread

        **void QGLContext::moveToThread(QThread * thread )**

        Moves the **QGLContext**  to the given **thread**.

        Enables calling **swapBuffers** () and **makeCurrent** () on the context
        in the given thread.
        """
        ...

    @staticmethod
    def areSharing(context1: "QGLContext", context2: "QGLContext") -> bool:
        """
        https://doc.qt.io/qt-5/qglcontext.html#areSharing

        **[static] bool QGLContext::areSharing(const QGLContext * context1 ,
        const QGLContext * context2 )**

        Returns `true` if **context1** and **context2** are sharing their GL
        resources such as textures, shader programs, etc; otherwise returns
        `false`.

        This function was introduced in Qt 4.6.
        """
        ...

    def setInitialized(self, on: bool) -> None:
        """
        https://doc.qt.io/qt-5/qglcontext.html#setInitialized

        **[protected] void QGLContext::setInitialized(bool on )**

        If **on** is true the context has been initialized, i.e.
        QGLContext::setInitialized() has been called on it. If **on** is false
        the context has not been initialized.

        **See also** **initialized** ().
        """
        ...

    def initialized(self) -> bool:
        """
        https://doc.qt.io/qt-5/qglcontext.html#initialized

        **[protected] bool QGLContext::initialized() const**

        Returns `true` if this context has been initialized, i.e. if
        **QGLWidget::initializeGL** () has been performed on it; otherwise
        returns `false`.

        **See also** **setInitialized** ().
        """
        ...

    def setWindowCreated(self, on: bool) -> None:
        """
        https://doc.qt.io/qt-5/qglcontext.html#setWindowCreated

        **[protected] void QGLContext::setWindowCreated(bool on )**

        If **on** is true the context has had a window created for it. If **on**
        is false no window has been created for the context.

        **See also** **windowCreated** ().
        """
        ...

    def windowCreated(self) -> bool:
        """
        https://doc.qt.io/qt-5/qglcontext.html#windowCreated

        **[protected] bool QGLContext::windowCreated() const**

        Returns `true` if a window has been created for this context; otherwise
        returns `false`.

        **See also** **setWindowCreated** ().
        """
        ...

    def deviceIsPixmap(self) -> bool:
        """
        https://doc.qt.io/qt-5/qglcontext.html#deviceIsPixmap

        **[protected] bool QGLContext::deviceIsPixmap() const**

        Returns `true` if the paint device of this context is a pixmap;
        otherwise returns `false`.

        Since Qt 5 the paint device is never actually a pixmap. renderPixmap()
        is however still simulated using framebuffer objects and readbacks, and
        this function will return `true` in this case.
        """
        ...

    def chooseContext(self, shareContext: typing.Optional["QGLContext"] = ...) -> bool:
        """
        https://doc.qt.io/qt-5/qglcontext.html#chooseContext

        **[virtual protected] bool QGLContext::chooseContext(const QGLContext *
        shareContext = 0)**

        This semi-internal function is called by **create** (). It creates a
        system-dependent OpenGL handle that matches the **format** () of
        **shareContext** as closely as possible, returning true if successful or
        false if a suitable handle could not be found.

        On Windows, it calls the virtual function choosePixelFormat(), which
        finds a matching pixel format identifier. On X11, it calls the virtual
        function chooseVisual() which finds an appropriate X visual. On other
        platforms it may work differently.
        """
        ...

    @staticmethod
    def currentContext() -> "QGLContext":
        """
        https://doc.qt.io/qt-5/qglcontext.html#currentContext

        **[static] const QGLContext *QGLContext::currentContext()**

        Returns the current context, i.e. the context to which any OpenGL
        commands will currently be directed. Returns 0 if no context is current.

        **See also** **makeCurrent** ().
        """
        ...

    def overlayTransparentColor(self) -> QtGui.QColor:
        """
        https://doc.qt.io/qt-5/qglcontext.html#overlayTransparentColor

        **QColor QGLContext::overlayTransparentColor() const**

        If this context is a valid context in an overlay plane, returns the
        plane's transparent color. Otherwise returns an **invalid**  color.

        The returned color's **pixel**  value is the index of the transparent
        color in the colormap of the overlay plane. (Naturally, the color's RGB
        values are meaningless.)

        The returned **QColor**  object will generally work as expected only
        when passed as the argument to **QGLWidget::qglColor** () or
        **QGLWidget::qglClearColor** (). Under certain circumstances it can also
        be used to draw transparent graphics with a **QPainter** .
        """
        ...

    def device(self) -> QtGui.QPaintDevice:
        """
        https://doc.qt.io/qt-5/qglcontext.html#device

        **QPaintDevice *QGLContext::device() const**

        Returns the paint device set for this context.

        **See also** **QGLContext::QGLContext** ().
        """
        ...

    def getProcAddress(self, proc: str) -> PyQt5.sip.voidptr:
        """
        https://doc.qt.io/qt-5/qglcontext.html#getProcAddress

        **QFunctionPointer QGLContext::getProcAddress(const QString & proc )
        const**

        Returns a function pointer to the GL extension function passed in
        **proc**. `nullptr` is returned if a pointer to the function could not
        be obtained.
        """
        ...

    @staticmethod
    def textureCacheLimit() -> int:
        """
        https://doc.qt.io/qt-5/qglcontext.html#textureCacheLimit

        **[static] int QGLContext::textureCacheLimit()**

        Returns the current texture cache limit in kilobytes.

        **See also** **setTextureCacheLimit** ().
        """
        ...

    @staticmethod
    def setTextureCacheLimit(size: int) -> None:
        """
        https://doc.qt.io/qt-5/qglcontext.html#setTextureCacheLimit

        **[static] void QGLContext::setTextureCacheLimit(int size )**

        This function sets the limit for the texture cache to **size** ,
        expressed in kilobytes.

        By default, the cache limit is approximately 64 MB.

        **See also** **textureCacheLimit** ().
        """
        ...

    def deleteTexture(self, tx_id: int) -> None:
        """
        https://doc.qt.io/qt-5/qglcontext.html#deleteTexture

        **void QGLContext::deleteTexture(GLuint id )**

        Removes the texture identified by **id** from the texture cache, and
        calls glDeleteTextures() to delete the texture from the context.

        **See also** **bindTexture** ().
        """
        ...

    @typing.overload
    def drawTexture(
        self, target: QtCore.QRectF, textureId: int, textureTarget: int = ...
    ) -> None:
        """
        https://doc.qt.io/qt-5/qglcontext.html#drawTexture

        **void QGLContext::drawTexture(const QRectF & target , GLuint textureId
        , GLenum textureTarget = GL_TEXTURE_2D)**

        This function supports the following use cases:

        * On OpenGL and OpenGL ES 1.x it draws the given texture, **textureId**
        , to the given target rectangle, **target** , in OpenGL model space. The
        **textureTarget** should be a 2D texture target.
          * On OpenGL and
        OpenGL ES 2.x, if a painter is active, not inside a beginNativePainting
        / endNativePainting block, and uses the engine with type
        **QPaintEngine::OpenGL2** , the function will draw the given texture,
        **textureId** , to the given target rectangle, **target** , respecting
        the current painter state. This will let you draw a texture with the
        clip, transform, render hints, and composition mode set by the painter.
        Note that the texture target needs to be GL_TEXTURE_2D for this use
        case, and that this is the only supported use case under OpenGL ES 2.x.

        This function was introduced in Qt 4.4.
        """
        ...

    @typing.overload
    def drawTexture(
        self,
        point: typing.Union[QtCore.QPointF, QtCore.QPoint],
        textureId: int,
        textureTarget: int = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qglcontext.html#drawTexture-1

        **void QGLContext::drawTexture(const QPointF & point , GLuint textureId
        , GLenum textureTarget = GL_TEXTURE_2D)**

        This function supports the following use cases:

        * By default it draws the given texture, **textureId** , at the given
        **point** in OpenGL model space. The **textureTarget** should be a 2D
        texture target.
          * If a painter is active, not inside a
        beginNativePainting / endNativePainting block, and uses the engine with
        type **QPaintEngine::OpenGL2** , the function will draw the given
        texture, **textureId** , at the given **point** , respecting the current
        painter state. This will let you draw a texture with the clip,
        transform, render hints, and composition mode set by the painter. Note
        that the texture target needs to be GL_TEXTURE_2D for this use case.

        **Note:** This function is not supported under any version of OpenGL ES.

        This function was introduced in Qt 4.4.
        """
        ...

    @typing.overload
    def bindTexture(
        self, image: QtGui.QImage, target: int = ..., format: int = ...
    ) -> int:
        """
        https://doc.qt.io/qt-5/qglcontext.html#bindTexture

        **GLuint QGLContext::bindTexture(const QImage & image , GLenum target ,
        GLint format , QGLContext::BindOptions options )**

        Generates and binds a 2D GL texture to the current context, based on
        **image**. The generated texture id is returned and can be used in later
        `glBindTexture()` calls.

        The **target** parameter specifies the texture target. The default
        target is `GL_TEXTURE_2D`.

        The **format** parameter sets the internal format for the texture. The
        default format is `GL_RGBA`.

        The binding **options** are a set of options used to decide how to bind
        the texture to the context.

        The texture that is generated is cached, so multiple calls to
        bindTexture() with the same **QImage**  will return the same texture id.

        Note that we assume default values for the glPixelStore() and
        glPixelTransfer() parameters.

        This function was introduced in Qt 4.6.

        **See also** **deleteTexture** ().
        """
        ...

    @typing.overload
    def bindTexture(
        self, pixmap: QtGui.QPixmap, target: int = ..., format: int = ...
    ) -> int:
        """
        https://doc.qt.io/qt-5/qglcontext.html#bindTexture-1

        **GLuint QGLContext::bindTexture(const QPixmap & pixmap , GLenum target
        , GLint format , QGLContext::BindOptions options )**

        This is an overloaded function.

        Generates and binds a 2D GL texture to the current context, based on
        **pixmap**.

        This function was introduced in Qt 4.6.
        """
        ...

    @typing.overload
    def bindTexture(self, fileName: str) -> int:
        """
        https://doc.qt.io/qt-5/qglcontext.html#bindTexture-2

        **GLuint QGLContext::bindTexture(const QImage & image , GLenum target =
        GL_TEXTURE_2D, GLint format = GL_RGBA)**

        Generates and binds a 2D GL texture to the current context, based on
        **image**. The generated texture id is returned and can be used in later
        `glBindTexture()` calls.

        This is an overloaded function.
        """
        ...

    @typing.overload
    def bindTexture(
        self,
        image: QtGui.QImage,
        target: int,
        format: int,
        options: typing.Union["QGLContext.BindOptions", "QGLContext.BindOption"],
    ) -> int:
        """
        https://doc.qt.io/qt-5/qglcontext.html#bindTexture-3

        **GLuint QGLContext::bindTexture(const QPixmap & pixmap , GLenum target
        = GL_TEXTURE_2D, GLint format = GL_RGBA)**

        This is an overloaded function.

        Generates and binds a 2D GL texture based on **pixmap**.
        """
        ...

    @typing.overload
    def bindTexture(
        self,
        pixmap: QtGui.QPixmap,
        target: int,
        format: int,
        options: typing.Union["QGLContext.BindOptions", "QGLContext.BindOption"],
    ) -> int:
        """
        https://doc.qt.io/qt-5/qglcontext.html#bindTexture-4

        **GLuint QGLContext::bindTexture(const QString & fileName )**

        This is an overloaded function.

        Reads the compressed texture file **fileName** and generates a 2D GL
        texture from it.

        This function can load DirectDrawSurface (DDS) textures in the DXT1,
        DXT3 and DXT5 DDS formats if the `GL_ARB_texture_compression` and
        `GL_EXT_texture_compression_s3tc` extensions are supported.

        Since 4.6.1, textures in the ETC1 format can be loaded if the
        `GL_OES_compressed_ETC1_RGB8_texture` extension is supported and the
        ETC1 texture has been encapsulated in the PVR container format. Also,
        textures in the PVRTC2 and PVRTC4 formats can be loaded if the
        `GL_IMG_texture_compression_pvrtc` extension is supported.

        **See also** **deleteTexture** ().
        """
        ...

    def swapBuffers(self) -> None:
        """
        https://doc.qt.io/qt-5/qglcontext.html#swapBuffers

        **[virtual] void QGLContext::swapBuffers() const**

        Call this to finish a frame of OpenGL rendering, and make sure to call
        **makeCurrent** () again before issuing any further OpenGL commands, for
        example as part of a new frame.
        """
        ...

    def doneCurrent(self) -> None:
        """
        https://doc.qt.io/qt-5/qglcontext.html#doneCurrent

        **[virtual] void QGLContext::doneCurrent()**

        Makes no GL context the current context. Normally, you do not need to
        call this function; **QGLContext**  calls it as necessary.
        """
        ...

    def makeCurrent(self) -> None:
        """
        https://doc.qt.io/qt-5/qglcontext.html#makeCurrent

        **[virtual] void QGLContext::makeCurrent()**

        Makes this context the current OpenGL rendering context. All GL
        functions you call operate on this context until another context is made
        current.

        In some very rare cases the underlying call may fail. If this occurs an
        error message is output to stderr.

        If you call this from a thread other than the main UI thread, make sure
        you've first pushed the context to the relevant thread from the UI
        thread using **moveToThread** ().
        """
        ...

    def setFormat(self, format: QGLFormat) -> None:
        """
        https://doc.qt.io/qt-5/qglcontext.html#setFormat

        **void QGLContext::setFormat(const QGLFormat & format )**

        Sets a **format** for this context. The context is **reset** .

        Call **create** () to create a new GL context that tries to match the
        new format.

        **QGLContext**  *cx;
            //  ...
            **QGLFormat**  f;
        f.setStereo(true);
            cx->setFormat(f);
            if (!cx->create())
        exit(); // no OpenGL support, or cannot render on the specified
        paintdevice
            if (!cx->format().stereo())
                exit(); // could not
        create stereo context

        **See also** **format** (), **reset** (), and **create** ().
        """
        ...

    def requestedFormat(self) -> QGLFormat:
        """
        https://doc.qt.io/qt-5/qglcontext.html#requestedFormat

        **QGLFormat QGLContext::requestedFormat() const**

        Returns the frame buffer format that was originally requested in the
        constructor or **setFormat** ().

        **See also** **format** ().
        """
        ...

    def format(self) -> QGLFormat:
        """
        https://doc.qt.io/qt-5/qglcontext.html#format

        **QGLFormat QGLContext::format() const**

        Returns the frame buffer format that was obtained (this may be a subset
        of what was requested).

        **See also** **setFormat** () and **requestedFormat** ().
        """
        ...

    def reset(self) -> None:
        """
        https://doc.qt.io/qt-5/qglcontext.html#reset

        **void QGLContext::reset()**

        Resets the context and makes it invalid.

        **See also** **create** () and **isValid** ().
        """
        ...

    def isSharing(self) -> bool:
        """
        https://doc.qt.io/qt-5/qglcontext.html#isSharing

        **bool QGLContext::isSharing() const**

        Returns `true` if this context is sharing its GL context with another
        **QGLContext** , otherwise false is returned. Note that context sharing
        might not be supported between contexts with different formats.
        """
        ...

    def isValid(self) -> bool:
        """
        https://doc.qt.io/qt-5/qglcontext.html#isValid

        **bool QGLContext::isValid() const**

        Returns `true` if a GL rendering context has been successfully created;
        otherwise returns `false`.
        """
        ...

    def create(self, shareContext: typing.Optional["QGLContext"] = ...) -> bool:
        """
        https://doc.qt.io/qt-5/qglcontext.html#create

        **[virtual] bool QGLContext::create(const QGLContext * shareContext =
        nullptr)**

        Creates the GL context. Returns `true` if it was successful in creating
        a valid GL rendering context on the paint device specified in the
        constructor; otherwise returns `false` (i.e. the context is invalid).

        If the OpenGL implementation on your system does not support the
        requested version of OpenGL context, then **QGLContext**  will try to
        create the closest matching version. The actual created context
        properties can be queried using the QGLFormat returned by the **format**
        () function. For example, if you request a context that supports OpenGL
        4.3 Core profile but the driver and/or hardware only supports version
        3.2 Core profile contexts then you will get a 3.2 Core profile context.

        After successful creation, **format** () returns the set of features of
        the created GL rendering context.

        If **shareContext** points to a valid **QGLContext** , this method will
        try to establish OpenGL display list and texture object sharing between
        this context and the **shareContext**. Note that this may fail if the
        two contexts have different **formats** . Use **isSharing** () to see if
        sharing is in effect.

        **Warning:** Implementation note: initialization of C++ class members
        usually takes place in the class constructor. **QGLContext**  is an
        exception because it must be simple to customize. The virtual functions
        **chooseContext** () (and chooseVisual() for X11) can be reimplemented
        in a subclass to select a particular context. The problem is that
        virtual functions are not properly called during construction (even
        though this is correct C++) because C++ constructs class hierarchies
        from the bottom up. For this reason we need a create() function.

        **See also** **chooseContext** (), **format** (), and **isValid** ().
        """
        ...
