"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
import PyQt5.sip
from PyQt5 import QtCore
from PyQt5.QtNfc import *


class QQmlNdefRecord(QtCore.QObject):
    """
    https://doc.qt.io/qt-5/qqmlndefrecord.html

    **Detailed Description**

    The QQmlNdefRecord class is the base class for all **NdefRecord**  types in
    QML. To support a new NDEF record type in QML subclass this class and expose
    new properties, member functions and signals appropriate for the new record
    type. The following must be done to create a new NDEF record type in QML:

    * The subclass must have a **Q_OBJECT**  macro in its declaration.
      * The
    subclass must have an **invokable**  constructor that takes a
    **QNdefRecord**  and a **QObject**  pointer.
      * The subclass must be
    declared as an NDEF record by expanding the **Q_DECLARE_NDEFRECORD** ()
    macro in the implementation file of the subclass.
      * The subclass must be
    registered with QML.

    For example the declaration of such a class may look like the following.

    class QQmlNdefFooRecord : public **QQmlNdefRecord**
        {
            Q_OBJECT
    Q_PROPERTY(int foo READ foo WRITE setFoo NOTIFY fooChanged)

        public:
    explicit QQmlNdefFooRecord(**QObject**  *parent = 0);
            Q_INVOKABLE
    QQmlNdefFooRecord(const **QNdefRecord**  &record, **QObject**  *parent = 0);
    ~QQmlNdefFooRecord();

            int foo() const;
            void setFoo(int
    value);

        signals:
            void fooChanged();
        };

    Within the implementation file the **Q_DECLARE_NDEFRECORD** () macro is
    expanded:

    Q_DECLARE_NDEFRECORD(QQmlNdefFooRecord, **QNdefRecord** ::ExternalRtd,
    "com.example:f")

    Finially the application or plugin code calls qmlRegisterType():

    qmlRegisterType<QQmlNdefFooRecord>(uri, 1, 0, "NdefFooRecord");

    **See also** **NdefRecord** .
    """

    class TypeNameFormat(int):
        Empty: QQmlNdefRecord = ...
        NfcRtd: QQmlNdefRecord = ...
        Mime: QQmlNdefRecord = ...
        Uri: QQmlNdefRecord = ...
        ExternalRtd: QQmlNdefRecord = ...
        Unknown: QQmlNdefRecord = ...

    @typing.overload
    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qqmlndefrecord.html#QQmlNdefRecord

        **QQmlNdefRecord::QQmlNdefRecord(QObject * parent = nullptr)**

        Constructs a new empty QQmlNdefRecord with **parent**.
        """
        ...

    @typing.overload
    def __init__(
        self, record: QNdefRecord, parent: typing.Optional[QtCore.QObject] = ...
    ) -> None:
        """
        https://doc.qt.io/qt-5/qqmlndefrecord.html#QQmlNdefRecord-1

        **QQmlNdefRecord::QQmlNdefRecord(const QNdefRecord & record , QObject *
        parent = nullptr)**

        Constructs a new QQmlNdefRecord representing **record**. The parent of
        the newly constructed object will be set to **parent**.
        """
        ...

    def setRecord(self, record: QNdefRecord) -> None:
        """
        https://doc.qt.io/qt-5/qqmlndefrecord.html#setRecord

        **void QQmlNdefRecord::setRecord(const QNdefRecord & record )**

        Sets the record to **record**. If the record is set the
        **recordChanged** () signal will be emitted.

        **Note:** Setter function for property **record** .

        **See also** **record** ().
        """
        ...

    def record(self) -> QNdefRecord:
        """
        https://doc.qt.io/qt-5/qqmlndefrecord.html#record

        **QNdefRecord QQmlNdefRecord::record() const**

        Returns a copy of the record.

        **Note:** Getter function for property record.

        **See also** **setRecord** ().
        """
        ...

    def typeNameFormat(self) -> "QQmlNdefRecord.TypeNameFormat":
        """
        https://doc.qt.io/qt-5/qqmlndefrecord.html#typeNameFormat

        **QQmlNdefRecord::TypeNameFormat QQmlNdefRecord::typeNameFormat()
        const**

        Returns the type name format of the NDEF record.

        **Note:** Getter function for property typeNameFormat.

        **See also** **setTypeNameFormat** ().
        """
        ...

    def setTypeNameFormat(
        self, typeNameFormat: "QQmlNdefRecord.TypeNameFormat"
    ) -> None:
        """
        https://doc.qt.io/qt-5/qqmlndefrecord.html#setTypeNameFormat

        **void QQmlNdefRecord::setTypeNameFormat(QQmlNdefRecord::TypeNameFormat
        newTypeNameFormat )**

        Sets the type name format of the NDEF record to **newTypeNameFormat**.

        **Note:** Setter function for property **typeNameFormat** .

        **See also** **typeNameFormat** ().
        """
        ...

    def setType(self, t: str) -> None:
        """
        https://doc.qt.io/qt-5/qqmlndefrecord.html#setType

        **void QQmlNdefRecord::setType(const QString & newtype )**

        Sets the record type to **newtype** if it is not currently equal to
        **type** (); otherwise does nothing. If the record type is set the
        **typeChanged** () signal will be emitted.

        **Note:** Setter function for property **type** .

        **See also** **QNdefRecord::setType** () and **QNdefRecord::type** ().
        """
        ...

    def type(self) -> str:
        """
        https://doc.qt.io/qt-5/qqmlndefrecord.html#type

        **QString QQmlNdefRecord::type() const**

        Returns the type of the record.

        **Note:** Getter function for property type.

        **See also** **QNdefRecord::setType** () and **QNdefRecord::type** ().
        """
        ...

    @property
    def recordChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        ...

    @property
    def typeChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qqmlndefrecord.html#typeChanged

        **[signal] void QQmlNdefRecord::typeChanged()**

        This signal is emitted when the record type changes.

        **Note:** Notifier signal for property **type** .
        """
        ...

    @property
    def typeNameFormatChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        ...
