"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
import PyQt5.sip
from PyQt5 import QtCore
from PyQt5.QtNfc import *
from PyQt5 import sip


class QNearFieldShareManager(QtCore.QObject):
    """
    https://doc.qt.io/qt-5/qnearfieldsharemanager.html

    **Detailed Description**

    Applications can share NDEF data or file content using NFC technology by
    tapping two NFC-enabled devices together. The QNearFieldShareManager
    provides a high level entry point to access this functionality.

    The class allows both NDEF data and/or files to be shared between two
    devices by calling the **setShareModes** () method. This method specifies
    either an NDEF Data and/or a File transfer. The **targetDetected** () signal
    is emitted each time a share target is detected. A **QNearFieldShareTarget**
    pointer is passed with the signal, which can be used to share either an NDEF
    message or one or more files.

    The process of sharing files via NFC involves other underlying communication
    transports such as Bluetooth or Wi-Fi Direct. It is implementation specific
    how and what type of transports are used to perform file transfer. The
    overall time taken to transfer content depends on the maximum speed of the
    transport used. Note that the process of sharing NDEF message/data does not
    require the use of other transports outside NFC.

    If an error occurs, **shareError** () returns the error type.

    Platforms that do not support both NDEF data and file content sharing modes
    can return the supported subset in the **supportedShareModes** () method.
    Applications that call **setShareModes** () with an unsupported mode will
    receive an error signal with a **UnsupportedShareModeError** .

    Since sharing data over NFC is effectively a data pipe between two processes
    (one on the sender and one of the receiver), the application developer
    should only create a single instance of QNearFieldShareManager per
    application. This avoids the possibility that different parts of the same
    application attempt to all consume data transferred over NFC.
    """

    class ShareMode(int):
        NoShare: QNearFieldShareManager = ...
        NdefShare: QNearFieldShareManager = ...
        FileShare: QNearFieldShareManager = ...

    class ShareError(int):
        NoError: QNearFieldShareManager = ...
        UnknownError: QNearFieldShareManager = ...
        InvalidShareContentError: QNearFieldShareManager = ...
        ShareCanceledError: QNearFieldShareManager = ...
        ShareInterruptedError: QNearFieldShareManager = ...
        ShareRejectedError: QNearFieldShareManager = ...
        UnsupportedShareModeError: QNearFieldShareManager = ...
        ShareAlreadyInProgressError: QNearFieldShareManager = ...
        SharePermissionDeniedError: QNearFieldShareManager = ...

    class ShareModes(sip.simplewrapper):
        @typing.overload
        def __init__(self) -> None:
            ...

        @typing.overload
        def __init__(
            self,
            f: typing.Union[
                "QNearFieldShareManager.ShareModes", "QNearFieldShareManager.ShareMode"
            ],
        ) -> None:
            ...

        @typing.overload
        def __init__(self, a0: "QNearFieldShareManager.ShareModes") -> None:
            ...

        def __hash__(self) -> int:
            ...

        def __bool__(self) -> int:
            ...

        def __invert__(self) -> "QNearFieldShareManager.ShareModes":
            ...

        def __index__(self) -> int:
            ...

        def __int__(self) -> int:
            ...

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qnearfieldsharemanager.html#QNearFieldShareManage
        r

        **QNearFieldShareManager::QNearFieldShareManager(QObject * parent =
        nullptr)**

        Constructs a new near field share manager with **parent**.
        """
        ...

    def shareError(self) -> "QNearFieldShareManager.ShareError":
        """
        https://doc.qt.io/qt-5/qnearfieldsharemanager.html#shareError

        **QNearFieldShareManager::ShareError
        QNearFieldShareManager::shareError() const**

        Returns the error code of the error that occurred.
        """
        ...

    def shareModes(self) -> "QNearFieldShareManager.ShareModes":
        """
        https://doc.qt.io/qt-5/qnearfieldsharemanager.html#shareModes

        **QNearFieldShareManager::ShareModes
        QNearFieldShareManager::shareModes() const**

        Returns which shared modes are set.

        **See also** **setShareModes** ().
        """
        ...

    def setShareModes(
        self,
        modes: typing.Union[
            "QNearFieldShareManager.ShareModes", "QNearFieldShareManager.ShareMode"
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-5/qnearfieldsharemanager.html#setShareModes

        **void
        QNearFieldShareManager::setShareModes(QNearFieldShareManager::ShareModes
        mode )**

        Initializes the NFC share **mode** to detect a **QNearFieldShareTarget**
        for data and/or file sharing. Calls to this method will overwrite
        previous share modes.

        A **shareModesChanged** () signal will be emitted when share modes are
        different from previous modes. A **targetDetected** () signal will be
        emitted if a share target is detected.

        **See also** **shareModes** ().
        """
        ...

    @staticmethod
    def supportedShareModes() -> "QNearFieldShareManager.ShareModes":
        """
        https://doc.qt.io/qt-5/qnearfieldsharemanager.html#supportedShareModes

        **[static] QNearFieldShareManager::ShareModes
        QNearFieldShareManager::supportedShareModes()**

        Returns the shared modes supported by NFC.
        """
        ...

    @property
    def error(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qnearfieldsharemanager.html#error

        **[signal] void
        QNearFieldShareManager::error(QNearFieldShareManager::ShareError error
        )**

        This signal is emitted whenever an **error** occurs related to a share
        request.
        """
        ...

    @property
    def shareModesChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qnearfieldsharemanager.html#shareModesChanged

        **[signal] void QNearFieldShareManager::shareModesChanged(QNearFieldShar
        eManager::ShareModes modes )**

        This signal is emitted whenever the share **modes** are changed.
        """
        ...

    @property
    def targetDetected(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qnearfieldsharemanager.html#targetDetected

        **[signal] void
        QNearFieldShareManager::targetDetected(QNearFieldShareTarget *
        shareTarget )**

        This signal is emitted whenever a **shareTarget** is detected. The
        **shareTarget** instance is owned by **QNearFieldShareManager**  and
        must not be deleted by the application.
        """
        ...
