"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
from PyQt5 import QtCore
from PyQt5.QtNfc import *
from PyQt5 import sip


class QNdefRecord(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qndefrecord.html

    **Detailed Description**

    QNdefRecord and derived classes are used to parse the contents of **NDEF
    messages**  and create new NDEF messages.

    Use **typeNameFormat** () and **setTypeNameFormat** () to get and set the
    type name format of the NDEF record.

    Use **type** () and **setType** () to get and set the type of the NDEF
    record.

    Use **id** () and **setId** () to get and set the id of the NDEF record.

    Use **payload** () and **setPayload** () to get and set the NDEF record
    payload. **isEmpty** () can be used to test if the payload is empty.

    QNdefRecord is an implicitly shared class. This means you can efficiently
    convert between QNdefRecord and specialized record classes. The
    **isRecordType** () template function can be used to test if a conversion is
    possible. The following example shows how to test if a QNdefRecord is an NFC
    RTD Text record and extract the text information from it.

    if (record.isRecordType<**QNdefNfcTextRecord** >()) {
    **QNdefNfcTextRecord**  textRecord(record);

            **qDebug** () <<
    textRecord.text();
        }

    **Creating Specialized NDEF Record Classes**

    Specialized NDEF record classes can be easily created with the
    **Q_DECLARE_NDEF_RECORD** () and **Q_DECLARE_ISRECORDTYPE_FOR_NDEF_RECORD**
    () macros. The following example shows the class declaration of the
    hypothetical **example.com:f** record type that encapsulates a single int
    property foo.

    class ExampleComF : public **QNdefRecord**
        {
        public:
    Q_DECLARE_NDEF_RECORD(ExampleComF, **QNdefRecord** ::ExternalRtd,
    "example.com:f",
                                  **QByteArray** (sizeof(int),
    char(0)))

            int foo() const;
            void setFoo(int v);
        };
    Q_DECLARE_ISRECORDTYPE_FOR_NDEF_RECORD(ExampleComF, **QNdefRecord**
    ::ExternalRtd, "example.com:f")

    The developer only needs to provide implementations for the `foo()` and
    `setFoo()` functions that parse and set the contents of the NDEF record's
    payload.
    """

    class TypeNameFormat(int):
        Empty: QNdefRecord = ...
        NfcRtd: QNdefRecord = ...
        Mime: QNdefRecord = ...
        Uri: QNdefRecord = ...
        ExternalRtd: QNdefRecord = ...
        Unknown: QNdefRecord = ...

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qndefrecord.html#QNdefRecord

        **QNdefRecord::QNdefRecord()**

        Constructs a new empty NDEF record.
        """
        ...

    @typing.overload
    def __init__(self, other: "QNdefRecord") -> None:
        """
        https://doc.qt.io/qt-5/qndefrecord.html#QNdefRecord-1

        **QNdefRecord::QNdefRecord(const QNdefRecord & other )**

        Constructs a new NDEF record that is a copy of **other**.
        """
        ...

    def __hash__(self) -> int:
        ...

    def isEmpty(self) -> bool:
        """
        https://doc.qt.io/qt-5/qndefrecord.html#isEmpty

        **bool QNdefRecord::isEmpty() const**

        Returns true if the NDEF record contains an empty payload; otherwise
        return false.

        This is equivalent to calling `payload().isEmpty()`.
        """
        ...

    def payload(self) -> QtCore.QByteArray:
        """
        https://doc.qt.io/qt-5/qndefrecord.html#payload

        **QByteArray QNdefRecord::payload() const**

        Returns the payload of the NDEF record.

        **See also** **setPayload** ().
        """
        ...

    def setPayload(
        self, payload: typing.Union[QtCore.QByteArray, bytes, bytearray]
    ) -> None:
        """
        https://doc.qt.io/qt-5/qndefrecord.html#setPayload

        **void QNdefRecord::setPayload(const QByteArray & payload )**

        Sets the payload of the NDEF record to **payload**.

        **See also** **payload** ().
        """
        ...

    def id(self) -> QtCore.QByteArray:
        """
        https://doc.qt.io/qt-5/qndefrecord.html#id

        **QByteArray QNdefRecord::id() const**

        Returns the id of the NDEF record.

        **See also** **setId** ().
        """
        ...

    def setId(self, id: typing.Union[QtCore.QByteArray, bytes, bytearray]) -> None:
        """
        https://doc.qt.io/qt-5/qndefrecord.html#setId

        **void QNdefRecord::setId(const QByteArray & id )**

        Sets the id of the NDEF record to **id**.

        **See also** **id** ().
        """
        ...

    def type(self) -> QtCore.QByteArray:
        """
        https://doc.qt.io/qt-5/qndefrecord.html#type

        **QByteArray QNdefRecord::type() const**

        Returns the type of the NDEF record.

        **See also** **setType** ().
        """
        ...

    def setType(self, type: typing.Union[QtCore.QByteArray, bytes, bytearray]) -> None:
        """
        https://doc.qt.io/qt-5/qndefrecord.html#setType

        **void QNdefRecord::setType(const QByteArray & type )**

        Sets the type of the NDEF record to **type**.

        **See also** **type** ().
        """
        ...

    def typeNameFormat(self) -> "QNdefRecord.TypeNameFormat":
        """
        https://doc.qt.io/qt-5/qndefrecord.html#typeNameFormat

        **QNdefRecord::TypeNameFormat QNdefRecord::typeNameFormat() const**

        Returns the type name format of the NDEF record.

        **See also** **setTypeNameFormat** ().
        """
        ...

    def setTypeNameFormat(self, typeNameFormat: "QNdefRecord.TypeNameFormat") -> None:
        """
        https://doc.qt.io/qt-5/qndefrecord.html#setTypeNameFormat

        **void QNdefRecord::setTypeNameFormat(QNdefRecord::TypeNameFormat
        typeNameFormat )**

        Sets the type name format of the NDEF record to **typeNameFormat**.

        **See also** **typeNameFormat** ().
        """
        ...
