"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
from PyQt5 import QtCore
from PyQt5.QtNfc import *


class QNdefNfcUriRecord(QNdefRecord):
    """
    https://doc.qt.io/qt-5/qndefnfcurirecord.html

    **Detailed Description**

    RTD-URI encapsulates a URI.
    """

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qndefnfcurirecord.html#QNdefNfcUriRecord

        **QNdefNfcUriRecord::QNdefNfcUriRecord()**

        Constructs an empty NFC uri record.
        """
        ...

    @typing.overload
    def __init__(self, other: QNdefRecord) -> None:
        """
        https://doc.qt.io/qt-5/qndefnfcurirecord.html#QNdefNfcUriRecord-1

        **QNdefNfcUriRecord::QNdefNfcUriRecord(const QNdefRecord & other )**

        Constructs a new NFC uri record that is a copy of **other**.
        """
        ...

    @typing.overload
    def __init__(self, a0: "QNdefNfcUriRecord") -> None:
        """
        https://doc.qt.io/qt-5/qndefnfcurirecord.html#QNdefNfcUriRecord

        **QNdefNfcUriRecord::QNdefNfcUriRecord()**

        Constructs an empty NFC uri record.
        """
        ...

    def setUri(self, uri: QtCore.QUrl) -> None:
        """
        https://doc.qt.io/qt-5/qndefnfcurirecord.html#setUri

        **void QNdefNfcUriRecord::setUri(const QUrl & uri )**

        Sets the URI of this URI record to **uri**.

        **See also** **uri** ().
        """
        ...

    def uri(self) -> QtCore.QUrl:
        """
        https://doc.qt.io/qt-5/qndefnfcurirecord.html#uri

        **QUrl QNdefNfcUriRecord::uri() const**

        Returns the URI of this URI record.

        **See also** **setUri** ().
        """
        ...
