"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
from PyQt5.QtNfc import *


class QNdefNfcTextRecord(QNdefRecord):
    """
    https://doc.qt.io/qt-5/qndefnfctextrecord.html

    **Detailed Description**

    RTD-Text encapsulates a user displayable text record.
    """

    class Encoding(int):
        Utf8: QNdefNfcTextRecord = ...
        Utf16: QNdefNfcTextRecord = ...

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qndefnfctextrecord.html#QNdefNfcTextRecord

        **QNdefNfcTextRecord::QNdefNfcTextRecord()**

        Constructs an empty NFC text record of type **QNdefRecord::NfcRtd** .
        """
        ...

    @typing.overload
    def __init__(self, other: QNdefRecord) -> None:
        """
        https://doc.qt.io/qt-5/qndefnfctextrecord.html#QNdefNfcTextRecord-1

        **QNdefNfcTextRecord::QNdefNfcTextRecord(const QNdefRecord & other )**

        Constructs a new NFC text record that is a copy of **other**.
        """
        ...

    @typing.overload
    def __init__(self, a0: "QNdefNfcTextRecord") -> None:
        """
        https://doc.qt.io/qt-5/qndefnfctextrecord.html#QNdefNfcTextRecord

        **QNdefNfcTextRecord::QNdefNfcTextRecord()**

        Constructs an empty NFC text record of type **QNdefRecord::NfcRtd** .
        """
        ...

    def setEncoding(self, encoding: "QNdefNfcTextRecord.Encoding") -> None:
        """
        https://doc.qt.io/qt-5/qndefnfctextrecord.html#setEncoding

        **void QNdefNfcTextRecord::setEncoding(QNdefNfcTextRecord::Encoding
        encoding )**

        Sets the enconding of the contents to **encoding**.

        **See also** **encoding** ().
        """
        ...

    def encoding(self) -> "QNdefNfcTextRecord.Encoding":
        """
        https://doc.qt.io/qt-5/qndefnfctextrecord.html#encoding

        **QNdefNfcTextRecord::Encoding QNdefNfcTextRecord::encoding() const**

        Returns the encoding of the contents.

        **See also** **setEncoding** ().
        """
        ...

    def setText(self, text: str) -> None:
        """
        https://doc.qt.io/qt-5/qndefnfctextrecord.html#setText

        **void QNdefNfcTextRecord::setText(const QString text )**

        Sets the contents of the text record to **text**.

        **See also** **text** ().
        """
        ...

    def text(self) -> str:
        """
        https://doc.qt.io/qt-5/qndefnfctextrecord.html#text

        **QString QNdefNfcTextRecord::text() const**

        Returns the contents of the text record as a string.

        **See also** **setText** ().
        """
        ...

    def setLocale(self, locale: str) -> None:
        """
        https://doc.qt.io/qt-5/qndefnfctextrecord.html#setLocale

        **void QNdefNfcTextRecord::setLocale(const QString & locale )**

        Sets the locale of the text record to **locale**.

        **See also** **locale** ().
        """
        ...

    def locale(self) -> str:
        """
        https://doc.qt.io/qt-5/qndefnfctextrecord.html#locale

        **QString QNdefNfcTextRecord::locale() const**

        Returns the locale of the text record.

        **See also** **setLocale** ().
        """
        ...
