"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
from PyQt5 import QtCore
from PyQt5.QtNfc import *


class QNdefNfcSmartPosterRecord(QNdefRecord):
    """
    https://doc.qt.io/qt-5/qndefnfcsmartposterrecord.html

    **Detailed Description**

    RTD-SmartPoster encapsulates a Smart Poster.
    """

    class Action(int):
        UnspecifiedAction: QNdefNfcSmartPosterRecord = ...
        DoAction: QNdefNfcSmartPosterRecord = ...
        SaveAction: QNdefNfcSmartPosterRecord = ...
        EditAction: QNdefNfcSmartPosterRecord = ...

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qndefnfcsmartposterrecord.html#QNdefNfcSmartPoste
        rRecord

        **QNdefNfcSmartPosterRecord::QNdefNfcSmartPosterRecord()**

        Constructs a new empty smart poster.
        """
        ...

    @typing.overload
    def __init__(self, other: "QNdefNfcSmartPosterRecord") -> None:
        """
        https://doc.qt.io/qt-5/qndefnfcsmartposterrecord.html#QNdefNfcSmartPoste
        rRecord-1

        **QNdefNfcSmartPosterRecord::QNdefNfcSmartPosterRecord(const QNdefRecord
        & other )**

        Constructs a new smart poster that is a copy of **other**.
        """
        ...

    @typing.overload
    def __init__(self, other: QNdefRecord) -> None:
        """
        https://doc.qt.io/qt-5/qndefnfcsmartposterrecord.html#QNdefNfcSmartPoste
        rRecord-2

        **QNdefNfcSmartPosterRecord::QNdefNfcSmartPosterRecord(const
        QNdefNfcSmartPosterRecord & other )**

        Constructs a new smart poster that is a copy of **other**.
        """
        ...

    def setTypeInfo(
        self, type: typing.Union[QtCore.QByteArray, bytes, bytearray]
    ) -> None:
        """
        https://doc.qt.io/qt-5/qndefnfcsmartposterrecord.html#setTypeInfo

        **void QNdefNfcSmartPosterRecord::setTypeInfo(const QByteArray & type
        )**

        Sets the type record to **type**. **type** must be UTF-8 encoded and
        describes the type of the object referenced by **uri** ()

        **See also** **typeInfo** ().
        """
        ...

    def typeInfo(self) -> QtCore.QByteArray:
        """
        https://doc.qt.io/qt-5/qndefnfcsmartposterrecord.html#typeInfo

        **QByteArray QNdefNfcSmartPosterRecord::typeInfo() const**

        Returns the UTF-8 encoded MIME type that describes the type of the
        objects that can be reached via **uri** ().

        If the type is not known the return **QByteArray**  is empty.

        **See also** **setTypeInfo** () and **hasTypeInfo** ().
        """
        ...

    def setSize(self, size: int) -> None:
        """
        https://doc.qt.io/qt-5/qndefnfcsmartposterrecord.html#setSize

        **void QNdefNfcSmartPosterRecord::setSize(quint32 size )**

        Sets the record **size**. The value contains the size in bytes of the
        object that the URI refers to.

        **See also** **size** () and **hasSize** ().
        """
        ...

    def size(self) -> int:
        """
        https://doc.qt.io/qt-5/qndefnfcsmartposterrecord.html#size

        **quint32 QNdefNfcSmartPosterRecord::size() const**

        Returns the size from the size record if available; otherwise returns 0.

        The value is optional and contains the size in bytes of the object that
        the URI refers to. It may be used by the device to determine whether it
        can accommodate the object.

        **See also** **setSize** ().
        """
        ...

    def setIcons(self, icons: typing.Iterable[QNdefNfcIconRecord]) -> None:
        """
        https://doc.qt.io/qt-5/qndefnfcsmartposterrecord.html#setIcons

        **void QNdefNfcSmartPosterRecord::setIcons(const
        QList<QNdefNfcIconRecord> & icons )**

        Adds the icon record list **icons** to the smart poster. Any existing
        records are overwritten.

        **See also** **hasIcon** () and **icon** ().
        """
        ...

    @typing.overload
    def removeIcon(self, icon: QNdefNfcIconRecord) -> bool:
        """
        https://doc.qt.io/qt-5/qndefnfcsmartposterrecord.html#removeIcon

        **bool QNdefNfcSmartPosterRecord::removeIcon(const QNdefNfcIconRecord &
        icon )**

        Attempts to remove the icon record **icon** from the smart poster.
        Removes the record and returns true if the smart poster contains a
        matching record, otherwise false.
        """
        ...

    @typing.overload
    def removeIcon(
        self, type: typing.Union[QtCore.QByteArray, bytes, bytearray]
    ) -> bool:
        """
        https://doc.qt.io/qt-5/qndefnfcsmartposterrecord.html#removeIcon-1

        **bool QNdefNfcSmartPosterRecord::removeIcon(const QByteArray & type )**

        Attempts to remove the icon record with type **type** from the smart
        poster. Removes the record and returns true if the smart poster contains
        a matching record, otherwise false.
        """
        ...

    @typing.overload
    def addIcon(self, icon: QNdefNfcIconRecord) -> None:
        """
        https://doc.qt.io/qt-5/qndefnfcsmartposterrecord.html#addIcon

        **void QNdefNfcSmartPosterRecord::addIcon(const QNdefNfcIconRecord &
        icon )**

        Adds an icon record **icon** to the smart poster. If the smart poster
        already contains an icon record with the same type then the existing
        icon record is replaced.
        """
        ...

    @typing.overload
    def addIcon(
        self,
        type: typing.Union[QtCore.QByteArray, bytes, bytearray],
        data: typing.Union[QtCore.QByteArray, bytes, bytearray],
    ) -> None:
        """
        https://doc.qt.io/qt-5/qndefnfcsmartposterrecord.html#addIcon-1

        **void QNdefNfcSmartPosterRecord::addIcon(const QByteArray & type ,
        const QByteArray & data )**

        Adds an icon record with type **type** and data **data** to the smart
        poster. If the smart poster already contains an icon record with the
        same type then the existing icon record is replaced.
        """
        ...

    def iconRecords(self) -> typing.List[QNdefNfcIconRecord]:
        """
        https://doc.qt.io/qt-5/qndefnfcsmartposterrecord.html#iconRecords

        **QList<QNdefNfcIconRecord> QNdefNfcSmartPosterRecord::iconRecords()
        const**

        Returns a copy of all icon records inside the smart poster.
        """
        ...

    def iconRecord(self, index: int) -> QNdefNfcIconRecord:
        """
        https://doc.qt.io/qt-5/qndefnfcsmartposterrecord.html#iconRecord

        **QNdefNfcIconRecord QNdefNfcSmartPosterRecord::iconRecord(const int
        index ) const**

        Returns the icon record corresponding to the index **index** inside the
        smart poster, where **index** is a value between 0 and **iconCount** ()
        - 1. Values outside of this range return an empty record.
        """
        ...

    def icon(
        self, mimetype: typing.Union[QtCore.QByteArray, bytes, bytearray] = ...
    ) -> QtCore.QByteArray:
        """
        https://doc.qt.io/qt-5/qndefnfcsmartposterrecord.html#icon

        **QByteArray QNdefNfcSmartPosterRecord::icon(const QByteArray & mimetype
        = QByteArray()) const**

        Returns the associated icon record data if the smart poster contains an
        icon record with MIME type **mimetype**. If **mimetype** is omitted or
        empty then the first icon's record data is returned. In all other cases,
        an empty array is returned.
        """
        ...

    def iconCount(self) -> int:
        """
        https://doc.qt.io/qt-5/qndefnfcsmartposterrecord.html#iconCount

        **int QNdefNfcSmartPosterRecord::iconCount() const**

        Returns the number of icon records contained inside the smart poster.
        """
        ...

    def setAction(self, act: "QNdefNfcSmartPosterRecord.Action") -> None:
        """
        https://doc.qt.io/qt-5/qndefnfcsmartposterrecord.html#setAction

        **void
        QNdefNfcSmartPosterRecord::setAction(QNdefNfcSmartPosterRecord::Action
        act )**

        Sets the action record to **act**

        **See also** **action** ().
        """
        ...

    def action(self) -> "QNdefNfcSmartPosterRecord.Action":
        """
        https://doc.qt.io/qt-5/qndefnfcsmartposterrecord.html#action

        **QNdefNfcSmartPosterRecord::Action QNdefNfcSmartPosterRecord::action()
        const**

        Returns the action from the action record if available. Otherwise
        **UnspecifiedAction**  is returned.

        **See also** **setAction** ().
        """
        ...

    @typing.overload
    def setUri(self, url: "QNdefNfcUriRecord") -> None:
        """
        https://doc.qt.io/qt-5/qndefnfcsmartposterrecord.html#setUri

        **void QNdefNfcSmartPosterRecord::setUri(const QNdefNfcUriRecord & url
        )**

        Sets the URI record to **url**

        **See also** **uri** ().
        """
        ...

    @typing.overload
    def setUri(self, url: QtCore.QUrl) -> None:
        """
        https://doc.qt.io/qt-5/qndefnfcsmartposterrecord.html#setUri-1

        **void QNdefNfcSmartPosterRecord::setUri(const QUrl & url )**

        Constructs a URI record and sets its content inside the smart poster to
        **url**
        """
        ...

    def uriRecord(self) -> "QNdefNfcUriRecord":
        """
        https://doc.qt.io/qt-5/qndefnfcsmartposterrecord.html#uriRecord

        **QNdefNfcUriRecord QNdefNfcSmartPosterRecord::uriRecord() const**

        Returns the smart poster's URI record if set. Otherwise an empty URI is
        returned.
        """
        ...

    def uri(self) -> QtCore.QUrl:
        """
        https://doc.qt.io/qt-5/qndefnfcsmartposterrecord.html#uri

        **QUrl QNdefNfcSmartPosterRecord::uri() const**

        Returns the URI from the smart poster's URI record if set. Otherwise an
        empty URI is returned.

        **See also** **setUri** ().
        """
        ...

    def setTitles(self, titles: typing.Iterable["QNdefNfcTextRecord"]) -> None:
        """
        https://doc.qt.io/qt-5/qndefnfcsmartposterrecord.html#setTitles

        **void QNdefNfcSmartPosterRecord::setTitles(const
        QList<QNdefNfcTextRecord> & titles )**

        Adds the title record list **titles** to the smart poster. Any existing
        records are overwritten.
        """
        ...

    @typing.overload
    def removeTitle(self, text: "QNdefNfcTextRecord") -> bool:
        """
        https://doc.qt.io/qt-5/qndefnfcsmartposterrecord.html#removeTitle

        **bool QNdefNfcSmartPosterRecord::removeTitle(const QNdefNfcTextRecord &
        text )**

        Attempts to remove the title record **text** from the smart poster.
        Removes the record and returns true if the smart poster contains a
        matching record, otherwise false.
        """
        ...

    @typing.overload
    def removeTitle(self, locale: str) -> bool:
        """
        https://doc.qt.io/qt-5/qndefnfcsmartposterrecord.html#removeTitle-1

        **bool QNdefNfcSmartPosterRecord::removeTitle(const QString & locale )**

        Attempts to remove a title record with locale **locale** from the smart
        poster. Removes the record and returns true if the smart poster contains
        a matching record, otherwise false.
        """
        ...

    @typing.overload
    def addTitle(self, text: "QNdefNfcTextRecord") -> bool:
        """
        https://doc.qt.io/qt-5/qndefnfcsmartposterrecord.html#addTitle

        **bool QNdefNfcSmartPosterRecord::addTitle(const QNdefNfcTextRecord &
        text )**

        Attempts to add a title record **text** to the smart poster. If the
        smart poster does not already contain a title record with the same
        locale as title record **text** , then the title record is added and the
        function returns true. Otherwise false is returned.
        """
        ...

    @typing.overload
    def addTitle(
        self, text: str, locale: str, encoding: "QNdefNfcTextRecord.Encoding"
    ) -> bool:
        """
        https://doc.qt.io/qt-5/qndefnfcsmartposterrecord.html#addTitle-1

        **bool QNdefNfcSmartPosterRecord::addTitle(const QString & text , const
        QString & locale , QNdefNfcTextRecord::Encoding encoding )**

        Attempts to add a new title record with title **text** , locale
        **locale** and encoding **encoding**. If the smart poster does not
        already contain a title record with locale **locale** , then the title
        record is added and the function returns true. Otherwise false is
        returned.
        """
        ...

    def titleRecords(self) -> typing.List["QNdefNfcTextRecord"]:
        """
        https://doc.qt.io/qt-5/qndefnfcsmartposterrecord.html#titleRecords

        **QList<QNdefNfcTextRecord> QNdefNfcSmartPosterRecord::titleRecords()
        const**

        Returns a copy of all title records inside the smart poster.
        """
        ...

    def titleRecord(self, index: int) -> "QNdefNfcTextRecord":
        """
        https://doc.qt.io/qt-5/qndefnfcsmartposterrecord.html#titleRecord

        **QNdefNfcTextRecord QNdefNfcSmartPosterRecord::titleRecord(const int
        index ) const**

        Returns the title record corresponding to the index **index** inside the
        smart poster, where **index** is a value between 0 and **titleCount** ()
        - 1. Values outside of this range return an empty record.
        """
        ...

    def title(self, locale: str = ...) -> str:
        """
        https://doc.qt.io/qt-5/qndefnfcsmartposterrecord.html#title

        **QString QNdefNfcSmartPosterRecord::title(const QString & locale =
        QString()) const**

        Returns the title record text associated with locale **locale** if
        available. If **locale** is empty then the title text of the first
        available record is returned. In all other cases an empty string is
        returned.
        """
        ...

    def titleCount(self) -> int:
        """
        https://doc.qt.io/qt-5/qndefnfcsmartposterrecord.html#titleCount

        **int QNdefNfcSmartPosterRecord::titleCount() const**

        Returns the number of title records contained inside the smart poster.
        """
        ...

    def hasTypeInfo(self) -> bool:
        """
        https://doc.qt.io/qt-5/qndefnfcsmartposterrecord.html#hasTypeInfo

        **bool QNdefNfcSmartPosterRecord::hasTypeInfo() const**

        Returns true if the smart poster contains a type record, otherwise
        false.
        """
        ...

    def hasSize(self) -> bool:
        """
        https://doc.qt.io/qt-5/qndefnfcsmartposterrecord.html#hasSize

        **bool QNdefNfcSmartPosterRecord::hasSize() const**

        Returns true if the smart poster contains a size record, otherwise
        false.
        """
        ...

    def hasIcon(
        self, mimetype: typing.Union[QtCore.QByteArray, bytes, bytearray] = ...
    ) -> bool:
        """
        https://doc.qt.io/qt-5/qndefnfcsmartposterrecord.html#hasIcon

        **bool QNdefNfcSmartPosterRecord::hasIcon(const QByteArray & mimetype =
        QByteArray()) const**

        Returns true if the smart poster contains an icon record using type
        **mimetype**. If **mimetype** is empty then true is returned if the
        smart poster contains at least one icon record. In all other cases false
        is returned.
        """
        ...

    def hasAction(self) -> bool:
        """
        https://doc.qt.io/qt-5/qndefnfcsmartposterrecord.html#hasAction

        **bool QNdefNfcSmartPosterRecord::hasAction() const**

        Returns true if the smart poster contains an action record, otherwise
        false.
        """
        ...

    def hasTitle(self, locale: str = ...) -> bool:
        """
        https://doc.qt.io/qt-5/qndefnfcsmartposterrecord.html#hasTitle

        **bool QNdefNfcSmartPosterRecord::hasTitle(const QString & locale =
        QString()) const**

        Returns true if the smart poster contains a title record using locale
        **locale**. If **locale** is empty then true is returned if the smart
        poster contains at least one title record. In all cases false is
        returned.
        """
        ...

    def setPayload(
        self, payload: typing.Union[QtCore.QByteArray, bytes, bytearray]
    ) -> None:
        ...
