"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
from PyQt5 import QtCore
from PyQt5.QtNetwork import *


class QUdpSocket(QAbstractSocket):
    """
    https://doc.qt.io/qt-5/qudpsocket.html

    **Detailed Description**

    UDP (User Datagram Protocol) is a lightweight, unreliable, datagram-
    oriented, connectionless protocol. It can be used when reliability isn't
    important. QUdpSocket is a subclass of **QAbstractSocket**  that allows you
    to send and receive UDP datagrams.

    The most common way to use this class is to bind to an address and port
    using **bind** (), then call **writeDatagram** () and **readDatagram** () /
    **receiveDatagram** () to transfer data. If you want to use the standard
    **QIODevice**  functions **read** (), **readLine** (), **write** (), etc.,
    you must first connect the socket directly to a peer by calling
    **connectToHost** ().

    The socket emits the **bytesWritten** () signal every time a datagram is
    written to the network. If you just want to send datagrams, you don't need
    to call **bind** ().

    The **readyRead** () signal is emitted whenever datagrams arrive. In that
    case, **hasPendingDatagrams** () returns `true`. Call
    **pendingDatagramSize** () to obtain the size of the first pending datagram,
    and **readDatagram** () or **receiveDatagram** () to read it.

    **Note:** An incoming datagram should be read when you receive the
    **readyRead** () signal, otherwise this signal will not be emitted for the
    next datagram.

    Example:

    void Server::initSocket()
        {
            udpSocket = new **QUdpSocket**
    (this);
            udpSocket->bind(**QHostAddress** ::LocalHost, 7755);
    connect(udpSocket, &**QUdpSocket** ::readyRead,
                    this,
    &Server::readPendingDatagrams);
        }

        void
    Server::readPendingDatagrams()
        {
            while
    (udpSocket->hasPendingDatagrams()) {
                **QNetworkDatagram**
    datagram = udpSocket->receiveDatagram();
    processTheDatagram(datagram);
            }
        }

    QUdpSocket also supports UDP multicast. Use **joinMulticastGroup** () and
    **leaveMulticastGroup** () to control group membership, and
    **QAbstractSocket::MulticastTtlOption**  and
    **QAbstractSocket::MulticastLoopbackOption**  to set the TTL and loopback
    socket options. Use **setMulticastInterface** () to control the outgoing
    interface for multicast datagrams, and **multicastInterface** () to query
    it.

    With QUdpSocket, you can also establish a virtual connection to a UDP server
    using **connectToHost** () and then use **read** () and **write** () to
    exchange datagrams without specifying the receiver for each datagram.

    The **Broadcast Sender** , **Broadcast Receiver** , **Multicast Sender** ,
    and **Multicast Receiver**  examples illustrate how to use QUdpSocket in
    applications.

    **See also** **QTcpSocket**  and **QNetworkDatagram** .
    """

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qudpsocket.html#QUdpSocket

        **QUdpSocket::QUdpSocket(QObject * parent = nullptr)**

        Creates a QUdpSocket object.

        **parent** is passed to the **QObject**  constructor.

        **See also** **socketType** ().
        """
        ...

    def receiveDatagram(self, maxSize: int = ...) -> QNetworkDatagram:
        """
        https://doc.qt.io/qt-5/qudpsocket.html#receiveDatagram

        **QNetworkDatagram QUdpSocket::receiveDatagram(qint64 maxSize = -1)**

        Receives a datagram no larger than **maxSize** bytes and returns it in
        the **QNetworkDatagram**  object, along with the sender's host address
        and port. If possible, this function will also try to determine the
        datagram's destination address, port, and the number of hop counts at
        reception time.

        On failure, returns a **QNetworkDatagram**  that reports **not valid** .

        If **maxSize** is too small, the rest of the datagram will be lost. If
        **maxSize** is 0, the datagram will be discarded. If **maxSize** is -1
        (the default), this function will attempt to read the entire datagram.

        This function was introduced in Qt 5.8.

        **See also** **writeDatagram** (), **hasPendingDatagrams** (), and
        **pendingDatagramSize** ().
        """
        ...

    def setMulticastInterface(self, iface: QNetworkInterface) -> None:
        """
        https://doc.qt.io/qt-5/qudpsocket.html#setMulticastInterface

        **void QUdpSocket::setMulticastInterface(const QNetworkInterface & iface
        )**

        Sets the outgoing interface for multicast datagrams to the interface
        **iface**. This corresponds to the IP_MULTICAST_IF socket option for
        IPv4 sockets and the IPV6_MULTICAST_IF socket option for IPv6 sockets.
        The socket must be in **BoundState** , otherwise this function does
        nothing.

        This function was introduced in Qt 4.8.

        **See also** **multicastInterface** (), **joinMulticastGroup** (), and
        **leaveMulticastGroup** ().
        """
        ...

    def multicastInterface(self) -> QNetworkInterface:
        """
        https://doc.qt.io/qt-5/qudpsocket.html#multicastInterface

        **QNetworkInterface QUdpSocket::multicastInterface() const**

        Returns the interface for the outgoing interface for multicast
        datagrams. This corresponds to the IP_MULTICAST_IF socket option for
        IPv4 sockets and the IPV6_MULTICAST_IF socket option for IPv6 sockets.
        If no interface has been previously set, this function returns an
        invalid **QNetworkInterface** . The socket must be in **BoundState** ,
        otherwise an invalid **QNetworkInterface**  is returned.

        This function was introduced in Qt 4.8.

        **See also** **setMulticastInterface** ().
        """
        ...

    @typing.overload
    def leaveMulticastGroup(
        self, groupAddress: typing.Union[QHostAddress, QHostAddress.SpecialAddress]
    ) -> bool:
        """
        https://doc.qt.io/qt-5/qudpsocket.html#leaveMulticastGroup

        **bool QUdpSocket::leaveMulticastGroup(const QHostAddress & groupAddress
        )**

        Leaves the multicast group specified by **groupAddress** on the default
        interface chosen by the operating system. The socket must be in
        **BoundState** , otherwise an error occurs.

        This function returns `true` if successful; otherwise it returns `false`
        and sets the socket error accordingly.

        **Note:** This function should be called with the same arguments as were
        passed to **joinMulticastGroup** ().

        This function was introduced in Qt 4.8.

        **See also** **joinMulticastGroup** ().
        """
        ...

    @typing.overload
    def leaveMulticastGroup(
        self,
        groupAddress: typing.Union[QHostAddress, QHostAddress.SpecialAddress],
        iface: QNetworkInterface,
    ) -> bool:
        """
        https://doc.qt.io/qt-5/qudpsocket.html#leaveMulticastGroup-1

        **bool QUdpSocket::leaveMulticastGroup(const QHostAddress & groupAddress
        , const QNetworkInterface & iface )**

        This is an overloaded function.

        Leaves the multicast group specified by **groupAddress** on the
        interface **iface**.

        **Note:** This function should be called with the same arguments as were
        passed to **joinMulticastGroup** ().

        This function was introduced in Qt 4.8.

        **See also** **joinMulticastGroup** ().
        """
        ...

    @typing.overload
    def joinMulticastGroup(
        self, groupAddress: typing.Union[QHostAddress, QHostAddress.SpecialAddress]
    ) -> bool:
        """
        https://doc.qt.io/qt-5/qudpsocket.html#joinMulticastGroup

        **bool QUdpSocket::joinMulticastGroup(const QHostAddress & groupAddress
        )**

        Joins the multicast group specified by **groupAddress** on the default
        interface chosen by the operating system. The socket must be in
        **BoundState** , otherwise an error occurs.

        Note that if you are attempting to join an IPv4 group, your socket must
        not be bound using IPv6 (or in dual mode, using **QHostAddress::Any** ).
        You must use **QHostAddress::AnyIPv4**  instead.

        This function returns `true` if successful; otherwise it returns `false`
        and sets the socket error accordingly.

        **Note:** Joining IPv6 multicast groups without an interface selection
        is not supported in all operating systems. Consider using the overload
        where the interface is specified.

        This function was introduced in Qt 4.8.

        **See also** **leaveMulticastGroup** ().
        """
        ...

    @typing.overload
    def joinMulticastGroup(
        self,
        groupAddress: typing.Union[QHostAddress, QHostAddress.SpecialAddress],
        iface: QNetworkInterface,
    ) -> bool:
        """
        https://doc.qt.io/qt-5/qudpsocket.html#joinMulticastGroup-1

        **bool QUdpSocket::joinMulticastGroup(const QHostAddress & groupAddress
        , const QNetworkInterface & iface )**

        This is an overloaded function.

        Joins the multicast group address **groupAddress** on the interface
        **iface**.

        This function was introduced in Qt 4.8.

        **See also** **leaveMulticastGroup** ().
        """
        ...

    @typing.overload
    def writeDatagram(
        self,
        data: bytes,
        host: typing.Union[QHostAddress, QHostAddress.SpecialAddress],
        port: int,
    ) -> int:
        """
        https://doc.qt.io/qt-5/qudpsocket.html#writeDatagram

        **qint64 QUdpSocket::writeDatagram(const char * data , qint64 size ,
        const QHostAddress & address , quint16 port )**

        Sends the datagram at **data** of size **size** to the host address
        **address** at port **port**. Returns the number of bytes sent on
        success; otherwise returns -1.

        Datagrams are always written as one block. The maximum size of a
        datagram is highly platform-dependent, but can be as low as 8192 bytes.
        If the datagram is too large, this function will return -1 and **error**
        () will return **DatagramTooLargeError** .

        Sending datagrams larger than 512 bytes is in general disadvised, as
        even if they are sent successfully, they are likely to be fragmented by
        the IP layer before arriving at their final destination.

        **Warning:** Calling this function on a connected UDP socket may result
        in an error and no packet being sent. If you are using a connected
        socket, use **write** () to send datagrams.

        **See also** **readDatagram** () and **write** ().
        """
        ...

    @typing.overload
    def writeDatagram(
        self,
        datagram: typing.Union[QtCore.QByteArray, bytes, bytearray],
        host: typing.Union[QHostAddress, QHostAddress.SpecialAddress],
        port: int,
    ) -> int:
        """
        https://doc.qt.io/qt-5/qudpsocket.html#writeDatagram-1

        **qint64 QUdpSocket::writeDatagram(const QNetworkDatagram & datagram )**

        This is an overloaded function.

        Sends the datagram **datagram** to the host address and port numbers
        contained in **datagram** , using the network interface and hop count
        limits also set there. If the destination address and port numbers are
        unset, this function will send to the address that was passed to
        **connectToHost** ().

        If the destination address is IPv6 with a non-empty **scope id**  but
        differs from the interface index in **datagram** , it is undefined which
        interface the operating system will choose to send on.

        The function returns the number of bytes sent if it succeeded or -1 if
        it encountered an error.

        **Warning:** Calling this function on a connected UDP socket may result
        in an error and no packet being sent. If you are using a connected
        socket, use **write** () to send datagrams.

        This function was introduced in Qt 5.8.

        **See also** **QNetworkDatagram::setDestination** (),
        **QNetworkDatagram::setHopLimit** (), and
        **QNetworkDatagram::setInterfaceIndex** ().
        """
        ...

    @typing.overload
    def writeDatagram(self, datagram: QNetworkDatagram) -> int:
        """
        https://doc.qt.io/qt-5/qudpsocket.html#writeDatagram-2

        **qint64 QUdpSocket::writeDatagram(const QByteArray & datagram , const
        QHostAddress & host , quint16 port )**

        This is an overloaded function.

        Sends the datagram **datagram** to the host address **host** and at port
        **port**.

        The function returns the number of bytes sent if it succeeded or -1 if
        it encountered an error.
        """
        ...

    def readDatagram(self, maxlen: int) -> typing.Tuple[bytes, QHostAddress, int]:
        """
        https://doc.qt.io/qt-5/qudpsocket.html#readDatagram

        **qint64 QUdpSocket::readDatagram(char * data , qint64 maxSize ,
        QHostAddress * address = nullptr, quint16 * port = nullptr)**

        Receives a datagram no larger than **maxSize** bytes and stores it in
        **data**. The sender's host address and port is stored in * **address**
        and * **port** (unless the pointers are `nullptr`).

        Returns the size of the datagram on success; otherwise returns -1.

        If **maxSize** is too small, the rest of the datagram will be lost. To
        avoid loss of data, call **pendingDatagramSize** () to determine the
        size of the pending datagram before attempting to read it. If
        **maxSize** is 0, the datagram will be discarded.

        **See also** **writeDatagram** (), **hasPendingDatagrams** (), and
        **pendingDatagramSize** ().
        """
        ...

    def pendingDatagramSize(self) -> int:
        """
        https://doc.qt.io/qt-5/qudpsocket.html#pendingDatagramSize

        **qint64 QUdpSocket::pendingDatagramSize() const**

        Returns the size of the first pending UDP datagram. If there is no
        datagram available, this function returns -1.

        **See also** **hasPendingDatagrams** () and **readDatagram** ().
        """
        ...

    def hasPendingDatagrams(self) -> bool:
        """
        https://doc.qt.io/qt-5/qudpsocket.html#hasPendingDatagrams

        **bool QUdpSocket::hasPendingDatagrams() const**

        Returns `true` if at least one datagram is waiting to be read; otherwise
        returns `false`.

        **See also** **pendingDatagramSize** () and **readDatagram** ().
        """
        ...
