"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
from PyQt5 import QtCore
from PyQt5 import sip


class QSslPreSharedKeyAuthenticator(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qsslpresharedkeyauthenticator.html

    **Detailed Description**

    The QSslPreSharedKeyAuthenticator class is used by an SSL socket to provide
    the required authentication data in a pre shared key (PSK) ciphersuite.

    In a PSK handshake, the client must derive a key, which must match the key
    set on the server. The exact algorithm of deriving the key depends on the
    application; however, for this purpose, the server may send an **identity
    hint** to the client. This hint, combined with other information (for
    instance a passphrase), is then used by the client to construct the shared
    key.

    The QSslPreSharedKeyAuthenticator provides means to client applications for
    completing the PSK handshake. The client application needs to connect a slot
    to the **QSslSocket::preSharedKeyAuthenticationRequired** () signal:

    connect(socket, &**QSslSocket** ::preSharedKeyAuthenticationRequired,
    this, &AuthManager::handlePreSharedKeyAuthentication);

    The signal carries a QSslPreSharedKeyAuthenticator object containing the
    identity hint the server sent to the client, and which must be filled with
    the corresponding client identity and the derived key:

    void AuthManager::handlePreSharedKeyAuthentication(**QSslPreSharedKeyAuthent
    icator**  *authenticator)
            {
    authenticator->setIdentity("My Qt App");

                const
    **QByteArray**  key = deriveKey(authenticator->identityHint(), passphrase);
    authenticator->setPreSharedKey(key);
            }

    **Note:** PSK ciphersuites are supported only when using OpenSSL 1.0.1 (or
    greater) as the SSL backend.

    **Note:** PSK is currently only supported in OpenSSL.

    **See also** **QSslSocket** .
    """

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qsslpresharedkeyauthenticator.html#QSslPreSharedK
        eyAuthenticator

        **QSslPreSharedKeyAuthenticator::QSslPreSharedKeyAuthenticator()**

        Constructs a default QSslPreSharedKeyAuthenticator object.

        The identity hint, the identity and the key will be initialized to empty
        byte arrays; the maximum length for both the identity and the key will
        be initialized to 0.
        """
        ...

    @typing.overload
    def __init__(self, authenticator: "QSslPreSharedKeyAuthenticator") -> None:
        """
        https://doc.qt.io/qt-5/qsslpresharedkeyauthenticator.html#QSslPreSharedK
        eyAuthenticator-1

        **QSslPreSharedKeyAuthenticator::QSslPreSharedKeyAuthenticator(const
        QSslPreSharedKeyAuthenticator & authenticator )**

        Constructs a QSslPreSharedKeyAuthenticator object as a copy of
        **authenticator**.

        **See also** **operator=** ().
        """
        ...

    def maximumPreSharedKeyLength(self) -> int:
        """
        https://doc.qt.io/qt-5/qsslpresharedkeyauthenticator.html#maximumPreShar
        edKeyLength

        **int QSslPreSharedKeyAuthenticator::maximumPreSharedKeyLength() const**

        Returns the maximum length, in bytes, of the pre shared key.

        **Note:** it is possible to set a key whose length is greater than the
        maximumPreSharedKeyLength(); in this case, only the first
        maximumPreSharedKeyLength() bytes will be actually sent to the server.

        **See also** **setPreSharedKey** ().
        """
        ...

    def preSharedKey(self) -> QtCore.QByteArray:
        """
        https://doc.qt.io/qt-5/qsslpresharedkeyauthenticator.html#preSharedKey

        **QByteArray QSslPreSharedKeyAuthenticator::preSharedKey() const**

        Returns the pre shared key.

        **See also** **setPreSharedKey** ().
        """
        ...

    def setPreSharedKey(
        self, preSharedKey: typing.Union[QtCore.QByteArray, bytes, bytearray]
    ) -> None:
        """
        https://doc.qt.io/qt-5/qsslpresharedkeyauthenticator.html#setPreSharedKe
        y

        **void QSslPreSharedKeyAuthenticator::setPreSharedKey(const QByteArray &
        preSharedKey )**

        Sets the pre shared key to **preSharedKey**.

        **Note:** it is possible to set a key whose length is greater than the
        **maximumPreSharedKeyLength** (); in this case, only the first
        **maximumPreSharedKeyLength** () bytes will be actually sent to the
        server.

        **See also** **preSharedKey** (), **maximumPreSharedKeyLength** (), and
        **QByteArray::fromHex** ().
        """
        ...

    def maximumIdentityLength(self) -> int:
        """
        https://doc.qt.io/qt-5/qsslpresharedkeyauthenticator.html#maximumIdentit
        yLength

        **int QSslPreSharedKeyAuthenticator::maximumIdentityLength() const**

        Returns the maximum length, in bytes, of the PSK client identity.

        **Note:** it is possible to set an identity whose length is greater than
        maximumIdentityLength(); in this case, only the first
        maximumIdentityLength() bytes will be actually sent to the server.

        **See also** **setIdentity** ().
        """
        ...

    def identity(self) -> QtCore.QByteArray:
        """
        https://doc.qt.io/qt-5/qsslpresharedkeyauthenticator.html#identity

        **QByteArray QSslPreSharedKeyAuthenticator::identity() const**

        Returns the PSK client identity.

        **See also** **setIdentity** ().
        """
        ...

    def setIdentity(
        self, identity: typing.Union[QtCore.QByteArray, bytes, bytearray]
    ) -> None:
        """
        https://doc.qt.io/qt-5/qsslpresharedkeyauthenticator.html#setIdentity

        **void QSslPreSharedKeyAuthenticator::setIdentity(const QByteArray &
        identity )**

        Sets the PSK client identity (to be advised to the server) to
        **identity**.

        **Note:** it is possible to set an identity whose length is greater than
        **maximumIdentityLength** (); in this case, only the first
        **maximumIdentityLength** () bytes will be actually sent to the server.

        **See also** **identity** () and **maximumIdentityLength** ().
        """
        ...

    def identityHint(self) -> QtCore.QByteArray:
        """
        https://doc.qt.io/qt-5/qsslpresharedkeyauthenticator.html#identityHint

        **QByteArray QSslPreSharedKeyAuthenticator::identityHint() const**

        Returns the PSK identity hint as provided by the server. The
        interpretation of this hint is left to the application.
        """
        ...

    def swap(self, authenticator: "QSslPreSharedKeyAuthenticator") -> None:
        """
        https://doc.qt.io/qt-5/qsslpresharedkeyauthenticator.html#swap

        **void QSslPreSharedKeyAuthenticator::swap(QSslPreSharedKeyAuthenticator
        & authenticator )**

        Swaps the **QSslPreSharedKeyAuthenticator**  object **authenticator**
        with this object. This operation is very fast and never fails.
        """
        ...
