"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
import PyQt5.sip
from PyQt5 import QtCore
from PyQt5.QtNetwork import *
from PyQt5 import sip


class QSslKey(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qsslkey.html

    **Detailed Description**

    QSslKey provides a simple API for managing keys.

    **See also** **QSslSocket** , **QSslCertificate** , and **QSslCipher** .
    """

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qsslkey.html#QSslKey

        **QSslKey::QSslKey()**

        Constructs a null key.

        **See also** **isNull** ().
        """
        ...

    @typing.overload
    def __init__(
        self,
        encoded: typing.Union[QtCore.QByteArray, bytes, bytearray],
        algorithm: QSsl.KeyAlgorithm,
        encoding: QSsl.EncodingFormat = ...,
        type: QSsl.KeyType = ...,
        passPhrase: typing.Union[QtCore.QByteArray, bytes, bytearray] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qsslkey.html#QSslKey-1

        **QSslKey::QSslKey(const QByteArray & encoded , QSsl::KeyAlgorithm
        algorithm , QSsl::EncodingFormat encoding = QSsl::Pem, QSsl::KeyType
        type = QSsl::PrivateKey, const QByteArray & passPhrase = QByteArray())**

        Constructs a QSslKey by decoding the string in the byte array
        **encoded** using a specified **algorithm** and **encoding** format.
        **type** specifies whether the key is public or private.

        If the key is encrypted then **passPhrase** is used to decrypt it.

        After construction, use **isNull** () to check if **encoded** contained
        a valid key.
        """
        ...

    @typing.overload
    def __init__(
        self,
        device: QtCore.QIODevice,
        algorithm: QSsl.KeyAlgorithm,
        encoding: QSsl.EncodingFormat = ...,
        type: QSsl.KeyType = ...,
        passPhrase: typing.Union[QtCore.QByteArray, bytes, bytearray] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qsslkey.html#QSslKey-2

        **QSslKey::QSslKey(QIODevice * device , QSsl::KeyAlgorithm algorithm ,
        QSsl::EncodingFormat encoding = QSsl::Pem, QSsl::KeyType type =
        QSsl::PrivateKey, const QByteArray & passPhrase = QByteArray())**

        Constructs a QSslKey by reading and decoding data from a **device**
        using a specified **algorithm** and **encoding** format. **type**
        specifies whether the key is public or private.

        If the key is encrypted then **passPhrase** is used to decrypt it.

        After construction, use **isNull** () to check if **device** provided a
        valid key.
        """
        ...

    @typing.overload
    def __init__(self, handle: PyQt5.sip.voidptr, type: QSsl.KeyType = ...) -> None:
        """
        https://doc.qt.io/qt-5/qsslkey.html#QSslKey-3

        **QSslKey::QSslKey(Qt::HANDLE handle , QSsl::KeyType type =
        QSsl::PrivateKey)**

        Constructs a QSslKey from a valid native key **handle**. **type**
        specifies whether the key is public or private.

        QSslKey will take ownership for this key and you must not free the key
        using the native library.

        This function was introduced in Qt 5.0.
        """
        ...

    @typing.overload
    def __init__(self, other: "QSslKey") -> None:
        """
        https://doc.qt.io/qt-5/qsslkey.html#QSslKey-4

        **QSslKey::QSslKey(const QSslKey & other )**

        Constructs an identical copy of **other**.
        """
        ...

    def swap(self, other: "QSslKey") -> None:
        """
        https://doc.qt.io/qt-5/qsslkey.html#swap

        **void QSslKey::swap(QSslKey & other )**

        Swaps this ssl key with **other**. This function is very fast and never
        fails.

        This function was introduced in Qt 5.0.
        """
        ...

    def handle(self) -> PyQt5.sip.voidptr:
        """
        https://doc.qt.io/qt-5/qsslkey.html#handle

        **Qt::HANDLE QSslKey::handle() const**

        Returns a pointer to the native key handle, if there is one, else
        `nullptr`.

        You can use this handle together with the native API to access extended
        information about the key.

        **Warning:** Use of this function has a high probability of being non-
        portable, and its return value may vary across platforms, and between
        minor Qt releases.
        """
        ...

    def toDer(
        self, passPhrase: typing.Union[QtCore.QByteArray, bytes, bytearray] = ...
    ) -> QtCore.QByteArray:
        """
        https://doc.qt.io/qt-5/qsslkey.html#toDer

        **QByteArray QSslKey::toDer(const QByteArray & passPhrase =
        QByteArray()) const**

        Returns the key in DER encoding.

        The **passPhrase** argument should be omitted as DER cannot be
        encrypted. It will be removed in a future version of Qt.
        """
        ...

    def toPem(
        self, passPhrase: typing.Union[QtCore.QByteArray, bytes, bytearray] = ...
    ) -> QtCore.QByteArray:
        """
        https://doc.qt.io/qt-5/qsslkey.html#toPem

        **QByteArray QSslKey::toPem(const QByteArray & passPhrase =
        QByteArray()) const**

        Returns the key in PEM encoding. The result is encrypted with
        **passPhrase** if the key is a private key and **passPhrase** is non-
        empty.
        """
        ...

    def algorithm(self) -> QSsl.KeyAlgorithm:
        """
        https://doc.qt.io/qt-5/qsslkey.html#algorithm

        **QSsl::KeyAlgorithm QSslKey::algorithm() const**

        Returns the key algorithm.
        """
        ...

    def type(self) -> QSsl.KeyType:
        """
        https://doc.qt.io/qt-5/qsslkey.html#type

        **QSsl::KeyType QSslKey::type() const**

        Returns the type of the key (i.e., PublicKey or PrivateKey).
        """
        ...

    def length(self) -> int:
        """
        https://doc.qt.io/qt-5/qsslkey.html#length

        **int QSslKey::length() const**

        Returns the length of the key in bits, or -1 if the key is null.
        """
        ...

    def clear(self) -> None:
        """
        https://doc.qt.io/qt-5/qsslkey.html#clear

        **void QSslKey::clear()**

        Clears the contents of this key, making it a null key.

        **See also** **isNull** ().
        """
        ...

    def isNull(self) -> bool:
        """
        https://doc.qt.io/qt-5/qsslkey.html#isNull

        **bool QSslKey::isNull() const**

        Returns `true` if this is a null key; otherwise false.

        **See also** **clear** ().
        """
        ...
