"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
import PyQt5.sip
from PyQt5 import QtCore
from PyQt5.QtNetwork import *
from PyQt5 import sip


class QSslCertificate(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qsslcertificate.html

    **Detailed Description**

    QSslCertificate stores an X509 certificate, and is commonly used to verify
    the identity and store information about the local host, a remotely
    connected peer, or a trusted third party Certificate Authority.

    There are many ways to construct a QSslCertificate. The most common way is
    to call **QSslSocket::peerCertificate** (), which returns a QSslCertificate
    object, or **QSslSocket::peerCertificateChain** (), which returns a list of
    them. You can also load certificates from a DER (binary) or PEM (Base64)
    encoded bundle, typically stored as one or more local files, or in a Qt
    Resource.

    You can call **isNull** () to check if your certificate is null. By default,
    QSslCertificate constructs a null certificate. A null certificate is
    invalid, but an invalid certificate is not necessarily null. If you want to
    reset all contents in a certificate, call **clear** ().

    After loading a certificate, you can find information about the certificate,
    its subject, and its issuer, by calling one of the many accessor functions,
    including **version** (), **serialNumber** (), **issuerInfo** () and
    **subjectInfo** (). You can call **effectiveDate** () and **expiryDate** ()
    to check when the certificate starts being effective and when it expires.
    The **publicKey** () function returns the certificate subject's public key
    as a **QSslKey** . You can call **issuerInfo** () or **subjectInfo** () to
    get detailed information about the certificate issuer and its subject.

    Internally, QSslCertificate is stored as an X509 structure. You can access
    this handle by calling **handle** (), but the results are likely to not be
    portable.

    **See also** **QSslSocket** , **QSslKey** , **QSslCipher** , and
    **QSslError** .
    """

    class PatternSyntax(int):
        RegularExpression: QSslCertificate = ...
        Wildcard: QSslCertificate = ...
        FixedString: QSslCertificate = ...

    class SubjectInfo(int):
        Organization: QSslCertificate = ...
        CommonName: QSslCertificate = ...
        LocalityName: QSslCertificate = ...
        OrganizationalUnitName: QSslCertificate = ...
        CountryName: QSslCertificate = ...
        StateOrProvinceName: QSslCertificate = ...
        DistinguishedNameQualifier: QSslCertificate = ...
        SerialNumber: QSslCertificate = ...
        EmailAddress: QSslCertificate = ...

    @typing.overload
    def __init__(
        self, device: QtCore.QIODevice, format: QSsl.EncodingFormat = ...
    ) -> None:
        """
        https://doc.qt.io/qt-5/qsslcertificate.html#QSslCertificate

        **QSslCertificate::QSslCertificate(QIODevice * device ,
        QSsl::EncodingFormat format = QSsl::Pem)**

        Constructs a QSslCertificate by reading **format** encoded data from
        **device** and using the first certificate found. You can later call
        **isNull** () to see if **device** contained a certificate, and if this
        certificate was loaded successfully.
        """
        ...

    @typing.overload
    def __init__(
        self,
        data: typing.Union[QtCore.QByteArray, bytes, bytearray] = ...,
        format: QSsl.EncodingFormat = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qsslcertificate.html#QSslCertificate-1

        **QSslCertificate::QSslCertificate(const QByteArray & data =
        QByteArray(), QSsl::EncodingFormat format = QSsl::Pem)**

        Constructs a QSslCertificate by parsing the **format** encoded **data**
        and using the first available certificate found. You can later call
        **isNull** () to see if **data** contained a certificate, and if this
        certificate was loaded successfully.
        """
        ...

    @typing.overload
    def __init__(self, other: "QSslCertificate") -> None:
        """
        https://doc.qt.io/qt-5/qsslcertificate.html#QSslCertificate-2

        **QSslCertificate::QSslCertificate(const QSslCertificate & other )**

        Constructs an identical copy of **other**.
        """
        ...

    def subjectDisplayName(self) -> str:
        """
        https://doc.qt.io/qt-5/qsslcertificate.html#subjectDisplayName

        **QString QSslCertificate::subjectDisplayName() const**

        Returns a name that describes the subject. It returns the
        **QSslCertificate::CommonName**  if available, otherwise falls back to
        the first **QSslCertificate::Organization**  or the first
        **QSslCertificate::OrganizationalUnitName** .

        This function was introduced in Qt 5.12.

        **See also** **subjectInfo** ().
        """
        ...

    def issuerDisplayName(self) -> str:
        """
        https://doc.qt.io/qt-5/qsslcertificate.html#issuerDisplayName

        **QString QSslCertificate::issuerDisplayName() const**

        Returns a name that describes the issuer. It returns the
        **QSslCertificate::CommonName**  if available, otherwise falls back to
        the first **QSslCertificate::Organization**  or the first
        **QSslCertificate::OrganizationalUnitName** .

        This function was introduced in Qt 5.12.

        **See also** **issuerInfo** ().
        """
        ...

    @staticmethod
    def importPkcs12(
        device: QtCore.QIODevice,
        key: "QSslKey",
        certificate: "QSslCertificate",
        caCertificates: typing.Optional[typing.Iterable["QSslCertificate"]] = ...,
        passPhrase: typing.Union[QtCore.QByteArray, bytes, bytearray] = ...,
    ) -> bool:
        """
        https://doc.qt.io/qt-5/qsslcertificate.html#importPkcs12

        **[static] bool QSslCertificate::importPkcs12(QIODevice * device ,
        QSslKey * key , QSslCertificate * certificate , QList<QSslCertificate> *
        caCertificates = nullptr, const QByteArray & passPhrase =
        QByteArray())**

        Imports a PKCS#12 (pfx) file from the specified **device**. A PKCS#12
        file is a bundle that can contain a number of certificates and keys.
        This method reads a single **key** , its **certificate** and any
        associated **caCertificates** from the bundle. If a **passPhrase** is
        specified then this will be used to decrypt the bundle. Returns `true`
        if the PKCS#12 file was successfully loaded.

        **Note:** The **device** must be open and ready to be read from.

        This function was introduced in Qt 5.4.
        """
        ...

    def __hash__(self) -> int:
        ...

    def isSelfSigned(self) -> bool:
        """
        https://doc.qt.io/qt-5/qsslcertificate.html#isSelfSigned

        **bool QSslCertificate::isSelfSigned() const**

        Returns `true` if this certificate is self signed; otherwise returns
        `false`.

        A certificate is considered self-signed its issuer and subject are
        identical.

        This function was introduced in Qt 5.4.
        """
        ...

    @staticmethod
    def verify(
        certificateChain: typing.Iterable["QSslCertificate"], hostName: str = ...
    ) -> typing.List["QSslError"]:
        """
        https://doc.qt.io/qt-5/qsslcertificate.html#verify

        **[static] QList<QSslError>
        QSslCertificate::verify(QList<QSslCertificate> certificateChain , const
        QString & hostName = QString())**

        Verifies a certificate chain. The chain to be verified is passed in the
        **certificateChain** parameter. The first certificate in the list should
        be the leaf certificate of the chain to be verified. If **hostName** is
        specified then the certificate is also checked to see if it is valid for
        the specified host name.

        Note that the root (CA) certificate should not be included in the list
        to be verified, this will be looked up automatically either using the CA
        list specified by QSslSocket::defaultCaCertificates() or, if possible,
        it will be loaded on demand on Unix.

        This function was introduced in Qt 5.0.
        """
        ...

    def toText(self) -> str:
        """
        https://doc.qt.io/qt-5/qsslcertificate.html#toText

        **QString QSslCertificate::toText() const**

        Returns this certificate converted to a human-readable text
        representation.

        This function was introduced in Qt 5.0.
        """
        ...

    def extensions(self) -> typing.List["QSslCertificateExtension"]:
        """
        https://doc.qt.io/qt-5/qsslcertificate.html#extensions

        **QList<QSslCertificateExtension> QSslCertificate::extensions() const**

        Returns a list containing the X509 extensions of this certificate.

        This function was introduced in Qt 5.0.
        """
        ...

    def issuerInfoAttributes(self) -> typing.List[QtCore.QByteArray]:
        """
        https://doc.qt.io/qt-5/qsslcertificate.html#issuerInfoAttributes

        **QList<QByteArray> QSslCertificate::issuerInfoAttributes() const**

        Returns a list of the attributes that have values in the issuer
        information of this certificate. The information associated with a given
        attribute can be accessed using the **issuerInfo** () method. Note that
        this list may include the OIDs for any elements that are not known by
        the SSL backend.

        This function was introduced in Qt 5.0.

        **See also** **subjectInfo** ().
        """
        ...

    def subjectInfoAttributes(self) -> typing.List[QtCore.QByteArray]:
        """
        https://doc.qt.io/qt-5/qsslcertificate.html#subjectInfoAttributes

        **QList<QByteArray> QSslCertificate::subjectInfoAttributes() const**

        Returns a list of the attributes that have values in the subject
        information of this certificate. The information associated with a given
        attribute can be accessed using the **subjectInfo** () method. Note that
        this list may include the OIDs for any elements that are not known by
        the SSL backend.

        This function was introduced in Qt 5.0.

        **See also** **subjectInfo** ().
        """
        ...

    def isBlacklisted(self) -> bool:
        """
        https://doc.qt.io/qt-5/qsslcertificate.html#isBlacklisted

        **bool QSslCertificate::isBlacklisted() const**

        Returns `true` if this certificate is blacklisted; otherwise returns
        `false`.

        **See also** **isNull** ().
        """
        ...

    def swap(self, other: "QSslCertificate") -> None:
        """
        https://doc.qt.io/qt-5/qsslcertificate.html#swap

        **void QSslCertificate::swap(QSslCertificate & other )**

        Swaps this certificate instance with **other**. This function is very
        fast and never fails.

        This function was introduced in Qt 5.0.
        """
        ...

    def handle(self) -> PyQt5.sip.voidptr:
        """
        https://doc.qt.io/qt-5/qsslcertificate.html#handle

        **Qt::HANDLE QSslCertificate::handle() const**

        Returns a pointer to the native certificate handle, if there is one,
        else `nullptr`.

        You can use this handle, together with the native API, to access
        extended information about the certificate.

        **Warning:** Use of this function has a high probability of being non-
        portable, and its return value may vary from platform to platform or
        change from minor release to minor release.
        """
        ...

    @staticmethod
    def fromData(
        data: typing.Union[QtCore.QByteArray, bytes, bytearray],
        format: QSsl.EncodingFormat = ...,
    ) -> typing.List["QSslCertificate"]:
        """
        https://doc.qt.io/qt-5/qsslcertificate.html#fromData

        **[static] QList<QSslCertificate> QSslCertificate::fromData(const
        QByteArray & data , QSsl::EncodingFormat format = QSsl::Pem)**

        Searches for and parses all certificates in **data** that are encoded in
        the specified **format** and returns them in a list of certificates.

        **See also** **fromDevice** ().
        """
        ...

    @staticmethod
    def fromDevice(
        device: QtCore.QIODevice, format: QSsl.EncodingFormat = ...
    ) -> typing.List["QSslCertificate"]:
        """
        https://doc.qt.io/qt-5/qsslcertificate.html#fromDevice

        **[static] QList<QSslCertificate> QSslCertificate::fromDevice(QIODevice
        * device , QSsl::EncodingFormat format = QSsl::Pem)**

        Searches for and parses all certificates in **device** that are encoded
        in the specified **format** and returns them in a list of certificates.

        **See also** **fromData** ().
        """
        ...

    @staticmethod
    def fromPath(
        path: str,
        format: QSsl.EncodingFormat = ...,
        syntax: QtCore.QRegExp.PatternSyntax = ...,
    ) -> typing.List["QSslCertificate"]:
        """
        https://doc.qt.io/qt-5/qsslcertificate.html#fromPath-1

        **[static] QList<QSslCertificate> QSslCertificate::fromPath(const
        QString & path , QSsl::EncodingFormat format = QSsl::Pem,
        QSslCertificate::PatternSyntax syntax = PatternSyntax::FixedString)**

        Searches all files in the **path** for certificates encoded in the
        specified **format** and returns them in a list. **path** must be a file
        or a pattern matching one or more files, as specified by **syntax**.

        Example:

        const auto certs = **QSslCertificate**
        ::fromPath("C:/ssl/certificate.*.pem",
        QSsl::Pem, **QSslCertificate** ::Wildcard);
            for (const
        **QSslCertificate**  &cert : certs) {
                **qDebug** () <<
        cert.issuerInfo(**QSslCertificate** ::Organization);
            }

        This function was introduced in Qt 5.15.

        **See also** **fromData** ().
        """
        ...

    def toDer(self) -> QtCore.QByteArray:
        """
        https://doc.qt.io/qt-5/qsslcertificate.html#toDer

        **QByteArray QSslCertificate::toDer() const**

        Returns this certificate converted to a DER (binary) encoded
        representation.
        """
        ...

    def toPem(self) -> QtCore.QByteArray:
        """
        https://doc.qt.io/qt-5/qsslcertificate.html#toPem

        **QByteArray QSslCertificate::toPem() const**

        Returns this certificate converted to a PEM (Base64) encoded
        representation.
        """
        ...

    def publicKey(self) -> "QSslKey":
        """
        https://doc.qt.io/qt-5/qsslcertificate.html#publicKey

        **QSslKey QSslCertificate::publicKey() const**

        Returns the certificate subject's public key.
        """
        ...

    def expiryDate(self) -> QtCore.QDateTime:
        """
        https://doc.qt.io/qt-5/qsslcertificate.html#expiryDate

        **QDateTime QSslCertificate::expiryDate() const**

        Returns the date-time that the certificate expires, or an empty
        **QDateTime**  if this is a null certificate.

        **See also** **effectiveDate** ().
        """
        ...

    def effectiveDate(self) -> QtCore.QDateTime:
        """
        https://doc.qt.io/qt-5/qsslcertificate.html#effectiveDate

        **QDateTime QSslCertificate::effectiveDate() const**

        Returns the date-time that the certificate becomes valid, or an empty
        **QDateTime**  if this is a null certificate.

        **See also** **expiryDate** ().
        """
        ...

    def subjectAlternativeNames(
        self,
    ) -> typing.Dict[QSsl.AlternativeNameEntryType, typing.List[str]]:
        """
        https://doc.qt.io/qt-5/qsslcertificate.html#subjectAlternativeNames

        **QMultiMap<QSsl::AlternativeNameEntryType, QString>
        QSslCertificate::subjectAlternativeNames() const**

        Returns the list of alternative subject names for this certificate. The
        alternative names typically contain host names, optionally with
        wildcards, that are valid for this certificate.

        These names are tested against the connected peer's host name, if either
        the subject information for **CommonName**  doesn't define a valid host
        name, or the subject info name doesn't match the peer's host name.

        **See also** **subjectInfo** ().
        """
        ...

    @typing.overload
    def subjectInfo(self, info: "QSslCertificate.SubjectInfo") -> typing.List[str]:
        """
        https://doc.qt.io/qt-5/qsslcertificate.html#subjectInfo

        **QStringList QSslCertificate::subjectInfo(QSslCertificate::SubjectInfo
        subject ) const**

        Returns the information for the **subject** , or an empty list if there
        is no information for **subject** in the certificate. There can be more
        than one entry of each type.

        **See also** **issuerInfo** ().
        """
        ...

    @typing.overload
    def subjectInfo(
        self, attribute: typing.Union[QtCore.QByteArray, bytes, bytearray]
    ) -> typing.List[str]:
        """
        https://doc.qt.io/qt-5/qsslcertificate.html#subjectInfo-1

        **QStringList QSslCertificate::subjectInfo(const QByteArray & attribute
        ) const**

        Returns the subject information for **attribute** , or an empty list if
        there is no information for **attribute** in the certificate. There can
        be more than one entry for an attribute.

        **See also** **issuerInfo** ().
        """
        ...

    @typing.overload
    def issuerInfo(self, info: "QSslCertificate.SubjectInfo") -> typing.List[str]:
        """
        https://doc.qt.io/qt-5/qsslcertificate.html#issuerInfo

        **QStringList QSslCertificate::issuerInfo(QSslCertificate::SubjectInfo
        subject ) const**

        Returns the issuer information for the **subject** from the certificate,
        or an empty list if there is no information for **subject** in the
        certificate. There can be more than one entry of each type.

        **See also** **subjectInfo** ().
        """
        ...

    @typing.overload
    def issuerInfo(
        self, attribute: typing.Union[QtCore.QByteArray, bytes, bytearray]
    ) -> typing.List[str]:
        """
        https://doc.qt.io/qt-5/qsslcertificate.html#issuerInfo-1

        **QStringList QSslCertificate::issuerInfo(const QByteArray & attribute )
        const**

        Returns the issuer information for **attribute** from the certificate,
        or an empty list if there is no information for **attribute** in the
        certificate. There can be more than one entry for an attribute.

        **See also** **subjectInfo** ().
        """
        ...

    def digest(
        self, algorithm: QtCore.QCryptographicHash.Algorithm = ...
    ) -> QtCore.QByteArray:
        """
        https://doc.qt.io/qt-5/qsslcertificate.html#digest

        **QByteArray QSslCertificate::digest(QCryptographicHash::Algorithm
        algorithm = QCryptographicHash::Md5) const**

        Returns a cryptographic digest of this certificate. By default, an MD5
        digest will be generated, but you can also specify a custom
        **algorithm**.
        """
        ...

    def serialNumber(self) -> QtCore.QByteArray:
        """
        https://doc.qt.io/qt-5/qsslcertificate.html#serialNumber

        **QByteArray QSslCertificate::serialNumber() const**

        Returns the certificate's serial number string in hexadecimal format.
        """
        ...

    def version(self) -> QtCore.QByteArray:
        """
        https://doc.qt.io/qt-5/qsslcertificate.html#version

        **QByteArray QSslCertificate::version() const**

        Returns the certificate's version string.
        """
        ...

    def clear(self) -> None:
        """
        https://doc.qt.io/qt-5/qsslcertificate.html#clear

        **void QSslCertificate::clear()**

        Clears the contents of this certificate, making it a null certificate.

        **See also** **isNull** ().
        """
        ...

    def isNull(self) -> bool:
        """
        https://doc.qt.io/qt-5/qsslcertificate.html#isNull

        **bool QSslCertificate::isNull() const**

        Returns `true` if this is a null certificate (i.e., a certificate with
        no contents); otherwise returns `false`.

        By default, **QSslCertificate**  constructs a null certificate.

        **See also** **clear** ().
        """
        ...
