"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
import PyQt5.sip
from PyQt5 import QtCore


class QPasswordDigestor(PyQt5.sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qpassworddigestor.html

    **Detailed Description**
    """

    def deriveKeyPbkdf2(
        self,
        algorithm: QtCore.QCryptographicHash.Algorithm,
        password: typing.Union[QtCore.QByteArray, bytes, bytearray],
        salt: typing.Union[QtCore.QByteArray, bytes, bytearray],
        iterations: int,
        dkLen: int,
    ) -> QtCore.QByteArray:
        """
        https://doc.qt.io/qt-5/qpassworddigestor.html#deriveKeyPbkdf2

        **QByteArray
        QPasswordDigestor::deriveKeyPbkdf2(QCryptographicHash::Algorithm
        algorithm , const QByteArray & data , const QByteArray & salt , int
        iterations , quint64 dkLen )**

        Derive a key using the PBKDF2-algorithm as defined in **RFC 8018** .

        This function takes the **data** and **salt** , and then applies HMAC-X,
        where the X is **algorithm** , repeatedly. It internally concatenates
        intermediate results to the final output until at least **dkLen** amount
        of bytes have been computed and it will execute HMAC-X **iterations**
        times each time a concatenation is required. The total number of times
        it will execute HMAC-X depends on **iterations** , **dkLen** and
        **algorithm** and can be calculated as `iterations * ceil(dkLen /
        QCryptographicHash::hashLength(algorithm))`.

        This function was introduced in Qt 5.12.

        **See also** **deriveKeyPbkdf1** , **QMessageAuthenticationCode** , and
        **QCryptographicHash** .
        """
        ...

    def deriveKeyPbkdf1(
        self,
        algorithm: QtCore.QCryptographicHash.Algorithm,
        password: typing.Union[QtCore.QByteArray, bytes, bytearray],
        salt: typing.Union[QtCore.QByteArray, bytes, bytearray],
        iterations: int,
        dkLen: int,
    ) -> QtCore.QByteArray:
        """
        https://doc.qt.io/qt-5/qpassworddigestor.html#deriveKeyPbkdf1

        **QByteArray
        QPasswordDigestor::deriveKeyPbkdf1(QCryptographicHash::Algorithm
        algorithm , const QByteArray & data , const QByteArray & salt , int
        iterations , quint64 dkLen )**

        Returns a hash computed using the PBKDF1-algorithm as defined in **RFC
        8018** .

        The function takes the **data** and **salt** , and then hashes it
        repeatedly for **iterations** iterations using the specified hash
        **algorithm**. If the resulting hash is longer than **dkLen** then it is
        truncated before it is returned.

        This function only supports SHA-1 and MD5! The max output size is 160
        bits (20 bytes) when using SHA-1, or 128 bits (16 bytes) when using MD5.
        Specifying a value for **dkLen** which is greater than this results in a
        warning and an empty **QByteArray**  is returned. To programmatically
        check this limit you can use **QCryptographicHash::hashLength** .
        Furthermore: the **salt** must always be 8 bytes long!

        **Note:** This function is provided for use with legacy applications and
        all new applications are recommended to use **PBKDF2** .

        This function was introduced in Qt 5.12.

        **See also** **deriveKeyPbkdf2** , **QCryptographicHash** , and
        **QCryptographicHash::hashLength** .
        """
        ...
