"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
from PyQt5.QtNetwork import *
from PyQt5 import sip


class QNetworkInterface(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qnetworkinterface.html

    **Detailed Description**

    QNetworkInterface represents one network interface attached to the host
    where the program is being run. Each network interface may contain zero or
    more IP addresses, each of which is optionally associated with a netmask
    and/or a broadcast address. The list of such trios can be obtained with
    **addressEntries** (). Alternatively, when the netmask or the broadcast
    addresses or other information aren't necessary, use the **allAddresses** ()
    convenience function to obtain just the IP addresses of the active
    interfaces.

    QNetworkInterface also reports the interface's hardware address with
    **hardwareAddress** ().

    Not all operating systems support reporting all features. Only the IPv4
    addresses are guaranteed to be listed by this class in all platforms. In
    particular, IPv6 address listing is only supported on Windows, Linux, macOS
    and the BSDs.

    **See also** **QNetworkAddressEntry** .
    """

    class InterfaceType(int):
        Unknown: QNetworkInterface = ...
        Loopback: QNetworkInterface = ...
        Virtual: QNetworkInterface = ...
        Ethernet: QNetworkInterface = ...
        Slip: QNetworkInterface = ...
        CanBus: QNetworkInterface = ...
        Ppp: QNetworkInterface = ...
        Fddi: QNetworkInterface = ...
        Wifi: QNetworkInterface = ...
        Ieee80211: QNetworkInterface = ...
        Phonet: QNetworkInterface = ...
        Ieee802154: QNetworkInterface = ...
        SixLoWPAN: QNetworkInterface = ...
        Ieee80216: QNetworkInterface = ...
        Ieee1394: QNetworkInterface = ...

    class InterfaceFlag(int):
        IsUp: QNetworkInterface = ...
        IsRunning: QNetworkInterface = ...
        CanBroadcast: QNetworkInterface = ...
        IsLoopBack: QNetworkInterface = ...
        IsPointToPoint: QNetworkInterface = ...
        CanMulticast: QNetworkInterface = ...

    class InterfaceFlags(sip.simplewrapper):
        @typing.overload
        def __init__(self) -> None:
            ...

        @typing.overload
        def __init__(
            self,
            f: typing.Union[
                "QNetworkInterface.InterfaceFlags", "QNetworkInterface.InterfaceFlag"
            ],
        ) -> None:
            ...

        @typing.overload
        def __init__(self, a0: "QNetworkInterface.InterfaceFlags") -> None:
            ...

        def __hash__(self) -> int:
            ...

        def __bool__(self) -> int:
            ...

        def __invert__(self) -> "QNetworkInterface.InterfaceFlags":
            ...

        def __index__(self) -> int:
            ...

        def __int__(self) -> int:
            ...

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qnetworkinterface.html#QNetworkInterface

        **QNetworkInterface::QNetworkInterface()**

        Constructs an empty network interface object.
        """
        ...

    @typing.overload
    def __init__(self, other: "QNetworkInterface") -> None:
        """
        https://doc.qt.io/qt-5/qnetworkinterface.html#QNetworkInterface-1

        **QNetworkInterface::QNetworkInterface(const QNetworkInterface & other
        )**

        Creates a copy of the QNetworkInterface object contained in **other**.
        """
        ...

    def maximumTransmissionUnit(self) -> int:
        """
        https://doc.qt.io/qt-5/qnetworkinterface.html#maximumTransmissionUnit

        **int QNetworkInterface::maximumTransmissionUnit() const**

        Returns the maximum transmission unit on this interface, if known, or 0
        otherwise.

        The maximum transmission unit is the largest packet that may be sent on
        this interface without incurring link-level fragmentation. Applications
        may use this value to calculate the size of the payload that will fit an
        unfragmented UDP datagram. Remember to subtract the sizes of headers
        used in your communication over the interface, e.g. TCP (20 bytes) or
        UDP (12), IPv4 (20) or IPv6 (40, absent some form of header
        compression), when computing how big a payload you can transmit. Also
        note that the MTU along the full path (the Path MTU) to the destination
        may be smaller than the interface's MTU.

        This function was introduced in Qt 5.11.

        **See also** **QUdpSocket** .
        """
        ...

    def type(self) -> "QNetworkInterface.InterfaceType":
        """
        https://doc.qt.io/qt-5/qnetworkinterface.html#type

        **QNetworkInterface::InterfaceType QNetworkInterface::type() const**

        Returns the type of this interface, if it could be determined. If it
        could not be determined, this function returns
        **QNetworkInterface::Unknown** .

        This function was introduced in Qt 5.11.

        **See also** **hardwareAddress** ().
        """
        ...

    @staticmethod
    def interfaceNameFromIndex(index: int) -> str:
        """
        https://doc.qt.io/qt-5/qnetworkinterface.html#interfaceNameFromIndex

        **[static] QString QNetworkInterface::interfaceNameFromIndex(int index
        )**

        Returns the name of the interface whose index is **index** or an empty
        string if there is no interface with that index. This function should
        produce the same result as the following code, but will probably execute
        faster.

        **QNetworkInterface** ::interfaceFromIndex(index).name()

        This function was introduced in Qt 5.7.

        **See also** **interfaceFromIndex** (), **interfaceIndexFromName** (),
        and **QNetworkDatagram::interfaceIndex** ().
        """
        ...

    @staticmethod
    def interfaceIndexFromName(name: str) -> int:
        """
        https://doc.qt.io/qt-5/qnetworkinterface.html#interfaceIndexFromName

        **[static] int QNetworkInterface::interfaceIndexFromName(const QString &
        name )**

        Returns the index of the interface whose name is **name** or 0 if there
        is no interface with that name. This function should produce the same
        result as the following code, but will probably execute faster.

        **QNetworkInterface** ::interfaceFromName(name).index()

        This function was introduced in Qt 5.7.

        **See also** **interfaceFromName** (), **interfaceNameFromIndex** (),
        and **QNetworkDatagram::interfaceIndex** ().
        """
        ...

    def swap(self, other: "QNetworkInterface") -> None:
        """
        https://doc.qt.io/qt-5/qnetworkinterface.html#swap

        **void QNetworkInterface::swap(QNetworkInterface & other )**

        Swaps this network interface instance with **other**. This function is
        very fast and never fails.

        This function was introduced in Qt 5.0.
        """
        ...

    def humanReadableName(self) -> str:
        """
        https://doc.qt.io/qt-5/qnetworkinterface.html#humanReadableName

        **QString QNetworkInterface::humanReadableName() const**

        Returns the human-readable name of this network interface on Windows,
        such as "Local Area Connection", if the name could be determined. If it
        couldn't, this function returns the same as **name** (). The human-
        readable name is a name that the user can modify in the Windows Control
        Panel, so it may change during the execution of the program.

        On Unix, this function currently always returns the same as **name** (),
        since Unix systems don't store a configuration for human-readable names.

        This function was introduced in Qt 4.5.
        """
        ...

    def index(self) -> int:
        """
        https://doc.qt.io/qt-5/qnetworkinterface.html#index

        **int QNetworkInterface::index() const**

        Returns the interface system index, if known. This is an integer
        assigned by the operating system to identify this interface and it
        generally doesn't change. It matches the scope ID field in IPv6
        addresses.

        If the index isn't known, this function returns 0.

        This function was introduced in Qt 4.5.
        """
        ...

    @staticmethod
    def allAddresses() -> typing.List[QHostAddress]:
        """
        https://doc.qt.io/qt-5/qnetworkinterface.html#allAddresses

        **[static] QList<QHostAddress> QNetworkInterface::allAddresses()**

        This convenience function returns all IP addresses found on the host
        machine. It is equivalent to calling **addressEntries** () on all the
        objects returned by **allInterfaces** () that are in the
        **QNetworkInterface::IsUp**  state to obtain lists of
        **QNetworkAddressEntry**  objects then calling
        **QNetworkAddressEntry::ip** () on each of these.
        """
        ...

    @staticmethod
    def allInterfaces() -> typing.List["QNetworkInterface"]:
        """
        https://doc.qt.io/qt-5/qnetworkinterface.html#allInterfaces

        **[static] QList<QNetworkInterface> QNetworkInterface::allInterfaces()**

        Returns a listing of all the network interfaces found on the host
        machine. In case of failure it returns a list with zero elements.
        """
        ...

    @staticmethod
    def interfaceFromIndex(index: int) -> "QNetworkInterface":
        """
        https://doc.qt.io/qt-5/qnetworkinterface.html#interfaceFromIndex

        **[static] QNetworkInterface QNetworkInterface::interfaceFromIndex(int
        index )**

        Returns a **QNetworkInterface**  object for the interface whose internal
        ID is **index**. Network interfaces have a unique identifier called the
        "interface index" to distinguish it from other interfaces on the system.
        Often, this value is assigned progressively and interfaces being removed
        and then added again get a different value every time.

        This index is also found in the IPv6 address' scope ID field.
        """
        ...

    @staticmethod
    def interfaceFromName(name: str) -> "QNetworkInterface":
        """
        https://doc.qt.io/qt-5/qnetworkinterface.html#interfaceFromName

        **[static] QNetworkInterface QNetworkInterface::interfaceFromName(const
        QString & name )**

        Returns a **QNetworkInterface**  object for the interface named
        **name**. If no such interface exists, this function returns an invalid
        **QNetworkInterface**  object.

        The string **name** may be either an actual interface name (such as
        "eth0" or "en1") or an interface index in string form ("1", "2", etc.).

        **See also** **name** () and **isValid** ().
        """
        ...

    def addressEntries(self) -> typing.List[QNetworkAddressEntry]:
        """
        https://doc.qt.io/qt-5/qnetworkinterface.html#addressEntries

        **QList<QNetworkAddressEntry> QNetworkInterface::addressEntries()
        const**

        Returns the list of IP addresses that this interface possesses along
        with their associated netmasks and broadcast addresses.

        If the netmask or broadcast address or other information is not
        necessary, you can call the **allAddresses** () function to obtain just
        the IP addresses of the active interfaces.
        """
        ...

    def hardwareAddress(self) -> str:
        """
        https://doc.qt.io/qt-5/qnetworkinterface.html#hardwareAddress

        **QString QNetworkInterface::hardwareAddress() const**

        Returns the low-level hardware address for this interface. On Ethernet
        interfaces, this will be a MAC address in string representation,
        separated by colons.

        Other interface types may have other types of hardware addresses.
        Implementations should not depend on this function returning a valid MAC
        address.

        **See also** **type** ().
        """
        ...

    def flags(self) -> "QNetworkInterface.InterfaceFlags":
        """
        https://doc.qt.io/qt-5/qnetworkinterface.html#flags

        **QNetworkInterface::InterfaceFlags QNetworkInterface::flags() const**

        Returns the flags associated with this network interface.
        """
        ...

    def name(self) -> str:
        """
        https://doc.qt.io/qt-5/qnetworkinterface.html#name

        **QString QNetworkInterface::name() const**

        Returns the name of this network interface. On Unix systems, this is a
        string containing the type of the interface and optionally a sequence
        number, such as "eth0", "lo" or "pcn0". On Windows, it's an internal ID
        that cannot be changed by the user.
        """
        ...

    def isValid(self) -> bool:
        """
        https://doc.qt.io/qt-5/qnetworkinterface.html#isValid

        **bool QNetworkInterface::isValid() const**

        Returns `true` if this **QNetworkInterface**  object contains valid
        information about a network interface.
        """
        ...
