"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
import PyQt5.sip
from PyQt5 import QtCore
from PyQt5.QtNetwork import *


class QNetworkAccessManager(QtCore.QObject):
    """
    https://doc.qt.io/qt-5/qnetworkaccessmanager.html

    **Detailed Description**

    The Network Access API is constructed around one QNetworkAccessManager
    object, which holds the common configuration and settings for the requests
    it sends. It contains the proxy and cache configuration, as well as the
    signals related to such issues, and reply signals that can be used to
    monitor the progress of a network operation. One QNetworkAccessManager
    instance should be enough for the whole Qt application. Since
    QNetworkAccessManager is based on **QObject** , it can only be used from the
    thread it belongs to.

    Once a QNetworkAccessManager object has been created, the application can
    use it to send requests over the network. A group of standard functions are
    supplied that take a request and optional data, and each return a
    **QNetworkReply**  object. The returned object is used to obtain any data
    returned in response to the corresponding request.

    A simple download off the network could be accomplished with:

    **QNetworkAccessManager**  *manager = new **QNetworkAccessManager** (this);
    connect(manager, &**QNetworkAccessManager** ::finished,
                this,
    &MyClass::replyFinished);

        manager->get(**QNetworkRequest**
    (**QUrl** ("http://qt-project.org")));

    QNetworkAccessManager has an asynchronous API. When the `replyFinished` slot
    above is called, the parameter it takes is the **QNetworkReply**  object
    containing the downloaded data as well as meta-data (headers, etc.).

    **Note:** After the request has finished, it is the responsibility of the
    user to delete the **QNetworkReply**  object at an appropriate time. Do not
    directly delete it inside the slot connected to **finished** (). You can use
    the **deleteLater** () function.

    **Note:** QNetworkAccessManager queues the requests it receives. The number
    of requests executed in parallel is dependent on the protocol. Currently,
    for the HTTP protocol on desktop platforms, 6 requests are executed in
    parallel for one host/port combination.

    A more involved example, assuming the manager is already existent, can be:

    **QNetworkRequest**  request;
        request.setUrl(**QUrl** ("http://qt-
    project.org"));
        request.setRawHeader("User-Agent", "MyOwnBrowser 1.0");
    **QNetworkReply**  *reply = manager->get(request);
        connect(reply,
    &**QIODevice** ::readyRead, this, &MyClass::slotReadyRead);
    connect(reply, &**QNetworkReply** ::errorOccurred,
                this,
    &MyClass::slotError);
        connect(reply, &**QNetworkReply** ::sslErrors,
    this, &MyClass::slotSslErrors);

    **See also** **QNetworkRequest** , **QNetworkReply** , and **QNetworkProxy**
    .
    """

    class NetworkAccessibility(int):
        UnknownAccessibility: QNetworkAccessManager = ...
        NotAccessible: QNetworkAccessManager = ...
        Accessible: QNetworkAccessManager = ...

    class Operation(int):
        HeadOperation: QNetworkAccessManager = ...
        GetOperation: QNetworkAccessManager = ...
        PutOperation: QNetworkAccessManager = ...
        PostOperation: QNetworkAccessManager = ...
        DeleteOperation: QNetworkAccessManager = ...
        CustomOperation: QNetworkAccessManager = ...

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qnetworkaccessmanager.html#QNetworkAccessManager

        **QNetworkAccessManager::QNetworkAccessManager(QObject * parent =
        nullptr)**

        Constructs a QNetworkAccessManager object that is the center of the
        Network Access API and sets **parent** as the parent object.
        """
        ...

    def setTransferTimeout(self, timeout: int = ...) -> None:
        """
        https://doc.qt.io/qt-5/qnetworkaccessmanager.html#setTransferTimeout

        **void QNetworkAccessManager::setTransferTimeout(int timeout =
        QNetworkRequest::DefaultTransferTimeoutConstant)**

        Sets **timeout** as the transfer timeout in milliseconds.

        Transfers are aborted if no bytes are transferred before the timeout
        expires. Zero means no timer is set. If no argument is provided, the
        timeout is **QNetworkRequest::DefaultTransferTimeoutConstant** . If this
        function is not called, the timeout is disabled and has the value zero.
        The request-specific non-zero timeouts set for the requests that are
        executed override this value. This means that if
        **QNetworkAccessManager**  has an enabled timeout, it needs to be
        disabled to execute a request without a timeout.

        This function was introduced in Qt 5.15.

        **See also** **transferTimeout** ().
        """
        ...

    def transferTimeout(self) -> int:
        """
        https://doc.qt.io/qt-5/qnetworkaccessmanager.html#transferTimeout

        **int QNetworkAccessManager::transferTimeout() const**

        Returns the timeout used for transfers, in milliseconds.

        This timeout is zero if **setTransferTimeout** () hasn't been called,
        which means that the timeout is not used.

        This function was introduced in Qt 5.15.

        **See also** **setTransferTimeout** ().
        """
        ...

    def setAutoDeleteReplies(self, autoDelete: bool) -> None:
        """
        https://doc.qt.io/qt-5/qnetworkaccessmanager.html#setAutoDeleteReplies

        **void QNetworkAccessManager::setAutoDeleteReplies(bool shouldAutoDelete
        )**

        Enables or disables automatic deletion of **QNetworkReplies** .

        Setting **shouldAutoDelete** to true is the same as setting the
        **QNetworkRequest::AutoDeleteReplyOnFinishAttribute**  attribute to true
        on all **future** **QNetworkRequests**  passed to this instance of
        **QNetworkAccessManager**  unless the attribute was already explicitly
        set on the **QNetworkRequest** .

        This function was introduced in Qt 5.14.

        **See also** **autoDeleteReplies**  and
        **QNetworkRequest::AutoDeleteReplyOnFinishAttribute** .
        """
        ...

    def autoDeleteReplies(self) -> bool:
        """
        https://doc.qt.io/qt-5/qnetworkaccessmanager.html#autoDeleteReplies

        **bool QNetworkAccessManager::autoDeleteReplies() const**

        Returns the true if **QNetworkAccessManager**  is currently configured
        to automatically delete QNetworkReplies, false otherwise.

        This function was introduced in Qt 5.14.

        **See also** **setAutoDeleteReplies**  and
        **QNetworkRequest::AutoDeleteReplyOnFinishAttribute** .
        """
        ...

    def isStrictTransportSecurityStoreEnabled(self) -> bool:
        """
        https://doc.qt.io/qt-5/qnetworkaccessmanager.html#isStrictTransportSecur
        ityStoreEnabled

        **bool QNetworkAccessManager::isStrictTransportSecurityStoreEnabled()
        const**

        Returns true if HSTS cache uses a permanent store to load and store HSTS
        policies.

        This function was introduced in Qt 5.10.

        **See also** **enableStrictTransportSecurityStore** ().
        """
        ...

    def enableStrictTransportSecurityStore(
        self, enabled: bool, storeDir: str = ...
    ) -> None:
        """
        https://doc.qt.io/qt-5/qnetworkaccessmanager.html#enableStrictTransportS
        ecurityStore

        **void QNetworkAccessManager::enableStrictTransportSecurityStore(bool
        enabled , const QString & storeDir = QString())**

        If **enabled** is `true`, the internal HSTS cache will use a persistent
        store to read and write HSTS policies. **storeDir** defines where this
        store will be located. The default location is defined by
        **QStandardPaths::CacheLocation** . If there is no writable
        QStandartPaths::CacheLocation and **storeDir** is an empty string, the
        store will be located in the program's working directory.

        **Note:** If HSTS cache already contains HSTS policies by the time
        persistent store is enabled, these policies will be preserved in the
        store. In case both cache and store contain the same known hosts,
        policies from cache are considered to be more up-to-date (and thus will
        overwrite the previous values in the store). If this behavior is
        undesired, enable HSTS store before enabling Strict Tranport Security.
        By default, the persistent store of HSTS policies is disabled.

        This function was introduced in Qt 5.10.

        **See also** **isStrictTransportSecurityStoreEnabled** (),
        **setStrictTransportSecurityEnabled** (), and
        **QStandardPaths::standardLocations** ().
        """
        ...

    def redirectPolicy(self) -> "QNetworkRequest.RedirectPolicy":
        """
        https://doc.qt.io/qt-5/qnetworkaccessmanager.html#redirectPolicy

        **QNetworkRequest::RedirectPolicy
        QNetworkAccessManager::redirectPolicy() const**

        Returns the redirect policy that is used when creating new requests.

        This function was introduced in Qt 5.9.

        **See also** **setRedirectPolicy** () and
        **QNetworkRequest::RedirectPolicy** .
        """
        ...

    def setRedirectPolicy(self, policy: "QNetworkRequest.RedirectPolicy") -> None:
        """
        https://doc.qt.io/qt-5/qnetworkaccessmanager.html#setRedirectPolicy

        **void
        QNetworkAccessManager::setRedirectPolicy(QNetworkRequest::RedirectPolicy
        policy )**

        Sets the manager's redirect policy to be the **policy** specified. This
        policy will affect all subsequent requests created by the manager.

        Use this function to enable or disable HTTP redirects on the manager's
        level.

        **Note:** When creating a request
        QNetworkRequest::RedirectAttributePolicy has the highest priority, next
        by priority is **QNetworkRequest::FollowRedirectsAttribute** . Finally,
        the manager's policy has the lowest priority.

        For backwards compatibility the default value is
        **QNetworkRequest::ManualRedirectPolicy** . This may change in the
        future and some type of auto-redirect policy will become the default;
        clients relying on manual redirect handling are encouraged to set this
        policy explicitly in their code.

        This function was introduced in Qt 5.9.

        **See also** **redirectPolicy** (), **QNetworkRequest::RedirectPolicy**
        , and **QNetworkRequest::FollowRedirectsAttribute** .
        """
        ...

    def strictTransportSecurityHosts(self) -> typing.List[QHstsPolicy]:
        """
        https://doc.qt.io/qt-5/qnetworkaccessmanager.html#strictTransportSecurit
        yHosts

        **QVector<QHstsPolicy>
        QNetworkAccessManager::strictTransportSecurityHosts() const**

        Returns the list of HTTP Strict Transport Security policies. This list
        can differ from what was initially set via
        **addStrictTransportSecurityHosts** () if HSTS cache was updated from a
        "Strict-Transport-Security" response header.

        This function was introduced in Qt 5.9.

        **See also** **addStrictTransportSecurityHosts** () and **QHstsPolicy**
        .
        """
        ...

    def addStrictTransportSecurityHosts(
        self, knownHosts: typing.Iterable[QHstsPolicy]
    ) -> None:
        """
        https://doc.qt.io/qt-5/qnetworkaccessmanager.html#addStrictTransportSecu
        rityHosts

        **void QNetworkAccessManager::addStrictTransportSecurityHosts(const
        QVector<QHstsPolicy> & knownHosts )**

        Adds HTTP Strict Transport Security policies into HSTS cache.
        **knownHosts** contains the known hosts that have **QHstsPolicy**
        information.

        **Note:** An expired policy will remove a known host from the cache, if
        previously present.

        **Note:** While processing HTTP responses, **QNetworkAccessManager**
        can also update the HSTS cache, removing or updating exitsting policies
        or introducing new **knownHosts**. The current implementation thus is
        server-driven, client code can provide **QNetworkAccessManager**  with
        previously known or discovered policies, but this information can be
        overridden by "Strict-Transport-Security" response headers.

        This function was introduced in Qt 5.9.

        **See also**  addStrictTransportSecurityHosts(),
        **enableStrictTransportSecurityStore** (), and **QHstsPolicy** .
        """
        ...

    def isStrictTransportSecurityEnabled(self) -> bool:
        """
        https://doc.qt.io/qt-5/qnetworkaccessmanager.html#isStrictTransportSecur
        ityEnabled

        **bool QNetworkAccessManager::isStrictTransportSecurityEnabled() const**

        Returns true if HTTP Strict Transport Security (HSTS) was enabled. By
        default HSTS is disabled.

        This function was introduced in Qt 5.9.

        **See also** **setStrictTransportSecurityEnabled** ().
        """
        ...

    def setStrictTransportSecurityEnabled(self, enabled: bool) -> None:
        """
        https://doc.qt.io/qt-5/qnetworkaccessmanager.html#setStrictTransportSecu
        rityEnabled

        **void QNetworkAccessManager::setStrictTransportSecurityEnabled(bool
        enabled )**

        If **enabled** is `true`, **QNetworkAccessManager**  follows the HTTP
        Strict Transport Security policy (HSTS, RFC6797). When processing a
        request, **QNetworkAccessManager**  automatically replaces the "http"
        scheme with "https" and uses a secure transport for HSTS hosts. If it's
        set explicitly, port 80 is replaced by port 443.

        When HSTS is enabled, for each HTTP response containing HSTS header and
        received over a secure transport, **QNetworkAccessManager**  will update
        its HSTS cache, either remembering a host with a valid policy or
        removing a host with an expired or disabled HSTS policy.

        This function was introduced in Qt 5.9.

        **See also** **isStrictTransportSecurityEnabled** ().
        """
        ...

    def clearConnectionCache(self) -> None:
        """
        https://doc.qt.io/qt-5/qnetworkaccessmanager.html#clearConnectionCache

        **void QNetworkAccessManager::clearConnectionCache()**

        Flushes the internal cache of network connections. In contrast to
        **clearAccessCache** () the authentication data is preserved.

        This function was introduced in Qt 5.9.

        **See also** **clearAccessCache** ().
        """
        ...

    def supportedSchemesImplementation(self) -> typing.List[str]:
        """
        https://doc.qt.io/qt-5/qnetworkaccessmanager.html#supportedSchemesImplem
        entation

        **[protected slot] QStringList
        QNetworkAccessManager::supportedSchemesImplementation() const**

        Lists all the URL schemes supported by the access manager.

        You should not call this function directly; use
        **QNetworkAccessManager::supportedSchemes** () instead.

        Reimplement this slot to provide your own supported schemes in a
        **QNetworkAccessManager**  subclass. It is for instance necessary when
        your subclass provides support for new protocols.

        Because of binary compatibility constraints, the **supportedSchemes** ()
        method (introduced in Qt 5.2) is not virtual. Instead,
        **supportedSchemes** () will dynamically detect and call this slot.

        This function was introduced in Qt 5.2.

        **See also** **supportedSchemes** ().
        """
        ...

    def connectToHost(self, hostName: str, port: int = ...) -> None:
        """
        https://doc.qt.io/qt-5/qnetworkaccessmanager.html#connectToHost

        **void QNetworkAccessManager::connectToHost(const QString & hostName ,
        quint16 port = 80)**

        Initiates a connection to the host given by **hostName** at port
        **port**. This function is useful to complete the TCP handshake to a
        host before the HTTP request is made, resulting in a lower network
        latency.

        **Note:** This function has no possibility to report errors.

        This function was introduced in Qt 5.2.

        **See also** **connectToHostEncrypted** (), **get** (), **post** (),
        **put** (), and **deleteResource** ().
        """
        ...

    @typing.overload
    def connectToHostEncrypted(
        self,
        hostName: str,
        port: int = ...,
        sslConfiguration: "QSslConfiguration" = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qnetworkaccessmanager.html#connectToHostEncrypted

        **void QNetworkAccessManager::connectToHostEncrypted(const QString &
        hostName , quint16 port = 443, const QSslConfiguration &
        sslConfiguration = QSslConfiguration::defaultConfiguration())**

        Initiates a connection to the host given by **hostName** at port
        **port** , using **sslConfiguration**. This function is useful to
        complete the TCP and SSL handshake to a host before the HTTPS request is
        made, resulting in a lower network latency.

        **Note:** Preconnecting a SPDY connection can be done by calling
        setAllowedNextProtocols() on **sslConfiguration** with
        **QSslConfiguration::NextProtocolSpdy3_0**  contained in the list of
        allowed protocols. When using SPDY, one single connection per host is
        enough, i.e. calling this method multiple times per host will not result
        in faster network transactions.

        **Note:** This function has no possibility to report errors.

        This function was introduced in Qt 5.2.

        **See also** **connectToHost** (), **get** (), **post** (), **put** (),
        and **deleteResource** ().
        """
        ...

    @typing.overload
    def connectToHostEncrypted(
        self,
        hostName: str,
        port: int,
        sslConfiguration: "QSslConfiguration",
        peerName: str,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qnetworkaccessmanager.html#connectToHostEncrypted
        -1

        **void QNetworkAccessManager::connectToHostEncrypted(const QString &
        hostName , quint16 port , const QSslConfiguration & sslConfiguration ,
        const QString & peerName )**

        This is an overloaded function.

        Initiates a connection to the host given by **hostName** at port
        **port** , using **sslConfiguration** with **peerName** set to be the
        hostName used for certificate validation. This function is useful to
        complete the TCP and SSL handshake to a host before the HTTPS request is
        made, resulting in a lower network latency.

        **Note:** Preconnecting a SPDY connection can be done by calling
        setAllowedNextProtocols() on **sslConfiguration** with
        **QSslConfiguration::NextProtocolSpdy3_0**  contained in the list of
        allowed protocols. When using SPDY, one single connection per host is
        enough, i.e. calling this method multiple times per host will not result
        in faster network transactions.

        **Note:** This function has no possibility to report errors.

        This function was introduced in Qt 5.13.

        **See also** **connectToHost** (), **get** (), **post** (), **put** (),
        and **deleteResource** ().
        """
        ...

    def supportedSchemes(self) -> typing.List[str]:
        """
        https://doc.qt.io/qt-5/qnetworkaccessmanager.html#supportedSchemes

        **QStringList QNetworkAccessManager::supportedSchemes() const**

        Lists all the URL schemes supported by the access manager.

        This function was introduced in Qt 5.2.

        **See also** **supportedSchemesImplementation** ().
        """
        ...

    def clearAccessCache(self) -> None:
        """
        https://doc.qt.io/qt-5/qnetworkaccessmanager.html#clearAccessCache

        **void QNetworkAccessManager::clearAccessCache()**

        Flushes the internal cache of authentication data and network
        connections.

        This function is useful for doing auto tests.

        This function was introduced in Qt 5.0.

        **See also** **clearConnectionCache** ().
        """
        ...

    def networkAccessible(self) -> "QNetworkAccessManager.NetworkAccessibility":
        ...

    def setNetworkAccessible(
        self, accessible: "QNetworkAccessManager.NetworkAccessibility"
    ) -> None:
        ...

    def activeConfiguration(self) -> "QNetworkConfiguration":
        ...

    def configuration(self) -> "QNetworkConfiguration":
        ...

    def setConfiguration(self, config: "QNetworkConfiguration") -> None:
        ...

    @typing.overload
    def sendCustomRequest(
        self,
        request: "QNetworkRequest",
        verb: typing.Union[QtCore.QByteArray, bytes, bytearray],
        data: typing.Optional[QtCore.QIODevice] = ...,
    ) -> "QNetworkReply":
        """
        https://doc.qt.io/qt-5/qnetworkaccessmanager.html#sendCustomRequest

        **QNetworkReply *QNetworkAccessManager::sendCustomRequest(const
        QNetworkRequest & request , const QByteArray & verb , QIODevice * data =
        nullptr)**

        Sends a custom request to the server identified by the URL of
        **request**.

        It is the user's responsibility to send a **verb** to the server that is
        valid according to the HTTP specification.

        This method provides means to send verbs other than the common ones
        provided via **get** () or **post** () etc., for instance sending an
        HTTP OPTIONS command.

        If **data** is not empty, the contents of the **data** device will be
        uploaded to the server; in that case, data must be open for reading and
        must remain valid until the **finished** () signal is emitted for this
        reply.

        **Note:** This feature is currently available for HTTP(S) only.

        This function was introduced in Qt 4.7.

        **See also** **get** (), **post** (), **put** (), and **deleteResource**
        ().
        """
        ...

    @typing.overload
    def sendCustomRequest(
        self,
        request: "QNetworkRequest",
        verb: typing.Union[QtCore.QByteArray, bytes, bytearray],
        data: typing.Union[QtCore.QByteArray, bytes, bytearray],
    ) -> "QNetworkReply":
        """
        https://doc.qt.io/qt-5/qnetworkaccessmanager.html#sendCustomRequest-1

        **QNetworkReply *QNetworkAccessManager::sendCustomRequest(const
        QNetworkRequest & request , const QByteArray & verb , const QByteArray &
        data )**

        This is an overloaded function.

        Sends the contents of the **data** byte array to the destination
        specified by **request**.

        This function was introduced in Qt 5.8.
        """
        ...

    @typing.overload
    def sendCustomRequest(
        self,
        request: "QNetworkRequest",
        verb: typing.Union[QtCore.QByteArray, bytes, bytearray],
        multiPart: QHttpMultiPart,
    ) -> "QNetworkReply":
        """
        https://doc.qt.io/qt-5/qnetworkaccessmanager.html#sendCustomRequest-2

        **QNetworkReply *QNetworkAccessManager::sendCustomRequest(const
        QNetworkRequest & request , const QByteArray & verb , QHttpMultiPart *
        multiPart )**

        This is an overloaded function.

        Sends a custom request to the server identified by the URL of
        **request**.

        Sends the contents of the **multiPart** message to the destination
        specified by **request**.

        This can be used for sending MIME multipart messages for custom verbs.

        This function was introduced in Qt 5.8.

        **See also** **QHttpMultiPart** , **QHttpPart** , and **put** ().
        """
        ...

    def deleteResource(self, request: "QNetworkRequest") -> "QNetworkReply":
        """
        https://doc.qt.io/qt-5/qnetworkaccessmanager.html#deleteResource

        **QNetworkReply *QNetworkAccessManager::deleteResource(const
        QNetworkRequest & request )**

        Sends a request to delete the resource identified by the URL of
        **request**.

        **Note:** This feature is currently available for HTTP only, performing
        an HTTP DELETE request.

        This function was introduced in Qt 4.6.

        **See also** **get** (), **post** (), **put** (), and
        **sendCustomRequest** ().
        """
        ...

    def setCache(self, cache: QAbstractNetworkCache) -> None:
        """
        https://doc.qt.io/qt-5/qnetworkaccessmanager.html#setCache

        **void QNetworkAccessManager::setCache(QAbstractNetworkCache * cache )**

        Sets the manager's network cache to be the **cache** specified. The
        cache is used for all requests dispatched by the manager.

        Use this function to set the network cache object to a class that
        implements additional features, like saving the cookies to permanent
        storage.

        **Note:****QNetworkAccessManager**  takes ownership of the **cache**
        object.

        **QNetworkAccessManager**  by default does not have a set cache. Qt
        provides a simple disk cache, **QNetworkDiskCache** , which can be used.

        This function was introduced in Qt 4.5.

        **See also** **cache** () and **QNetworkRequest::CacheLoadControl** .
        """
        ...

    def cache(self) -> QAbstractNetworkCache:
        """
        https://doc.qt.io/qt-5/qnetworkaccessmanager.html#cache

        **QAbstractNetworkCache *QNetworkAccessManager::cache() const**

        Returns the cache that is used to store data obtained from the network.

        This function was introduced in Qt 4.5.

        **See also** **setCache** ().
        """
        ...

    def setProxyFactory(self, factory: "QNetworkProxyFactory") -> None:
        """
        https://doc.qt.io/qt-5/qnetworkaccessmanager.html#setProxyFactory

        **void QNetworkAccessManager::setProxyFactory(QNetworkProxyFactory *
        factory )**

        Sets the proxy factory for this class to be **factory**. A proxy factory
        is used to determine a more specific list of proxies to be used for a
        given request, instead of trying to use the same proxy value for all
        requests.

        All queries sent by **QNetworkAccessManager**  will have type
        **QNetworkProxyQuery::UrlRequest** .

        For example, a proxy factory could apply the following rules:

        * if the target address is in the local network (for example, if the
        hostname contains no dots or if it's an IP address in the organization's
        range), return **QNetworkProxy::NoProxy**
          * if the request is FTP,
        return an FTP proxy
          * if the request is HTTP or HTTPS, then return an
        HTTP proxy
          * otherwise, return a SOCKSv5 proxy server

        The lifetime of the object **factory** will be managed by
        **QNetworkAccessManager** . It will delete the object when necessary.

        **Note:** If a specific proxy is set with **setProxy** (), the factory
        will not be used.

        This function was introduced in Qt 4.5.

        **See also** **proxyFactory** (), **setProxy** (), and
        **QNetworkProxyQuery** .
        """
        ...

    def proxyFactory(self) -> "QNetworkProxyFactory":
        """
        https://doc.qt.io/qt-5/qnetworkaccessmanager.html#proxyFactory

        **QNetworkProxyFactory *QNetworkAccessManager::proxyFactory() const**

        Returns the proxy factory that this **QNetworkAccessManager**  object is
        using to determine the proxies to be used for requests.

        Note that the pointer returned by this function is managed by
        **QNetworkAccessManager**  and could be deleted at any time.

        This function was introduced in Qt 4.5.

        **See also** **setProxyFactory** () and **proxy** ().
        """
        ...

    def createRequest(
        self,
        op: "QNetworkAccessManager.Operation",
        request: "QNetworkRequest",
        device: typing.Optional[QtCore.QIODevice] = ...,
    ) -> "QNetworkReply":
        """
        https://doc.qt.io/qt-5/qnetworkaccessmanager.html#createRequest

        **[virtual protected] QNetworkReply
        *QNetworkAccessManager::createRequest(QNetworkAccessManager::Operation
        op , const QNetworkRequest & originalReq , QIODevice * outgoingData =
        nullptr)**

        Returns a new **QNetworkReply**  object to handle the operation **op**
        and request **originalReq**. The device **outgoingData** is always 0 for
        Get and Head requests, but is the value passed to **post** () and
        **put** () in those operations (the **QByteArray**  variants will pass a
        **QBuffer**  object).

        The default implementation calls **QNetworkCookieJar::cookiesForUrl** ()
        on the cookie jar set with **setCookieJar** () to obtain the cookies to
        be sent to the remote server.

        The returned object must be in an open state.
        """
        ...

    def networkAccessibleChanged(
        self, accessible: "QNetworkAccessManager.NetworkAccessibility"
    ) -> None:
        ...

    @typing.overload
    def put(
        self, request: "QNetworkRequest", data: QtCore.QIODevice
    ) -> "QNetworkReply":
        """
        https://doc.qt.io/qt-5/qnetworkaccessmanager.html#put

        **QNetworkReply *QNetworkAccessManager::put(const QNetworkRequest &
        request , QIODevice * data )**

        Uploads the contents of **data** to the destination **request** and
        returns a new **QNetworkReply**  object that will be open for reply.

        **data** must be opened for reading when this function is called and
        must remain valid until the **finished** () signal is emitted for this
        reply.

        Whether anything will be available for reading from the returned object
        is protocol dependent. For HTTP, the server may send a small HTML page
        indicating the upload was successful (or not). Other protocols will
        probably have content in their replies.

        **Note:** For HTTP, this request will send a PUT request, which most
        servers do not allow. Form upload mechanisms, including that of
        uploading files through HTML forms, use the POST mechanism.

        **See also** **get** (), **post** (), **deleteResource** (), and
        **sendCustomRequest** ().
        """
        ...

    @typing.overload
    def put(
        self,
        request: "QNetworkRequest",
        data: typing.Union[QtCore.QByteArray, bytes, bytearray],
    ) -> "QNetworkReply":
        """
        https://doc.qt.io/qt-5/qnetworkaccessmanager.html#put-1

        **QNetworkReply *QNetworkAccessManager::put(const QNetworkRequest &
        request , const QByteArray & data )**

        This is an overloaded function.

        Sends the contents of the **data** byte array to the destination
        specified by **request**.
        """
        ...

    @typing.overload
    def put(
        self, request: "QNetworkRequest", multiPart: QHttpMultiPart
    ) -> "QNetworkReply":
        """
        https://doc.qt.io/qt-5/qnetworkaccessmanager.html#put-2

        **QNetworkReply *QNetworkAccessManager::put(const QNetworkRequest &
        request , QHttpMultiPart * multiPart )**

        This is an overloaded function.

        Sends the contents of the **multiPart** message to the destination
        specified by **request**.

        This can be used for sending MIME multipart messages over HTTP.

        This function was introduced in Qt 4.8.

        **See also** **QHttpMultiPart** , **QHttpPart** , and **post** ().
        """
        ...

    @typing.overload
    def post(
        self, request: "QNetworkRequest", data: QtCore.QIODevice
    ) -> "QNetworkReply":
        """
        https://doc.qt.io/qt-5/qnetworkaccessmanager.html#post

        **QNetworkReply *QNetworkAccessManager::post(const QNetworkRequest &
        request , QIODevice * data )**

        Sends an HTTP POST request to the destination specified by **request**
        and returns a new **QNetworkReply**  object opened for reading that will
        contain the reply sent by the server. The contents of the **data**
        device will be uploaded to the server.

        **data** must be open for reading and must remain valid until the
        **finished** () signal is emitted for this reply.

        **Note:** Sending a POST request on protocols other than HTTP and HTTPS
        is undefined and will probably fail.

        **See also** **get** (), **put** (), **deleteResource** (), and
        **sendCustomRequest** ().
        """
        ...

    @typing.overload
    def post(
        self,
        request: "QNetworkRequest",
        data: typing.Union[QtCore.QByteArray, bytes, bytearray],
    ) -> "QNetworkReply":
        """
        https://doc.qt.io/qt-5/qnetworkaccessmanager.html#post-1

        **QNetworkReply *QNetworkAccessManager::post(const QNetworkRequest &
        request , const QByteArray & data )**

        This is an overloaded function.

        Sends the contents of the **data** byte array to the destination
        specified by **request**.
        """
        ...

    @typing.overload
    def post(
        self, request: "QNetworkRequest", multiPart: QHttpMultiPart
    ) -> "QNetworkReply":
        """
        https://doc.qt.io/qt-5/qnetworkaccessmanager.html#post-2

        **QNetworkReply *QNetworkAccessManager::post(const QNetworkRequest &
        request , QHttpMultiPart * multiPart )**

        This is an overloaded function.

        Sends the contents of the **multiPart** message to the destination
        specified by **request**.

        This can be used for sending MIME multipart messages over HTTP.

        This function was introduced in Qt 4.8.

        **See also** **QHttpMultiPart** , **QHttpPart** , and **put** ().
        """
        ...

    def get(self, request: "QNetworkRequest") -> "QNetworkReply":
        """
        https://doc.qt.io/qt-5/qnetworkaccessmanager.html#get

        **QNetworkReply *QNetworkAccessManager::get(const QNetworkRequest &
        request )**

        Posts a request to obtain the contents of the target **request** and
        returns a new **QNetworkReply**  object opened for reading which emits
        the **readyRead()**  signal whenever new data arrives.

        The contents as well as associated headers will be downloaded.

        **See also** **post** (), **put** (), **deleteResource** (), and
        **sendCustomRequest** ().
        """
        ...

    def head(self, request: "QNetworkRequest") -> "QNetworkReply":
        """
        https://doc.qt.io/qt-5/qnetworkaccessmanager.html#head

        **QNetworkReply *QNetworkAccessManager::head(const QNetworkRequest &
        request )**

        Posts a request to obtain the network headers for **request** and
        returns a new **QNetworkReply**  object which will contain such headers.

        The function is named after the HTTP request associated (HEAD).
        """
        ...

    def setCookieJar(self, cookieJar: "QNetworkCookieJar") -> None:
        """
        https://doc.qt.io/qt-5/qnetworkaccessmanager.html#setCookieJar

        **void QNetworkAccessManager::setCookieJar(QNetworkCookieJar * cookieJar
        )**

        Sets the manager's cookie jar to be the **cookieJar** specified. The
        cookie jar is used by all requests dispatched by the manager.

        Use this function to set the cookie jar object to a class that
        implements additional features, like saving the cookies to permanent
        storage.

        **Note:****QNetworkAccessManager**  takes ownership of the **cookieJar**
        object.

        If **cookieJar** is in the same thread as this **QNetworkAccessManager**
        , it will set the parent of the **cookieJar** so that the cookie jar is
        deleted when this object is deleted as well. If you want to share cookie
        jars between different **QNetworkAccessManager**  objects, you may want
        to set the cookie jar's parent to 0 after calling this function.

        **QNetworkAccessManager**  by default does not implement any cookie
        policy of its own: it accepts all cookies sent by the server, as long as
        they are well formed and meet the minimum security requirements (cookie
        domain matches the request's and cookie path matches the request's). In
        order to implement your own security policy, override the
        **QNetworkCookieJar::cookiesForUrl** () and
        **QNetworkCookieJar::setCookiesFromUrl** () virtual functions. Those
        functions are called by **QNetworkAccessManager**  when it detects a new
        cookie.

        **See also** **cookieJar** (), **QNetworkCookieJar::cookiesForUrl** (),
        and **QNetworkCookieJar::setCookiesFromUrl** ().
        """
        ...

    def cookieJar(self) -> "QNetworkCookieJar":
        """
        https://doc.qt.io/qt-5/qnetworkaccessmanager.html#cookieJar

        **QNetworkCookieJar *QNetworkAccessManager::cookieJar() const**

        Returns the **QNetworkCookieJar**  that is used to store cookies
        obtained from the network as well as cookies that are about to be sent.

        **See also** **setCookieJar** ().
        """
        ...

    def setProxy(self, proxy: "QNetworkProxy") -> None:
        """
        https://doc.qt.io/qt-5/qnetworkaccessmanager.html#setProxy

        **void QNetworkAccessManager::setProxy(const QNetworkProxy & proxy )**

        Sets the proxy to be used in future requests to be **proxy**. This does
        not affect requests that have already been sent. The
        **proxyAuthenticationRequired** () signal will be emitted if the proxy
        requests authentication.

        A proxy set with this function will be used for all requests issued by
        **QNetworkAccessManager** . In some cases, it might be necessary to
        select different proxies depending on the type of request being sent or
        the destination host. If that's the case, you should consider using
        **setProxyFactory** ().

        **See also** **proxy** () and **proxyAuthenticationRequired** ().
        """
        ...

    def proxy(self) -> "QNetworkProxy":
        """
        https://doc.qt.io/qt-5/qnetworkaccessmanager.html#proxy

        **QNetworkProxy QNetworkAccessManager::proxy() const**

        Returns the **QNetworkProxy**  that the requests sent using this
        **QNetworkAccessManager**  object will use. The default value for the
        proxy is **QNetworkProxy::DefaultProxy** .

        **See also** **setProxy** (), **setProxyFactory** (), and
        **proxyAuthenticationRequired** ().
        """
        ...

    @property
    def authenticationRequired(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qnetworkaccessmanager.html#authenticationRequired

        **[signal] void
        QNetworkAccessManager::authenticationRequired(QNetworkReply * reply ,
        QAuthenticator * authenticator )**

        This signal is emitted whenever a final server requests authentication
        before it delivers the requested contents. The slot connected to this
        signal should fill the credentials for the contents (which can be
        determined by inspecting the **reply** object) in the **authenticator**
        object.

        **QNetworkAccessManager**  will cache the credentials internally and
        will send the same values if the server requires authentication again,
        without emitting the authenticationRequired() signal. If it rejects the
        credentials, this signal will be emitted again.

        **Note:** To have the request not send credentials you must not call
        setUser() or setPassword() on the **authenticator** object. This will
        result in the **finished** () signal being emitted with a
        **QNetworkReply**  with error **AuthenticationRequiredError** .

        **Note:** It is not possible to use a QueuedConnection to connect to
        this signal, as the connection will fail if the authenticator has not
        been filled in with new information when the signal returns.

        **See also** **proxyAuthenticationRequired** (),
        **QAuthenticator::setUser** (), and **QAuthenticator::setPassword** ().
        """
        ...

    @property
    def encrypted(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qnetworkaccessmanager.html#encrypted

        **[signal] void QNetworkAccessManager::encrypted(QNetworkReply * reply
        )**

        This signal is emitted when an SSL/TLS session has successfully
        completed the initial handshake. At this point, no user data has been
        transmitted. The signal can be used to perform additional checks on the
        certificate chain, for example to notify users when the certificate for
        a website has changed. The **reply** parameter specifies which network
        reply is responsible. If the reply does not match the expected criteria
        then it should be aborted by calling **QNetworkReply::abort** () by a
        slot connected to this signal. The SSL configuration in use can be
        inspected using the **QNetworkReply::sslConfiguration** () method.

        Internally, **QNetworkAccessManager**  may open multiple connections to
        a server, in order to allow it process requests in parallel. These
        connections may be reused, which means that the encrypted() signal would
        not be emitted. This means that you are only guaranteed to receive this
        signal for the first connection to a site in the lifespan of the
        **QNetworkAccessManager** .

        This function was introduced in Qt 5.1.

        **See also** **QSslSocket::encrypted** () and
        **QNetworkReply::encrypted** ().
        """
        ...

    @property
    def finished(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qnetworkaccessmanager.html#finished

        **[signal] void QNetworkAccessManager::finished(QNetworkReply * reply
        )**

        This signal is emitted whenever a pending network reply is finished. The
        **reply** parameter will contain a pointer to the reply that has just
        finished. This signal is emitted in tandem with the
        **QNetworkReply::finished** () signal.

        See **QNetworkReply::finished** () for information on the status that
        the object will be in.

        **Note:** Do not delete the **reply** object in the slot connected to
        this signal. Use **deleteLater** ().

        **See also** **QNetworkReply::finished** () and **QNetworkReply::error**
        ().
        """
        ...

    @property
    def preSharedKeyAuthenticationRequired(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qnetworkaccessmanager.html#preSharedKeyAuthentica
        tionRequired

        **[signal] void
        QNetworkAccessManager::preSharedKeyAuthenticationRequired(QNetworkReply
        * reply , QSslPreSharedKeyAuthenticator * authenticator )**

        This signal is emitted if the SSL/TLS handshake negotiates a PSK
        ciphersuite, and therefore a PSK authentication is then required. The
        **reply** object is the **QNetworkReply**  that is negotiating such
        ciphersuites.

        When using PSK, the client must send to the server a valid identity and
        a valid pre shared key, in order for the SSL handshake to continue.
        Applications can provide this information in a slot connected to this
        signal, by filling in the passed **authenticator** object according to
        their needs.

        **Note:** Ignoring this signal, or failing to provide the required
        credentials, will cause the handshake to fail, and therefore the
        connection to be aborted.

        **Note:** The **authenticator** object is owned by the reply and must
        not be deleted by the application.

        This function was introduced in Qt 5.5.

        **See also** **QSslPreSharedKeyAuthenticator** .
        """
        ...

    @property
    def proxyAuthenticationRequired(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qnetworkaccessmanager.html#proxyAuthenticationReq
        uired

        **[signal] void QNetworkAccessManager::proxyAuthenticationRequired(const
        QNetworkProxy & proxy , QAuthenticator * authenticator )**

        This signal is emitted whenever a proxy requests authentication and
        **QNetworkAccessManager**  cannot find a valid, cached credential. The
        slot connected to this signal should fill in the credentials for the
        proxy **proxy** in the **authenticator** object.

        **QNetworkAccessManager**  will cache the credentials internally. The
        next time the proxy requests authentication, **QNetworkAccessManager**
        will automatically send the same credential without emitting the
        proxyAuthenticationRequired signal again.

        If the proxy rejects the credentials, **QNetworkAccessManager**  will
        emit the signal again.

        **See also** **proxy** (), **setProxy** (), and
        **authenticationRequired** ().
        """
        ...

    @property
    def sslErrors(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qnetworkaccessmanager.html#sslErrors

        **[signal] void QNetworkAccessManager::sslErrors(QNetworkReply * reply ,
        const QList<QSslError> & errors )**

        This signal is emitted if the SSL/TLS session encountered errors during
        the set up, including certificate verification errors. The **errors**
        parameter contains the list of errors and **reply** is the
        **QNetworkReply**  that is encountering these errors.

        To indicate that the errors are not fatal and that the connection should
        proceed, the **QNetworkReply::ignoreSslErrors** () function should be
        called from the slot connected to this signal. If it is not called, the
        SSL session will be torn down before any data is exchanged (including
        the URL).

        This signal can be used to display an error message to the user
        indicating that security may be compromised and display the SSL settings
        (see sslConfiguration() to obtain it). If the user decides to proceed
        after analyzing the remote certificate, the slot should call
        ignoreSslErrors().

        **See also** **QSslSocket::sslErrors** (), **QNetworkReply::sslErrors**
        (), **QNetworkReply::sslConfiguration** (), and
        **QNetworkReply::ignoreSslErrors** ().
        """
        ...
