"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
import PyQt5.sip
from PyQt5 import QtCore
from PyQt5.QtNetwork import *
from PyQt5 import sip


class QLocalServer(QtCore.QObject):
    """
    https://doc.qt.io/qt-5/qlocalserver.html

    **Detailed Description**

    This class makes it possible to accept incoming local socket connections.

    Call **listen** () to have the server start listening for incoming
    connections on a specified key. The **newConnection** () signal is then
    emitted each time a client connects to the server.

    Call **nextPendingConnection** () to accept the pending connection as a
    connected **QLocalSocket** . The function returns a pointer to a
    **QLocalSocket**  that can be used for communicating with the client.

    If an error occurs, **serverError** () returns the type of error, and
    **errorString** () can be called to get a human readable description of what
    happened.

    When listening for connections, the name which the server is listening on is
    available through **serverName** ().

    Calling **close** () makes QLocalServer stop listening for incoming
    connections.

    Although QLocalServer is designed for use with an event loop, it's possible
    to use it without one. In that case, you must use **waitForNewConnection**
    (), which blocks until either a connection is available or a timeout
    expires.

    **See also** **QLocalSocket**  and **QTcpServer** .
    """

    class SocketOption(int):
        UserAccessOption: QLocalServer = ...
        GroupAccessOption: QLocalServer = ...
        OtherAccessOption: QLocalServer = ...
        WorldAccessOption: QLocalServer = ...

    class SocketOptions(sip.simplewrapper):
        @typing.overload
        def __init__(self) -> None:
            ...

        @typing.overload
        def __init__(
            self,
            f: typing.Union["QLocalServer.SocketOptions", "QLocalServer.SocketOption"],
        ) -> None:
            ...

        @typing.overload
        def __init__(self, a0: "QLocalServer.SocketOptions") -> None:
            ...

        def __hash__(self) -> int:
            ...

        def __bool__(self) -> int:
            ...

        def __invert__(self) -> "QLocalServer.SocketOptions":
            ...

        def __index__(self) -> int:
            ...

        def __int__(self) -> int:
            ...

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qlocalserver.html#QLocalServer

        **QLocalServer::QLocalServer(QObject * parent = nullptr)**

        Create a new local socket server with the given **parent**.

        **See also** **listen** ().
        """
        ...

    def socketDescriptor(self) -> PyQt5.sip.voidptr:
        """
        https://doc.qt.io/qt-5/qlocalserver.html#socketDescriptor

        **qintptr QLocalServer::socketDescriptor() const**

        Returns the native socket descriptor the server uses to listen for
        incoming instructions, or -1 if the server is not listening.

        The type of the descriptor depends on the platform:

        * On Windows, the returned value is a **Winsock 2 Socket Handle** .
          *
        With WinRT and on INTEGRITY, the returned value is the **QTcpServer**
        socket descriptor and the type is defined by **socketDescriptor** .
          *
        On all other UNIX-like operating systems, the type is a file descriptor
        representing a listening socket.

        This function was introduced in Qt 5.10.

        **See also** **listen** ().
        """
        ...

    def socketOptions(self) -> "QLocalServer.SocketOptions":
        """
        https://doc.qt.io/qt-5/qlocalserver.html#socketOptions

        **QLocalServer::SocketOptions QLocalServer::socketOptions() const**

        Returns the socket options set on the socket.

        **Note:** Getter function for property socketOptions.

        This function was introduced in Qt 5.0.

        **See also** **setSocketOptions** ().
        """
        ...

    def setSocketOptions(
        self,
        options: typing.Union[
            "QLocalServer.SocketOptions", "QLocalServer.SocketOption"
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-5/qlocalserver.html#socketOptions-prop

        **socketOptions : SocketOptions**

        The setSocketOptions method controls how the socket operates. For
        example the socket may restrict access to what user ids can connect to
        the socket.

        These options must be set before **listen** () is called.

        In some cases, such as with Unix domain sockets on Linux, the access to
        the socket will be determined by file system permissions, and are
        created based on the umask. Setting the access flags will overide this
        and will restrict or permit access as specified.

        Other Unix-based operating systems, such as macOS, do not honor file
        permissions for Unix domain sockets and by default have WorldAccess and
        these permission flags will have no effect.

        On Windows, **UserAccessOption**  is sufficient to allow a non elevated
        process to connect to a local server created by an elevated process run
        by the same user. **GroupAccessOption**  refers to the primary group of
        the process (see TokenPrimaryGroup in the Windows documentation).
        **OtherAccessOption**  refers to the well known "Everyone" group.

        By default none of the flags are set, access permissions are the
        platform default.

        This property was introduced in Qt 5.0.

        **Access functions:**

        QLocalServer::SocketOptions ****socketOptions** ** () const
        void
        **setSocketOptions** (QLocalServer::SocketOptions **options** )

        **See also** **listen** ().

        **Member Function Documentation**
        """
        ...

    def incomingConnection(self, socketDescriptor: PyQt5.sip.voidptr) -> None:
        """
        https://doc.qt.io/qt-5/qlocalserver.html#incomingConnection

        **[virtual protected] void QLocalServer::incomingConnection(quintptr
        socketDescriptor )**

        This virtual function is called by **QLocalServer**  when a new
        connection is available. **socketDescriptor** is the native socket
        descriptor for the accepted connection.

        The base implementation creates a **QLocalSocket** , sets the socket
        descriptor and then stores the **QLocalSocket**  in an internal list of
        pending connections. Finally **newConnection** () is emitted.

        Reimplement this function to alter the server's behavior when a
        connection is available.

        **See also** **newConnection** (), **nextPendingConnection** (), and
        **QLocalSocket::setSocketDescriptor** ().
        """
        ...

    @staticmethod
    def removeServer(name: str) -> bool:
        """
        https://doc.qt.io/qt-5/qlocalserver.html#removeServer

        **[static] bool QLocalServer::removeServer(const QString & name )**

        Removes any server instance that might cause a call to **listen** () to
        fail and returns `true` if successful; otherwise returns `false`. This
        function is meant to recover from a crash, when the previous server
        instance has not been cleaned up.

        On Windows, this function does nothing; on Unix, it removes the socket
        file given by **name**.

        **Warning:** Be careful to avoid removing sockets of running instances.

        This function was introduced in Qt 4.5.
        """
        ...

    def waitForNewConnection(self, msecs: int = ...) -> typing.Tuple[bool, bool]:
        """
        https://doc.qt.io/qt-5/qlocalserver.html#waitForNewConnection

        **bool QLocalServer::waitForNewConnection(int msec = 0, bool * timedOut
        = nullptr)**

        Waits for at most **msec** milliseconds or until an incoming connection
        is available. Returns `true` if a connection is available; otherwise
        returns `false`. If the operation timed out and **timedOut** is not
        `nullptr`, *timedOut will be set to true.

        This is a blocking function call. Its use is ill-advised in a single-
        threaded GUI application, since the whole application will stop
        responding until the function returns. waitForNewConnection() is mostly
        useful when there is no event loop available.

        The non-blocking alternative is to connect to the **newConnection** ()
        signal.

        If msec is -1, this function will not time out.

        **See also** **hasPendingConnections** () and **nextPendingConnection**
        ().
        """
        ...

    def setMaxPendingConnections(self, numConnections: int) -> None:
        """
        https://doc.qt.io/qt-5/qlocalserver.html#setMaxPendingConnections

        **void QLocalServer::setMaxPendingConnections(int numConnections )**

        Sets the maximum number of pending accepted connections to
        **numConnections**. **QLocalServer**  will accept no more than
        **numConnections** incoming connections before **nextPendingConnection**
        () is called.

        Note: Even though **QLocalServer**  will stop accepting new connections
        after it has reached its maximum number of pending connections, the
        operating system may still keep them in queue which will result in
        clients signaling that it is connected.

        **See also** **maxPendingConnections** () and **hasPendingConnections**
        ().
        """
        ...

    def serverError(self) -> QAbstractSocket.SocketError:
        """
        https://doc.qt.io/qt-5/qlocalserver.html#serverError

        **QAbstractSocket::SocketError QLocalServer::serverError() const**

        Returns the type of error that occurred last or **NoError** .

        **See also** **errorString** ().
        """
        ...

    def fullServerName(self) -> str:
        """
        https://doc.qt.io/qt-5/qlocalserver.html#fullServerName

        **QString QLocalServer::fullServerName() const**

        Returns the full path that the server is listening on.

        Note: This is platform specific

        **See also** **listen** () and **serverName** ().
        """
        ...

    def serverName(self) -> str:
        """
        https://doc.qt.io/qt-5/qlocalserver.html#serverName

        **QString QLocalServer::serverName() const**

        Returns the server name if the server is listening for connections;
        otherwise returns QString()

        **See also** **listen** () and **fullServerName** ().
        """
        ...

    def nextPendingConnection(self) -> "QLocalSocket":
        """
        https://doc.qt.io/qt-5/qlocalserver.html#nextPendingConnection

        **[virtual] QLocalSocket *QLocalServer::nextPendingConnection()**

        Returns the next pending connection as a connected **QLocalSocket**
        object.

        The socket is created as a child of the server, which means that it is
        automatically deleted when the **QLocalServer**  object is destroyed. It
        is still a good idea to delete the object explicitly when you are done
        with it, to avoid wasting memory.

        `nullptr` is returned if this function is called when there are no
        pending connections.

        **See also** **hasPendingConnections** (), **newConnection** (), and
        **incomingConnection** ().
        """
        ...

    def maxPendingConnections(self) -> int:
        """
        https://doc.qt.io/qt-5/qlocalserver.html#maxPendingConnections

        **int QLocalServer::maxPendingConnections() const**

        Returns the maximum number of pending accepted connections. The default
        is 30.

        **See also** **setMaxPendingConnections** () and
        **hasPendingConnections** ().
        """
        ...

    @typing.overload
    def listen(self, name: str) -> bool:
        """
        https://doc.qt.io/qt-5/qlocalserver.html#listen

        **bool QLocalServer::listen(const QString & name )**

        Tells the server to listen for incoming connections on **name**. If the
        server is currently listening then it will return false. Return true on
        success otherwise false.

        **name** can be a single name and **QLocalServer**  will determine the
        correct platform specific path. **serverName** () will return the name
        that is passed into listen.

        Usually you would just pass in a name like "foo", but on Unix this could
        also be a path such as "/tmp/foo" and on Windows this could be a pipe
        path such as "\\\\\\\\.\\pipe\\foo"

        **Note:** On Unix if the server crashes without closing listen will fail
        with AddressInUseError. To create a new server the file should be
        removed. On Windows two local servers can listen to the same pipe at the
        same time, but any connections will go to one of the server.

        **See also** **serverName** (), **isListening** (), and **close** ().
        """
        ...

    @typing.overload
    def listen(self, socketDescriptor: PyQt5.sip.voidptr) -> bool:
        """
        https://doc.qt.io/qt-5/qlocalserver.html#listen-1

        **bool QLocalServer::listen(qintptr socketDescriptor )**

        Instructs the server to listen for incoming connections on
        **socketDescriptor**. The property returns `false` if the server is
        currently listening. It returns `true` on success; otherwise, it returns
        `false`. The socket must be ready to accept new connections with no
        extra platform-specific functions called. The socket is set into non-
        blocking mode.

        **serverName** (), **fullServerName** () may return a string with a name
        if this option is supported by the platform; otherwise, they return an
        empty **QString** .

        This function was introduced in Qt 5.0.

        **See also** **isListening** () and **close** ().
        """
        ...

    def isListening(self) -> bool:
        """
        https://doc.qt.io/qt-5/qlocalserver.html#isListening

        **bool QLocalServer::isListening() const**

        Returns `true` if the server is listening for incoming connections
        otherwise false.

        **See also** **listen** () and **close** ().
        """
        ...

    def hasPendingConnections(self) -> bool:
        """
        https://doc.qt.io/qt-5/qlocalserver.html#hasPendingConnections

        **[virtual] bool QLocalServer::hasPendingConnections() const**

        Returns `true` if the server has a pending connection; otherwise returns
        `false`.

        **See also** **nextPendingConnection** () and
        **setMaxPendingConnections** ().
        """
        ...

    def errorString(self) -> str:
        """
        https://doc.qt.io/qt-5/qlocalserver.html#errorString

        **QString QLocalServer::errorString() const**

        Returns the human-readable message appropriate to the current error
        reported by **serverError** (). If no suitable string is available, an
        empty string is returned.

        **See also** **serverError** ().
        """
        ...

    def close(self) -> None:
        """
        https://doc.qt.io/qt-5/qlocalserver.html#close

        **void QLocalServer::close()**

        Stop listening for incoming connections. Existing connections are not
        affected, but any new connections will be refused.

        **See also** **isListening** () and **listen** ().
        """
        ...

    @property
    def newConnection(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qlocalserver.html#newConnection

        **[signal] void QLocalServer::newConnection()**

        This signal is emitted every time a new connection is available.

        **See also** **hasPendingConnections** () and **nextPendingConnection**
        ().
        """
        ...
