"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
from PyQt5 import sip


class QHttp2Configuration(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qhttp2configuration.html

    **Detailed Description**

    QHttp2Configuration controls HTTP/2 parameters and settings that
    **QNetworkAccessManager**  will use to send requests and process responses
    when the HTTP/2 protocol is enabled.

    The HTTP/2 parameters that QHttp2Configuration currently supports include:

    * The session window size for connection-level flow control. Will be sent to
    a remote peer when needed as 'WINDOW_UPDATE' frames on the stream with an
    identifier 0.
      * The stream receiving window size for stream-level flow
    control. Sent as 'SETTINGS_INITIAL_WINDOW_SIZE' parameter in the initial
    SETTINGS frame and, when needed, 'WINDOW_UPDATE' frames will be sent on
    streams that **QNetworkAccessManager**  opens.
      * The maximum frame size.
    This parameter limits the maximum payload a frame coming from the remote
    peer can have. Sent by **QNetworkAccessManager**  as
    'SETTINGS_MAX_FRAME_SIZE' parameter in the initial 'SETTINGS' frame.
      * The
    server push. Allows to enable or disable server push. Sent as
    'SETTINGS_ENABLE_PUSH' parameter in the initial 'SETTINGS' frame.

    The QHttp2Configuration class also controls if the header compression
    algorithm (HPACK) is additionally using Huffman coding for string
    compression.

    **Note:** The configuration must be set before the first request was sent to
    a given host (and thus an HTTP/2 session established).

    **Note:** Details about flow control, server push and 'SETTINGS' can be
    found in **RFC 7540** . Different modes and parameters of the HPACK
    compression algorithm are described in **RFC 7541** .

    **See also** **QNetworkRequest::setHttp2Configuration** (),
    **QNetworkRequest::http2Configuration** (), and **QNetworkAccessManager** .
    """

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qhttp2configuration.html#QHttp2Configuration

        **QHttp2Configuration::QHttp2Configuration()**

        Default constructs a QHttp2Configuration object.

        Such a configuration has the following values:

        * Server push is disabled
          * Huffman string compression is enabled
          *
        Window size for connection-level flow control is 65535 octets
          * Window
        size for stream-level flow control is 65535 octets
          * Frame size is
        16384 octets
        """
        ...

    @typing.overload
    def __init__(self, other: "QHttp2Configuration") -> None:
        """
        https://doc.qt.io/qt-5/qhttp2configuration.html#QHttp2Configuration-1

        **QHttp2Configuration::QHttp2Configuration(const QHttp2Configuration &
        other )**

        Copy-constructs this QHttp2Configuration.
        """
        ...

    def swap(self, other: "QHttp2Configuration") -> None:
        """
        https://doc.qt.io/qt-5/qhttp2configuration.html#swap

        **void QHttp2Configuration::swap(QHttp2Configuration & other )**

        Swaps this configuration with the **other** configuration.
        """
        ...

    def maxFrameSize(self) -> int:
        """
        https://doc.qt.io/qt-5/qhttp2configuration.html#maxFrameSize

        **unsigned int QHttp2Configuration::maxFrameSize() const**

        The maximum payload size that HTTP/2 frames can have. The default
        (initial) value is 16384 octets.

        **See also** **setMaxFrameSize** ().
        """
        ...

    def setMaxFrameSize(self, size: int) -> bool:
        """
        https://doc.qt.io/qt-5/qhttp2configuration.html#setMaxFrameSize

        **bool QHttp2Configuration::setMaxFrameSize(unsigned int size )**

        Sets the maximum frame size that **QNetworkAccessManager**  will
        advertise to the server when sending its initial SETTINGS frame.

        **Note:** While this **size** is required to be within a range between
        16384 and 16777215 inclusive, the actual payload size in frames that
        carry payload maybe be less than 16384.

        **See also** **maxFrameSize** ().
        """
        ...

    def streamReceiveWindowSize(self) -> int:
        """
        https://doc.qt.io/qt-5/qhttp2configuration.html#streamReceiveWindowSize

        **unsigned int QHttp2Configuration::streamReceiveWindowSize() const**

        Returns the window size for stream-level flow control. The default value
        **QNetworkAccessManager**  will be using is 21474836 octets.

        **See also** **setStreamReceiveWindowSize** ().
        """
        ...

    def setStreamReceiveWindowSize(self, size: int) -> bool:
        """
        https://doc.qt.io/qt-5/qhttp2configuration.html#setStreamReceiveWindowSi
        ze

        **bool QHttp2Configuration::setStreamReceiveWindowSize(unsigned int size
        )**

        Sets the window size for stream-level flow control. **size** cannot be 0
        and must not exceed 2147483647 octets.

        **See also** **streamReceiveWindowSize** .
        """
        ...

    def sessionReceiveWindowSize(self) -> int:
        """
        https://doc.qt.io/qt-5/qhttp2configuration.html#sessionReceiveWindowSize

        **unsigned int QHttp2Configuration::sessionReceiveWindowSize() const**

        Returns the window size for connection-level flow control. The default
        value **QNetworkAccessManager**  will be using is 2147483647 octets.

        **See also** **setSessionReceiveWindowSize** ().
        """
        ...

    def setSessionReceiveWindowSize(self, size: int) -> bool:
        """
        https://doc.qt.io/qt-5/qhttp2configuration.html#setSessionReceiveWindowS
        ize

        **bool QHttp2Configuration::setSessionReceiveWindowSize(unsigned int
        size )**

        Sets the window size for connection-level flow control. **size** cannot
        be 0 and must not exceed 2147483647 octets.

        **See also** **sessionReceiveWindowSize** .
        """
        ...

    def huffmanCompressionEnabled(self) -> bool:
        """
        https://doc.qt.io/qt-5/qhttp2configuration.html#huffmanCompressionEnable
        d

        **bool QHttp2Configuration::huffmanCompressionEnabled() const**

        Returns `true` if the Huffman coding in HPACK is enabled.

        **See also** **setHuffmanCompressionEnabled** .
        """
        ...

    def setHuffmanCompressionEnabled(self, enable: bool) -> None:
        """
        https://doc.qt.io/qt-5/qhttp2configuration.html#setHuffmanCompressionEna
        bled

        **void QHttp2Configuration::setHuffmanCompressionEnabled(bool enable )**

        If **enable** is `true`, HPACK compression will additionally compress
        string using the Huffman coding. Enabled by default.

        **Note:** This parameter only affects 'HEADERS' frames that
        **QNetworkAccessManager**  is sending.

        **See also** **huffmanCompressionEnabled** .
        """
        ...

    def serverPushEnabled(self) -> bool:
        """
        https://doc.qt.io/qt-5/qhttp2configuration.html#serverPushEnabled

        **bool QHttp2Configuration::serverPushEnabled() const**

        Returns true if server push was enabled.

        **Note:** By default, **QNetworkAccessManager**  disables server push
        via the 'SETTINGS' frame.

        **See also** **setServerPushEnabled** .
        """
        ...

    def setServerPushEnabled(self, enable: bool) -> None:
        """
        https://doc.qt.io/qt-5/qhttp2configuration.html#setServerPushEnabled

        **void QHttp2Configuration::setServerPushEnabled(bool enable )**

        If **enable** is `true`, a remote server can potentially use server push
        to send reponses in advance.

        **See also** **serverPushEnabled** .
        """
        ...
