"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
from PyQt5.QtNetwork import *
from PyQt5 import sip


class QHostInfo(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qhostinfo.html

    **Detailed Description**

    QHostInfo finds the IP address(es) associated with a host name, or the host
    name associated with an IP address. The class provides two static
    convenience functions: one that works asynchronously and emits a signal once
    the host is found, and one that blocks and returns a QHostInfo object.

    To look up a host's IP addresses asynchronously, call **lookupHost** (),
    which takes the host name or IP address, a receiver object, and a slot
    signature as arguments and returns an ID. You can abort the lookup by
    calling **abortHostLookup** () with the lookup ID.

    Example:

    // To find the IP address of qt-project.org
        **QHostInfo**
    ::lookupHost("qt-project.org",
                              this,
    SLOT(printResults(**QHostInfo** )));

        // To find the host name for
    4.2.2.1
        **QHostInfo** ::lookupHost("4.2.2.1",
    this, SLOT(printResults(**QHostInfo** )));

    The slot is invoked when the results are ready. The results are stored in a
    QHostInfo object. Call **addresses** () to get the list of IP addresses for
    the host, and **hostName** () to get the host name that was looked up.

    If the lookup failed, **error** () returns the type of error that occurred.
    **errorString** () gives a human-readable description of the lookup error.

    If you want a blocking lookup, use the **QHostInfo::fromName** () function:

    **QHostInfo**  info = **QHostInfo** ::fromName("qt-project.org");

    QHostInfo supports Internationalized Domain Names (IDNs) through the IDNA
    and Punycode standards.

    To retrieve the name of the local host, use the static
    **QHostInfo::localHostName** () function.

    QHostInfo uses the mechanisms provided by the operating system to perform
    the lookup. As per {https://tools.ietf.org/html/rfc6724}{RFC 6724} there is
    no guarantee that all IP addresses registered for a domain or host will be
    returned.

    **Note:** Since Qt 4.6.1 QHostInfo is using multiple threads for DNS lookup
    instead of one dedicated DNS thread. This improves performance, but also
    changes the order of signal emissions when using **lookupHost** () compared
    to previous versions of Qt.

    **Note:** Since Qt 4.6.3 QHostInfo is using a small internal 60 second DNS
    cache for performance improvements.

    **See also** **QAbstractSocket** , **RFC 3492** , and **RFC 6724** .
    """

    class HostInfoError(int):
        NoError: QHostInfo = ...
        HostNotFound: QHostInfo = ...
        UnknownError: QHostInfo = ...

    @typing.overload
    def __init__(self, id: int = ...) -> None:
        """
        https://doc.qt.io/qt-5/qhostinfo.html#QHostInfo

        **QHostInfo::QHostInfo(int id = -1)**

        Constructs an empty host info object with lookup ID **id**.

        **See also** **lookupId** ().
        """
        ...

    @typing.overload
    def __init__(self, d: "QHostInfo") -> None:
        """
        https://doc.qt.io/qt-5/qhostinfo.html#QHostInfo-1

        **QHostInfo::QHostInfo(const QHostInfo & other )**

        Constructs a copy of **other**.
        """
        ...

    def swap(self, other: "QHostInfo") -> None:
        """
        https://doc.qt.io/qt-5/qhostinfo.html#swap

        **void QHostInfo::swap(QHostInfo & other )**

        Swaps host-info **other** with this host-info. This operation is very
        fast and never fails.

        This function was introduced in Qt 5.10.
        """
        ...

    @staticmethod
    def localDomainName() -> str:
        """
        https://doc.qt.io/qt-5/qhostinfo.html#localDomainName

        **[static] QString QHostInfo::localDomainName()**

        Returns the DNS domain of this machine.

        **Note:** DNS domains are not related to domain names found in Windows
        networks.

        **See also** **hostName** ().
        """
        ...

    @staticmethod
    def localHostName() -> str:
        """
        https://doc.qt.io/qt-5/qhostinfo.html#localHostName

        **[static] QString QHostInfo::localHostName()**

        Returns this machine's host name, if one is configured. Note that
        hostnames are not guaranteed to be globally unique, especially if they
        were configured automatically.

        This function does not guarantee the returned host name is a Fully
        Qualified Domain Name (FQDN). For that, use **fromName** () to resolve
        the returned name to an FQDN.

        This function returns the same as **QSysInfo::machineHostName** ().

        **See also** **hostName** () and **localDomainName** ().
        """
        ...

    @staticmethod
    def fromName(name: str) -> "QHostInfo":
        """
        https://doc.qt.io/qt-5/qhostinfo.html#fromName

        **[static] QHostInfo QHostInfo::fromName(const QString & name )**

        Looks up the IP address(es) for the given host **name**. The function
        blocks during the lookup which means that execution of the program is
        suspended until the results of the lookup are ready. Returns the result
        of the lookup in a **QHostInfo**  object.

        If you pass a literal IP address to **name** instead of a host name,
        **QHostInfo**  will search for the domain name for the IP (i.e.,
        **QHostInfo**  will perform a **reverse** lookup). On success, the
        returned **QHostInfo**  will contain both the resolved domain name and
        IP addresses for the host name.

        **See also** **lookupHost** ().
        """
        ...

    @staticmethod
    def abortHostLookup(lookupId: int) -> None:
        """
        https://doc.qt.io/qt-5/qhostinfo.html#abortHostLookup

        **[static] void QHostInfo::abortHostLookup(int id )**

        Aborts the host lookup with the ID **id** , as returned by
        **lookupHost** ().

        **See also** **lookupHost** () and **lookupId** ().
        """
        ...

    @staticmethod
    def lookupHost(name: str, slot: PYQT_SLOT) -> int:
        """
        https://doc.qt.io/qt-5/qhostinfo.html#lookupHost

        **[static] int QHostInfo::lookupHost(const QString & name , QObject *
        receiver , const char * member )**

        Looks up the IP address(es) associated with host name **name** , and
        returns an ID for the lookup. When the result of the lookup is ready,
        the slot or signal **member** in **receiver** is called with a
        **QHostInfo**  argument. The **QHostInfo**  object can then be inspected
        to get the results of the lookup.

        The lookup is performed by a single function call, for example:

        **QHostInfo** ::lookupHost("www.kde.org",
        this, SLOT(lookedUp(**QHostInfo** )));

        The implementation of the slot prints basic information about the
        addresses returned by the lookup, or reports an error if it failed:

        void MyWidget::lookedUp(const **QHostInfo**  &host)
            {
                if
        (host.error() != **QHostInfo** ::NoError) {
                    **qDebug** () <<
        "Lookup failed:" << host.errorString();
                    return;
                }
        const auto addresses = host.addresses();
                for (const
        **QHostAddress**  &address : addresses)
                    **qDebug** () <<
        "Found address:" << address.toString();
            }

        If you pass a literal IP address to **name** instead of a host name,
        **QHostInfo**  will search for the domain name for the IP (i.e.,
        **QHostInfo**  will perform a **reverse** lookup). On success, the
        resulting **QHostInfo**  will contain both the resolved domain name and
        IP addresses for the host name. Example:

        **QHostInfo** ::lookupHost("4.2.2.1",
                                  this,
        SLOT(lookedUp(**QHostInfo** )));

        **Note:** There is no guarantee on the order the signals will be emitted
        if you start multiple requests with lookupHost().

        **See also** **abortHostLookup** (), **addresses** (), **error** (), and
        **fromName** ().
        """
        ...

    def lookupId(self) -> int:
        """
        https://doc.qt.io/qt-5/qhostinfo.html#lookupId

        **int QHostInfo::lookupId() const**

        Returns the ID of this lookup.

        **See also** **setLookupId** (), **abortHostLookup** (), and
        **hostName** ().
        """
        ...

    def setLookupId(self, id: int) -> None:
        """
        https://doc.qt.io/qt-5/qhostinfo.html#setLookupId

        **void QHostInfo::setLookupId(int id )**

        Sets the ID of this lookup to **id**.

        **See also** **lookupId** () and **lookupHost** ().
        """
        ...

    def setErrorString(self, errorString: str) -> None:
        """
        https://doc.qt.io/qt-5/qhostinfo.html#setErrorString

        **void QHostInfo::setErrorString(const QString & str )**

        Sets the human readable description of the error that occurred to
        **str** if the lookup failed.

        **See also** **errorString** () and **setError** ().
        """
        ...

    def errorString(self) -> str:
        """
        https://doc.qt.io/qt-5/qhostinfo.html#errorString

        **QString QHostInfo::errorString() const**

        If the lookup failed, this function returns a human readable description
        of the error; otherwise "Unknown error" is returned.

        **See also** **setErrorString** () and **error** ().
        """
        ...

    def setError(self, error: "QHostInfo.HostInfoError") -> None:
        """
        https://doc.qt.io/qt-5/qhostinfo.html#setError

        **void QHostInfo::setError(QHostInfo::HostInfoError error )**

        Sets the error type of this **QHostInfo**  to **error**.

        **See also** **error** () and **errorString** ().
        """
        ...

    def error(self) -> "QHostInfo.HostInfoError":
        """
        https://doc.qt.io/qt-5/qhostinfo.html#error

        **QHostInfo::HostInfoError QHostInfo::error() const**

        Returns the type of error that occurred if the host name lookup failed;
        otherwise returns **NoError** .

        **See also** **setError** () and **errorString** ().
        """
        ...

    def setAddresses(
        self,
        addresses: typing.Iterable[
            typing.Union[QHostAddress, QHostAddress.SpecialAddress]
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-5/qhostinfo.html#setAddresses

        **void QHostInfo::setAddresses(const QList<QHostAddress> & addresses )**

        Sets the list of addresses in this **QHostInfo**  to **addresses**.

        **See also** **addresses** ().
        """
        ...

    def addresses(self) -> typing.List[QHostAddress]:
        """
        https://doc.qt.io/qt-5/qhostinfo.html#addresses

        **QList<QHostAddress> QHostInfo::addresses() const**

        Returns the list of IP addresses associated with **hostName** (). This
        list may be empty.

        Example:

        **QHostInfo**  info;
            ...
            if (!info.addresses().isEmpty()) {
        **QHostAddress**  address = info.addresses().first();
                // use the
        first IP address
            }

        **See also** **setAddresses** (), **hostName** (), and **error** ().
        """
        ...

    def setHostName(self, name: str) -> None:
        """
        https://doc.qt.io/qt-5/qhostinfo.html#setHostName

        **void QHostInfo::setHostName(const QString & hostName )**

        Sets the host name of this **QHostInfo**  to **hostName**.

        **See also** **hostName** ().
        """
        ...

    def hostName(self) -> str:
        """
        https://doc.qt.io/qt-5/qhostinfo.html#hostName

        **QString QHostInfo::hostName() const**

        Returns the name of the host whose IP addresses were looked up.

        **See also** **setHostName** () and **localHostName** ().
        """
        ...
