"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
from PyQt5 import sip


class QDnsDomainNameRecord(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qdnsdomainnamerecord.html

    **Detailed Description**

    When performing a name server lookup, zero or more records will be returned.
    Each record is represented by a QDnsDomainNameRecord instance.

    **See also** **QDnsLookup** .
    """

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qdnsdomainnamerecord.html#QDnsDomainNameRecord

        **QDnsDomainNameRecord::QDnsDomainNameRecord()**

        Constructs an empty domain name record object.
        """
        ...

    @typing.overload
    def __init__(self, other: "QDnsDomainNameRecord") -> None:
        """
        https://doc.qt.io/qt-5/qdnsdomainnamerecord.html#QDnsDomainNameRecord-1

        **QDnsDomainNameRecord::QDnsDomainNameRecord(const QDnsDomainNameRecord
        & other )**

        Constructs a copy of **other**.
        """
        ...

    def value(self) -> str:
        """
        https://doc.qt.io/qt-5/qdnsdomainnamerecord.html#value

        **QString QDnsDomainNameRecord::value() const**

        Returns the value for this domain name record.
        """
        ...

    def timeToLive(self) -> int:
        """
        https://doc.qt.io/qt-5/qdnsdomainnamerecord.html#timeToLive

        **quint32 QDnsDomainNameRecord::timeToLive() const**

        Returns the duration in seconds for which this record is valid.
        """
        ...

    def name(self) -> str:
        """
        https://doc.qt.io/qt-5/qdnsdomainnamerecord.html#name

        **QString QDnsDomainNameRecord::name() const**

        Returns the name for this record.
        """
        ...

    def swap(self, other: "QDnsDomainNameRecord") -> None:
        """
        https://doc.qt.io/qt-5/qdnsdomainnamerecord.html#swap

        **void QDnsDomainNameRecord::swap(QDnsDomainNameRecord & other )**

        Swaps this domain-name record instance with **other**. This function is
        very fast and never fails.
        """
        ...
