"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
import PyQt5.sip
from PyQt5 import QtWidgets
from PyQt5 import QtMultimedia
from PyQt5 import QtCore


class QVideoWidgetControl(QtMultimedia.QMediaControl):
    """
    https://doc.qt.io/qt-5/qvideowidgetcontrol.html

    **Detailed Description**

    The **videoWidget** () property of QVideoWidgetControl provides a pointer to
    a video widget implemented by the control's media service. This widget is
    owned by the media service and so care should be taken not to delete it.

    **QVideoWidgetControl**  *widgetControl =
    mediaService->requestControl<**QVideoWidgetControl**  *>();
    layout->addWidget(widgetControl->videoWidget());

    QVideoWidgetControl is one of number of possible video output controls.

    The interface name of QVideoWidgetControl is `org.qt-
    project.qt.videowidgetcontrol/5.0` as defined in **QVideoWidgetControl_iid**
    .

    **See also** **QMediaService::requestControl** () and **QVideoWidget** .
    """

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qvideowidgetcontrol.html#QVideoWidgetControl

        **[protected] QVideoWidgetControl::QVideoWidgetControl(QObject * parent
        = nullptr)**

        Constructs a new video widget control with the given **parent**.
        """
        ...

    def setSaturation(self, saturation: int) -> None:
        """
        https://doc.qt.io/qt-5/qvideowidgetcontrol.html#setSaturation

        **[pure virtual] void QVideoWidgetControl::setSaturation(int saturation
        )**

        Sets a **saturation** adjustment for a video widget.

        Valid saturation values range between -100 and 100, the default is 0.

        **See also** **saturation** ().
        """
        ...

    def saturation(self) -> int:
        """
        https://doc.qt.io/qt-5/qvideowidgetcontrol.html#saturation

        **[pure virtual] int QVideoWidgetControl::saturation() const**

        Returns the saturation adjustment applied to a video widget.

        Value saturation values range between -100 and 100, the default is 0.

        **See also** **setSaturation** ().
        """
        ...

    def setHue(self, hue: int) -> None:
        """
        https://doc.qt.io/qt-5/qvideowidgetcontrol.html#setHue

        **[pure virtual] void QVideoWidgetControl::setHue(int hue )**

        Sets a **hue** adjustment for a video widget.

        Valid hue values range between -100 and 100, the default is 0.

        **See also** **hue** ().
        """
        ...

    def hue(self) -> int:
        """
        https://doc.qt.io/qt-5/qvideowidgetcontrol.html#hue

        **[pure virtual] int QVideoWidgetControl::hue() const**

        Returns the hue adjustment applied to a video widget.

        Value hue values range between -100 and 100, the default is 0.

        **See also** **setHue** ().
        """
        ...

    def setContrast(self, contrast: int) -> None:
        """
        https://doc.qt.io/qt-5/qvideowidgetcontrol.html#setContrast

        **[pure virtual] void QVideoWidgetControl::setContrast(int contrast )**

        Sets the contrast adjustment for a video widget to **contrast**.

        Valid contrast values range between -100 and 100, the default is 0.

        **See also** **contrast** ().
        """
        ...

    def contrast(self) -> int:
        """
        https://doc.qt.io/qt-5/qvideowidgetcontrol.html#contrast

        **[pure virtual] int QVideoWidgetControl::contrast() const**

        Returns the contrast adjustment applied to a video.

        Valid contrast values range between -100 and 100, the default is 0.

        **See also** **setContrast** ().
        """
        ...

    def setBrightness(self, brightness: int) -> None:
        """
        https://doc.qt.io/qt-5/qvideowidgetcontrol.html#setBrightness

        **[pure virtual] void QVideoWidgetControl::setBrightness(int brightness
        )**

        Sets a **brightness** adjustment for a video.

        Valid brightness values range between -100 and 100, the default is 0.

        **See also** **brightness** ().
        """
        ...

    def brightness(self) -> int:
        """
        https://doc.qt.io/qt-5/qvideowidgetcontrol.html#brightness

        **[pure virtual] int QVideoWidgetControl::brightness() const**

        Returns the brightness adjustment applied to a video.

        Valid brightness values range between -100 and 100, the default is 0.

        **See also** **setBrightness** ().
        """
        ...

    def setFullScreen(self, fullScreen: bool) -> None:
        """
        https://doc.qt.io/qt-5/qvideowidgetcontrol.html#setFullScreen

        **[pure virtual] void QVideoWidgetControl::setFullScreen(bool fullScreen
        )**

        Sets whether a video widget is in **fullScreen** mode.

        **See also** **isFullScreen** ().
        """
        ...

    def isFullScreen(self) -> bool:
        """
        https://doc.qt.io/qt-5/qvideowidgetcontrol.html#isFullScreen

        **[pure virtual] bool QVideoWidgetControl::isFullScreen() const**

        Returns true if the video is shown using the complete screen.
        """
        ...

    def setAspectRatioMode(self, mode: QtCore.Qt.AspectRatioMode) -> None:
        """
        https://doc.qt.io/qt-5/qvideowidgetcontrol.html#setAspectRatioMode

        **[pure virtual] void
        QVideoWidgetControl::setAspectRatioMode(Qt::AspectRatioMode mode )**

        Sets the aspect ratio **mode** which determines how video is scaled to
        the fit the widget with respect to its aspect ratio.

        **See also** **aspectRatioMode** ().
        """
        ...

    def aspectRatioMode(self) -> QtCore.Qt.AspectRatioMode:
        """
        https://doc.qt.io/qt-5/qvideowidgetcontrol.html#aspectRatioMode

        **[pure virtual] Qt::AspectRatioMode
        QVideoWidgetControl::aspectRatioMode() const**

        Returns how video is scaled to fit the widget with respect to its aspect
        ratio.

        **See also** **setAspectRatioMode** ().
        """
        ...

    def videoWidget(self) -> QtWidgets.QWidget:
        """
        https://doc.qt.io/qt-5/qvideowidgetcontrol.html#videoWidget

        **[pure virtual] QWidget *QVideoWidgetControl::videoWidget()**

        Returns the **QWidget** .
        """
        ...

    @property
    def brightnessChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qvideowidgetcontrol.html#brightnessChanged

        **[signal] void QVideoWidgetControl::brightnessChanged(int brightness
        )**

        Signals that a video widget's **brightness** adjustment has changed.
        """
        ...

    @property
    def contrastChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qvideowidgetcontrol.html#contrastChanged

        **[signal] void QVideoWidgetControl::contrastChanged(int contrast )**

        Signals that a video widget's **contrast** adjustment has changed.
        """
        ...

    @property
    def fullScreenChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qvideowidgetcontrol.html#fullScreenChanged

        **[signal] void QVideoWidgetControl::fullScreenChanged(bool fullScreen
        )**

        Signals that the **fullScreen** state of a video widget has changed.
        """
        ...

    @property
    def hueChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qvideowidgetcontrol.html#hueChanged

        **[signal] void QVideoWidgetControl::hueChanged(int hue )**

        Signals that a video widget's **hue** adjustment has changed.
        """
        ...

    @property
    def saturationChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qvideowidgetcontrol.html#saturationChanged

        **[signal] void QVideoWidgetControl::saturationChanged(int saturation
        )**

        Signals that a video widget's **saturation** adjustment has changed.
        """
        ...
