"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
from PyQt5 import QtCore
from PyQt5.QtMultimedia import *
from PyQt5 import sip


class QVideoSurfaceFormat(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qvideosurfaceformat.html

    **Detailed Description**

    A video surface presents a stream of video frames. The surface's format
    describes the type of the frames and determines how they should be
    presented.

    The core properties of a video stream required to setup a video surface are
    the pixel format given by **pixelFormat** (), and the frame dimensions given
    by **frameSize** ().

    If the surface is to present frames using a frame's handle a surface format
    will also include a handle type which is given by the **handleType** ()
    function.

    The region of a frame that is actually displayed on a video surface is given
    by the **viewport** (). A stream may have a viewport less than the entire
    region of a frame to allow for videos smaller than the nearest optimal size
    of a video frame. For example the width of a frame may be extended so that
    the start of each scan line is eight byte aligned.

    Other common properties are the **pixelAspectRatio** (),
    **scanLineDirection** (), and **frameRate** (). Additionally a stream may
    have some additional type specific properties which are listed by the
    dynamicPropertyNames() function and can be accessed using the **property**
    (), and **setProperty** () functions.
    """

    class YCbCrColorSpace(int):
        YCbCr_Undefined: QVideoSurfaceFormat = ...
        YCbCr_BT601: QVideoSurfaceFormat = ...
        YCbCr_BT709: QVideoSurfaceFormat = ...
        YCbCr_xvYCC601: QVideoSurfaceFormat = ...
        YCbCr_xvYCC709: QVideoSurfaceFormat = ...
        YCbCr_JPEG: QVideoSurfaceFormat = ...

    class Direction(int):
        TopToBottom: QVideoSurfaceFormat = ...
        BottomToTop: QVideoSurfaceFormat = ...

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qvideosurfaceformat.html#QVideoSurfaceFormat

        **QVideoSurfaceFormat::QVideoSurfaceFormat()**

        Constructs a null video stream format.
        """
        ...

    @typing.overload
    def __init__(
        self,
        size: QtCore.QSize,
        format: QVideoFrame.PixelFormat,
        type: QAbstractVideoBuffer.HandleType = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qvideosurfaceformat.html#QVideoSurfaceFormat-1

        **QVideoSurfaceFormat::QVideoSurfaceFormat(const QSize & size ,
        QVideoFrame::PixelFormat format , QAbstractVideoBuffer::HandleType type
        = QAbstractVideoBuffer::NoHandle)**

        Contructs a description of stream which receives stream of **type**
        buffers with given frame **size** and pixel **format**.
        """
        ...

    @typing.overload
    def __init__(self, format: "QVideoSurfaceFormat") -> None:
        """
        https://doc.qt.io/qt-5/qvideosurfaceformat.html#QVideoSurfaceFormat-2

        **QVideoSurfaceFormat::QVideoSurfaceFormat(const QVideoSurfaceFormat &
        other )**

        Constructs a copy of **other**.
        """
        ...

    def setMirrored(self, mirrored: bool) -> None:
        """
        https://doc.qt.io/qt-5/qvideosurfaceformat.html#setMirrored

        **void QVideoSurfaceFormat::setMirrored(bool mirrored )**

        Sets if the surface is **mirrored** around its vertical axis. This is
        typically needed for video frames coming from a front camera of a mobile
        device. Default value is false.

        **Note:** The mirroring here differs from **QImage::mirrored** , as a
        vertically mirrored **QImage**  will be mirrored around its x-axis.

        This function was introduced in Qt 5.11.

        **See also** **isMirrored** ().
        """
        ...

    def isMirrored(self) -> bool:
        """
        https://doc.qt.io/qt-5/qvideosurfaceformat.html#isMirrored

        **bool QVideoSurfaceFormat::isMirrored() const**

        Returns `true` if the surface is mirrored around its vertical axis. This
        is typically needed for video frames coming from a front camera of a
        mobile device.

        **Note:** The mirroring here differs from **QImage::mirrored** , as a
        vertically mirrored **QImage**  will be mirrored around its x-axis.

        This function was introduced in Qt 5.11.
        """
        ...

    def setProperty(self, name: str, value: typing.Any) -> None:
        """
        https://doc.qt.io/qt-5/qvideosurfaceformat.html#setProperty

        **void QVideoSurfaceFormat::setProperty(const char * name , const
        QVariant & value )**

        Sets the video format's **name** property to **value**.

        Trying to set a read only property will be ignored.

        **See also** **property** ().
        """
        ...

    def property(self, name: str) -> typing.Any:
        """
        https://doc.qt.io/qt-5/qvideosurfaceformat.html#property

        **QVariant QVideoSurfaceFormat::property(const char * name ) const**

        Returns the value of the video format's **name** property.

        **See also** **setProperty** ().
        """
        ...

    def propertyNames(self) -> typing.List[QtCore.QByteArray]:
        """
        https://doc.qt.io/qt-5/qvideosurfaceformat.html#propertyNames

        **QList<QByteArray> QVideoSurfaceFormat::propertyNames() const**

        Returns a list of video format dynamic property names.
        """
        ...

    def sizeHint(self) -> QtCore.QSize:
        """
        https://doc.qt.io/qt-5/qvideosurfaceformat.html#sizeHint

        **QSize QVideoSurfaceFormat::sizeHint() const**

        Returns a suggested size in pixels for the video stream.

        This is the size of the viewport scaled according to the pixel aspect
        ratio.
        """
        ...

    def setYCbCrColorSpace(
        self, colorSpace: "QVideoSurfaceFormat.YCbCrColorSpace"
    ) -> None:
        """
        https://doc.qt.io/qt-5/qvideosurfaceformat.html#setYCbCrColorSpace

        **void QVideoSurfaceFormat::setYCbCrColorSpace(QVideoSurfaceFormat::YCbC
        rColorSpace space )**

        Sets the Y'CbCr color **space** of a video stream. It is only used with
        raw YUV frame types.

        **See also** **yCbCrColorSpace** ().
        """
        ...

    def yCbCrColorSpace(self) -> "QVideoSurfaceFormat.YCbCrColorSpace":
        """
        https://doc.qt.io/qt-5/qvideosurfaceformat.html#yCbCrColorSpace

        **QVideoSurfaceFormat::YCbCrColorSpace
        QVideoSurfaceFormat::yCbCrColorSpace() const**

        Returns the Y'CbCr color space of a video stream.

        **See also** **setYCbCrColorSpace** ().
        """
        ...

    @typing.overload
    def setPixelAspectRatio(self, ratio: QtCore.QSize) -> None:
        """
        https://doc.qt.io/qt-5/qvideosurfaceformat.html#setPixelAspectRatio

        **void QVideoSurfaceFormat::setPixelAspectRatio(const QSize & ratio )**

        Sets a video stream's pixel aspect **ratio**.

        **See also** **pixelAspectRatio** ().
        """
        ...

    @typing.overload
    def setPixelAspectRatio(self, width: int, height: int) -> None:
        """
        https://doc.qt.io/qt-5/qvideosurfaceformat.html#setPixelAspectRatio-1

        **void QVideoSurfaceFormat::setPixelAspectRatio(int horizontal , int
        vertical )**

        This is an overloaded function.

        Sets the **horizontal** and **vertical** elements of a video stream's
        pixel aspect ratio.
        """
        ...

    def pixelAspectRatio(self) -> QtCore.QSize:
        """
        https://doc.qt.io/qt-5/qvideosurfaceformat.html#pixelAspectRatio

        **QSize QVideoSurfaceFormat::pixelAspectRatio() const**

        Returns a video stream's pixel aspect ratio.

        **See also** **setPixelAspectRatio** ().
        """
        ...

    def setFrameRate(self, rate: float) -> None:
        """
        https://doc.qt.io/qt-5/qvideosurfaceformat.html#setFrameRate

        **void QVideoSurfaceFormat::setFrameRate(qreal rate )**

        Sets the frame **rate** of a video stream in frames per second.

        **See also** **frameRate** ().
        """
        ...

    def frameRate(self) -> float:
        """
        https://doc.qt.io/qt-5/qvideosurfaceformat.html#frameRate

        **qreal QVideoSurfaceFormat::frameRate() const**

        Returns the frame rate of a video stream in frames per second.

        **See also** **setFrameRate** ().
        """
        ...

    def setScanLineDirection(self, direction: "QVideoSurfaceFormat.Direction") -> None:
        """
        https://doc.qt.io/qt-5/qvideosurfaceformat.html#setScanLineDirection

        **void
        QVideoSurfaceFormat::setScanLineDirection(QVideoSurfaceFormat::Direction
        direction )**

        Sets the **direction** of scan lines.

        **See also** **scanLineDirection** ().
        """
        ...

    def scanLineDirection(self) -> "QVideoSurfaceFormat.Direction":
        """
        https://doc.qt.io/qt-5/qvideosurfaceformat.html#scanLineDirection

        **QVideoSurfaceFormat::Direction
        QVideoSurfaceFormat::scanLineDirection() const**

        Returns the direction of scan lines.

        **See also** **setScanLineDirection** ().
        """
        ...

    def setViewport(self, viewport: QtCore.QRect) -> None:
        """
        https://doc.qt.io/qt-5/qvideosurfaceformat.html#setViewport

        **void QVideoSurfaceFormat::setViewport(const QRect & viewport )**

        Sets the viewport of a video stream to **viewport**.

        **See also** **viewport** ().
        """
        ...

    def viewport(self) -> QtCore.QRect:
        """
        https://doc.qt.io/qt-5/qvideosurfaceformat.html#viewport

        **QRect QVideoSurfaceFormat::viewport() const**

        Returns the viewport of a video stream.

        The viewport is the region of a video frame that is actually displayed.

        By default the viewport covers an entire frame.

        **See also** **setViewport** ().
        """
        ...

    def frameHeight(self) -> int:
        """
        https://doc.qt.io/qt-5/qvideosurfaceformat.html#frameHeight

        **int QVideoSurfaceFormat::frameHeight() const**

        Returns the height of frame in a video stream.
        """
        ...

    def frameWidth(self) -> int:
        """
        https://doc.qt.io/qt-5/qvideosurfaceformat.html#frameWidth

        **int QVideoSurfaceFormat::frameWidth() const**

        Returns the width of frames in a video stream.

        **See also** **frameSize** () and **frameHeight** ().
        """
        ...

    @typing.overload
    def setFrameSize(self, size: QtCore.QSize) -> None:
        """
        https://doc.qt.io/qt-5/qvideosurfaceformat.html#setFrameSize

        **void QVideoSurfaceFormat::setFrameSize(const QSize & size )**

        Sets the size of frames in a video stream to **size**.

        This will reset the **viewport** () to fill the entire frame.

        **See also** **frameSize** ().
        """
        ...

    @typing.overload
    def setFrameSize(self, width: int, height: int) -> None:
        """
        https://doc.qt.io/qt-5/qvideosurfaceformat.html#setFrameSize-1

        **void QVideoSurfaceFormat::setFrameSize(int width , int height )**

        This is an overloaded function.

        Sets the **width** and **height** of frames in a video stream.

        This will reset the **viewport** () to fill the entire frame.
        """
        ...

    def frameSize(self) -> QtCore.QSize:
        """
        https://doc.qt.io/qt-5/qvideosurfaceformat.html#frameSize

        **QSize QVideoSurfaceFormat::frameSize() const**

        Returns the dimensions of frames in a video stream.

        **See also** **setFrameSize** (), **frameWidth** (), and **frameHeight**
        ().
        """
        ...

    def handleType(self) -> QAbstractVideoBuffer.HandleType:
        """
        https://doc.qt.io/qt-5/qvideosurfaceformat.html#handleType

        **QAbstractVideoBuffer::HandleType QVideoSurfaceFormat::handleType()
        const**

        Returns the type of handle the surface uses to present the frame data.

        If the handle type is `QAbstractVideoBuffer::NoHandle`, buffers with any
        handle type are valid provided they can be **mapped**  with the
        **QAbstractVideoBuffer::ReadOnly**  flag. If the handleType() is not
        **QAbstractVideoBuffer::NoHandle**  then the handle type of the buffer
        must be the same as that of the surface format.
        """
        ...

    def pixelFormat(self) -> QVideoFrame.PixelFormat:
        """
        https://doc.qt.io/qt-5/qvideosurfaceformat.html#pixelFormat

        **QVideoFrame::PixelFormat QVideoSurfaceFormat::pixelFormat() const**

        Returns the pixel format of frames in a video stream.
        """
        ...

    def isValid(self) -> bool:
        """
        https://doc.qt.io/qt-5/qvideosurfaceformat.html#isValid

        **bool QVideoSurfaceFormat::isValid() const**

        Identifies if a video surface format has a valid pixel format and frame
        size.

        Returns true if the format is valid, and false otherwise.
        """
        ...
