"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
from PyQt5 import QtCore
from PyQt5.QtMultimedia import *


class QVideoRendererControl(QMediaControl):
    """
    https://doc.qt.io/qt-5/qvideorenderercontrol.html

    **Detailed Description**

    Using the **surface** () property of QVideoRendererControl a
    **QAbstractVideoSurface**  may be set as the video render target of a
    **QMediaService** .

    **QVideoRendererControl**  *rendererControl =
    mediaService->requestControl<**QVideoRendererControl**  *>();
    rendererControl->setSurface(myVideoSurface);

    QVideoRendererControl is one of a number of possible video output controls.

    The interface name of QVideoRendererControl is `org.qt-
    project.qt.videorenderercontrol/5.0` as defined in
    **QVideoRendererControl_iid** .

    **See also** **QMediaService::requestControl** () and **QVideoWidget** .
    """

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qvideorenderercontrol.html#QVideoRendererControl

        **[protected] QVideoRendererControl::QVideoRendererControl(QObject *
        parent = nullptr)**

        Constructs a new video renderer media end point with the given
        **parent**.
        """
        ...

    def setSurface(self, surface: QAbstractVideoSurface) -> None:
        """
        https://doc.qt.io/qt-5/qvideorenderercontrol.html#setSurface

        **[pure virtual] void
        QVideoRendererControl::setSurface(QAbstractVideoSurface * surface )**

        Sets the **surface** a video producer renders to.

        **See also** **surface** ().
        """
        ...

    def surface(self) -> QAbstractVideoSurface:
        """
        https://doc.qt.io/qt-5/qvideorenderercontrol.html#surface

        **[pure virtual] QAbstractVideoSurface *QVideoRendererControl::surface()
        const**

        Returns the surface a video producer renders to.

        **See also** **setSurface** ().
        """
        ...
