"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
import PyQt5.sip
from PyQt5 import QtGui
from PyQt5 import QtCore
from PyQt5.QtMultimedia import *
from PyQt5 import sip


class QVideoFrame(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qvideoframe.html

    **Detailed Description**

    A QVideoFrame encapsulates the pixel data of a video frame, and information
    about the frame.

    Video frames can come from several places - decoded **media** , a **camera**
    , or generated programmatically. The way pixels are described in these
    frames can vary greatly, and some pixel formats offer greater compression
    opportunities at the expense of ease of use.

    The pixel contents of a video frame can be mapped to memory using the
    **map** () function. While mapped, the video data can accessed using the
    **bits** () function, which returns a pointer to a buffer. The total size of
    this buffer is given by the **mappedBytes** () function, and the size of
    each line is given by **bytesPerLine** (). The return value of the
    **handle** () function may also be used to access frame data using the
    internal buffer's native APIs (for example - an OpenGL texture handle).

    A video frame can also have timestamp information associated with it. These
    timestamps can be used by an implementation of **QAbstractVideoSurface**  to
    determine when to start and stop displaying the frame, but not all surfaces
    might respect this setting.

    The video pixel data in a QVideoFrame is encapsulated in a
    **QAbstractVideoBuffer** . A QVideoFrame may be constructed from any buffer
    type by subclassing the **QAbstractVideoBuffer**  class.

    **Note:** Since video frames can be expensive to copy, QVideoFrame is
    explicitly shared, so any change made to a video frame will also apply to
    any copies.
    """

    class PixelFormat(int):
        Format_Invalid: QVideoFrame = ...
        Format_ARGB32: QVideoFrame = ...
        Format_ARGB32_Premultiplied: QVideoFrame = ...
        Format_RGB32: QVideoFrame = ...
        Format_RGB24: QVideoFrame = ...
        Format_RGB565: QVideoFrame = ...
        Format_RGB555: QVideoFrame = ...
        Format_ARGB8565_Premultiplied: QVideoFrame = ...
        Format_BGRA32: QVideoFrame = ...
        Format_BGRA32_Premultiplied: QVideoFrame = ...
        Format_BGR32: QVideoFrame = ...
        Format_BGR24: QVideoFrame = ...
        Format_BGR565: QVideoFrame = ...
        Format_BGR555: QVideoFrame = ...
        Format_BGRA5658_Premultiplied: QVideoFrame = ...
        Format_AYUV444: QVideoFrame = ...
        Format_AYUV444_Premultiplied: QVideoFrame = ...
        Format_YUV444: QVideoFrame = ...
        Format_YUV420P: QVideoFrame = ...
        Format_YV12: QVideoFrame = ...
        Format_UYVY: QVideoFrame = ...
        Format_YUYV: QVideoFrame = ...
        Format_NV12: QVideoFrame = ...
        Format_NV21: QVideoFrame = ...
        Format_IMC1: QVideoFrame = ...
        Format_IMC2: QVideoFrame = ...
        Format_IMC3: QVideoFrame = ...
        Format_IMC4: QVideoFrame = ...
        Format_Y8: QVideoFrame = ...
        Format_Y16: QVideoFrame = ...
        Format_Jpeg: QVideoFrame = ...
        Format_CameraRaw: QVideoFrame = ...
        Format_AdobeDng: QVideoFrame = ...
        Format_ABGR32: QVideoFrame = ...
        Format_YUV422P: QVideoFrame = ...
        Format_User: QVideoFrame = ...

    class FieldType(int):
        ProgressiveFrame: QVideoFrame = ...
        TopField: QVideoFrame = ...
        BottomField: QVideoFrame = ...
        InterlacedFrame: QVideoFrame = ...

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qvideoframe.html#QVideoFrame

        **QVideoFrame::QVideoFrame()**

        Constructs a null video frame.
        """
        ...

    @typing.overload
    def __init__(
        self,
        buffer: QAbstractVideoBuffer,
        size: QtCore.QSize,
        format: "QVideoFrame.PixelFormat",
    ) -> None:
        """
        https://doc.qt.io/qt-5/qvideoframe.html#QVideoFrame-1

        **QVideoFrame::QVideoFrame(QAbstractVideoBuffer * buffer , const QSize &
        size , QVideoFrame::PixelFormat format )**

        Constructs a video frame from a **buffer** with the given pixel
        **format** and **size** in pixels.

        **Note:** This doesn't increment the reference count of the video
        buffer.
        """
        ...

    @typing.overload
    def __init__(
        self,
        bytes: int,
        size: QtCore.QSize,
        bytesPerLine: int,
        format: "QVideoFrame.PixelFormat",
    ) -> None:
        """
        https://doc.qt.io/qt-5/qvideoframe.html#QVideoFrame-2

        **QVideoFrame::QVideoFrame(int bytes , const QSize & size , int
        bytesPerLine , QVideoFrame::PixelFormat format )**

        Constructs a video frame of the given pixel **format** and **size** in
        pixels.

        The **bytesPerLine** (stride) is the length of each scan line in bytes,
        and **bytes** is the total number of bytes that must be allocated for
        the frame.
        """
        ...

    @typing.overload
    def __init__(self, image: QtGui.QImage) -> None:
        """
        https://doc.qt.io/qt-5/qvideoframe.html#QVideoFrame-3

        **QVideoFrame::QVideoFrame(const QImage & image )**

        Constructs a video frame from an **image**.

        **Note:** This will construct an invalid video frame if there is no
        frame type equivalent to the image format.

        **See also** **pixelFormatFromImageFormat** ().
        """
        ...

    @typing.overload
    def __init__(self, other: "QVideoFrame") -> None:
        """
        https://doc.qt.io/qt-5/qvideoframe.html#QVideoFrame-4

        **QVideoFrame::QVideoFrame(const QVideoFrame & other )**

        Constructs a shallow copy of **other**. Since QVideoFrame is explicitly
        shared, these two instances will reflect the same frame.
        """
        ...

    def image(self) -> QtGui.QImage:
        """
        https://doc.qt.io/qt-5/qvideoframe.html#image

        **QImage QVideoFrame::image() const**

        Based on the pixel format converts current video frame to image.

        This function was introduced in Qt 5.15.
        """
        ...

    def buffer(self) -> QAbstractVideoBuffer:
        """
        https://doc.qt.io/qt-5/qvideoframe.html#buffer

        **QAbstractVideoBuffer *QVideoFrame::buffer() const**

        Returns underlying video buffer or `null` if there is none.

        This function was introduced in Qt 5.13.
        """
        ...

    def planeCount(self) -> int:
        """
        https://doc.qt.io/qt-5/qvideoframe.html#planeCount

        **int QVideoFrame::planeCount() const**

        Returns the number of planes in the video frame.

        This value is only valid while the frame data is **mapped** .

        This function was introduced in Qt 5.4.

        **See also** **map** ().
        """
        ...

    def setMetaData(self, key: str, value: typing.Any) -> None:
        """
        https://doc.qt.io/qt-5/qvideoframe.html#setMetaData

        **void QVideoFrame::setMetaData(const QString & key , const QVariant &
        value )**

        Sets the metadata for the given **key** to **value**.

        If **value** is a null variant, any metadata for this key will be
        removed.

        The producer of the video frame might use this to associate certain data
        with this frame, or for an intermediate processor to add information for
        a consumer of this frame.

        **See also** **metaData** ().
        """
        ...

    def metaData(self, key: str) -> typing.Any:
        """
        https://doc.qt.io/qt-5/qvideoframe.html#metaData

        **QVariant QVideoFrame::metaData(const QString & key ) const**

        Returns any metadata for this frame for the given **key**.

        This might include frame specific information from a camera, or
        subtitles from a decoded video stream.

        See the documentation for the relevant video frame producer for further
        information about available metadata.

        **See also** **setMetaData** ().
        """
        ...

    def availableMetaData(self) -> typing.Dict[str, typing.Any]:
        """
        https://doc.qt.io/qt-5/qvideoframe.html#availableMetaData

        **QVariantMap QVideoFrame::availableMetaData() const**

        Returns any extra metadata associated with this frame.
        """
        ...

    @staticmethod
    def imageFormatFromPixelFormat(
        format: "QVideoFrame.PixelFormat",
    ) -> QtGui.QImage.Format:
        """
        https://doc.qt.io/qt-5/qvideoframe.html#imageFormatFromPixelFormat

        **[static] QImage::Format
        QVideoFrame::imageFormatFromPixelFormat(QVideoFrame::PixelFormat format
        )**

        Returns an image format equivalent to a video frame pixel **format**. If
        there is no equivalent format **QImage::Format_Invalid**  is returned
        instead.

        **Note:** In general **QImage**  does not handle YUV formats.
        """
        ...

    @staticmethod
    def pixelFormatFromImageFormat(
        format: QtGui.QImage.Format,
    ) -> "QVideoFrame.PixelFormat":
        """
        https://doc.qt.io/qt-5/qvideoframe.html#pixelFormatFromImageFormat

        **[static] QVideoFrame::PixelFormat
        QVideoFrame::pixelFormatFromImageFormat(QImage::Format format )**

        Returns a video pixel format equivalent to an image **format**. If there
        is no equivalent format QVideoFrame::InvalidType is returned instead.

        **Note:** In general **QImage**  does not handle YUV formats.
        """
        ...

    def setEndTime(self, time: int) -> None:
        """
        https://doc.qt.io/qt-5/qvideoframe.html#setEndTime

        **void QVideoFrame::setEndTime(qint64 time )**

        Sets the presentation **time** (in microseconds) when a frame should
        stop being displayed.

        An invalid time is represented as -1.

        **See also** **endTime** ().
        """
        ...

    def endTime(self) -> int:
        """
        https://doc.qt.io/qt-5/qvideoframe.html#endTime

        **qint64 QVideoFrame::endTime() const**

        Returns the presentation time (in microseconds) when a frame should stop
        being displayed.

        An invalid time is represented as -1.

        **See also** **setEndTime** ().
        """
        ...

    def setStartTime(self, time: int) -> None:
        """
        https://doc.qt.io/qt-5/qvideoframe.html#setStartTime

        **void QVideoFrame::setStartTime(qint64 time )**

        Sets the presentation **time** (in microseconds) when the frame should
        initially be displayed.

        An invalid time is represented as -1.

        **See also** **startTime** ().
        """
        ...

    def startTime(self) -> int:
        """
        https://doc.qt.io/qt-5/qvideoframe.html#startTime

        **qint64 QVideoFrame::startTime() const**

        Returns the presentation time (in microseconds) when the frame should be
        displayed.

        An invalid time is represented as -1.

        **See also** **setStartTime** ().
        """
        ...

    def handle(self) -> typing.Any:
        """
        https://doc.qt.io/qt-5/qvideoframe.html#handle

        **QVariant QVideoFrame::handle() const**

        Returns a type specific handle to a video frame's buffer.

        For an OpenGL texture this would be the texture ID.

        **See also** **QAbstractVideoBuffer::handle** ().
        """
        ...

    def mappedBytes(self) -> int:
        """
        https://doc.qt.io/qt-5/qvideoframe.html#mappedBytes

        **int QVideoFrame::mappedBytes() const**

        Returns the number of bytes occupied by the mapped frame data.

        This value is only valid while the frame data is **mapped** .

        **See also** **map** ().
        """
        ...

    @typing.overload
    def bits(self) -> PyQt5.sip.voidptr:
        """
        https://doc.qt.io/qt-5/qvideoframe.html#bits

        **uchar *QVideoFrame::bits()**

        Returns a pointer to the start of the frame data buffer.

        This value is only valid while the frame data is **mapped** .

        Changes made to data accessed via this pointer (when mapped with write
        access) are only guaranteed to have been persisted when **unmap** () is
        called and when the buffer has been mapped for writing.

        **See also** **map** (), **mappedBytes** (), and **bytesPerLine** ().
        """
        ...

    @typing.overload
    def bits(self, plane: int) -> PyQt5.sip.voidptr:
        """
        https://doc.qt.io/qt-5/qvideoframe.html#bits-1

        **uchar *QVideoFrame::bits(int plane )**

        Returns a pointer to the start of the frame data buffer for a **plane**.

        This value is only valid while the frame data is **mapped** .

        Changes made to data accessed via this pointer (when mapped with write
        access) are only guaranteed to have been persisted when **unmap** () is
        called and when the buffer has been mapped for writing.

        This function was introduced in Qt 5.4.

        **See also** **map** (), **mappedBytes** (), **bytesPerLine** (), and
        **planeCount** ().
        """
        ...

    @typing.overload
    def bytesPerLine(self) -> int:
        """
        https://doc.qt.io/qt-5/qvideoframe.html#bytesPerLine

        **int QVideoFrame::bytesPerLine() const**

        Returns the number of bytes in a scan line.

        **Note:** For planar formats this is the bytes per line of the first
        plane only. The bytes per line of subsequent planes should be calculated
        as per the frame **pixel format** .

        This value is only valid while the frame data is **mapped** .

        **See also** **bits** (), **map** (), and **mappedBytes** ().
        """
        ...

    @typing.overload
    def bytesPerLine(self, plane: int) -> int:
        """
        https://doc.qt.io/qt-5/qvideoframe.html#bytesPerLine-1

        **int QVideoFrame::bytesPerLine(int plane ) const**

        Returns the number of bytes in a scan line of a **plane**.

        This value is only valid while the frame data is **mapped** .

        This function was introduced in Qt 5.4.

        **See also** **bits** (), **map** (), **mappedBytes** (), and
        **planeCount** ().
        """
        ...

    def unmap(self) -> None:
        """
        https://doc.qt.io/qt-5/qvideoframe.html#unmap

        **void QVideoFrame::unmap()**

        Releases the memory mapped by the **map** () function.

        If the **MapMode**  included the **QAbstractVideoBuffer::WriteOnly**
        flag this will persist the current content of the mapped memory to the
        video frame.

        unmap() should not be called if **map** () function failed.

        **See also** **map** ().
        """
        ...

    def map(self, mode: QAbstractVideoBuffer.MapMode) -> bool:
        """
        https://doc.qt.io/qt-5/qvideoframe.html#map

        **bool QVideoFrame::map(QAbstractVideoBuffer::MapMode mode )**

        Maps the contents of a video frame to system (CPU addressable) memory.

        In some cases the video frame data might be stored in video memory or
        otherwise inaccessible memory, so it is necessary to map a frame before
        accessing the pixel data. This may involve copying the contents around,
        so avoid mapping and unmapping unless required.

        The map **mode** indicates whether the contents of the mapped memory
        should be read from and/or written to the frame. If the map mode
        includes the `QAbstractVideoBuffer::ReadOnly` flag the mapped memory
        will be populated with the content of the video frame when initially
        mapped. If the map mode includes the `QAbstractVideoBuffer::WriteOnly`
        flag the content of the possibly modified mapped memory will be written
        back to the frame when unmapped.

        While mapped the contents of a video frame can be accessed directly
        through the pointer returned by the **bits** () function.

        When access to the data is no longer needed, be sure to call the
        **unmap** () function to release the mapped memory and possibly update
        the video frame contents.

        If the video frame has been mapped in read only mode, it is permissible
        to map it multiple times in read only mode (and unmap it a corresponding
        number of times). In all other cases it is necessary to unmap the frame
        first before mapping a second time.

        **Note:** Writing to memory that is mapped as read-only is undefined,
        and may result in changes to shared data or crashes.

        Returns true if the frame was mapped to memory in the given **mode** and
        false otherwise.

        **See also** **unmap** (), **mapMode** (), and **bits** ().
        """
        ...

    def mapMode(self) -> QAbstractVideoBuffer.MapMode:
        """
        https://doc.qt.io/qt-5/qvideoframe.html#mapMode

        **QAbstractVideoBuffer::MapMode QVideoFrame::mapMode() const**

        Returns the mode a video frame was mapped to system memory in.

        **See also** **map** () and **QAbstractVideoBuffer::MapMode** .
        """
        ...

    def isWritable(self) -> bool:
        """
        https://doc.qt.io/qt-5/qvideoframe.html#isWritable

        **bool QVideoFrame::isWritable() const**

        Identifies if the mapped contents of a video frame will be persisted
        when the frame is unmapped.

        This is a convenience function which checks if the **MapMode**  contains
        the **QAbstractVideoBuffer::WriteOnly**  flag.

        Returns true if the video frame will be updated when unmapped, and false
        otherwise.

        **Note:** The result of altering the data of a frame that is mapped in
        read-only mode is undefined. Depending on the buffer implementation the
        changes may be persisted, or worse alter a shared buffer.

        **See also** **mapMode** () and **QAbstractVideoBuffer::MapMode** .
        """
        ...

    def isReadable(self) -> bool:
        """
        https://doc.qt.io/qt-5/qvideoframe.html#isReadable

        **bool QVideoFrame::isReadable() const**

        Identifies if the mapped contents of a video frame were read from the
        frame when it was mapped.

        This is a convenience function which checks if the **MapMode**  contains
        the **QAbstractVideoBuffer::WriteOnly**  flag.

        Returns true if the contents of the mapped memory were read from the
        video frame, and false otherwise.

        **See also** **mapMode** () and **QAbstractVideoBuffer::MapMode** .
        """
        ...

    def isMapped(self) -> bool:
        """
        https://doc.qt.io/qt-5/qvideoframe.html#isMapped

        **bool QVideoFrame::isMapped() const**

        Identifies if a video frame's contents are currently mapped to system
        memory.

        This is a convenience function which checks that the **MapMode**  of the
        frame is not equal to **QAbstractVideoBuffer::NotMapped** .

        Returns true if the contents of the video frame are mapped to system
        memory, and false otherwise.

        **See also** **mapMode** () and **QAbstractVideoBuffer::MapMode** .
        """
        ...

    def setFieldType(self, a0: "QVideoFrame.FieldType") -> None:
        """
        https://doc.qt.io/qt-5/qvideoframe.html#setFieldType

        **void QVideoFrame::setFieldType(QVideoFrame::FieldType field )**

        Sets the **field** an interlaced video frame belongs to.

        **See also** **fieldType** ().
        """
        ...

    def fieldType(self) -> "QVideoFrame.FieldType":
        """
        https://doc.qt.io/qt-5/qvideoframe.html#fieldType

        **QVideoFrame::FieldType QVideoFrame::fieldType() const**

        Returns the field an interlaced video frame belongs to.

        If the video is not interlaced this will return WholeFrame.

        **See also** **setFieldType** ().
        """
        ...

    def height(self) -> int:
        """
        https://doc.qt.io/qt-5/qvideoframe.html#height

        **int QVideoFrame::height() const**

        Returns the height of a video frame.
        """
        ...

    def width(self) -> int:
        """
        https://doc.qt.io/qt-5/qvideoframe.html#width

        **int QVideoFrame::width() const**

        Returns the width of a video frame.
        """
        ...

    def size(self) -> QtCore.QSize:
        """
        https://doc.qt.io/qt-5/qvideoframe.html#size

        **QSize QVideoFrame::size() const**

        Returns the dimensions of a video frame.
        """
        ...

    def handleType(self) -> QAbstractVideoBuffer.HandleType:
        """
        https://doc.qt.io/qt-5/qvideoframe.html#handleType

        **QAbstractVideoBuffer::HandleType QVideoFrame::handleType() const**

        Returns the type of a video frame's handle.
        """
        ...

    def pixelFormat(self) -> "QVideoFrame.PixelFormat":
        """
        https://doc.qt.io/qt-5/qvideoframe.html#pixelFormat

        **QVideoFrame::PixelFormat QVideoFrame::pixelFormat() const**

        Returns the color format of a video frame.
        """
        ...

    def isValid(self) -> bool:
        """
        https://doc.qt.io/qt-5/qvideoframe.html#isValid

        **bool QVideoFrame::isValid() const**

        Identifies whether a video frame is valid.

        An invalid frame has no video buffer associated with it.

        Returns true if the frame is valid, and false if it is not.
        """
        ...
