"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
from PyQt5 import QtCore
from PyQt5.QtMultimedia import *
from PyQt5 import sip


class QVideoEncoderSettings(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qvideoencodersettings.html

    **Detailed Description**

    A video encoder settings object is used to specify the video encoder
    settings used by **QMediaRecorder** . Video encoder settings are selected by
    constructing a QVideoEncoderSettings object, setting the desired properties
    and then passing it to a **QMediaRecorder**  instance using the
    **QMediaRecorder::setEncodingSettings** () function.

    **QVideoEncoderSettings**  videoSettings;
    videoSettings.setCodec("video/mpeg2");
        videoSettings.setResolution(640,
    480);

        recorder->setVideoSettings(videoSettings);

    **See also** **QMediaRecorder**  and **QVideoEncoderSettingsControl** .
    """

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qvideoencodersettings.html#QVideoEncoderSettings

        **QVideoEncoderSettings::QVideoEncoderSettings()**

        Constructs a null video encoder settings object.
        """
        ...

    @typing.overload
    def __init__(self, other: "QVideoEncoderSettings") -> None:
        """
        https://doc.qt.io/qt-5/qvideoencodersettings.html#QVideoEncoderSettings-
        1

        **QVideoEncoderSettings::QVideoEncoderSettings(const
        QVideoEncoderSettings & other )**

        Constructs a copy of the video encoder settings object **other**.
        """
        ...

    def setEncodingOptions(self, options: typing.Dict[str, typing.Any]) -> None:
        """
        https://doc.qt.io/qt-5/qvideoencodersettings.html#setEncodingOptions

        **void QVideoEncoderSettings::setEncodingOptions(const QVariantMap &
        options )**

        Replace all the encoding options with **options**.

        The supported set and meaning of encoding options are system and
        selected codec specific.

        **See also** **encodingOptions** (), **encodingOption** (), and
        **setEncodingOption** ().
        """
        ...

    def setEncodingOption(self, option: str, value: typing.Any) -> None:
        """
        https://doc.qt.io/qt-5/qvideoencodersettings.html#setEncodingOption

        **void QVideoEncoderSettings::setEncodingOption(const QString & option ,
        const QVariant & value )**

        Set the encoding **option** **value**.

        The supported set and meaning of encoding options are system and
        selected codec specific.

        **See also** **encodingOption** () and **setEncodingOptions** ().
        """
        ...

    def encodingOptions(self) -> typing.Dict[str, typing.Any]:
        """
        https://doc.qt.io/qt-5/qvideoencodersettings.html#encodingOptions

        **QVariantMap QVideoEncoderSettings::encodingOptions() const**

        Returns the all the encoding options as **QVariantMap** .

        **See also** **encodingOption** () and **setEncodingOptions** ().
        """
        ...

    def encodingOption(self, option: str) -> typing.Any:
        """
        https://doc.qt.io/qt-5/qvideoencodersettings.html#encodingOption

        **QVariant QVideoEncoderSettings::encodingOption(const QString & option
        ) const**

        Returns the value of encoding **option**.

        **See also** **setEncodingOption** () and **encodingOptions** ().
        """
        ...

    def setQuality(self, quality: "QMultimedia.EncodingQuality") -> None:
        """
        https://doc.qt.io/qt-5/qvideoencodersettings.html#setQuality

        **void QVideoEncoderSettings::setQuality(QMultimedia::EncodingQuality
        quality )**

        Sets the video encoding **quality**.

        Setting the video quality parameter allows backend to choose the
        balanced set of encoding parameters to achieve the desired quality
        level.

        The **quality** settings parameter is only used in the **constant
        quality**  **encoding mode** . The **quality** settings parameter is
        only used in the **constant quality**  **encoding mode** .

        **See also** **quality** ().
        """
        ...

    def quality(self) -> "QMultimedia.EncodingQuality":
        """
        https://doc.qt.io/qt-5/qvideoencodersettings.html#quality

        **QMultimedia::EncodingQuality QVideoEncoderSettings::quality() const**

        Returns the video encoding quality.

        **See also** **setQuality** ().
        """
        ...

    def setBitRate(self, bitrate: int) -> None:
        """
        https://doc.qt.io/qt-5/qvideoencodersettings.html#setBitRate

        **void QVideoEncoderSettings::setBitRate(int value )**

        Sets the bit rate of the encoded video stream to **value**.

        **See also** **bitRate** ().
        """
        ...

    def bitRate(self) -> int:
        """
        https://doc.qt.io/qt-5/qvideoencodersettings.html#bitRate

        **int QVideoEncoderSettings::bitRate() const**

        Returns bit rate of the encoded video stream in bits per second.

        **See also** **setBitRate** ().
        """
        ...

    def setFrameRate(self, rate: float) -> None:
        """
        https://doc.qt.io/qt-5/qvideoencodersettings.html#setFrameRate

        **void QVideoEncoderSettings::setFrameRate(qreal rate )**

        Sets the video frame **rate**.

        A value of 0 indicates the encoder should make an optimal choice based
        on what is available from the video source and the limitations of the
        codec.

        **See also** **frameRate** ().
        """
        ...

    def frameRate(self) -> float:
        """
        https://doc.qt.io/qt-5/qvideoencodersettings.html#frameRate

        **qreal QVideoEncoderSettings::frameRate() const**

        Returns the video frame rate.

        **See also** **setFrameRate** ().
        """
        ...

    @typing.overload
    def setResolution(self, a0: QtCore.QSize) -> None:
        """
        https://doc.qt.io/qt-5/qvideoencodersettings.html#setResolution

        **void QVideoEncoderSettings::setResolution(const QSize & resolution )**

        Sets the **resolution** of the encoded video.

        An empty **QSize**  indicates the encoder should make an optimal choice
        based on what is available from the video source and the limitations of
        the codec.

        **See also** **resolution** ().
        """
        ...

    @typing.overload
    def setResolution(self, width: int, height: int) -> None:
        """
        https://doc.qt.io/qt-5/qvideoencodersettings.html#setResolution-1

        **void QVideoEncoderSettings::setResolution(int width , int height )**

        Sets the **width** and **height** of the resolution of the encoded
        video.

        This is an overloaded function.
        """
        ...

    def resolution(self) -> QtCore.QSize:
        """
        https://doc.qt.io/qt-5/qvideoencodersettings.html#resolution

        **QSize QVideoEncoderSettings::resolution() const**

        Returns the resolution of the encoded video.

        **See also** **setResolution** ().
        """
        ...

    def setCodec(self, a0: str) -> None:
        """
        https://doc.qt.io/qt-5/qvideoencodersettings.html#setCodec

        **void QVideoEncoderSettings::setCodec(const QString & codec )**

        Sets the video **codec**.

        **See also** **codec** ().
        """
        ...

    def codec(self) -> str:
        """
        https://doc.qt.io/qt-5/qvideoencodersettings.html#codec

        **QString QVideoEncoderSettings::codec() const**

        Returns the video codec.

        **See also** **setCodec** ().
        """
        ...

    def setEncodingMode(self, a0: "QMultimedia.EncodingMode") -> None:
        """
        https://doc.qt.io/qt-5/qvideoencodersettings.html#setEncodingMode

        **void QVideoEncoderSettings::setEncodingMode(QMultimedia::EncodingMode
        mode )**

        Sets the video encoding **mode**.

        If **QMultimedia::ConstantQualityEncoding**  is set, the quality
        encoding parameter is used and bit rate is ignored, otherwise the
        bitrate is used.

        The rest of encoding settings are respected regardless of encoding mode.

        **See also** **encodingMode** () and **QMultimedia::EncodingMode** .
        """
        ...

    def encodingMode(self) -> "QMultimedia.EncodingMode":
        """
        https://doc.qt.io/qt-5/qvideoencodersettings.html#encodingMode

        **QMultimedia::EncodingMode QVideoEncoderSettings::encodingMode()
        const**

        Returns the video encoding mode.

        **See also** **setEncodingMode** () and **QMultimedia::EncodingMode** .
        """
        ...

    def isNull(self) -> bool:
        """
        https://doc.qt.io/qt-5/qvideoencodersettings.html#isNull

        **bool QVideoEncoderSettings::isNull() const**

        Identifies if a video encoder settings object is uninitalized.

        Returns true if the settings are null, and false if they are not.
        """
        ...
