"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
import PyQt5.sip
from PyQt5 import QtCore
from PyQt5.QtMultimedia import *


class QVideoDeviceSelectorControl(QMediaControl):
    """
    https://doc.qt.io/qt-5/qvideodeviceselectorcontrol.html

    **Detailed Description**

    The QVideoDeviceSelectorControl class provides descriptions of the video
    devices available on a system and allows one to be selected as the endpoint
    of a media service.

    The interface name of QVideoDeviceSelectorControl is `org.qt-
    project.qt.videodeviceselectorcontrol/5.0` as defined in
    **QVideoDeviceSelectorControl_iid** .
    """

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qvideodeviceselectorcontrol.html#QVideoDeviceSele
        ctorControl

        **[protected]
        QVideoDeviceSelectorControl::QVideoDeviceSelectorControl(QObject *
        parent = nullptr)**

        Constructs a video device selector control with the given **parent**.
        """
        ...

    def setSelectedDevice(self, index: int) -> None:
        """
        https://doc.qt.io/qt-5/qvideodeviceselectorcontrol.html#setSelectedDevic
        e

        **[pure virtual slot] void
        QVideoDeviceSelectorControl::setSelectedDevice(int index )**

        Sets the selected video device **index**.

        **See also** **selectedDevice** ().
        """
        ...

    def selectedDevice(self) -> int:
        """
        https://doc.qt.io/qt-5/qvideodeviceselectorcontrol.html#selectedDevice

        **[pure virtual] int QVideoDeviceSelectorControl::selectedDevice()
        const**

        Returns the index of the selected video device.

        **See also** **setSelectedDevice** ().
        """
        ...

    def defaultDevice(self) -> int:
        """
        https://doc.qt.io/qt-5/qvideodeviceselectorcontrol.html#defaultDevice

        **[pure virtual] int QVideoDeviceSelectorControl::defaultDevice()
        const**

        Returns the index of the default video device.
        """
        ...

    def deviceDescription(self, index: int) -> str:
        """
        https://doc.qt.io/qt-5/qvideodeviceselectorcontrol.html#deviceDescriptio
        n

        **[pure virtual] QString
        QVideoDeviceSelectorControl::deviceDescription(int index ) const**

        Returns a description of the video device at **index**.
        """
        ...

    def deviceName(self, index: int) -> str:
        """
        https://doc.qt.io/qt-5/qvideodeviceselectorcontrol.html#deviceName

        **[pure virtual] QString QVideoDeviceSelectorControl::deviceName(int
        index ) const**

        Returns the name of the video device at **index**.
        """
        ...

    def deviceCount(self) -> int:
        """
        https://doc.qt.io/qt-5/qvideodeviceselectorcontrol.html#deviceCount

        **[pure virtual] int QVideoDeviceSelectorControl::deviceCount() const**

        Returns the number of available video devices;
        """
        ...

    @property
    def devicesChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qvideodeviceselectorcontrol.html#devicesChanged

        **[signal] void QVideoDeviceSelectorControl::devicesChanged()**

        Signals that the list of available video devices has changed.
        """
        ...

    @property
    def selectedDeviceChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qvideodeviceselectorcontrol.html#selectedDeviceCh
        anged

        **[signal] void QVideoDeviceSelectorControl::selectedDeviceChanged(int
        index )**

        Signals that the selected video device **index** has changed.

        **Note:** Signal **selectedDeviceChanged** is overloaded in this class.
        To connect to this signal by using the function pointer syntax, Qt
        provides a convenient helper for obtaining the function pointer as shown
        in this example:

        connect(videoDeviceSelectorControl,
        QOverload<int>::of(&**QVideoDeviceSelectorControl**
        ::selectedDeviceChanged),
                [=](int index){ /* ... */ });
        """
        ...

    @property
    def selectedDeviceChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qvideodeviceselectorcontrol.html#selectedDeviceCh
        anged-1

        **[signal] void QVideoDeviceSelectorControl::selectedDeviceChanged(const
        QString & name )**

        Signals that the selected video device **name** has changed.

        **Note:** Signal **selectedDeviceChanged** is overloaded in this class.
        To connect to this signal by using the function pointer syntax, Qt
        provides a convenient helper for obtaining the function pointer as shown
        in this example:

        connect(videoDeviceSelectorControl, QOverload<const **QString**
        &>::of(&**QVideoDeviceSelectorControl** ::selectedDeviceChanged),
        [=](const **QString**  &name){ /* ... */ });
        """
        ...
