"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
import PyQt5.sip
from PyQt5 import QtCore
from PyQt5.QtMultimedia import *


class QRadioTunerControl(QMediaControl):
    """
    https://doc.qt.io/qt-5/qradiotunercontrol.html

    **Detailed Description**

    If a **QMediaService**  can tune an analog radio device it will implement
    QRadioTunerControl. This control provides a means to tune a radio device to
    a specific **frequency**  as well as search **forwards**  and **backwards**
    for a signal.

    The functionality provided by this control is exposed to application code
    through the **QRadioTuner**  class.

    The interface name of QRadioTunerControl is `org.qt-
    project.qt.radiotunercontrol/5.0` as defined in **QRadioTunerControl_iid** .

    **See also** **QMediaService::requestControl** () and **QRadioTuner** .
    """

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qradiotunercontrol.html#QRadioTunerControl

        **[protected] QRadioTunerControl::QRadioTunerControl(QObject * parent =
        nullptr)**

        Constructs a radio tuner control with the given **parent**.
        """
        ...

    def errorString(self) -> str:
        """
        https://doc.qt.io/qt-5/qradiotunercontrol.html#errorString

        **[pure virtual] QString QRadioTunerControl::errorString() const**

        Returns a string describing a radio tuner's error state.
        """
        ...

    def stop(self) -> None:
        """
        https://doc.qt.io/qt-5/qradiotunercontrol.html#stop

        **[pure virtual] void QRadioTunerControl::stop()**

        Deactivate the radio device.
        """
        ...

    def start(self) -> None:
        """
        https://doc.qt.io/qt-5/qradiotunercontrol.html#start

        **[pure virtual] void QRadioTunerControl::start()**

        Activate the radio device.
        """
        ...

    def cancelSearch(self) -> None:
        """
        https://doc.qt.io/qt-5/qradiotunercontrol.html#cancelSearch

        **[pure virtual] void QRadioTunerControl::cancelSearch()**

        Stops scanning for a signal.
        """
        ...

    def searchAllStations(self, searchMode: QRadioTuner.SearchMode = ...) -> None:
        """
        https://doc.qt.io/qt-5/qradiotunercontrol.html#searchAllStations

        **[pure virtual] void
        QRadioTunerControl::searchAllStations(QRadioTuner::SearchMode searchMode
        = QRadioTuner::SearchFast)**

        Starts a scan through the whole frequency band searching all stations
        with a specific **searchMode**.
        """
        ...

    def searchBackward(self) -> None:
        """
        https://doc.qt.io/qt-5/qradiotunercontrol.html#searchBackward

        **[pure virtual] void QRadioTunerControl::searchBackward()**

        Starts a backwards scan for a signal, starting from the current
        **frequency** ().
        """
        ...

    def searchForward(self) -> None:
        """
        https://doc.qt.io/qt-5/qradiotunercontrol.html#searchForward

        **[pure virtual] void QRadioTunerControl::searchForward()**

        Starts a forward scan for a signal, starting from the current
        **frequency** ().
        """
        ...

    def isAntennaConnected(self) -> bool:
        """
        https://doc.qt.io/qt-5/qradiotunercontrol.html#isAntennaConnected

        **[virtual] bool QRadioTunerControl::isAntennaConnected() const**

        Identifies if there is an antenna connected to the device.

        Returns true if there is a connected antenna, and false otherwise.
        """
        ...

    def isSearching(self) -> bool:
        """
        https://doc.qt.io/qt-5/qradiotunercontrol.html#isSearching

        **[pure virtual] bool QRadioTunerControl::isSearching() const**

        Identifies if a radio tuner is currently scanning for signal.

        Returns true if the tuner is scanning, and false if it is not.
        """
        ...

    def setMuted(self, muted: bool) -> None:
        """
        https://doc.qt.io/qt-5/qradiotunercontrol.html#setMuted

        **[pure virtual] void QRadioTunerControl::setMuted(bool muted )**

        Sets the **muted** state of a radio tuner's audio output.

        **See also** **isMuted** ().
        """
        ...

    def isMuted(self) -> bool:
        """
        https://doc.qt.io/qt-5/qradiotunercontrol.html#isMuted

        **[pure virtual] bool QRadioTunerControl::isMuted() const**

        Identifies if a radio tuner's audio output is muted.

        Returns true if the audio is muted, and false if it is not.
        """
        ...

    def setVolume(self, volume: int) -> None:
        """
        https://doc.qt.io/qt-5/qradiotunercontrol.html#setVolume

        **[pure virtual] void QRadioTunerControl::setVolume(int volume )**

        Sets the percentage **volume** of a radio tuner's audio output.

        **See also** **volume** ().
        """
        ...

    def volume(self) -> int:
        """
        https://doc.qt.io/qt-5/qradiotunercontrol.html#volume

        **[pure virtual] int QRadioTunerControl::volume() const**

        Returns the volume of a radio tuner's audio output as a percentage.

        **See also** **setVolume** ().
        """
        ...

    def signalStrength(self) -> int:
        """
        https://doc.qt.io/qt-5/qradiotunercontrol.html#signalStrength

        **[pure virtual] int QRadioTunerControl::signalStrength() const**

        Return a radio tuner's current signal strength as a percentage.
        """
        ...

    def setStereoMode(self, mode: QRadioTuner.StereoMode) -> None:
        """
        https://doc.qt.io/qt-5/qradiotunercontrol.html#setStereoMode

        **[pure virtual] void
        QRadioTunerControl::setStereoMode(QRadioTuner::StereoMode mode )**

        Sets a radio tuner's stereo **mode**.

        **See also** **stereoMode** () and **QRadioTuner::StereoMode** .
        """
        ...

    def stereoMode(self) -> QRadioTuner.StereoMode:
        """
        https://doc.qt.io/qt-5/qradiotunercontrol.html#stereoMode

        **[pure virtual] QRadioTuner::StereoMode
        QRadioTunerControl::stereoMode() const**

        Returns a radio tuner's stereo mode.

        **See also** **setStereoMode** () and **QRadioTuner::StereoMode** .
        """
        ...

    def isStereo(self) -> bool:
        """
        https://doc.qt.io/qt-5/qradiotunercontrol.html#isStereo

        **[pure virtual] bool QRadioTunerControl::isStereo() const**

        Identifies if a radio tuner is receiving a stereo signal.

        Returns true if the tuner is receiving a stereo signal, and false if it
        is not.
        """
        ...

    def setFrequency(self, frequency: int) -> None:
        """
        https://doc.qt.io/qt-5/qradiotunercontrol.html#setFrequency

        **[pure virtual] void QRadioTunerControl::setFrequency(int frequency )**

        Sets the **frequency** a radio tuner is tuned to.

        **See also** **frequency** ().
        """
        ...

    def frequencyRange(self, b: QRadioTuner.Band) -> typing.Tuple[int, int]:
        """
        https://doc.qt.io/qt-5/qradiotunercontrol.html#frequencyRange

        **[pure virtual] QPair<int, int>
        QRadioTunerControl::frequencyRange(QRadioTuner::Band band ) const**

        Returns a frequency **band** 's minimum and maximum frequency.
        """
        ...

    def frequencyStep(self, b: QRadioTuner.Band) -> int:
        """
        https://doc.qt.io/qt-5/qradiotunercontrol.html#frequencyStep

        **[pure virtual] int QRadioTunerControl::frequencyStep(QRadioTuner::Band
        band ) const**

        Returns the number of Hertz to increment the frequency by when stepping
        through frequencies within a given **band**.
        """
        ...

    def frequency(self) -> int:
        """
        https://doc.qt.io/qt-5/qradiotunercontrol.html#frequency

        **[pure virtual] int QRadioTunerControl::frequency() const**

        Returns the frequency a radio tuner is tuned to.

        **See also** **setFrequency** ().
        """
        ...

    def isBandSupported(self, b: QRadioTuner.Band) -> bool:
        """
        https://doc.qt.io/qt-5/qradiotunercontrol.html#isBandSupported

        **[pure virtual] bool
        QRadioTunerControl::isBandSupported(QRadioTuner::Band band ) const**

        Identifies if a frequency **band** is supported.

        Returns true if the band is supported, and false if it is not.
        """
        ...

    def setBand(self, b: QRadioTuner.Band) -> None:
        """
        https://doc.qt.io/qt-5/qradiotunercontrol.html#setBand

        **[pure virtual] void QRadioTunerControl::setBand(QRadioTuner::Band band
        )**

        Sets the frequecy **band** a radio tuner is tuned to.

        Changing the frequency band will reset the frequency to the minimum
        frequency of the new band.

        **See also** **band** ().
        """
        ...

    def band(self) -> QRadioTuner.Band:
        """
        https://doc.qt.io/qt-5/qradiotunercontrol.html#band

        **[pure virtual] QRadioTuner::Band QRadioTunerControl::band() const**

        Returns the frequency band a radio tuner is tuned to.

        **See also** **setBand** ().
        """
        ...

    def state(self) -> QRadioTuner.State:
        """
        https://doc.qt.io/qt-5/qradiotunercontrol.html#state

        **[pure virtual] QRadioTuner::State QRadioTunerControl::state() const**

        Returns the current radio tuner state.
        """
        ...

    @property
    def antennaConnectedChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qradiotunercontrol.html#antennaConnectedChanged

        **[signal] void QRadioTunerControl::antennaConnectedChanged(bool
        connectionStatus )**

        Signals that the antenna has either been connected or disconnected as
        reflected with the **connectionStatus**.
        """
        ...

    @property
    def bandChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qradiotunercontrol.html#bandChanged

        **[signal] void QRadioTunerControl::bandChanged(QRadioTuner::Band band
        )**

        Signals that the frequency **band** a radio tuner is tuned to has
        changed.
        """
        ...

    @property
    def error(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qradiotunercontrol.html#error

        **[pure virtual] QRadioTuner::Error QRadioTunerControl::error() const**

        Returns the error state of a radio tuner.
        """
        ...

    @property
    def frequencyChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qradiotunercontrol.html#frequencyChanged

        **[signal] void QRadioTunerControl::frequencyChanged(int frequency )**

        Signals that the **frequency** a radio tuner is tuned to has changed.
        """
        ...

    @property
    def mutedChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qradiotunercontrol.html#mutedChanged

        **[signal] void QRadioTunerControl::mutedChanged(bool muted )**

        Signals that the **muted** state of a radio tuner's audio output has
        changed.
        """
        ...

    @property
    def searchingChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qradiotunercontrol.html#searchingChanged

        **[signal] void QRadioTunerControl::searchingChanged(bool searching )**

        Signals that the **searching** state of a radio tuner has changed.
        """
        ...

    @property
    def signalStrengthChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qradiotunercontrol.html#signalStrengthChanged

        **[signal] void QRadioTunerControl::signalStrengthChanged(int strength
        )**

        Signals that the percentage **strength** of the signal received by a
        radio tuner has changed.
        """
        ...

    @property
    def stateChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qradiotunercontrol.html#stateChanged

        **[signal] void QRadioTunerControl::stateChanged(QRadioTuner::State
        state )**

        Signals that the **state** of a radio tuner has changed.
        """
        ...

    @property
    def stationFound(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qradiotunercontrol.html#stationFound

        **[signal] void QRadioTunerControl::stationFound(int frequency , QString
        stationId )**

        Signals that new station with **frequency** and **stationId** was found
        when scanning
        """
        ...

    @property
    def stereoStatusChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qradiotunercontrol.html#stereoStatusChanged

        **[signal] void QRadioTunerControl::stereoStatusChanged(bool stereo )**

        Signals that the **stereo** state of a radio tuner has changed.
        """
        ...

    @property
    def volumeChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qradiotunercontrol.html#volumeChanged

        **[signal] void QRadioTunerControl::volumeChanged(int volume )**

        Signals that the percentage **volume** of radio tuner's audio output has
        changed.
        """
        ...
