"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
import PyQt5.sip
from PyQt5 import QtCore
from PyQt5.QtMultimedia import *


class QRadioDataControl(QMediaControl):
    """
    https://doc.qt.io/qt-5/qradiodatacontrol.html

    **Detailed Description**

    The functionality provided by this control is exposed to application code
    through the **QRadioData**  class.

    The interface name of QRadioDataControl is `org.qt-
    project.qt.radiodatacontrol/5.0` as defined in **QRadioDataControl_iid** .

    **See also** **QMediaService::requestControl** () and **QRadioData** .
    """

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qradiodatacontrol.html#QRadioDataControl

        **[protected] QRadioDataControl::QRadioDataControl(QObject * parent =
        nullptr)**

        Constructs a radio data control with the given **parent**.
        """
        ...

    def errorString(self) -> str:
        """
        https://doc.qt.io/qt-5/qradiodatacontrol.html#errorString

        **[pure virtual] QString QRadioDataControl::errorString() const**

        Returns a string describing a radio data's error state.
        """
        ...

    def isAlternativeFrequenciesEnabled(self) -> bool:
        """
        https://doc.qt.io/qt-5/qradiodatacontrol.html#isAlternativeFrequenciesEn
        abled

        **[pure virtual] bool
        QRadioDataControl::isAlternativeFrequenciesEnabled() const**

        Returns true if Alternative Frequency is currently enabled
        """
        ...

    def setAlternativeFrequenciesEnabled(self, enabled: bool) -> None:
        """
        https://doc.qt.io/qt-5/qradiodatacontrol.html#setAlternativeFrequenciesE
        nabled

        **[pure virtual] void
        QRadioDataControl::setAlternativeFrequenciesEnabled(bool enabled )**

        Sets the Alternative Frequency to **enabled**

        **See also** **isAlternativeFrequenciesEnabled** ().
        """
        ...

    def radioText(self) -> str:
        """
        https://doc.qt.io/qt-5/qradiodatacontrol.html#radioText

        **[pure virtual] QString QRadioDataControl::radioText() const**

        Returns the current Radio Text
        """
        ...

    def stationName(self) -> str:
        """
        https://doc.qt.io/qt-5/qradiodatacontrol.html#stationName

        **[pure virtual] QString QRadioDataControl::stationName() const**

        Returns the current Program Service
        """
        ...

    def programTypeName(self) -> str:
        """
        https://doc.qt.io/qt-5/qradiodatacontrol.html#programTypeName

        **[pure virtual] QString QRadioDataControl::programTypeName() const**

        Returns the current Program Type Name
        """
        ...

    def programType(self) -> QRadioData.ProgramType:
        """
        https://doc.qt.io/qt-5/qradiodatacontrol.html#programType

        **[pure virtual] QRadioData::ProgramType
        QRadioDataControl::programType() const**

        Returns the current Program Type
        """
        ...

    def stationId(self) -> str:
        """
        https://doc.qt.io/qt-5/qradiodatacontrol.html#stationId

        **[pure virtual] QString QRadioDataControl::stationId() const**

        Returns the current Program Identification
        """
        ...

    @property
    def alternativeFrequenciesEnabledChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qradiodatacontrol.html#alternativeFrequenciesEnab
        ledChanged

        **[signal] void
        QRadioDataControl::alternativeFrequenciesEnabledChanged(bool enabled )**

        Signals that the alternative frequencies setting has changed to the
        value of **enabled**.
        """
        ...

    @property
    def error(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qradiodatacontrol.html#error

        **[pure virtual] QRadioData::Error QRadioDataControl::error() const**

        Returns the error state of a radio data.
        """
        ...

    @property
    def programTypeChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qradiodatacontrol.html#programTypeChanged

        **[signal] void
        QRadioDataControl::programTypeChanged(QRadioData::ProgramType
        programType )**

        Signals that the Program Type **programType** has changed
        """
        ...

    @property
    def programTypeNameChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qradiodatacontrol.html#programTypeNameChanged

        **[signal] void QRadioDataControl::programTypeNameChanged(QString
        programTypeName )**

        Signals that the Program Type Name **programTypeName** has changed
        """
        ...

    @property
    def radioTextChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qradiodatacontrol.html#radioTextChanged

        **[signal] void QRadioDataControl::radioTextChanged(QString radioText
        )**

        Signals that the Radio Text **radioText** has changed
        """
        ...

    @property
    def stationIdChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qradiodatacontrol.html#stationIdChanged

        **[signal] void QRadioDataControl::stationIdChanged(QString stationId
        )**

        Signals that the Program Identification **stationId** has changed
        """
        ...

    @property
    def stationNameChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qradiodatacontrol.html#stationNameChanged

        **[signal] void QRadioDataControl::stationNameChanged(QString
        stationName )**

        Signals that the Program Service **stationName** has changed
        """
        ...
