"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
import PyQt5.sip
from PyQt5 import QtCore
from PyQt5.QtMultimedia import *


class QRadioData(QtCore.QObject, QMediaBindableInterface):
    """
    https://doc.qt.io/qt-5/qradiodata.html

    **Detailed Description**

    The radio data object will emit signals for any changes in radio data. You
    can enable or disable alternative frequency with
    **setAlternativeFrequenciesEnabled** ().

    You can get a QRadioData instance fromt the **radioData**  property from a
    **QRadioTuner**  instance.

    radio = new **QRadioTuner** ;
        radioData = radio->radioData();

    Alternatively, you can pass an instance of **QRadioTuner**  to the
    constructor to QRadioData.

    **See also** **Radio Overview** .
    """

    class ProgramType(int):
        Undefined: QRadioData = ...
        News: QRadioData = ...
        CurrentAffairs: QRadioData = ...
        Information: QRadioData = ...
        Sport: QRadioData = ...
        Education: QRadioData = ...
        Drama: QRadioData = ...
        Culture: QRadioData = ...
        Science: QRadioData = ...
        Varied: QRadioData = ...
        PopMusic: QRadioData = ...
        RockMusic: QRadioData = ...
        EasyListening: QRadioData = ...
        LightClassical: QRadioData = ...
        SeriousClassical: QRadioData = ...
        OtherMusic: QRadioData = ...
        Weather: QRadioData = ...
        Finance: QRadioData = ...
        ChildrensProgrammes: QRadioData = ...
        SocialAffairs: QRadioData = ...
        Religion: QRadioData = ...
        PhoneIn: QRadioData = ...
        Travel: QRadioData = ...
        Leisure: QRadioData = ...
        JazzMusic: QRadioData = ...
        CountryMusic: QRadioData = ...
        NationalMusic: QRadioData = ...
        OldiesMusic: QRadioData = ...
        FolkMusic: QRadioData = ...
        Documentary: QRadioData = ...
        AlarmTest: QRadioData = ...
        Alarm: QRadioData = ...
        Talk: QRadioData = ...
        ClassicRock: QRadioData = ...
        AdultHits: QRadioData = ...
        SoftRock: QRadioData = ...
        Top40: QRadioData = ...
        Soft: QRadioData = ...
        Nostalgia: QRadioData = ...
        Classical: QRadioData = ...
        RhythmAndBlues: QRadioData = ...
        SoftRhythmAndBlues: QRadioData = ...
        Language: QRadioData = ...
        ReligiousMusic: QRadioData = ...
        ReligiousTalk: QRadioData = ...
        Personality: QRadioData = ...
        Public: QRadioData = ...
        College: QRadioData = ...

    class Error(int):
        NoError: QRadioData = ...
        ResourceError: QRadioData = ...
        OpenError: QRadioData = ...
        OutOfRangeError: QRadioData = ...

    def __init__(
        self, mediaObject: QMediaObject, parent: typing.Optional[QtCore.QObject] = ...
    ) -> None:
        """
        https://doc.qt.io/qt-5/qradiodata.html#QRadioData

        **QRadioData::QRadioData(QMediaObject * mediaObject , QObject * parent =
        nullptr)**

        Constructs a radio data based on a **mediaObject** and **parent**.

        The **mediaObject** should be an instance of **QRadioTuner** . It is
        preferable to use the **radioData**  property on a QRadioTuner instance
        to get an instance of QRadioData.

        During construction, this class is bound to the **mediaObject** using
        the **bind()**  method.
        """
        ...

    def setMediaObject(self, a0: QMediaObject) -> bool:
        """
        https://doc.qt.io/qt-5/qradiodata.html#setMediaObject

        **[override virtual protected] bool
        QRadioData::setMediaObject(QMediaObject * mediaObject )**

        Reimplements: **QMediaBindableInterface::setMediaObject** (QMediaObject
        *object).

        **See also** **mediaObject** ().
        """
        ...

    def setAlternativeFrequenciesEnabled(self, enabled: bool) -> None:
        """
        https://doc.qt.io/qt-5/qradiodata.html#alternativeFrequenciesEnabled-
        prop

        **alternativeFrequenciesEnabled : bool**

        Is Alternative Frequency currently enabled

        **Access functions:**

        bool **isAlternativeFrequenciesEnabled** () const
        void
        **setAlternativeFrequenciesEnabled** (bool **enabled** )

        **Notifier signal:**

        void ****alternativeFrequenciesEnabledChanged** ** (bool **enabled** )
        """
        ...

    def errorString(self) -> str:
        """
        https://doc.qt.io/qt-5/qradiodata.html#errorString

        **QString QRadioData::errorString() const**

        Returns a description of a radio data's error state.

        **See also** **error** ().
        """
        ...

    def isAlternativeFrequenciesEnabled(self) -> bool:
        ...

    def radioText(self) -> str:
        """
        https://doc.qt.io/qt-5/qradiodata.html#radioText-prop

        **radioText : const QString**

        Current Radio Text

        **Access functions:**

        QString **radioText** () const

        **Notifier signal:**

        void ****radioTextChanged** ** (QString **radioText** )
        """
        ...

    def stationName(self) -> str:
        """
        https://doc.qt.io/qt-5/qradiodata.html#stationName-prop

        **stationName : const QString**

        Current Program Service

        **Access functions:**

        QString **stationName** () const

        **Notifier signal:**

        void ****stationNameChanged** ** (QString **stationName** )

        **Member Function Documentation**
        """
        ...

    def programTypeName(self) -> str:
        """
        https://doc.qt.io/qt-5/qradiodata.html#programTypeName-prop

        **programTypeName : const QString**

        Current Program Type Name

        **Access functions:**

        QString **programTypeName** () const

        **Notifier signal:**

        void ****programTypeNameChanged** ** (QString **programTypeName** )
        """
        ...

    def programType(self) -> "QRadioData.ProgramType":
        """
        https://doc.qt.io/qt-5/qradiodata.html#programType-prop

        **programType : const ProgramType**

        Current Program Type

        **Access functions:**

        QRadioData::ProgramType **programType** () const

        **Notifier signal:**

        void ****programTypeChanged** ** (QRadioData::ProgramType
        **programType** )
        """
        ...

    def stationId(self) -> str:
        """
        https://doc.qt.io/qt-5/qradiodata.html#stationId-prop

        **stationId : const QString**

        Current Program Identification

        **Access functions:**

        QString **stationId** () const

        **Notifier signal:**

        void ****stationIdChanged** ** (QString **stationId** )
        """
        ...

    def availability(self) -> QMultimedia.AvailabilityStatus:
        """
        https://doc.qt.io/qt-5/qradiodata.html#availability

        **QMultimedia::AvailabilityStatus QRadioData::availability() const**

        Returns the availability of the radio data service.

        A long as there is a media service which provides radio functionality,
        then the **availability**  will be that of the **radio tuner** .
        """
        ...

    def mediaObject(self) -> QMediaObject:
        """
        https://doc.qt.io/qt-5/qradiodata.html#mediaObject

        **[override virtual] QMediaObject *QRadioData::mediaObject() const**

        Reimplements: **QMediaBindableInterface::mediaObject** () const.

        **See also** **setMediaObject** ().
        """
        ...

    @property
    def alternativeFrequenciesEnabledChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qradiodata.html#alternativeFrequenciesEnabledChan
        ged

        **[signal] void QRadioData::alternativeFrequenciesEnabledChanged(bool
        enabled )**

        Signals that automatically tuning to alternative frequencies has been
        enabled or disabled according to **enabled**.

        **Note:** Notifier signal for property **alternativeFrequenciesEnabled**
        .
        """
        ...

    @property
    def error(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qradiodata.html#error

        **QRadioData::Error QRadioData::error() const**

        Returns the error state of a radio data.

        **See also** **errorString** ().
        """
        ...

    @property
    def programTypeChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qradiodata.html#programTypeChanged

        **[signal] void QRadioData::programTypeChanged(QRadioData::ProgramType
        programType )**

        Signals that the Program Type code has changed to **programType**

        **Note:** Notifier signal for property **programType** .
        """
        ...

    @property
    def programTypeNameChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qradiodata.html#programTypeNameChanged

        **[signal] void QRadioData::programTypeNameChanged(QString
        programTypeName )**

        Signals that the Program Type Name has changed to **programTypeName**

        **Note:** Notifier signal for property **programTypeName** .
        """
        ...

    @property
    def radioTextChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qradiodata.html#radioTextChanged

        **[signal] void QRadioData::radioTextChanged(QString radioText )**

        Signals that the Radio Text property has changed to **radioText**

        **Note:** Notifier signal for property **radioText** .
        """
        ...

    @property
    def stationIdChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qradiodata.html#stationIdChanged

        **[signal] void QRadioData::stationIdChanged(QString stationId )**

        Signals that the Program Identification code has changed to
        **stationId**

        **Note:** Notifier signal for property **stationId** .
        """
        ...

    @property
    def stationNameChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qradiodata.html#stationNameChanged

        **[signal] void QRadioData::stationNameChanged(QString stationName )**

        Signals that the Program Service has changed to **stationName**

        **Note:** Notifier signal for property **stationName** .
        """
        ...
