"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
from PyQt5 import sip


class QMediaTimeInterval(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qmediatimeinterval.html

    **Detailed Description**

    An interval is specified by an inclusive **start** () and **end** () time.
    These must be set in the constructor, as this is an immutable class. The
    specific units of time represented by the class have not been defined - it
    is suitable for any times which can be represented by a signed 64 bit
    integer.

    The **isNormal** () method determines if a time interval is normal (a normal
    time interval has **start** () <= **end** ()). A normal interval can be
    received from an abnormal interval by calling the **normalized** () method.

    The **contains** () method determines if a specified time lies within the
    time interval.

    The **translated** () method returns a time interval which has been
    translated forwards or backwards through time by a specified offset.

    **See also** **QMediaTimeRange** .
    """

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qmediatimeinterval.html#QMediaTimeInterval

        **QMediaTimeInterval::QMediaTimeInterval()**

        Constructs an empty interval.
        """
        ...

    @typing.overload
    def __init__(self, start: int, end: int) -> None:
        """
        https://doc.qt.io/qt-5/qmediatimeinterval.html#QMediaTimeInterval-1

        **QMediaTimeInterval::QMediaTimeInterval(qint64 start , qint64 end )**

        Constructs an interval with the specified **start** and **end** times.
        """
        ...

    @typing.overload
    def __init__(self, a0: "QMediaTimeInterval") -> None:
        """
        https://doc.qt.io/qt-5/qmediatimeinterval.html#QMediaTimeInterval-2

        **QMediaTimeInterval::QMediaTimeInterval(const QMediaTimeInterval &
        other )**

        Constructs an interval by taking a copy of **other**.
        """
        ...

    def translated(self, offset: int) -> "QMediaTimeInterval":
        """
        https://doc.qt.io/qt-5/qmediatimeinterval.html#translated

        **QMediaTimeInterval QMediaTimeInterval::translated(qint64 offset )
        const**

        Returns a copy of this time interval, translated by a value of
        **offset**. An interval can be moved forward through time with a
        positive offset, or backward through time with a negative offset.
        """
        ...

    def normalized(self) -> "QMediaTimeInterval":
        """
        https://doc.qt.io/qt-5/qmediatimeinterval.html#normalized

        **QMediaTimeInterval QMediaTimeInterval::normalized() const**

        Returns a normalized version of this interval.

        If the **start** () time of the interval is greater than the **end** ()
        time, then the returned interval has the start and end times swapped.
        """
        ...

    def isNormal(self) -> bool:
        """
        https://doc.qt.io/qt-5/qmediatimeinterval.html#isNormal

        **bool QMediaTimeInterval::isNormal() const**

        Returns true if this time interval is normal. A normal time interval has
        **start** () <= **end** ().

        **See also** **normalized** ().
        """
        ...

    def contains(self, time: int) -> bool:
        """
        https://doc.qt.io/qt-5/qmediatimeinterval.html#contains

        **bool QMediaTimeInterval::contains(qint64 time ) const**

        Returns true if the time interval contains the specified **time**. That
        is, **start** () <= time <= **end** ().
        """
        ...

    def end(self) -> int:
        """
        https://doc.qt.io/qt-5/qmediatimeinterval.html#end

        **qint64 QMediaTimeInterval::end() const**

        Returns the end time of the interval.

        **See also** **start** ().
        """
        ...

    def start(self) -> int:
        """
        https://doc.qt.io/qt-5/qmediatimeinterval.html#start

        **qint64 QMediaTimeInterval::start() const**

        Returns the start time of the interval.

        **See also** **end** ().
        """
        ...
