"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
import PyQt5.sip
from PyQt5 import QtCore
from PyQt5.QtMultimedia import *


class QMediaRecorder(QtCore.QObject, QMediaBindableInterface):
    """
    https://doc.qt.io/qt-5/qmediarecorder.html

    **Detailed Description**

    The QMediaRecorder class is a high level media recording class. It's not
    intended to be used alone but for accessing the media recording functions of
    other media objects, like QRadioTuner, or **QCamera** .

    recorder = new **QMediaRecorder** (camera);
    **QAudioEncoderSettings**  audioSettings;
    audioSettings.setCodec("audio/amr");
    audioSettings.setQuality(QMultimedia::HighQuality);
    recorder->setAudioSettings(audioSettings);
    recorder->setOutputLocation(**QUrl** ::fromLocalFile(fileName));
    recorder->record();

    **See also** **QAudioRecorder** .
    """

    class Error(int):
        NoError: QMediaRecorder = ...
        ResourceError: QMediaRecorder = ...
        FormatError: QMediaRecorder = ...
        OutOfSpaceError: QMediaRecorder = ...

    class Status(int):
        UnavailableStatus: QMediaRecorder = ...
        UnloadedStatus: QMediaRecorder = ...
        LoadingStatus: QMediaRecorder = ...
        LoadedStatus: QMediaRecorder = ...
        StartingStatus: QMediaRecorder = ...
        RecordingStatus: QMediaRecorder = ...
        PausedStatus: QMediaRecorder = ...
        FinalizingStatus: QMediaRecorder = ...

    class State(int):
        StoppedState: QMediaRecorder = ...
        RecordingState: QMediaRecorder = ...
        PausedState: QMediaRecorder = ...

    def __init__(
        self, mediaObject: QMediaObject, parent: typing.Optional[QtCore.QObject] = ...
    ) -> None:
        """
        https://doc.qt.io/qt-5/qmediarecorder.html#QMediaRecorder

        **QMediaRecorder::QMediaRecorder(QMediaObject * mediaObject , QObject *
        parent = nullptr)**

        Constructs a media recorder which records the media produced by
        **mediaObject**.

        The **parent** is passed to **QMediaObject** .
        """
        ...

    def setMediaObject(self, object: QMediaObject) -> bool:
        """
        https://doc.qt.io/qt-5/qmediarecorder.html#mediaObject

        **[override virtual] QMediaObject *QMediaRecorder::mediaObject() const**

        Reimplements: **QMediaBindableInterface::mediaObject** () const.

        Returns the **QMediaObject**  instance that this **QMediaRecorder**  is
        bound too, or 0 otherwise.
        """
        ...

    def setVolume(self, volume: float) -> None:
        """
        https://doc.qt.io/qt-5/qmediarecorder.html#volume-prop

        **volume : qreal**

        This property holds the current recording audio volume.

        The volume is scaled linearly from `0.0` (silence) to `1.0` (full
        volume). Values outside this range will be clamped.

        The default volume is `1.0`.

        UI volume controls should usually be scaled nonlinearly. For example,
        using a logarithmic scale will produce linear changes in perceived
        loudness, which is what a user would normally expect from a volume
        control. See **QAudio::convertVolume** () for more details.

        **Access functions:**

        qreal **volume** () const
        void **setVolume** (qreal **volume** )

        **Notifier signal:**

        void **volumeChanged** (qreal **volume** )

        **Member Function Documentation**
        """
        ...

    def setMuted(self, muted: bool) -> None:
        """
        https://doc.qt.io/qt-5/qmediarecorder.html#muted-prop

        **muted : bool**

        This property holds whether a recording audio stream is muted.

        **Access functions:**

        bool **isMuted** () const
        void **setMuted** (bool **muted** )

        **Notifier signal:**

        void ****mutedChanged** ** (bool **muted** )
        """
        ...

    def stop(self) -> None:
        """
        https://doc.qt.io/qt-5/qmediarecorder.html#stop

        **[slot] void QMediaRecorder::stop()**

        Stop recording.

        The recorder state is changed to **QMediaRecorder::StoppedState** .
        """
        ...

    def pause(self) -> None:
        """
        https://doc.qt.io/qt-5/qmediarecorder.html#pause

        **[slot] void QMediaRecorder::pause()**

        Pause recording.

        The recorder state is changed to **QMediaRecorder::PausedState** .

        Depending on platform recording pause may be not supported, in this case
        the recorder state stays unchanged.
        """
        ...

    def record(self) -> None:
        """
        https://doc.qt.io/qt-5/qmediarecorder.html#record

        **[slot] void QMediaRecorder::record()**

        Start recording.

        While the recorder state is changed immediately to
        **QMediaRecorder::RecordingState** , recording may start asynchronously,
        with **statusChanged** (**QMediaRecorder::RecordingStatus** ) signal
        emitted when recording starts.

        If recording fails **error** () signal is emitted with recorder state
        being reset back to **QMediaRecorder::StoppedState** .
        """
        ...

    def availableMetaData(self) -> typing.List[str]:
        """
        https://doc.qt.io/qt-5/qmediarecorder.html#availableMetaData

        **QStringList QMediaRecorder::availableMetaData() const**

        Returns a list of keys there is meta-data available for.
        """
        ...

    def setMetaData(self, key: str, value: typing.Any) -> None:
        """
        https://doc.qt.io/qt-5/qmediarecorder.html#setMetaData

        **void QMediaRecorder::setMetaData(const QString & key , const QVariant
        & value )**

        Sets a **value** for a meta-data **key**.

        **Note:** To ensure that meta data is set corretly, it should be set
        before starting the recording. Once the recording is stopped, any meta
        data set will be attached to the next recording.

        **See also** **metaData** ().
        """
        ...

    def metaData(self, key: str) -> typing.Any:
        """
        https://doc.qt.io/qt-5/qmediarecorder.html#metaData

        **QVariant QMediaRecorder::metaData(const QString & key ) const**

        Returns the value associated with a meta-data **key**.

        **See also** **setMetaData** ().
        """
        ...

    def isMetaDataWritable(self) -> bool:
        ...

    def isMetaDataAvailable(self) -> bool:
        ...

    def setEncodingSettings(
        self,
        audio: "QAudioEncoderSettings",
        video: "QVideoEncoderSettings" = ...,
        container: str = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qmediarecorder.html#setEncodingSettings

        **void QMediaRecorder::setEncodingSettings(const QAudioEncoderSettings &
        audio , const QVideoEncoderSettings & video = QVideoEncoderSettings(),
        const QString & container = QString())**

        Sets the **audio** and **video** encoder settings and **container**
        format.

        If some parameters are not specified, or null settings are passed, the
        encoder will choose default encoding parameters, depending on media
        source properties.

        It's only possible to change settings when the encoder is in the
        QMediaEncoder::StoppedState state.

        **See also** **audioSettings** (), **videoSettings** (), and
        **containerFormat** ().
        """
        ...

    def setContainerFormat(self, container: str) -> None:
        """
        https://doc.qt.io/qt-5/qmediarecorder.html#setContainerFormat

        **void QMediaRecorder::setContainerFormat(const QString & container )**

        Sets the media **container** format.

        If the container format is not specified, the encoder will choose
        format, depending on media source properties and encoding settings
        selected.

        It's only possible to change settings when the encoder is in the
        QMediaEncoder::StoppedState state.

        **See also** **audioSettings** (), **videoSettings** (), and
        **containerFormat** ().
        """
        ...

    def setVideoSettings(self, videoSettings: "QVideoEncoderSettings") -> None:
        """
        https://doc.qt.io/qt-5/qmediarecorder.html#setVideoSettings

        **void QMediaRecorder::setVideoSettings(const QVideoEncoderSettings &
        settings )**

        Sets the video encoder **settings**.

        If some parameters are not specified, or null settings are passed, the
        encoder will choose default encoding parameters, depending on media
        source properties.

        It's only possible to change settings when the encoder is in the
        QMediaEncoder::StoppedState state.

        **See also** **audioSettings** (), **videoSettings** (), and
        **containerFormat** ().
        """
        ...

    def setAudioSettings(self, audioSettings: "QAudioEncoderSettings") -> None:
        """
        https://doc.qt.io/qt-5/qmediarecorder.html#setAudioSettings

        **void QMediaRecorder::setAudioSettings(const QAudioEncoderSettings &
        settings )**

        Sets the audio encoder **settings**.

        If some parameters are not specified, or null settings are passed, the
        encoder will choose default encoding parameters, depending on media
        source properties.

        It's only possible to change settings when the encoder is in the
        QMediaEncoder::StoppedState state.

        **See also** **audioSettings** (), **videoSettings** (), and
        **containerFormat** ().
        """
        ...

    def containerFormat(self) -> str:
        """
        https://doc.qt.io/qt-5/qmediarecorder.html#containerFormat

        **QString QMediaRecorder::containerFormat() const**

        Returns the selected container format.

        **See also** **setContainerFormat** ().
        """
        ...

    def videoSettings(self) -> "QVideoEncoderSettings":
        """
        https://doc.qt.io/qt-5/qmediarecorder.html#videoSettings

        **QVideoEncoderSettings QMediaRecorder::videoSettings() const**

        Returns the video encoder settings being used.

        **See also** **setVideoSettings** () and **setEncodingSettings** ().
        """
        ...

    def audioSettings(self) -> "QAudioEncoderSettings":
        """
        https://doc.qt.io/qt-5/qmediarecorder.html#audioSettings

        **QAudioEncoderSettings QMediaRecorder::audioSettings() const**

        Returns the audio encoder settings being used.

        **See also** **setAudioSettings** () and **setEncodingSettings** ().
        """
        ...

    def supportedFrameRates(
        self, settings: "QVideoEncoderSettings" = ...
    ) -> typing.Tuple[typing.List[float], bool]:
        """
        https://doc.qt.io/qt-5/qmediarecorder.html#supportedFrameRates

        **QList<qreal> QMediaRecorder::supportedFrameRates(const
        QVideoEncoderSettings & settings = QVideoEncoderSettings(), bool *
        continuous = nullptr) const**

        Returns a list of frame rates video can be encoded at.

        If non null video **settings** parameter is passed, the returned list is
        reduced to frame rates supported with partial settings like video codec
        or resolution applied.

        If the encoder supports arbitrary frame rates within the supported
        range, * **continuous** is set to true, otherwise * **continuous** is
        set to false.

        **See also** **QVideoEncoderSettings::frameRate** ().
        """
        ...

    def supportedResolutions(
        self, settings: "QVideoEncoderSettings" = ...
    ) -> typing.Tuple[typing.List[QtCore.QSize], bool]:
        """
        https://doc.qt.io/qt-5/qmediarecorder.html#supportedResolutions

        **QList<QSize> QMediaRecorder::supportedResolutions(const
        QVideoEncoderSettings & settings = QVideoEncoderSettings(), bool *
        continuous = nullptr) const**

        Returns a list of resolutions video can be encoded at.

        If non null video **settings** parameter is passed, the returned list is
        reduced to resolution supported with partial settings like video codec
        or framerate applied.

        If the encoder supports arbitrary resolutions within the supported
        range, * **continuous** is set to true, otherwise * **continuous** is
        set to false.

        **See also** **QVideoEncoderSettings::resolution** ().
        """
        ...

    def videoCodecDescription(self, codecName: str) -> str:
        """
        https://doc.qt.io/qt-5/qmediarecorder.html#videoCodecDescription

        **QString QMediaRecorder::videoCodecDescription(const QString & codec )
        const**

        Returns a description of a video **codec**.

        **See also** **setEncodingSettings** ().
        """
        ...

    def supportedVideoCodecs(self) -> typing.List[str]:
        """
        https://doc.qt.io/qt-5/qmediarecorder.html#supportedVideoCodecs

        **QStringList QMediaRecorder::supportedVideoCodecs() const**

        Returns a list of supported video codecs.
        """
        ...

    def supportedAudioSampleRates(
        self, settings: "QAudioEncoderSettings" = ...
    ) -> typing.Tuple[typing.List[int], bool]:
        """
        https://doc.qt.io/qt-5/qmediarecorder.html#supportedAudioSampleRates

        **QList<int> QMediaRecorder::supportedAudioSampleRates(const
        QAudioEncoderSettings & settings = QAudioEncoderSettings(), bool *
        continuous = nullptr) const**

        Returns a list of supported audio sample rates.

        If non null audio **settings** parameter is passed, the returned list is
        reduced to sample rates supported with partial settings applied.

        This can be used to query the list of sample rates, supported by
        specific audio codec.

        If the encoder supports arbitrary sample rates within the supported
        rates range, * **continuous** is set to true, otherwise * **continuous**
        is set to false.
        """
        ...

    def audioCodecDescription(self, codecName: str) -> str:
        """
        https://doc.qt.io/qt-5/qmediarecorder.html#audioCodecDescription

        **QString QMediaRecorder::audioCodecDescription(const QString & codec )
        const**

        Returns a description of an audio **codec**.
        """
        ...

    def supportedAudioCodecs(self) -> typing.List[str]:
        """
        https://doc.qt.io/qt-5/qmediarecorder.html#supportedAudioCodecs

        **QStringList QMediaRecorder::supportedAudioCodecs() const**

        Returns a list of supported audio codecs.
        """
        ...

    def containerDescription(self, format: str) -> str:
        """
        https://doc.qt.io/qt-5/qmediarecorder.html#containerDescription

        **QString QMediaRecorder::containerDescription(const QString & format )
        const**

        Returns a description of a container **format**.
        """
        ...

    def supportedContainers(self) -> typing.List[str]:
        """
        https://doc.qt.io/qt-5/qmediarecorder.html#supportedContainers

        **QStringList QMediaRecorder::supportedContainers() const**

        Returns a list of supported container formats.
        """
        ...

    def volume(self) -> float:
        """
        https://doc.qt.io/qt-5/qmediarecorder.html#volume-prop

        **volume : qreal**

        This property holds the current recording audio volume.

        The volume is scaled linearly from `0.0` (silence) to `1.0` (full
        volume). Values outside this range will be clamped.

        The default volume is `1.0`.

        UI volume controls should usually be scaled nonlinearly. For example,
        using a logarithmic scale will produce linear changes in perceived
        loudness, which is what a user would normally expect from a volume
        control. See **QAudio::convertVolume** () for more details.

        **Access functions:**

        qreal **volume** () const
        void **setVolume** (qreal **volume** )

        **Notifier signal:**

        void **volumeChanged** (qreal **volume** )

        **Member Function Documentation**
        """
        ...

    def isMuted(self) -> bool:
        ...

    def duration(self) -> int:
        """
        https://doc.qt.io/qt-5/qmediarecorder.html#duration-prop

        **duration : const qint64**

        This property holds the recorded media duration in milliseconds.

        **Access functions:**

        qint64 **duration** () const

        **Notifier signal:**

        void ****durationChanged** ** (qint64 **duration** )
        """
        ...

    def errorString(self) -> str:
        """
        https://doc.qt.io/qt-5/qmediarecorder.html#errorString

        **QString QMediaRecorder::errorString() const**

        Returns a string describing the current error state.

        **See also** **error** ().
        """
        ...

    def status(self) -> "QMediaRecorder.Status":
        """
        https://doc.qt.io/qt-5/qmediarecorder.html#status

        **QMediaRecorder::Status QMediaRecorder::status() const**

        Returns the current media recorder status.

        **Note:** Getter function for property status.

        **See also** **QMediaRecorder::Status** .
        """
        ...

    def state(self) -> "QMediaRecorder.State":
        """
        https://doc.qt.io/qt-5/qmediarecorder.html#state

        **QMediaRecorder::State QMediaRecorder::state() const**

        Returns the current media recorder state.

        **Note:** Getter function for property state.

        **See also** **QMediaRecorder::State** .
        """
        ...

    def actualLocation(self) -> QtCore.QUrl:
        """
        https://doc.qt.io/qt-5/qmediarecorder.html#actualLocation-prop

        **actualLocation : const QUrl**

        This property holds the actual location of the last media content.

        The actual location is usually available after recording starts, and
        reset when new location is set or new recording starts.

        **Access functions:**

        QUrl **actualLocation** () const

        **Notifier signal:**

        void ****actualLocationChanged** ** (const QUrl & **location** )
        """
        ...

    def setOutputLocation(self, location: QtCore.QUrl) -> bool:
        """
        https://doc.qt.io/qt-5/qmediarecorder.html#outputLocation-prop

        **outputLocation : QUrl**

        This property holds the destination location of media content.

        Setting the location can fail, for example when the service supports
        only local file system locations but a network URL was passed. If the
        service does not support media recording this setting the output
        location will always fail.

        The **location** can be relative or empty; in this case the recorder
        uses the system specific place and file naming scheme. After recording
        has stated, QMediaRecorder::outputLocation() returns the actual output
        location.

        **Access functions:**

        QUrl **outputLocation** () const
        bool **setOutputLocation** (const
        QUrl & **location** )
        """
        ...

    def outputLocation(self) -> QtCore.QUrl:
        """
        https://doc.qt.io/qt-5/qmediarecorder.html#outputLocation-prop

        **outputLocation : QUrl**

        This property holds the destination location of media content.

        Setting the location can fail, for example when the service supports
        only local file system locations but a network URL was passed. If the
        service does not support media recording this setting the output
        location will always fail.

        The **location** can be relative or empty; in this case the recorder
        uses the system specific place and file naming scheme. After recording
        has stated, QMediaRecorder::outputLocation() returns the actual output
        location.

        **Access functions:**

        QUrl **outputLocation** () const
        bool **setOutputLocation** (const
        QUrl & **location** )
        """
        ...

    def availability(self) -> "QMultimedia.AvailabilityStatus":
        """
        https://doc.qt.io/qt-5/qmediarecorder.html#availability

        **QMultimedia::AvailabilityStatus QMediaRecorder::availability() const**

        Returns the availability of this functionality.

        **See also** **availabilityChanged** ().
        """
        ...

    def isAvailable(self) -> bool:
        """
        https://doc.qt.io/qt-5/qmediarecorder.html#isAvailable

        **bool QMediaRecorder::isAvailable() const**

        Returns true if media recorder service ready to use.

        **See also** **availabilityChanged** ().
        """
        ...

    def mediaObject(self) -> QMediaObject:
        """
        https://doc.qt.io/qt-5/qmediarecorder.html#mediaObject

        **[override virtual] QMediaObject *QMediaRecorder::mediaObject() const**

        Reimplements: **QMediaBindableInterface::mediaObject** () const.

        Returns the **QMediaObject**  instance that this **QMediaRecorder**  is
        bound too, or 0 otherwise.
        """
        ...

    @property
    def actualLocationChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qmediarecorder.html#actualLocationChanged

        **[signal] void QMediaRecorder::actualLocationChanged(const QUrl &
        location )**

        Signals that the actual **location** of the recorded media has changed.
        This signal is usually emitted when recording starts.

        **Note:** Notifier signal for property **actualLocation** .
        """
        ...

    @property
    def availabilityChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qmediarecorder.html#availabilityChanged

        **[signal] void QMediaRecorder::availabilityChanged(bool available )**

        Signals that the media recorder is now available (if **available** is
        true), or not.

        **Note:** Signal **availabilityChanged** is overloaded in this class. To
        connect to this signal by using the function pointer syntax, Qt provides
        a convenient helper for obtaining the function pointer as shown in this
        example:

        connect(mediaRecorder, QOverload<bool>::of(&**QMediaRecorder**
        ::availabilityChanged),
                [=](bool available){ /* ... */ });
        """
        ...

    @property
    def availabilityChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qmediarecorder.html#availabilityChanged-1

        **[signal] void
        QMediaRecorder::availabilityChanged(QMultimedia::AvailabilityStatus
        availability )**

        Signals that the service availability has changed to **availability**.

        **Note:** Signal **availabilityChanged** is overloaded in this class. To
        connect to this signal by using the function pointer syntax, Qt provides
        a convenient helper for obtaining the function pointer as shown in this
        example:

        connect(mediaRecorder,
        QOverload<QMultimedia::AvailabilityStatus>::of(&**QMediaRecorder**
        ::availabilityChanged),
                [=](QMultimedia::AvailabilityStatus
        availability){ /* ... */ });
        """
        ...

    @property
    def durationChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qmediarecorder.html#durationChanged

        **[signal] void QMediaRecorder::durationChanged(qint64 duration )**

        Signals that the **duration** of the recorded media has changed.

        **Note:** Notifier signal for property **duration** .
        """
        ...

    @property
    def error(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qmediarecorder.html#error

        **QMediaRecorder::Error QMediaRecorder::error() const**

        Returns the current error state.

        **See also** **errorString** ().
        """
        ...

    @property
    def metaDataAvailableChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qmediarecorder.html#metaDataAvailableChanged

        **[signal] void QMediaRecorder::metaDataAvailableChanged(bool available
        )**

        Signals that the **available** state of a media object's meta-data has
        changed.

        **Note:** Notifier signal for property **metaDataAvailable** .
        """
        ...

    @property
    def metaDataChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qmediarecorder.html#metaDataChanged

        **[signal] void QMediaRecorder::metaDataChanged()**

        Signals that a media object's meta-data has changed.

        If multiple meta-data elements are changed, metaDataChanged(const
        **QString**  &key, const **QVariant**  &value) signal is emitted for
        each of them with metaDataChanged() changed emitted once.

        **Note:** Signal **metaDataChanged** is overloaded in this class. To
        connect to this signal by using the function pointer syntax, Qt provides
        a convenient helper for obtaining the function pointer as shown in this
        example:

        connect(mediaRecorder, QOverload<>::of(&**QMediaRecorder**
        ::metaDataChanged),
                [=](){ /* ... */ });
        """
        ...

    @property
    def metaDataChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qmediarecorder.html#metaDataChanged-1

        **[signal] void QMediaRecorder::metaDataChanged(const QString & key ,
        const QVariant & value )**

        Signal the changes of one meta-data element **value** with the given
        **key**.

        **Note:** Signal **metaDataChanged** is overloaded in this class. To
        connect to this signal by using the function pointer syntax, Qt provides
        a convenient helper for obtaining the function pointer as shown in this
        example:

        connect(mediaRecorder, QOverload<const **QString**  &, const
        **QVariant**  &>::of(&**QMediaRecorder** ::metaDataChanged),
        [=](const **QString**  &key, const **QVariant**  &value){ /* ... */ });
        """
        ...

    @property
    def metaDataWritableChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qmediarecorder.html#metaDataWritableChanged

        **[signal] void QMediaRecorder::metaDataWritableChanged(bool writable
        )**

        Signals that the **writable** state of a media object's meta-data has
        changed.

        **Note:** Notifier signal for property **metaDataWritable** .
        """
        ...

    @property
    def mutedChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qmediarecorder.html#mutedChanged

        **[signal] void QMediaRecorder::mutedChanged(bool muted )**

        Signals that the **muted** state has changed. If true the recording is
        being muted.

        **Note:** Notifier signal for property **muted** .
        """
        ...

    @property
    def stateChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qmediarecorder.html#stateChanged

        **[signal] void QMediaRecorder::stateChanged(QMediaRecorder::State state
        )**

        Signals that a media recorder's **state** has changed.

        **Note:** Notifier signal for property **state** .
        """
        ...

    @property
    def statusChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        ...

    @property
    def volumeChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        ...
