"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
import PyQt5.sip
from PyQt5 import QtCore
from PyQt5.QtMultimedia import *


class QMediaObject(QtCore.QObject):
    """
    https://doc.qt.io/qt-5/qmediaobject.html

    **Detailed Description**

    It provides some basic functionality that is common to other high level
    classes like **QMediaPlayer** , **QAudioDecoder**  and **QCamera** ,
    including availability and meta-data functionality, as well as functionality
    to connect media objects with support classes like **QMediaPlaylist** .

    The higher level QMediaObject derived classes provide the actual multimedia
    functionality, by internally using a QMediaService. Each media object hosts
    a QMediaService and uses the QMediaControl interfaces implemented by the
    service to implement its API. These controls can be accessed from the media
    object if necessary, but in general the useful functionality can be accessed
    from the higher level classes.

    Most media objects when constructed will request a new QMediaService
    instance, but some like **QMediaRecorder**  and **QAudioRecorder**  will
    share a service with another object.

    **See also** **QMediaService**  and **QMediaControl** .
    """

    def __init__(self, parent: QtCore.QObject, service: "QMediaService") -> None:
        """
        https://doc.qt.io/qt-5/qmediaobject.html#QMediaObject

        **[protected] QMediaObject::QMediaObject(QObject * parent ,
        QMediaService * service )**

        Constructs a media object which uses the functionality provided by a
        media **service**.

        The **parent** is passed to **QObject** .

        This class is meant as a base class for multimedia objects so this
        constructor is protected.
        """
        ...

    def removePropertyWatch(
        self, name: typing.Union[QtCore.QByteArray, bytes, bytearray]
    ) -> None:
        """
        https://doc.qt.io/qt-5/qmediaobject.html#removePropertyWatch

        **[protected] void QMediaObject::removePropertyWatch(const QByteArray &
        name )**

        Remove property **name** from the list of properties whose changes are
        regularly signaled.

        **See also** **notifyInterval** .
        """
        ...

    def addPropertyWatch(
        self, name: typing.Union[QtCore.QByteArray, bytes, bytearray]
    ) -> None:
        """
        https://doc.qt.io/qt-5/qmediaobject.html#addPropertyWatch

        **[protected] void QMediaObject::addPropertyWatch(const QByteArray &
        name )**

        Watch the property **name**. The property's notify signal will be
        emitted once every `notifyInterval` milliseconds.

        **See also** **notifyInterval** .
        """
        ...

    def availableMetaData(self) -> typing.List[str]:
        """
        https://doc.qt.io/qt-5/qmediaobject.html#availableMetaData

        **QStringList QMediaObject::availableMetaData() const**

        Returns a list of keys there is meta-data available for.
        """
        ...

    def metaData(self, key: str) -> typing.Any:
        """
        https://doc.qt.io/qt-5/qmediaobject.html#metaData

        **QVariant QMediaObject::metaData(const QString & key ) const**

        Returns the value associated with a meta-data **key**.

        See the list of predefined **meta-data keys** .
        """
        ...

    def isMetaDataAvailable(self) -> bool:
        """
        https://doc.qt.io/qt-5/qmediaobject.html#isMetaDataAvailable

        **bool QMediaObject::isMetaDataAvailable() const**

        Returns true if there is meta-data associated with this media object,
        else false.
        """
        ...

    def unbind(self, a0: QtCore.QObject) -> None:
        """
        https://doc.qt.io/qt-5/qmediaobject.html#unbind

        **[virtual] void QMediaObject::unbind(QObject * object )**

        Detach **object** from the **QMediaObject**  instance.

        Unbind the helper object from this media object. A warning will be
        generated if the object was not previously bound to this object.

        **See also** **QMediaBindableInterface** .
        """
        ...

    def bind(self, a0: QtCore.QObject) -> bool:
        """
        https://doc.qt.io/qt-5/qmediaobject.html#bind

        **[virtual] bool QMediaObject::bind(QObject * object )**

        Bind **object** to this **QMediaObject**  instance.

        This method establishes a relationship between this media object and a
        helper object. The nature of the relationship depends on both parties.
        This methods returns true if the helper was successfully bound, false
        otherwise.

        Most subclasses of **QMediaObject**  provide more convenient functions
        that wrap this functionality, so this function rarely needs to be called
        directly.

        The object passed must implement the **QMediaBindableInterface**
        interface.

        **See also** **QMediaBindableInterface** .
        """
        ...

    def setNotifyInterval(self, milliSeconds: int) -> None:
        """
        https://doc.qt.io/qt-5/qmediaobject.html#notifyInterval-prop

        **notifyInterval : int**

        The interval at which notifiable properties will update.

        The interval is expressed in milliseconds, the default value is 1000.

        **Access functions:**

        int **notifyInterval** () const
        void **setNotifyInterval** (int
        **milliSeconds** )

        **Notifier signal:**

        void ****notifyIntervalChanged** ** (int **milliseconds** )

        **See also** **addPropertyWatch** () and **removePropertyWatch** ().

        **Member Function Documentation**
        """
        ...

    def notifyInterval(self) -> int:
        """
        https://doc.qt.io/qt-5/qmediaobject.html#notifyInterval-prop

        **notifyInterval : int**

        The interval at which notifiable properties will update.

        The interval is expressed in milliseconds, the default value is 1000.

        **Access functions:**

        int **notifyInterval** () const
        void **setNotifyInterval** (int
        **milliSeconds** )

        **Notifier signal:**

        void ****notifyIntervalChanged** ** (int **milliseconds** )

        **See also** **addPropertyWatch** () and **removePropertyWatch** ().

        **Member Function Documentation**
        """
        ...

    def service(self) -> "QMediaService":
        """
        https://doc.qt.io/qt-5/qmediaobject.html#service

        **[virtual] QMediaService *QMediaObject::service() const**

        Returns the media service that provides the functionality of this
        multimedia object.
        """
        ...

    def availability(self) -> "QMultimedia.AvailabilityStatus":
        """
        https://doc.qt.io/qt-5/qmediaobject.html#availability

        **[virtual] QMultimedia::AvailabilityStatus QMediaObject::availability()
        const**

        Returns the availability of the functionality offered by this object.

        In some cases the functionality may not be available (for example, if
        the current operating system or platform does not provide the required
        functionality), or it may be temporarily unavailable (for example, audio
        playback during a phone call or similar).
        """
        ...

    def isAvailable(self) -> bool:
        """
        https://doc.qt.io/qt-5/qmediaobject.html#isAvailable

        **[virtual] bool QMediaObject::isAvailable() const**

        Returns true if the service is available for use.
        """
        ...

    @property
    def availabilityChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qmediaobject.html#availabilityChanged

        **[signal] void QMediaObject::availabilityChanged(bool available )**

        Signal emitted when the availability state has changed to **available**.

        **Note:** Signal **availabilityChanged** is overloaded in this class. To
        connect to this signal by using the function pointer syntax, Qt provides
        a convenient helper for obtaining the function pointer as shown in this
        example:

        connect(mediaObject, QOverload<bool>::of(&**QMediaObject**
        ::availabilityChanged),
                [=](bool available){ /* ... */ });
        """
        ...

    @property
    def availabilityChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qmediaobject.html#availabilityChanged-1

        **[signal] void
        QMediaObject::availabilityChanged(QMultimedia::AvailabilityStatus
        availability )**

        Signal emitted when the availability of the service has changed to
        **availability**.

        **Note:** Signal **availabilityChanged** is overloaded in this class. To
        connect to this signal by using the function pointer syntax, Qt provides
        a convenient helper for obtaining the function pointer as shown in this
        example:

        connect(mediaObject,
        QOverload<QMultimedia::AvailabilityStatus>::of(&**QMediaObject**
        ::availabilityChanged),
                [=](QMultimedia::AvailabilityStatus
        availability){ /* ... */ });
        """
        ...

    @property
    def metaDataAvailableChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qmediaobject.html#metaDataAvailableChanged

        **[signal] void QMediaObject::metaDataAvailableChanged(bool available
        )**

        Signals that the **available** state of a media object's meta-data has
        changed.
        """
        ...

    @property
    def metaDataChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qmediaobject.html#metaDataChanged

        **[signal] void QMediaObject::metaDataChanged()**

        Signals that this media object's meta-data has changed.

        If multiple meta-data elements are changed, metaDataChanged(const
        **QString**  &key, const **QVariant**  &value) signal is emitted for
        each of them with metaDataChanged() changed emitted once.

        **Note:** Signal **metaDataChanged** is overloaded in this class. To
        connect to this signal by using the function pointer syntax, Qt provides
        a convenient helper for obtaining the function pointer as shown in this
        example:

        connect(mediaObject, QOverload<>::of(&**QMediaObject**
        ::metaDataChanged),
                [=](){ /* ... */ });
        """
        ...

    @property
    def metaDataChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qmediaobject.html#metaDataChanged-1

        **[signal] void QMediaObject::metaDataChanged(const QString & key ,
        const QVariant & value )**

        Signal the changes of one meta-data element **value** with the given
        **key**.

        **Note:** Signal **metaDataChanged** is overloaded in this class. To
        connect to this signal by using the function pointer syntax, Qt provides
        a convenient helper for obtaining the function pointer as shown in this
        example:

        connect(mediaObject, QOverload<const **QString**  &, const **QVariant**
        &>::of(&**QMediaObject** ::metaDataChanged),
                [=](const
        **QString**  &key, const **QVariant**  &value){ /* ... */ });
        """
        ...

    @property
    def notifyIntervalChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qmediaobject.html#notifyIntervalChanged

        **[signal] void QMediaObject::notifyIntervalChanged(int milliseconds )**

        Signal a change in the notify interval period to **milliseconds**.

        **Note:** Notifier signal for property **notifyInterval** .
        """
        ...
